/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzInitializerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
    private boolean performShutdown = true;
    private boolean waitOnShutdown = false;
    private transient Scheduler scheduler = null;

    public void init(ServletConfig servletConfig) {
        super.init(servletConfig);
        this.log("Quartz Initializer Servlet loaded, initializing Scheduler...");
        try {
            Object object = servletConfig.getInitParameter("config-file");
            String string = servletConfig.getInitParameter("shutdown-on-unload");
            if (string != null) {
                this.performShutdown = Boolean.valueOf(string);
            }
            String string2 = servletConfig.getInitParameter("wait-on-shutdown");
            if (string != null) {
                this.waitOnShutdown = Boolean.valueOf(string2);
            }
            object = this.getSchedulerFactory((String)object);
            this.scheduler = ((StdSchedulerFactory)object).getScheduler();
            string = servletConfig.getInitParameter("start-scheduler-on-load");
            int n = 0;
            String string3 = servletConfig.getInitParameter("start-delay-seconds");
            try {
                if (string3 != null && string3.trim().length() > 0) {
                    n = Integer.parseInt(string3);
                }
            }
            catch (Exception exception) {
                this.log("Cannot parse value of 'start-delay-seconds' to an integer: " + string3 + ", defaulting to 5 seconds.", exception);
                n = 5;
            }
            if (string == null || Boolean.valueOf(string).booleanValue()) {
                if (n <= 0) {
                    this.scheduler.start();
                    this.log("Scheduler has been started...");
                } else {
                    this.scheduler.startDelayed(n);
                    this.log("Scheduler will start in " + n + " seconds.");
                }
            } else {
                this.log("Scheduler has not been started. Use scheduler.start()");
            }
            String string4 = servletConfig.getInitParameter("servlet-context-factory-key");
            if (string4 == null) {
                string4 = QUARTZ_FACTORY_KEY;
            }
            this.log("Storing the Quartz Scheduler Factory in the servlet context at key: " + string4);
            servletConfig.getServletContext().setAttribute(string4, object);
            object = servletConfig.getInitParameter("scheduler-context-servlet-context-key");
            if (object != null) {
                this.log("Storing the ServletContext in the scheduler context at key: " + (String)object);
                this.scheduler.getContext().put((String)object, (Object)servletConfig.getServletContext());
            }
            return;
        }
        catch (Exception exception) {
            this.log("Quartz Scheduler failed to initialize: " + exception.toString());
            throw new ServletException((Throwable)exception);
        }
    }

    protected StdSchedulerFactory getSchedulerFactory(String object) {
        object = object != null ? new StdSchedulerFactory((String)object) : new StdSchedulerFactory();
        return object;
    }

    public void destroy() {
        if (!this.performShutdown) {
            return;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown(this.waitOnShutdown);
            }
        }
        catch (Exception exception) {
            this.log("Quartz Scheduler failed to shutdown cleanly: " + exception.toString());
            exception.printStackTrace();
        }
        this.log("Quartz Scheduler successful shutdown.");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.sendError(403);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.sendError(403);
    }
}

