/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.util.Collection;
import java.util.Map;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.DefaultThreadExecutor;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerDetailsSetter;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdJobRunShellFactory;
import org.quartz.impl.StdScheduler;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSchedulerFactory
implements SchedulerFactory {
    public static final String DEFAULT_INSTANCE_ID = "SIMPLE_NON_CLUSTERED";
    public static final String DEFAULT_SCHEDULER_NAME = "SimpleQuartzScheduler";
    private static final boolean DEFAULT_JMX_EXPORT = false;
    private static final String DEFAULT_JMX_OBJECTNAME = null;
    private static final DefaultThreadExecutor DEFAULT_THREAD_EXECUTOR = new DefaultThreadExecutor();
    private static final int DEFAULT_BATCH_MAX_SIZE = 1;
    private static final long DEFAULT_BATCH_TIME_WINDOW = 0L;
    private boolean initialized = false;
    private static DirectSchedulerFactory instance = new DirectSchedulerFactory();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    protected DirectSchedulerFactory() {
    }

    public static DirectSchedulerFactory getInstance() {
        return instance;
    }

    public void createVolatileScheduler(int n) {
        SimpleThreadPool simpleThreadPool = new SimpleThreadPool(n, 5);
        RAMJobStore rAMJobStore = new RAMJobStore();
        this.createScheduler(simpleThreadPool, rAMJobStore);
    }

    public void createRemoteScheduler(String string, int n) {
        this.createRemoteScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, string, n);
    }

    public void createRemoteScheduler(String string, String string2, String string3, int n) {
        this.createRemoteScheduler(string, string2, null, string3, n);
    }

    public void createRemoteScheduler(String object, String object2, String string, String string2, int n) {
        object = string != null ? string : QuartzSchedulerResources.getUniqueIdentifier((String)object, (String)object2);
        object = new RemoteScheduler((String)object, string2, n);
        object2 = SchedulerRepository.getInstance();
        ((SchedulerRepository)object2).bind((Scheduler)object);
        this.initialized = true;
    }

    public void createScheduler(ThreadPool threadPool, JobStore jobStore) {
        this.createScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, threadPool, jobStore);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, JobStore jobStore) {
        this.createScheduler(string, string2, threadPool, jobStore, null, 0, -1L, -1L);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, JobStore jobStore, String string3, int n, long l, long l2) {
        this.createScheduler(string, string2, threadPool, jobStore, null, string3, n, l, l2, false, DEFAULT_JMX_OBJECTNAME);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, JobStore jobStore, Map<String, SchedulerPlugin> map, String string3, int n, long l, long l2, boolean bl, String string4) {
        this.createScheduler(string, string2, threadPool, DEFAULT_THREAD_EXECUTOR, jobStore, map, string3, n, l, l2, bl, string4);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, ThreadExecutor threadExecutor, JobStore jobStore, Map<String, SchedulerPlugin> map, String string3, int n, long l, long l2, boolean bl, String string4) {
        this.createScheduler(string, string2, threadPool, DEFAULT_THREAD_EXECUTOR, jobStore, map, string3, n, l, l2, bl, string4, 1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public void createScheduler(String object, String object2, ThreadPool object3, ThreadExecutor object4, JobStore object52, Map<String, SchedulerPlugin> map, String string, int n, long l, long l2, boolean bl, String string2, int n2, long l3) {
        void var11_12;
        void var9_11;
        void var6_8;
        void var14_14;
        void var13_13;
        void var8_10;
        void var7_9;
        void var16_16;
        void var15_15;
        StdJobRunShellFactory stdJobRunShellFactory = new StdJobRunShellFactory();
        object3.setInstanceName((String)object);
        object3.initialize();
        QuartzSchedulerResources quartzSchedulerResources = new QuartzSchedulerResources();
        quartzSchedulerResources.setName((String)object);
        quartzSchedulerResources.setInstanceId((String)object2);
        SchedulerDetailsSetter.setDetails(object3, (String)object, (String)object2);
        quartzSchedulerResources.setJobRunShellFactory(stdJobRunShellFactory);
        quartzSchedulerResources.setThreadPool((ThreadPool)object3);
        quartzSchedulerResources.setThreadExecutor((ThreadExecutor)object4);
        quartzSchedulerResources.setJobStore((JobStore)object52);
        quartzSchedulerResources.setMaxBatchSize((int)var15_15);
        quartzSchedulerResources.setBatchTimeWindow((long)var16_16);
        quartzSchedulerResources.setRMIRegistryHost((String)var7_9);
        quartzSchedulerResources.setRMIRegistryPort((int)var8_10);
        quartzSchedulerResources.setJMXExport((boolean)var13_13);
        if (var14_14 != null) {
            quartzSchedulerResources.setJMXObjectName((String)var14_14);
        }
        if (var6_8 != null) {
            object3 = var6_8.values().iterator();
            while (object3.hasNext()) {
                quartzSchedulerResources.addSchedulerPlugin((SchedulerPlugin)object3.next());
            }
        }
        object3 = new QuartzScheduler(quartzSchedulerResources, (long)var9_11, (long)var11_12);
        object4 = new CascadingClassLoadHelper();
        object4.initialize();
        SchedulerDetailsSetter.setDetails(object52, (String)object, (String)object2);
        object52.initialize((ClassLoadHelper)object4, ((QuartzScheduler)object3).getSchedulerSignaler());
        object = new StdScheduler((QuartzScheduler)object3);
        stdJobRunShellFactory.initialize((Scheduler)object);
        ((QuartzScheduler)object3).initialize();
        if (var6_8 != null) {
            for (Map.Entry entry : var6_8.entrySet()) {
                ((SchedulerPlugin)entry.getValue()).initialize((String)entry.getKey(), (Scheduler)object, (ClassLoadHelper)object4);
            }
        }
        this.getLog().info("Quartz scheduler '" + object.getSchedulerName());
        this.getLog().info("Quartz scheduler version: " + ((QuartzScheduler)object3).getVersion());
        object2 = SchedulerRepository.getInstance();
        ((QuartzScheduler)object3).addNoGCObject(object2);
        ((SchedulerRepository)object2).bind((Scheduler)object);
        this.initialized = true;
    }

    @Override
    public Scheduler getScheduler() {
        if (!this.initialized) {
            throw new SchedulerException("you must call createRemoteScheduler or createScheduler methods before calling getScheduler()");
        }
        return this.getScheduler(DEFAULT_SCHEDULER_NAME);
    }

    @Override
    public Scheduler getScheduler(String string) {
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        return schedulerRepository.lookup(string);
    }

    @Override
    public Collection<Scheduler> getAllSchedulers() {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

