/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore.oracle.weblogic;

import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.oracle.OracleDelegate;
import weblogic.jdbc.vendor.oracle.OracleThinBlob;

public class WebLogicOracleDelegate
extends OracleDelegate {
    @Override
    protected Blob writeDataToBlob(ResultSet object, int n, byte[] byArray) {
        Blob blob = object.getBlob(n);
        if (blob == null) {
            throw new SQLException("Driver's Blob representation is null!");
        }
        if (blob instanceof OracleThinBlob) {
            ((OracleThinBlob)blob).putBytes(1L, byArray);
            return blob;
        }
        if (blob.getClass().getPackage().getName().startsWith("weblogic.")) {
            try {
                object = blob.getClass().getMethod("putBytes", Long.TYPE, byte[].class);
                ((Method)object).invoke((Object)blob, 1L, byArray);
            }
            catch (Exception exception) {
                try {
                    object = blob.getClass().getMethod("setBytes", Long.TYPE, byte[].class);
                    ((Method)object).invoke((Object)blob, 1L, byArray);
                }
                catch (Exception exception2) {
                    throw new SQLException("Unable to find putBytes(long,byte[]) or setBytes(long,byte[]) methods on blob: " + exception2);
                }
            }
            return blob;
        }
        return super.writeDataToBlob((ResultSet)object, n, byArray);
    }
}

