/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.listeners;

import java.util.HashMap;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.listeners.JobListenerSupport;

public class JobChainingJobListener
extends JobListenerSupport {
    private String name;
    private Map<JobKey, JobKey> chainLinks;

    public JobChainingJobListener(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Listener name cannot be null!");
        }
        this.name = string;
        this.chainLinks = new HashMap<JobKey, JobKey>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addJobChainLink(JobKey jobKey, JobKey jobKey2) {
        if (jobKey == null || jobKey2 == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (jobKey.getName() == null || jobKey2.getName() == null) {
            throw new IllegalArgumentException("Key cannot have a null name!");
        }
        this.chainLinks.put(jobKey, jobKey2);
    }

    @Override
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException serializable) {
        serializable = this.chainLinks.get(jobExecutionContext.getJobDetail().getKey());
        if (serializable == null) {
            return;
        }
        this.getLog().info("Job '" + jobExecutionContext.getJobDetail().getKey() + "' will now chain to Job '" + serializable + "'");
        try {
            jobExecutionContext.getScheduler().triggerJob((JobKey)serializable);
            return;
        }
        catch (SchedulerException schedulerException) {
            this.getLog().error("Error encountered during chaining to Job '" + serializable + "'", (Throwable)schedulerException);
            return;
        }
    }
}

