/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Trigger;
import org.quartz.Trigger$CompletedExecutionInstruction;
import org.quartz.Trigger$TriggerState;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.impl.matchers.StringMatcher$StringOperatorName;
import org.quartz.simpl.JobWrapper;
import org.quartz.simpl.RAMJobStore$1;
import org.quartz.simpl.TriggerWrapper;
import org.quartz.simpl.TriggerWrapperComparator;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.DirtyFlagMap;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAMJobStore
implements JobStore {
    protected HashMap<JobKey, JobWrapper> jobsByKey = new HashMap(1000);
    protected HashMap<TriggerKey, TriggerWrapper> triggersByKey = new HashMap(1000);
    protected HashMap<String, HashMap<JobKey, JobWrapper>> jobsByGroup = new HashMap(25);
    protected HashMap<String, HashMap<TriggerKey, TriggerWrapper>> triggersByGroup = new HashMap(25);
    protected TreeSet<TriggerWrapper> timeTriggers = new TreeSet<TriggerWrapper>(new TriggerWrapperComparator());
    protected HashMap<String, Calendar> calendarsByName = new HashMap(25);
    protected Map<JobKey, List<TriggerWrapper>> triggersByJob = new HashMap<JobKey, List<TriggerWrapper>>(1000);
    protected final Object lock = new Object();
    protected HashSet<String> pausedTriggerGroups = new HashSet();
    protected HashSet<String> pausedJobGroups = new HashSet();
    protected HashSet<JobKey> blockedJobs = new HashSet();
    protected long misfireThreshold = 5000L;
    protected SchedulerSignaler signaler;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final AtomicLong ftrCtr = new AtomicLong(System.currentTimeMillis());

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) {
        this.signaler = schedulerSignaler;
        this.getLog().info("RAMJobStore initialized.");
    }

    @Override
    public void schedulerStarted() {
    }

    @Override
    public void schedulerPaused() {
    }

    @Override
    public void schedulerResumed() {
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Misfire threshold must be larger than 0");
        }
        this.misfireThreshold = l;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean supportsPersistence() {
        return false;
    }

    @Override
    public void clearAllSchedulingData() {
        Object object = this.lock;
        synchronized (object) {
            Key key;
            Object object2;
            Object object3 = this.getTriggerGroupNames();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object2 = this.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)object2));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    key = (TriggerKey)object2.next();
                    this.removeTrigger((TriggerKey)key);
                }
            }
            object3 = this.getJobGroupNames();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object2 = this.getJobKeys(GroupMatcher.jobGroupEquals((String)object2));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    key = (JobKey)object2.next();
                    this.removeJob((JobKey)key);
                }
            }
            object3 = this.getCalendarNames();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                this.removeCalendar((String)object2);
            }
            return;
        }
    }

    @Override
    public void storeJobAndTrigger(JobDetail jobDetail, OperableTrigger operableTrigger) {
        this.storeJob(jobDetail, false);
        this.storeTrigger(operableTrigger, false);
    }

    @Override
    public void storeJob(JobDetail jobDetail, boolean bl) {
        JobWrapper jobWrapper = new JobWrapper((JobDetail)jobDetail.clone());
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.jobsByKey.get(jobWrapper.key) != null) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(jobDetail);
                }
                bl2 = true;
            }
            if (!bl2) {
                HashMap<JobKey, JobWrapper> hashMap = this.jobsByGroup.get(jobDetail.getKey().getGroup());
                if (hashMap == null) {
                    hashMap = new HashMap(100);
                    this.jobsByGroup.put(jobDetail.getKey().getGroup(), hashMap);
                }
                hashMap.put(jobDetail.getKey(), jobWrapper);
                this.jobsByKey.put(jobWrapper.key, jobWrapper);
            } else {
                JobWrapper jobWrapper2 = this.jobsByKey.get(jobWrapper.key);
                this.jobsByKey.get(jobWrapper.key).jobDetail = jobWrapper.jobDetail;
            }
            return;
        }
    }

    @Override
    public boolean removeJob(JobKey jobKey) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            HashMap<JobKey, JobWrapper> hashMap = this.getTriggersForJob(jobKey);
            hashMap = hashMap.iterator();
            while (hashMap.hasNext()) {
                OperableTrigger operableTrigger = (OperableTrigger)hashMap.next();
                this.removeTrigger(operableTrigger.getKey());
                bl = true;
            }
            bl = this.jobsByKey.remove(jobKey) != null | bl;
            if (bl && (hashMap = this.jobsByGroup.get(jobKey.getGroup())) != null) {
                hashMap.remove(jobKey);
                if (hashMap.size() == 0) {
                    this.jobsByGroup.remove(jobKey.getGroup());
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeJobs(List<JobKey> object) {
        boolean bl = true;
        Object object2 = this.lock;
        synchronized (object2) {
            object = object.iterator();
            while (object.hasNext()) {
                JobKey jobKey = (JobKey)object.next();
                bl = this.removeJob(jobKey) && bl;
            }
        }
        return bl;
    }

    @Override
    public boolean removeTriggers(List<TriggerKey> object) {
        boolean bl = true;
        Object object2 = this.lock;
        synchronized (object2) {
            object = object.iterator();
            while (object.hasNext()) {
                TriggerKey triggerKey = (TriggerKey)object.next();
                bl = this.removeTrigger(triggerKey) && bl;
            }
        }
        return bl;
    }

    @Override
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (!bl) {
                for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : map.entrySet()) {
                    if (this.checkExists(entry.getKey().getKey())) {
                        throw new ObjectAlreadyExistsException(entry.getKey());
                    }
                    for (Trigger trigger : entry.getValue()) {
                        if (!this.checkExists(trigger.getKey())) continue;
                        throw new ObjectAlreadyExistsException(trigger);
                    }
                }
            }
            for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : map.entrySet()) {
                this.storeJob(entry.getKey(), true);
                for (Trigger trigger : entry.getValue()) {
                    this.storeTrigger((OperableTrigger)trigger, true);
                }
            }
            return;
        }
    }

    @Override
    public void storeTrigger(OperableTrigger operableTrigger, boolean bl) {
        TriggerWrapper triggerWrapper = new TriggerWrapper((OperableTrigger)operableTrigger.clone());
        Object object = this.lock;
        synchronized (object) {
            if (this.triggersByKey.get(triggerWrapper.key) != null) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(operableTrigger);
                }
                this.removeTrigger(operableTrigger.getKey(), false);
            }
            if (this.retrieveJob(operableTrigger.getJobKey()) == null) {
                throw new JobPersistenceException("The job (" + operableTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            Object object2 = this.triggersByJob.get(triggerWrapper.jobKey);
            if (object2 == null) {
                object2 = new ArrayList<TriggerWrapper>(1);
                this.triggersByJob.put(triggerWrapper.jobKey, (List<TriggerWrapper>)object2);
            }
            object2.add((TriggerWrapper)triggerWrapper);
            object2 = this.triggersByGroup.get(operableTrigger.getKey().getGroup());
            if (object2 == null) {
                object2 = new HashMap<TriggerKey, TriggerWrapper>(100);
                this.triggersByGroup.put(operableTrigger.getKey().getGroup(), (HashMap<TriggerKey, TriggerWrapper>)object2);
            }
            ((HashMap)object2).put(operableTrigger.getKey(), triggerWrapper);
            this.triggersByKey.put(triggerWrapper.key, triggerWrapper);
            if (this.pausedTriggerGroups.contains(operableTrigger.getKey().getGroup()) || this.pausedJobGroups.contains(operableTrigger.getJobKey().getGroup())) {
                triggerWrapper.state = 4;
                if (this.blockedJobs.contains(triggerWrapper.jobKey)) {
                    triggerWrapper.state = 6;
                }
            } else if (this.blockedJobs.contains(triggerWrapper.jobKey)) {
                triggerWrapper.state = 5;
            } else {
                this.timeTriggers.add(triggerWrapper);
            }
            return;
        }
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) {
        return this.removeTrigger(triggerKey, true);
    }

    private boolean removeTrigger(TriggerKey object, boolean bl) {
        boolean bl2;
        Object object2 = this.lock;
        synchronized (object2) {
            TriggerWrapper triggerWrapper = this.triggersByKey.remove(object);
            bl2 = triggerWrapper != null;
            if (bl2) {
                HashMap<TriggerKey, TriggerWrapper> hashMap = this.triggersByGroup.get(((Key)object).getGroup());
                if (hashMap != null) {
                    hashMap.remove(object);
                    if (hashMap.size() == 0) {
                        this.triggersByGroup.remove(((Key)object).getGroup());
                    }
                }
                if ((object = this.triggersByJob.get(triggerWrapper.jobKey)) != null) {
                    object.remove(triggerWrapper);
                    if (object.isEmpty()) {
                        this.triggersByJob.remove(triggerWrapper.jobKey);
                    }
                }
                this.timeTriggers.remove(triggerWrapper);
                if (bl) {
                    object = this.jobsByKey.get(triggerWrapper.jobKey);
                    List<OperableTrigger> list = this.getTriggersForJob(triggerWrapper.jobKey);
                    if ((list == null || list.size() == 0) && !((JobWrapper)object).jobDetail.isDurable() && this.removeJob(((JobWrapper)object).key)) {
                        this.signaler.notifySchedulerListenersJobDeleted(((JobWrapper)object).key);
                    }
                }
            }
        }
        return bl2;
    }

    @Override
    public boolean replaceTrigger(TriggerKey object, OperableTrigger operableTrigger) {
        boolean bl;
        Object object2 = this.lock;
        synchronized (object2) {
            TriggerWrapper triggerWrapper = this.triggersByKey.remove(object);
            bl = triggerWrapper != null;
            if (bl) {
                if (!triggerWrapper.getTrigger().getJobKey().equals(operableTrigger.getJobKey())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
                }
                HashMap<TriggerKey, TriggerWrapper> hashMap = this.triggersByGroup.get(((Key)object).getGroup());
                if (hashMap != null) {
                    hashMap.remove(object);
                    if (hashMap.size() == 0) {
                        this.triggersByGroup.remove(((Key)object).getGroup());
                    }
                }
                if ((object = this.triggersByJob.get(triggerWrapper.jobKey)) != null) {
                    object.remove(triggerWrapper);
                    if (object.isEmpty()) {
                        this.triggersByJob.remove(triggerWrapper.jobKey);
                    }
                }
                this.timeTriggers.remove(triggerWrapper);
                try {
                    this.storeTrigger(operableTrigger, false);
                }
                catch (JobPersistenceException jobPersistenceException) {
                    this.storeTrigger(triggerWrapper.getTrigger(), false);
                    throw jobPersistenceException;
                }
            }
        }
        return bl;
    }

    @Override
    public JobDetail retrieveJob(JobKey object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.jobsByKey.get(object);
            return object != null ? (JobDetail)((JobWrapper)object).jobDetail.clone() : null;
        }
    }

    @Override
    public OperableTrigger retrieveTrigger(TriggerKey object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.triggersByKey.get(object);
            return object != null ? (OperableTrigger)((TriggerWrapper)object).getTrigger().clone() : null;
        }
    }

    @Override
    public boolean checkExists(JobKey object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.jobsByKey.get(object);
            return object != null;
        }
    }

    @Override
    public boolean checkExists(TriggerKey object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.triggersByKey.get(object);
            return object != null;
        }
    }

    @Override
    public Trigger$TriggerState getTriggerState(TriggerKey object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.triggersByKey.get(object);
            if (object == null) {
                return Trigger$TriggerState.NONE;
            }
            if (((TriggerWrapper)object).state == 3) {
                return Trigger$TriggerState.COMPLETE;
            }
            if (((TriggerWrapper)object).state == 4) {
                return Trigger$TriggerState.PAUSED;
            }
            if (((TriggerWrapper)object).state == 6) {
                return Trigger$TriggerState.PAUSED;
            }
            if (((TriggerWrapper)object).state == 5) {
                return Trigger$TriggerState.BLOCKED;
            }
            if (((TriggerWrapper)object).state == 7) {
                return Trigger$TriggerState.ERROR;
            }
            return Trigger$TriggerState.NORMAL;
        }
    }

    @Override
    public void resetTriggerFromErrorState(TriggerKey triggerKey) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = this.triggersByKey.get(triggerKey);
            if (triggerWrapper == null || triggerWrapper.trigger == null) {
                return;
            }
            if (triggerWrapper.state != 7) {
                return;
            }
            if (this.pausedTriggerGroups.contains(triggerKey.getGroup())) {
                triggerWrapper.state = 4;
            } else {
                triggerWrapper.state = 0;
                this.timeTriggers.add(triggerWrapper);
            }
            return;
        }
    }

    @Override
    public void storeCalendar(String object, Calendar calendar, boolean bl, boolean bl2) {
        calendar = (Calendar)calendar.clone();
        Object object2 = this.lock;
        synchronized (object2) {
            Calendar calendar2 = this.calendarsByName.get(object);
            if (calendar2 != null && !bl) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + (String)object + "' already exists.");
            }
            if (calendar2 != null) {
                this.calendarsByName.remove(object);
            }
            this.calendarsByName.put((String)object, calendar);
            if (calendar2 != null && bl2) {
                for (TriggerWrapper triggerWrapper : this.getTriggerWrappersForCalendar((String)object)) {
                    OperableTrigger operableTrigger = triggerWrapper.getTrigger();
                    boolean bl3 = this.timeTriggers.remove(triggerWrapper);
                    operableTrigger.updateWithNewCalendar(calendar, this.getMisfireThreshold());
                    if (!bl3) continue;
                    this.timeTriggers.add(triggerWrapper);
                }
            }
            return;
        }
    }

    @Override
    public boolean removeCalendar(String string) {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.triggersByKey.values()) {
                OperableTrigger object2 = triggerWrapper.trigger;
                if (object2.getCalendarName() == null || !object2.getCalendarName().equals(string)) continue;
                ++n;
            }
        }
        if (n > 0) {
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        return this.calendarsByName.remove(string) != null;
    }

    @Override
    public Calendar retrieveCalendar(String object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.calendarsByName.get(object);
            if (object != null) {
                return (Calendar)object.clone();
            }
            return null;
        }
    }

    @Override
    public int getNumberOfJobs() {
        Object object = this.lock;
        synchronized (object) {
            return this.jobsByKey.size();
        }
    }

    @Override
    public int getNumberOfTriggers() {
        Object object = this.lock;
        synchronized (object) {
            return this.triggersByKey.size();
        }
    }

    @Override
    public int getNumberOfCalendars() {
        Object object = this.lock;
        synchronized (object) {
            return this.calendarsByName.size();
        }
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> hashMap) {
        HashSet<JobKey> hashSet = null;
        Object object = this.lock;
        synchronized (object) {
            StringMatcher$StringOperatorName stringMatcher$StringOperatorName = ((StringMatcher)((Object)hashMap)).getCompareWithOperator();
            hashMap = ((StringMatcher)((Object)hashMap)).getCompareToValue();
            switch (stringMatcher$StringOperatorName) {
                case EQUALS: {
                    hashMap = this.jobsByGroup.get(hashMap);
                    if (hashMap == null) break;
                    hashSet = new HashSet<JobKey>();
                    for (JobWrapper jobWrapper : hashMap.values()) {
                        if (jobWrapper == null) continue;
                        hashSet.add(jobWrapper.jobDetail.getKey());
                    }
                    break;
                }
                default: {
                    for (Map.Entry<String, HashMap<JobKey, JobWrapper>> entry : this.jobsByGroup.entrySet()) {
                        if (!stringMatcher$StringOperatorName.evaluate(entry.getKey(), (String)((Object)hashMap)) || entry.getValue() == null) continue;
                        if (hashSet == null) {
                            hashSet = new HashSet();
                        }
                        entry = entry.getValue().values().iterator();
                        while (entry.hasNext()) {
                            JobWrapper jobWrapper = (JobWrapper)entry.next();
                            if (jobWrapper == null) continue;
                            hashSet.add(jobWrapper.jobDetail.getKey());
                        }
                    }
                }
            }
        }
        if (hashSet == null) {
            return Collections.emptySet();
        }
        return hashSet;
    }

    @Override
    public List<String> getCalendarNames() {
        Object object = this.lock;
        synchronized (object) {
            return new LinkedList<String>(this.calendarsByName.keySet());
        }
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> hashMap) {
        HashSet<TriggerKey> hashSet = null;
        Object object = this.lock;
        synchronized (object) {
            StringMatcher$StringOperatorName stringMatcher$StringOperatorName = ((StringMatcher)((Object)hashMap)).getCompareWithOperator();
            hashMap = ((StringMatcher)((Object)hashMap)).getCompareToValue();
            switch (stringMatcher$StringOperatorName) {
                case EQUALS: {
                    hashMap = this.triggersByGroup.get(hashMap);
                    if (hashMap == null) break;
                    hashSet = new HashSet<TriggerKey>();
                    for (TriggerWrapper triggerWrapper : hashMap.values()) {
                        if (triggerWrapper == null) continue;
                        hashSet.add(triggerWrapper.trigger.getKey());
                    }
                    break;
                }
                default: {
                    for (Map.Entry<String, HashMap<TriggerKey, TriggerWrapper>> entry : this.triggersByGroup.entrySet()) {
                        if (!stringMatcher$StringOperatorName.evaluate(entry.getKey(), (String)((Object)hashMap)) || entry.getValue() == null) continue;
                        if (hashSet == null) {
                            hashSet = new HashSet();
                        }
                        entry = entry.getValue().values().iterator();
                        while (entry.hasNext()) {
                            TriggerWrapper triggerWrapper = (TriggerWrapper)entry.next();
                            if (triggerWrapper == null) continue;
                            hashSet.add(triggerWrapper.trigger.getKey());
                        }
                    }
                }
            }
        }
        if (hashSet == null) {
            return Collections.emptySet();
        }
        return hashSet;
    }

    @Override
    public List<String> getJobGroupNames() {
        LinkedList<String> linkedList;
        Object object = this.lock;
        synchronized (object) {
            linkedList = new LinkedList<String>(this.jobsByGroup.keySet());
        }
        return linkedList;
    }

    @Override
    public List<String> getTriggerGroupNames() {
        LinkedList<String> linkedList;
        Object object = this.lock;
        synchronized (object) {
            linkedList = new LinkedList<String>(this.triggersByGroup.keySet());
        }
        return linkedList;
    }

    @Override
    public List<OperableTrigger> getTriggersForJob(JobKey iterator) {
        ArrayList<OperableTrigger> arrayList = new ArrayList<OperableTrigger>();
        Object object = this.lock;
        synchronized (object) {
            iterator = this.triggersByJob.get(iterator);
            if (iterator != null) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    TriggerWrapper triggerWrapper = (TriggerWrapper)iterator.next();
                    arrayList.add((OperableTrigger)triggerWrapper.trigger.clone());
                }
            }
        }
        return arrayList;
    }

    protected ArrayList<TriggerWrapper> getTriggerWrappersForJob(JobKey iterator) {
        ArrayList<TriggerWrapper> arrayList = new ArrayList<TriggerWrapper>();
        Object object = this.lock;
        synchronized (object) {
            iterator = this.triggersByJob.get(iterator);
            if (iterator != null) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    TriggerWrapper triggerWrapper = (TriggerWrapper)iterator.next();
                    arrayList.add(triggerWrapper);
                }
            }
        }
        return arrayList;
    }

    protected ArrayList<TriggerWrapper> getTriggerWrappersForCalendar(String string) {
        ArrayList<TriggerWrapper> arrayList = new ArrayList<TriggerWrapper>();
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.triggersByKey.values()) {
                String string2 = triggerWrapper.getTrigger().getCalendarName();
                if (string2 == null || !string2.equals(string)) continue;
                arrayList.add(triggerWrapper);
            }
        }
        return arrayList;
    }

    @Override
    public void pauseTrigger(TriggerKey object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.triggersByKey.get(object);
            if (object == null || ((TriggerWrapper)object).trigger == null) {
                return;
            }
            if (((TriggerWrapper)object).state == 3) {
                return;
            }
            ((TriggerWrapper)object).state = ((TriggerWrapper)object).state == 5 ? 6 : 4;
            this.timeTriggers.remove(object);
            return;
        }
    }

    public List<String> pauseTriggers(GroupMatcher<TriggerKey> iterator) {
        LinkedList<String> linkedList;
        Object object = this.lock;
        synchronized (object) {
            linkedList = new LinkedList<String>();
            Object object2 = ((StringMatcher)((Object)iterator)).getCompareWithOperator();
            switch (object2) {
                case EQUALS: {
                    if (!this.pausedTriggerGroups.add(((StringMatcher)((Object)iterator)).getCompareToValue())) break;
                    linkedList.add(((StringMatcher)((Object)iterator)).getCompareToValue());
                    break;
                }
                default: {
                    for (String string : this.triggersByGroup.keySet()) {
                        if (!object2.evaluate(string, ((StringMatcher)((Object)iterator)).getCompareToValue()) || !this.pausedTriggerGroups.add(((StringMatcher)((Object)iterator)).getCompareToValue())) continue;
                        linkedList.add(string);
                    }
                }
            }
            for (String string : linkedList) {
                iterator = this.getTriggerKeys(GroupMatcher.triggerGroupEquals(string));
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    this.pauseTrigger((TriggerKey)object2);
                }
            }
        }
        return linkedList;
    }

    @Override
    public void pauseJob(JobKey iterator) {
        Object object = this.lock;
        synchronized (object) {
            iterator = this.getTriggersForJob((JobKey)((Object)iterator));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                OperableTrigger operableTrigger = iterator.next();
                this.pauseTrigger(operableTrigger.getKey());
            }
            return;
        }
    }

    public List<String> pauseJobs(GroupMatcher<JobKey> object) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object2 = this.lock;
        synchronized (object2) {
            StringMatcher$StringOperatorName object32 = ((StringMatcher)((Object)object)).getCompareWithOperator();
            switch (object32) {
                case EQUALS: {
                    if (!this.pausedJobGroups.add(((StringMatcher)((Object)object)).getCompareToValue())) break;
                    linkedList.add(((StringMatcher)((Object)object)).getCompareToValue());
                    break;
                }
                default: {
                    for (String string : this.jobsByGroup.keySet()) {
                        if (!object32.evaluate(string, ((StringMatcher)((Object)object)).getCompareToValue()) || !this.pausedJobGroups.add(string)) continue;
                        linkedList.add(string);
                    }
                }
            }
            for (String string : linkedList) {
                for (JobKey jobKey : this.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                    List<OperableTrigger> list = this.getTriggersForJob(jobKey);
                    for (OperableTrigger operableTrigger : list) {
                        this.pauseTrigger(operableTrigger.getKey());
                    }
                }
            }
        }
        return linkedList;
    }

    @Override
    public void resumeTrigger(TriggerKey object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.triggersByKey.get(object);
            if (object == null || ((TriggerWrapper)object).trigger == null) {
                return;
            }
            OperableTrigger operableTrigger = ((TriggerWrapper)object).getTrigger();
            if (((TriggerWrapper)object).state != 4 && ((TriggerWrapper)object).state != 6) {
                return;
            }
            ((TriggerWrapper)object).state = this.blockedJobs.contains(operableTrigger.getJobKey()) ? 5 : 0;
            this.applyMisfire((TriggerWrapper)object);
            if (((TriggerWrapper)object).state == 0) {
                this.timeTriggers.add((TriggerWrapper)object);
            }
            return;
        }
    }

    public List<String> resumeTriggers(GroupMatcher<TriggerKey> iterator) {
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            String string;
            Serializable serializable;
            Object object2 = this.getTriggerKeys((GroupMatcher<TriggerKey>)((Object)iterator));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                serializable = (TriggerKey)object2.next();
                hashSet.add(((Key)serializable).getGroup());
                if (this.triggersByKey.get(serializable) != null && this.pausedJobGroups.contains(string = this.triggersByKey.get((Object)serializable).jobKey.getGroup())) continue;
                this.resumeTrigger((TriggerKey)serializable);
            }
            object2 = ((StringMatcher)((Object)iterator)).getCompareWithOperator();
            serializable = new LinkedList();
            string = ((StringMatcher)((Object)iterator)).getCompareToValue();
            switch (RAMJobStore$1.$SwitchMap$org$quartz$impl$matchers$StringMatcher$StringOperatorName[((Enum)object2).ordinal()]) {
                case 1: {
                    if (!this.pausedTriggerGroups.contains(string)) break;
                    ((LinkedList)serializable).add(((StringMatcher)((Object)iterator)).getCompareToValue());
                    break;
                }
                default: {
                    for (String string2 : this.pausedTriggerGroups) {
                        if (!((StringMatcher$StringOperatorName)((Object)object2)).evaluate(string2, string)) continue;
                        ((LinkedList)serializable).add(string2);
                    }
                }
            }
            iterator = ((AbstractSequentialList)((Object)serializable)).iterator();
            while (iterator.hasNext()) {
                String string2;
                string2 = (String)iterator.next();
                this.pausedTriggerGroups.remove(string2);
            }
        }
        return new ArrayList<String>(hashSet);
    }

    @Override
    public void resumeJob(JobKey iterator) {
        Object object = this.lock;
        synchronized (object) {
            iterator = this.getTriggersForJob((JobKey)((Object)iterator));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                OperableTrigger operableTrigger = iterator.next();
                this.resumeTrigger(operableTrigger.getKey());
            }
            return;
        }
    }

    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> iterator) {
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.getJobKeys((GroupMatcher<JobKey>)((Object)iterator));
            for (String object3 : this.pausedJobGroups) {
                if (!((StringMatcher)((Object)iterator)).getCompareWithOperator().evaluate(object3, ((StringMatcher)((Object)iterator)).getCompareToValue())) continue;
                hashSet.add(object3);
            }
            for (String string : hashSet) {
                this.pausedJobGroups.remove(string);
            }
            Iterator<Object> iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                JobKey jobKey = (JobKey)iterator2.next();
                iterator = this.getTriggersForJob(jobKey);
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    this.resumeTrigger(object2.getKey());
                }
            }
        }
        return hashSet;
    }

    @Override
    public void pauseAll() {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.getTriggerGroupNames();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                this.pauseTriggers((GroupMatcher)GroupMatcher.triggerGroupEquals(string));
            }
            return;
        }
    }

    @Override
    public void resumeAll() {
        Object object = this.lock;
        synchronized (object) {
            this.pausedJobGroups.clear();
            this.resumeTriggers((GroupMatcher)GroupMatcher.anyTriggerGroup());
            return;
        }
    }

    protected boolean applyMisfire(TriggerWrapper triggerWrapper) {
        Date date;
        long l = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            l -= this.getMisfireThreshold();
        }
        if ((date = triggerWrapper.trigger.getNextFireTime()) == null || date.getTime() > l || triggerWrapper.trigger.getMisfireInstruction() == -1) {
            return false;
        }
        Object object = null;
        if (triggerWrapper.trigger.getCalendarName() != null) {
            object = this.retrieveCalendar(triggerWrapper.trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired((OperableTrigger)triggerWrapper.trigger.clone());
        triggerWrapper.trigger.updateAfterMisfire((Calendar)object);
        if (triggerWrapper.trigger.getNextFireTime() == null) {
            triggerWrapper.state = 3;
            this.signaler.notifySchedulerListenersFinalized(triggerWrapper.trigger);
            object = this.lock;
            synchronized (object) {
                this.timeTriggers.remove(triggerWrapper);
            }
        } else if (date.equals(triggerWrapper.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    protected String getFiredTriggerRecordId() {
        return String.valueOf(ftrCtr.incrementAndGet());
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(long l, int n, long l2) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<OperableTrigger> arrayList = new ArrayList<OperableTrigger>();
            HashSet<JobKey> hashSet = new HashSet<JobKey>();
            HashSet<TriggerWrapper> hashSet2 = new HashSet<TriggerWrapper>();
            long l3 = l;
            if (this.timeTriggers.size() == 0) {
                return arrayList;
            }
            while (true) {
                TriggerWrapper triggerWrapper;
                try {
                    triggerWrapper = this.timeTriggers.first();
                    if (triggerWrapper == null) break;
                    this.timeTriggers.remove(triggerWrapper);
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                if (triggerWrapper.trigger.getNextFireTime() == null) continue;
                if (this.applyMisfire(triggerWrapper)) {
                    if (triggerWrapper.trigger.getNextFireTime() == null) continue;
                    this.timeTriggers.add(triggerWrapper);
                    continue;
                }
                if (triggerWrapper.getTrigger().getNextFireTime().getTime() > l3) {
                    this.timeTriggers.add(triggerWrapper);
                    break;
                }
                Comparable<Key<JobKey>> comparable = triggerWrapper.trigger.getJobKey();
                JobDetail jobDetail = this.jobsByKey.get((Object)triggerWrapper.trigger.getJobKey()).jobDetail;
                if (jobDetail.isConcurrentExectionDisallowed()) {
                    if (hashSet.contains(comparable)) {
                        hashSet2.add(triggerWrapper);
                        continue;
                    }
                    hashSet.add((JobKey)comparable);
                }
                triggerWrapper.state = 1;
                triggerWrapper.trigger.setFireInstanceId(this.getFiredTriggerRecordId());
                comparable = (OperableTrigger)triggerWrapper.trigger.clone();
                if (arrayList.isEmpty()) {
                    l3 = Math.max(triggerWrapper.trigger.getNextFireTime().getTime(), System.currentTimeMillis()) + l2;
                }
                arrayList.add((OperableTrigger)comparable);
                if (arrayList.size() == n) break;
            }
            if (hashSet2.size() > 0) {
                this.timeTriggers.addAll(hashSet2);
            }
            return arrayList;
        }
    }

    @Override
    public void releaseAcquiredTrigger(OperableTrigger object) {
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.triggersByKey.get(object.getKey());
            if (object != null && ((TriggerWrapper)object).state == 1) {
                ((TriggerWrapper)object).state = 0;
                this.timeTriggers.add((TriggerWrapper)object);
            }
            return;
        }
    }

    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> object) {
        Object object2 = this.lock;
        synchronized (object2) {
            ArrayList<TriggerFiredResult> arrayList = new ArrayList<TriggerFiredResult>();
            object = object.iterator();
            while (object.hasNext()) {
                Serializable serializable = (OperableTrigger)object.next();
                Object object3 = this.triggersByKey.get(serializable.getKey());
                if (object3 == null || ((TriggerWrapper)object3).trigger == null || ((TriggerWrapper)object3).state != 1) continue;
                Cloneable cloneable = null;
                if (((TriggerWrapper)object3).trigger.getCalendarName() != null && (cloneable = this.retrieveCalendar(((TriggerWrapper)object3).trigger.getCalendarName())) == null) continue;
                Object object4 = serializable.getPreviousFireTime();
                this.timeTriggers.remove(object3);
                ((TriggerWrapper)object3).trigger.triggered((Calendar)cloneable);
                serializable.triggered((Calendar)cloneable);
                ((TriggerWrapper)object3).state = 0;
                serializable = new TriggerFiredBundle(this.retrieveJob(((TriggerWrapper)object3).jobKey), (OperableTrigger)serializable, (Calendar)cloneable, false, new Date(), serializable.getPreviousFireTime(), (Date)object4, serializable.getNextFireTime());
                cloneable = ((TriggerFiredBundle)serializable).getJobDetail();
                if (cloneable.isConcurrentExectionDisallowed()) {
                    object4 = this.getTriggerWrappersForJob(cloneable.getKey());
                    object3 = ((ArrayList)object4).iterator();
                    while (object3.hasNext()) {
                        object4 = (TriggerWrapper)object3.next();
                        if (((TriggerWrapper)object4).state == 0) {
                            ((TriggerWrapper)object4).state = 5;
                        }
                        if (((TriggerWrapper)object4).state == 4) {
                            ((TriggerWrapper)object4).state = 6;
                        }
                        this.timeTriggers.remove(object4);
                    }
                    this.blockedJobs.add(cloneable.getKey());
                } else if (((TriggerWrapper)object3).trigger.getNextFireTime() != null) {
                    object4 = this.lock;
                    synchronized (object4) {
                        this.timeTriggers.add((TriggerWrapper)object3);
                    }
                }
                arrayList.add(new TriggerFiredResult((TriggerFiredBundle)serializable));
            }
            return arrayList;
        }
    }

    @Override
    public void triggeredJobComplete(OperableTrigger operableTrigger, JobDetail object, Trigger$CompletedExecutionInstruction trigger$CompletedExecutionInstruction) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object object3 = this.jobsByKey.get(object.getKey());
            TriggerWrapper triggerWrapper = this.triggersByKey.get(operableTrigger.getKey());
            if (object3 != null) {
                JobDetail jobDetail = ((JobWrapper)object3).jobDetail;
                if (jobDetail.isPersistJobDataAfterExecution()) {
                    if ((object = object.getJobDataMap()) != null) {
                        object = (JobDataMap)((DirtyFlagMap)object).clone();
                        ((DirtyFlagMap)object).clearDirtyFlag();
                    }
                    ((JobWrapper)object3).jobDetail = jobDetail = jobDetail.getJobBuilder().setJobData((JobDataMap)object).build();
                }
                if (jobDetail.isConcurrentExectionDisallowed()) {
                    this.blockedJobs.remove(jobDetail.getKey());
                    object = this.getTriggerWrappersForJob(jobDetail.getKey());
                    object = ((ArrayList)object).iterator();
                    while (object.hasNext()) {
                        object3 = (TriggerWrapper)object.next();
                        if (((TriggerWrapper)object3).state == 5) {
                            ((TriggerWrapper)object3).state = 0;
                            this.timeTriggers.add((TriggerWrapper)object3);
                        }
                        if (((TriggerWrapper)object3).state != 6) continue;
                        ((TriggerWrapper)object3).state = 4;
                    }
                    this.signaler.signalSchedulingChange(0L);
                }
            } else {
                this.blockedJobs.remove(object.getKey());
            }
            if (triggerWrapper != null) {
                if (trigger$CompletedExecutionInstruction == Trigger$CompletedExecutionInstruction.DELETE_TRIGGER) {
                    if (operableTrigger.getNextFireTime() == null) {
                        if (triggerWrapper.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(operableTrigger.getKey());
                        }
                    } else {
                        this.removeTrigger(operableTrigger.getKey());
                        this.signaler.signalSchedulingChange(0L);
                    }
                } else if (trigger$CompletedExecutionInstruction == Trigger$CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                    triggerWrapper.state = 3;
                    this.timeTriggers.remove(triggerWrapper);
                    this.signaler.signalSchedulingChange(0L);
                } else if (trigger$CompletedExecutionInstruction == Trigger$CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                    this.getLog().info("Trigger " + operableTrigger.getKey() + " set to ERROR state.");
                    triggerWrapper.state = 7;
                    this.signaler.signalSchedulingChange(0L);
                } else if (trigger$CompletedExecutionInstruction == Trigger$CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                    this.getLog().info("All triggers of Job " + operableTrigger.getJobKey() + " set to ERROR state.");
                    this.setAllTriggersOfJobToState(operableTrigger.getJobKey(), 7);
                    this.signaler.signalSchedulingChange(0L);
                } else if (trigger$CompletedExecutionInstruction == Trigger$CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                    this.setAllTriggersOfJobToState(operableTrigger.getJobKey(), 3);
                    this.signaler.signalSchedulingChange(0L);
                }
            }
            return;
        }
    }

    @Override
    public long getAcquireRetryDelay(int n) {
        return 20L;
    }

    protected void setAllTriggersOfJobToState(JobKey object, int n) {
        object = this.getTriggerWrappersForJob((JobKey)object);
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)object.next();
            ((TriggerWrapper)object.next()).state = n;
            if (n == 0) continue;
            this.timeTriggers.remove(triggerWrapper);
        }
    }

    protected String peekTriggers() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.triggersByKey.values()) {
                stringBuilder.append(triggerWrapper.trigger.getKey().getName());
                stringBuilder.append("/");
            }
        }
        stringBuilder.append(" | ");
        object = this.lock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.timeTriggers) {
                stringBuilder.append(triggerWrapper.trigger.getKey().getName());
                stringBuilder.append("->");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<String> getPausedTriggerGroups() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.pausedTriggerGroups);
        return hashSet;
    }

    @Override
    public void setInstanceId(String string) {
    }

    @Override
    public void setInstanceName(String string) {
    }

    @Override
    public void setThreadPoolSize(int n) {
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 5L;
    }

    @Override
    public boolean isClustered() {
        return false;
    }
}

