/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedList;

public class ClassUtils {
    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> clazz2) {
        while (clazz != null) {
            if (clazz.isAnnotationPresent(clazz2)) {
                return true;
            }
            if (ClassUtils.isAnnotationPresentOnInterfaces(clazz, clazz2)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private static boolean isAnnotationPresentOnInterfaces(Class<?> classArray, Class<? extends Annotation> clazz) {
        for (Class<?> clazz2 : classArray.getInterfaces()) {
            if (clazz2.isAnnotationPresent(clazz)) {
                return true;
            }
            if (!ClassUtils.isAnnotationPresentOnInterfaces(clazz2, clazz)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> clazz2) {
        Object object;
        Serializable serializable;
        for (serializable = clazz; serializable != null; serializable = ((Class)serializable).getSuperclass()) {
            object = ((Class)serializable).getAnnotation(clazz2);
            if (object == null) continue;
            return object;
        }
        serializable = new LinkedList();
        serializable.add(clazz);
        while (!serializable.isEmpty()) {
            object = (Class)serializable.remove();
            if (object == null) continue;
            if (((Class)object).isInterface()) {
                clazz = ((Class)object).getAnnotation(clazz2);
                if (clazz != null) {
                    return (T)clazz;
                }
            } else {
                serializable.add(((Class)object).getSuperclass());
            }
            serializable.addAll(Arrays.asList(((Class)object).getInterfaces()));
        }
        return null;
    }
}

