(function (_, kotlin_kotlin) {
  'use strict';
  //region block: imports
  var IndexOutOfBoundsException_init_$Create$ = kotlin_kotlin.$_$.e2;
  var Long = kotlin_kotlin.$_$.yh;
  var IllegalArgumentException_init_$Create$ = kotlin_kotlin.$_$.u1;
  var _Char___init__impl__6a9atx = kotlin_kotlin.$_$.u2;
  var charArrayOf = kotlin_kotlin.$_$.eb;
  var VOID = kotlin_kotlin.$_$.f;
  var toLong = kotlin_kotlin.$_$.xc;
  var Unit_instance = kotlin_kotlin.$_$.m5;
  var protoOf = kotlin_kotlin.$_$.uc;
  var objectCreate = kotlin_kotlin.$_$.sc;
  var captureStack = kotlin_kotlin.$_$.db;
  var Exception = kotlin_kotlin.$_$.uh;
  var Exception_init_$Init$ = kotlin_kotlin.$_$.o1;
  var classMeta = kotlin_kotlin.$_$.jb;
  var setMetadataFor = kotlin_kotlin.$_$.vc;
  //endregion
  //region block: pre-declaration
  setMetadataFor(IOException, 'IOException', classMeta, Exception, VOID, IOException_init_$Create$);
  setMetadataFor(EOFException, 'EOFException', classMeta, IOException, VOID, EOFException);
  //endregion
  var HEX_DIGIT_CHARS;
  function checkBounds(size, startIndex, endIndex) {
    _init_properties__Util_kt__g8tcl9();
    if (startIndex.c7(new Long(0, 0)) < 0 ? true : endIndex.c7(size) > 0) {
      throw IndexOutOfBoundsException_init_$Create$('startIndex (' + startIndex.toString() + ') and endIndex (' + endIndex.toString() + ') are not within the range [0..size(' + size.toString() + '))');
    }
    if (startIndex.c7(endIndex) > 0) {
      throw IllegalArgumentException_init_$Create$('startIndex (' + startIndex.toString() + ') > endIndex (' + endIndex.toString() + ')');
    }
  }
  var properties_initialized__Util_kt_67kc5b;
  function _init_properties__Util_kt__g8tcl9() {
    if (!properties_initialized__Util_kt_67kc5b) {
      properties_initialized__Util_kt_67kc5b = true;
      // Inline function 'kotlin.charArrayOf' call
      HEX_DIGIT_CHARS = charArrayOf([_Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(97), _Char___init__impl__6a9atx(98), _Char___init__impl__6a9atx(99), _Char___init__impl__6a9atx(100), _Char___init__impl__6a9atx(101), _Char___init__impl__6a9atx(102)]);
    }
  }
  function readTo(_this__u8e3s4, sink, startIndex, endIndex) {
    startIndex = startIndex === VOID ? 0 : startIndex;
    endIndex = endIndex === VOID ? sink.length : endIndex;
    // Inline function 'kotlinx.io.checkBounds' call
    var size = sink.length;
    checkBounds(toLong(size), toLong(startIndex), toLong(endIndex));
    var offset = startIndex;
    while (offset < endIndex) {
      var bytesRead = _this__u8e3s4.yk4(sink, offset, endIndex);
      if (bytesRead === -1) {
        throw new EOFException('Source exhausted before reading ' + (endIndex - startIndex | 0) + ' bytes. ' + ('Only ' + bytesRead + ' bytes were read.'));
      }
      offset = offset + bytesRead | 0;
    }
  }
  function IOException_init_$Init$(message, $this) {
    message = message === VOID ? null : message;
    IOException.call($this, message, null);
    return $this;
  }
  function IOException_init_$Create$(message) {
    var tmp = IOException_init_$Init$(message, objectCreate(protoOf(IOException)));
    captureStack(tmp, IOException_init_$Create$);
    return tmp;
  }
  function IOException(message, cause) {
    Exception_init_$Init$(message, cause, this);
    captureStack(this, IOException);
  }
  function EOFException(message) {
    message = message === VOID ? null : message;
    IOException_init_$Init$(message, this);
    captureStack(this, EOFException);
  }
  //region block: exports
  _.$_$ = _.$_$ || {};
  _.$_$.a = readTo;
  //endregion
  return _;
}(module.exports, require('./kotlin-kotlin-stdlib.js')));

//# sourceMappingURL=kotlinx-io-kotlinx-io-core.js.map
