describe('WEB_004_003_multiple_submission_possible _for_student', () => {
  before(() => {
    // Start Test Server
    cy.ustadStartTestServer(6000)
  })

it('Teacher add assignment', () => {
  cy.importUsersViaHttp("Ustad_Teacher_and_Students.csv");
  cy.ustadClearDbAndLogin('teach1','testt1')
  cy.contains("Course").click()
  cy.contains("Test Course Block").click()
  cy.contains("button","Edit").click()
  cy.contains("Add block").click()
  cy.contains("Assignment").click()
  cy.get('input[id="title"]').type("Assignment 1")
  cy.get('div[data-placeholder="Description"]').type("this is a simple assignment")
  cy.contains("div","Graded").click()
  cy.contains("li","Submitted").click()
  cy.ustadSetDateTime(cy.get("#cbDeadlineDate"), new Date("2025-06-01T08:30"))
  cy.get('#caSubmissionPolicy').click()
  cy.contains('Can make multiple submissions').click()
  cy.contains("button","Done").should('be.visible')
  cy.contains("button","Done").click()
  cy.contains("button","Save").should('be.visible')
  cy.contains("button","Save").click()
  cy.contains("button","Members").should('be.visible')
  cy.contains("button","Edit").click()
  cy.contains("Assignment 1").click()
  cy.contains("button","Done").should('be.visible')
  cy.contains("button","Done").click()
  cy.contains("button","Save").should('be.visible')
  cy.contains("button","Save").click()
  cy.contains("button","Members").should('be.visible')
})

it('Student submit assignment', () => {

  cy.ustadClearDbAndLogin('stud1','tests1')
  cy.contains("Course").click()
  cy.contains("Test Course Block").click()
  cy.contains('Assignment 1').click()
  cy.get('#assignment_text').get('div[contenteditable="true"]',{timeout:5000}).should('be.visible')
  cy.get('.ql-editor').ustadTypeAndVerify('Text 1')
  cy.contains('SUBMIT').click()
  cy.contains("Submission 1").should("be.visible")
  cy.contains("Text 1").should('be.visible')
})

it('Teacher can mark assignment and add course comment', () => {
  cy.ustadClearDbAndLogin('teach1','testt1')
  cy.contains("Course").click()
  cy.contains("Test Course Block").click()
  cy.contains("button","Course").click()
  cy.contains("Assignment 1").click()
  cy.contains('Submissions').click()
  cy.ustadReloadUntilVisible("Student 1")
  cy.contains("Student 1").click()
  cy.get('#marker_comment').type("Keep it up")
  cy.get('#marker_mark').type('9')
  cy.get('#submit_mark_button').click()
  cy.contains('Keep it up').should('be.visible')
  cy.contains('9/10 Points').should('be.visible')
})

it('Student can add another submission', () => {
  cy.ustadClearDbAndLogin('stud1','tests1')
  cy.contains("Course").click()
  cy.contains("Test Course Block").click()
  cy.contains('Assignment 1').click()
  cy.get(".VirtualList").scrollTo('bottom')
  cy.contains('Keep it up').should('exist')
  cy.contains('9/10 Points').should('exist')
  cy.get('#assignment_text').get('div[contenteditable="true"]',{timeout:5000}).should('exist')
  cy.contains('SUBMIT').should('exist')
  cy.get('.ql-editor').ustadTypeAndVerify('Text 2')
  cy.contains('SUBMIT').click()
  cy.contains("Submission 2").should("be.visible")
})

it('Teacher can update mark', () => {
  cy.ustadClearDbAndLogin('teach1','testt1')
  cy.contains("Course").click()
  cy.contains("Test Course Block").click()
  cy.contains("button","Course").click()
  cy.contains("Assignment 1").click()
  cy.contains('Submissions').click()
  cy.ustadReloadUntilVisible("Student 1")
  cy.contains("Student 1").click()
  cy.contains("Submission 2").should("be.visible")
  cy.get('#marker_comment').type("Keep it up")
  cy.get('#marker_mark').type('9.5')
  cy.get('#submit_mark_button').click()
  cy.contains('Keep it up').should('be.visible')
  cy.contains('9.5/10 Points').should('be.visible')
})

it('Student can see the updated mark', () => {
  cy.ustadClearDbAndLogin('stud1','tests1')
  cy.contains("Course").click()
  cy.contains("Test Course Block").click()
  cy.contains('Assignment 1').click()
  cy.contains("Submission 2").click()
  cy.get(".VirtualList").scrollTo('bottom')
  cy.contains('Keep it up').should('exist')
  cy.contains('9.5/10 Points').should('exist')
})

  after(() => {
    // Stop Test Server after tests are complete
    cy.ustadStopTestServer();
  })
})