@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem
@rem SPDX-License-Identifier: Apache-2.0
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  respect-cli startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and RESPECT_CLI_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo. 1>&2
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH. 1>&2
echo. 1>&2
echo Please set the JAVA_HOME variable in your environment to match the 1>&2
echo location of your Java installation. 1>&2

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo. 1>&2
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME% 1>&2
echo. 1>&2
echo Please set the JAVA_HOME variable in your environment to match the 1>&2
echo location of your Java installation. 1>&2

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\respect-cli.jar;%APP_HOME%\lib\respect-lib-shared-jvm.jar;%APP_HOME%\lib\respect-datalayer-db-jvm.jar;%APP_HOME%\lib\respect-datalayer-http-jvm.jar;%APP_HOME%\lib\respect-datalayer-jvm.jar;%APP_HOME%\lib\respect-credentials-jvm.jar;%APP_HOME%\lib\respect-lib-util-jvm.jar;%APP_HOME%\lib\respect-lib-cache-jvm.jar;%APP_HOME%\lib\ktor-client-json-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-client-content-negotiation-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-client-okhttp-jvm-3.3.0.jar;%APP_HOME%\lib\respect-lib-ihttp-okhttp-jvm.jar;%APP_HOME%\lib\respect-lib-ihttp-core-jvm.jar;%APP_HOME%\lib\ktor-client-core-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-serialization-kotlinx-json-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-http-cio-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-websocket-serialization-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-serialization-kotlinx-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-serialization-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-websockets-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-http-jvm-3.3.0.jar;%APP_HOME%\lib\navigation-compose-desktop-2.9.0.jar;%APP_HOME%\lib\kotlinx-serialization-json-io-jvm-1.9.0.jar;%APP_HOME%\lib\lifecycle-viewmodel-compose-desktop-2.9.4.jar;%APP_HOME%\lib\navigation-runtime-desktop-2.9.0.jar;%APP_HOME%\lib\navigation-common-desktop-2.9.0.jar;%APP_HOME%\lib\library-desktop-1.9.0.jar;%APP_HOME%\lib\foundation-desktop-1.9.0.jar;%APP_HOME%\lib\animation-desktop-1.9.0.jar;%APP_HOME%\lib\foundation-layout-desktop-1.9.0.jar;%APP_HOME%\lib\animation-core-desktop-1.9.0.jar;%APP_HOME%\lib\ui-desktop-1.9.0.jar;%APP_HOME%\lib\ui-text-desktop-1.9.0.jar;%APP_HOME%\lib\runtime-saveable-desktop-1.9.0.jar;%APP_HOME%\lib\ui-backhandler-desktop-1.9.0.jar;%APP_HOME%\lib\lifecycle-runtime-compose-desktop-2.9.4.jar;%APP_HOME%\lib\savedstate-compose-desktop-1.3.4.jar;%APP_HOME%\lib\savedstate-desktop-1.3.1.jar;%APP_HOME%\lib\lifecycle-runtime-desktop-2.9.2.jar;%APP_HOME%\lib\lifecycle-common-jvm-2.9.2.jar;%APP_HOME%\lib\lifecycle-viewmodel-desktop-2.9.2.jar;%APP_HOME%\lib\lifecycle-viewmodel-savedstate-desktop-2.9.2.jar;%APP_HOME%\lib\ktor-events-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-sse-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-network-jvm-3.3.0.jar;%APP_HOME%\lib\ktor-utils-jvm-3.3.0.jar;%APP_HOME%\lib\kotlinx-serialization-core-jvm-1.9.0.jar;%APP_HOME%\lib\kotlinx-serialization-json-jvm-1.9.0.jar;%APP_HOME%\lib\respect-lib-primarykeygen-jvm.jar;%APP_HOME%\lib\kotlinx-datetime-jvm-0.7.1.jar;%APP_HOME%\lib\room-common-jvm-2.8.0.jar;%APP_HOME%\lib\room-paging-jvm-2.8.0.jar;%APP_HOME%\lib\room-runtime-jvm-2.8.0.jar;%APP_HOME%\lib\paging-common-desktop-3.4.0-alpha04.jar;%APP_HOME%\lib\ktor-io-jvm-3.3.0.jar;%APP_HOME%\lib\ui-graphics-desktop-1.9.0.jar;%APP_HOME%\lib\ui-unit-desktop-1.9.0.jar;%APP_HOME%\lib\ui-geometry-desktop-1.9.0.jar;%APP_HOME%\lib\runtime-desktop-1.9.0.jar;%APP_HOME%\lib\runtime-annotation-jvm-1.9.0.jar;%APP_HOME%\lib\runtime-desktop-1.9.0.jar;%APP_HOME%\lib\skiko-awt-0.9.22.2.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.10.2.jar;%APP_HOME%\lib\kotlinx-coroutines-slf4j-1.10.2.jar;%APP_HOME%\lib\okhttp-jvm-5.1.0.jar;%APP_HOME%\lib\respect-lib-xxhash-jvm.jar;%APP_HOME%\lib\uri-jvm-0.0.20.jar;%APP_HOME%\lib\napier-jvm-2.7.1.jar;%APP_HOME%\lib\respect-lib-ihttp-iostreams-jvm.jar;%APP_HOME%\lib\koin-core-jvm-4.1.1.jar;%APP_HOME%\lib\multiplatform-settings-jvm-1.3.0.jar;%APP_HOME%\lib\kotlinx-io-okio-jvm-0.8.0.jar;%APP_HOME%\lib\okio-jvm-3.16.0.jar;%APP_HOME%\lib\atomicfu-jvm-0.29.0.jar;%APP_HOME%\lib\kotlinx-io-core-jvm-0.8.0.jar;%APP_HOME%\lib\core-common-2.2.0.jar;%APP_HOME%\lib\ui-util-desktop-1.9.0.jar;%APP_HOME%\lib\collection-jvm-1.5.0.jar;%APP_HOME%\lib\sqlite-jvm-2.6.0.jar;%APP_HOME%\lib\annotation-jvm-1.9.1.jar;%APP_HOME%\lib\stately-concurrent-collections-jvm-2.1.0.jar;%APP_HOME%\lib\stately-concurrency-jvm-2.1.0.jar;%APP_HOME%\lib\kotlinx-io-bytestring-jvm-0.8.0.jar;%APP_HOME%\lib\stately-strict-jvm-2.1.0.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-2.1.21.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-2.1.21.jar;%APP_HOME%\lib\kotlin-stdlib-2.2.20.jar;%APP_HOME%\lib\argparse4j-0.9.0.jar;%APP_HOME%\lib\webauthn4j-core-0.25.0.RELEASE.jar;%APP_HOME%\lib\webauthn4j-util-0.25.0.RELEASE.jar;%APP_HOME%\lib\annotations-24.1.0.jar;%APP_HOME%\lib\json-schema-validator-1.5.9.jar;%APP_HOME%\lib\slf4j-api-2.0.17.jar;%APP_HOME%\lib\jsoup-1.21.2.jar;%APP_HOME%\lib\nanohttpd-2.3.1.jar;%APP_HOME%\lib\lz4-pure-java-1.8.0.jar;%APP_HOME%\lib\itu-1.14.0.jar;%APP_HOME%\lib\jackson-annotations-2.18.3.jar;%APP_HOME%\lib\jackson-dataformat-cbor-2.18.3.jar;%APP_HOME%\lib\jackson-core-2.18.3.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.18.3.jar;%APP_HOME%\lib\jackson-databind-2.18.3.jar;%APP_HOME%\lib\kerby-asn1-2.0.3.jar;%APP_HOME%\lib\snakeyaml-2.3.jar;%APP_HOME%\lib\jspecify-1.0.0.jar;%APP_HOME%\lib\jbr-api-1.5.0.jar


@rem Execute respect-cli
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %RESPECT_CLI_OPTS%  -classpath "%CLASSPATH%" world.respect.clitools.RespectCLI %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable RESPECT_CLI_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%RESPECT_CLI_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
