/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account.authwithpassword;

import androidx.compose.runtime.internal.StabilityInferred;
import io.ktor.http.Url;
import io.ktor.util.Base64Kt;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.credentials.passkey.RespectCredential;
import world.respect.credentials.passkey.RespectPasskeyCredential;
import world.respect.credentials.passkey.RespectPasswordCredential;
import world.respect.credentials.passkey.model.PasskeyVerifyResult;
import world.respect.datalayer.DataLoadState;
import world.respect.datalayer.RespectAppDataSource;
import world.respect.datalayer.db.RespectSchoolDatabase;
import world.respect.datalayer.db.school.adapters.AuthTokenAdapterKt;
import world.respect.datalayer.db.school.adapters.PersonAdapterKt;
import world.respect.datalayer.db.school.adapters.PersonEntities;
import world.respect.datalayer.db.school.entities.PersonEntityWithRoles;
import world.respect.datalayer.db.school.entities.PersonPasskeyEntity;
import world.respect.datalayer.db.school.entities.PersonPasswordEntity;
import world.respect.datalayer.ext.DataLoadStateExtKt;
import world.respect.datalayer.respect.model.SchoolDirectoryEntry;
import world.respect.datalayer.school.model.AuthToken;
import world.respect.datalayer.school.model.DeviceInfo;
import world.respect.libutil.ext.RandomStringKt;
import world.respect.libutil.util.throwable.ExceptionWithHttpStatusCodeKt;
import world.respect.libutil.util.throwable.ForbiddenException;
import world.respect.libxxhash.XXStringHasher;
import world.respect.shared.domain.account.AuthResponse;
import world.respect.shared.domain.account.authwithpassword.GetTokenAndUserProfileWithCredentialDbImpl;
import world.respect.shared.domain.account.gettokenanduser.GetTokenAndUserProfileWithCredentialUseCase;
import world.respect.shared.domain.account.passkey.VerifySignInWithPasskeyUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096B\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lworld/respect/shared/domain/account/authwithpassword/GetTokenAndUserProfileWithCredentialDbImpl;", "Lworld/respect/shared/domain/account/gettokenanduser/GetTokenAndUserProfileWithCredentialUseCase;", "schoolUrl", "Lio/ktor/http/Url;", "schoolDb", "Lworld/respect/datalayer/db/RespectSchoolDatabase;", "xxHash", "Lworld/respect/libxxhash/XXStringHasher;", "verifyPasskeyUseCase", "Lworld/respect/shared/domain/account/passkey/VerifySignInWithPasskeyUseCase;", "respectAppDataSource", "Lworld/respect/datalayer/RespectAppDataSource;", "<init>", "(Lio/ktor/http/Url;Lworld/respect/datalayer/db/RespectSchoolDatabase;Lworld/respect/libxxhash/XXStringHasher;Lworld/respect/shared/domain/account/passkey/VerifySignInWithPasskeyUseCase;Lworld/respect/datalayer/RespectAppDataSource;)V", "invoke", "Lworld/respect/shared/domain/account/AuthResponse;", "credential", "Lworld/respect/credentials/passkey/RespectCredential;", "deviceInfo", "Lworld/respect/datalayer/school/model/DeviceInfo;", "(Lworld/respect/credentials/passkey/RespectCredential;Lworld/respect/datalayer/school/model/DeviceInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "respect-lib-shared"})
@StabilityInferred(parameters=0)
public final class GetTokenAndUserProfileWithCredentialDbImpl
implements GetTokenAndUserProfileWithCredentialUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Url schoolUrl;
    @NotNull
    private final RespectSchoolDatabase schoolDb;
    @NotNull
    private final XXStringHasher xxHash;
    @Nullable
    private final VerifySignInWithPasskeyUseCase verifyPasskeyUseCase;
    @NotNull
    private final RespectAppDataSource respectAppDataSource;
    public static final int $stable = 8;
    public static final int TOKEN_DEFAULT_TTL = 31536000;

    public GetTokenAndUserProfileWithCredentialDbImpl(@NotNull Url schoolUrl, @NotNull RespectSchoolDatabase schoolDb, @NotNull XXStringHasher xxHash, @Nullable VerifySignInWithPasskeyUseCase verifyPasskeyUseCase, @NotNull RespectAppDataSource respectAppDataSource) {
        Intrinsics.checkNotNullParameter((Object)schoolUrl, (String)"schoolUrl");
        Intrinsics.checkNotNullParameter((Object)schoolDb, (String)"schoolDb");
        Intrinsics.checkNotNullParameter((Object)xxHash, (String)"xxHash");
        Intrinsics.checkNotNullParameter((Object)respectAppDataSource, (String)"respectAppDataSource");
        this.schoolUrl = schoolUrl;
        this.schoolDb = schoolDb;
        this.xxHash = xxHash;
        this.verifyPasskeyUseCase = verifyPasskeyUseCase;
        this.respectAppDataSource = respectAppDataSource;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object invoke(@NotNull RespectCredential credential, @Nullable DeviceInfo deviceInfo, @NotNull Continuation<? super AuthResponse> $completion) {
        block25: {
            block26: {
                if (!($completion instanceof invoke.1)) ** GOTO lbl-1000
                var15_4 = $completion;
                if ((var15_4.label & -2147483648) != 0) {
                    var15_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        long J$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ GetTokenAndUserProfileWithCredentialDbImpl this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.invoke(null, null, (Continuation<? super AuthResponse>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var16_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var5_7 = credential;
                        if (!(var5_7 instanceof RespectPasswordCredential)) break;
                        $continuation.L$0 = credential;
                        $continuation.L$1 = deviceInfo;
                        $continuation.label = 1;
                        v0 = this.schoolDb.getPersonEntityDao().findByUsername(((RespectPasswordCredential)credential).getUsername(), (Continuation)$continuation);
                        if (v0 == var16_6) {
                            return var16_6;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        deviceInfo = (DeviceInfo)$continuation.L$1;
                        credential = (RespectCredential)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        v1 = (PersonEntityWithRoles)v0;
                        if (v1 == null) {
                            throw new IllegalArgumentException();
                        }
                        personEntity = v1;
                        personGuidHash = this.xxHash.hash(personEntity.getPerson().getPGuid());
                        $continuation.L$0 = credential;
                        $continuation.L$1 = deviceInfo;
                        $continuation.L$2 = personEntity;
                        $continuation.J$0 = personGuidHash;
                        $continuation.label = 2;
                        v2 = this.schoolDb.getPersonPasswordEntityDao().findByUid(personGuidHash, (Continuation)$continuation);
                        if (v2 == var16_6) {
                            return var16_6;
                        }
                        ** GOTO lbl47
                    }
                    case 2: {
                        personGuidHash = $continuation.J$0;
                        personEntity = (PersonEntityWithRoles)$continuation.L$2;
                        deviceInfo = (DeviceInfo)$continuation.L$1;
                        credential = (RespectCredential)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl47:
                        // 2 sources

                        v3 = (PersonPasswordEntity)v2;
                        if (v3 == null) {
                            throw new ForbiddenException("Invalid username/password", null, 2, null);
                        }
                        personPassword = v3;
                        v4 = ((RespectPasswordCredential)credential).getPassword().toCharArray();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toCharArray(...)");
                        var11_16 = personPassword.getAuthSalt();
                        v5 = var11_16.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getBytes(...)");
                        keySpec = new PBEKeySpec(v4, v5, personPassword.getAuthIterations(), personPassword.getAuthKeyLen());
                        keyFactory = SecretKeyFactory.getInstance(personPassword.getAuthAlgorithm());
                        expectedAuthEncoded = Base64Kt.decodeBase64Bytes((String)personPassword.getAuthEncoded());
                        actualAuthEncoded = keyFactory.generateSecret(keySpec).getEncoded();
                        if (!Arrays.equals(expectedAuthEncoded, actualAuthEncoded)) ** GOTO lbl63
                        v6 = personEntity;
                        break block25;
lbl63:
                        // 1 sources

                        throw new ForbiddenException("Invalid username/password", null, 2, null);
                    }
                }
                if (!(var5_7 instanceof RespectPasskeyCredential)) break block26;
                $continuation.L$0 = credential;
                $continuation.L$1 = deviceInfo;
                $continuation.label = 3;
                v7 = this.respectAppDataSource.getSchoolDirectoryEntryDataSource().getSchoolDirectoryEntryByUrl(this.schoolUrl, (Continuation)$continuation);
                if (v7 == var16_6) {
                    return var16_6;
                }
                ** GOTO lbl77
                {
                    case 3: {
                        deviceInfo = (DeviceInfo)$continuation.L$1;
                        credential = (RespectCredential)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl77:
                        // 2 sources

                        if ((personGuidHash = (SchoolDirectoryEntry)DataLoadStateExtKt.dataOrNull((DataLoadState)((DataLoadState)v7))) == null || (var8_20 = personGuidHash.getRpId()) == null) {
                            throw ExceptionWithHttpStatusCodeKt.withHttpStatus((Throwable)new IllegalStateException("School " + this.schoolUrl + " has no rpId"), (int)400);
                        }
                        rpId = var8_20;
                        v8 = this.verifyPasskeyUseCase;
                        if (v8 == null) {
                            throw new IllegalStateException("Verify passkey use case not provided");
                        }
                        verifyPasskeyUseCaseVal = v8;
                        $continuation.L$0 = credential;
                        $continuation.L$1 = deviceInfo;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rpId);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)verifyPasskeyUseCaseVal);
                        $continuation.label = 4;
                        v9 = verifyPasskeyUseCaseVal.invoke(((RespectPasskeyCredential)credential).getPasskeyWebAuthNResponse(), rpId, (Continuation<? super PasskeyVerifyResult>)$continuation);
                        if (v9 == var16_6) {
                            return var16_6;
                        }
                        ** GOTO lbl100
                    }
                    case 4: {
                        verifyPasskeyUseCaseVal = (VerifySignInWithPasskeyUseCase)$continuation.L$3;
                        rpId = (String)$continuation.L$2;
                        deviceInfo = (DeviceInfo)$continuation.L$1;
                        credential = (RespectCredential)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl100:
                        // 2 sources

                        passkeyId = ((RespectPasskeyCredential)credential).getPasskeyWebAuthNResponse().getId();
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)credential);
                        $continuation.L$1 = deviceInfo;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rpId);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)verifyPasskeyUseCaseVal);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)passkeyId);
                        $continuation.label = 5;
                        v10 = this.schoolDb.getPersonPasskeyEntityDao().findPersonPasskeyFromClientDataJson(passkeyId, (Continuation)$continuation);
                        if (v10 == var16_6) {
                            return var16_6;
                        }
                        ** GOTO lbl119
                    }
                    case 5: {
                        passkeyId = (String)$continuation.L$4;
                        verifyPasskeyUseCaseVal = (VerifySignInWithPasskeyUseCase)$continuation.L$3;
                        rpId = (String)$continuation.L$2;
                        deviceInfo = (DeviceInfo)$continuation.L$1;
                        credential = (RespectCredential)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v10 = $result;
lbl119:
                        // 2 sources

                        v11 = (PersonPasskeyEntity)v10;
                        if (v11 == null) {
                            throw ExceptionWithHttpStatusCodeKt.withHttpStatus((Throwable)new IllegalArgumentException(), (int)400);
                        }
                        personPasskey = v11;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)credential);
                        $continuation.L$1 = deviceInfo;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rpId);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)verifyPasskeyUseCaseVal);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)passkeyId);
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)personPasskey);
                        $continuation.label = 6;
                        v12 = this.schoolDb.getPersonEntityDao().findByGuidNum(personPasskey.getPpPersonUidNum(), (Continuation)$continuation);
                        if (v12 == var16_6) {
                            return var16_6;
                        }
                        ** GOTO lbl143
                    }
                    case 6: {
                        personPasskey = (PersonPasskeyEntity)$continuation.L$5;
                        passkeyId = (String)$continuation.L$4;
                        verifyPasskeyUseCaseVal = (VerifySignInWithPasskeyUseCase)$continuation.L$3;
                        rpId = (String)$continuation.L$2;
                        deviceInfo = (DeviceInfo)$continuation.L$1;
                        credential = (RespectCredential)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v12 = $result;
lbl143:
                        // 2 sources

                        if ((v6 = (PersonEntityWithRoles)v12) == null) {
                            throw new ForbiddenException("Person not found", null, 2, null);
                        }
                        break block25;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        personEntity = v6;
        token = new AuthToken(RandomStringKt.randomString$default((int)32, null, (int)2, null), System.currentTimeMillis(), 31536000);
        personGuidHash = this.xxHash.hash(personEntity.getPerson().getPGuid());
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)credential);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deviceInfo);
        $continuation.L$2 = personEntity;
        $continuation.L$3 = token;
        $continuation.L$4 = null;
        $continuation.L$5 = null;
        $continuation.J$0 = personGuidHash;
        $continuation.label = 7;
        v13 = this.schoolDb.getAuthTokenEntityDao().insert(AuthTokenAdapterKt.toEntity$default((AuthToken)token, (String)personEntity.getPerson().getPGuid(), (long)personGuidHash, null, (DeviceInfo)deviceInfo, (int)4, null), (Continuation)$continuation);
        if (v13 == var16_6) {
            return var16_6;
        }
        ** GOTO lbl172
        {
            case 7: {
                personGuidHash = $continuation.J$0;
                token = (AuthToken)$continuation.L$3;
                personEntity = (PersonEntityWithRoles)$continuation.L$2;
                deviceInfo = (DeviceInfo)$continuation.L$1;
                credential = (RespectCredential)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl172:
                // 2 sources

                return new AuthResponse(token, PersonAdapterKt.toModel((PersonEntities)PersonAdapterKt.toPersonEntities((PersonEntityWithRoles)personEntity)));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lworld/respect/shared/domain/account/authwithpassword/GetTokenAndUserProfileWithCredentialDbImpl$Companion;", "", "<init>", "()V", "TOKEN_DEFAULT_TTL", "", "respect-lib-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

