package world.respect.datalayer.db.schooldirectory.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import world.respect.datalayer.db.schooldirectory.entities.SchoolDirectoryEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class SchoolDirectoryEntityDao_Impl(
  __db: RoomDatabase,
) : SchoolDirectoryEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfSchoolDirectoryEntity: EntityInsertAdapter<SchoolDirectoryEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfSchoolDirectoryEntity = object : EntityInsertAdapter<SchoolDirectoryEntity>() {
      protected override fun createQuery(): String = "INSERT OR IGNORE INTO `SchoolDirectoryEntity` (`rdUid`,`rdUrl`,`rdInvitePrefix`) VALUES (?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: SchoolDirectoryEntity) {
        statement.bindLong(1, entity.rdUid)
        val _tmp: String? = __sharedConverters.fromUrl(entity.rdUrl)
        if (_tmp == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp)
        }
        statement.bindText(3, entity.rdInvitePrefix)
      }
    }
  }

  public override suspend fun insertOrIgnore(schoolDirectory: SchoolDirectoryEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfSchoolDirectoryEntity.insert(_connection, schoolDirectory)
  }

  public override suspend fun getSchoolDirectories(): List<SchoolDirectoryEntity> {
    val _sql: String = """
        |
        |            SELECT * FROM SchoolDirectoryEntity
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfRdUid: Int = getColumnIndexOrThrow(_stmt, "rdUid")
        val _columnIndexOfRdUrl: Int = getColumnIndexOrThrow(_stmt, "rdUrl")
        val _columnIndexOfRdInvitePrefix: Int = getColumnIndexOrThrow(_stmt, "rdInvitePrefix")
        val _result: MutableList<SchoolDirectoryEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: SchoolDirectoryEntity
          val _tmpRdUid: Long
          _tmpRdUid = _stmt.getLong(_columnIndexOfRdUid)
          val _tmpRdUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfRdUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfRdUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpRdUrl = _tmp_1
          }
          val _tmpRdInvitePrefix: String
          _tmpRdInvitePrefix = _stmt.getText(_columnIndexOfRdInvitePrefix)
          _item = SchoolDirectoryEntity(_tmpRdUid,_tmpRdUrl,_tmpRdInvitePrefix)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getServerManagerSchoolDirectory(): SchoolDirectoryEntity? {
    val _sql: String = """
        |
        |        SELECT SchoolDirectoryEntity.*
        |          FROM SchoolDirectoryEntity
        |         WHERE SchoolDirectoryEntity.rdUrl = 'local-dir://localhost/'
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfRdUid: Int = getColumnIndexOrThrow(_stmt, "rdUid")
        val _columnIndexOfRdUrl: Int = getColumnIndexOrThrow(_stmt, "rdUrl")
        val _columnIndexOfRdInvitePrefix: Int = getColumnIndexOrThrow(_stmt, "rdInvitePrefix")
        val _result: SchoolDirectoryEntity?
        if (_stmt.step()) {
          val _tmpRdUid: Long
          _tmpRdUid = _stmt.getLong(_columnIndexOfRdUid)
          val _tmpRdUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfRdUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfRdUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpRdUrl = _tmp_1
          }
          val _tmpRdInvitePrefix: String
          _tmpRdInvitePrefix = _stmt.getText(_columnIndexOfRdInvitePrefix)
          _result = SchoolDirectoryEntity(_tmpRdUid,_tmpRdUrl,_tmpRdInvitePrefix)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteOthers(exceptUid: Long) {
    val _sql: String = """
        |
        |        DELETE FROM SchoolDirectoryEntity
        |         WHERE rdUid != ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, exceptUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
