/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicDataSourceFactory
implements ObjectFactory {
    private static final String[] a = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "driverClassName", "maxActive", "maxIdle", "minIdle", "initialSize", "maxWait", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "testWhileIdle", "password", "url", "username", "validationQuery", "validationQueryTimeout", "initConnectionSqls", "accessToUnderlyingConnectionAllowed", "removeAbandoned", "removeAbandonedTimeout", "logAbandoned", "poolPreparedStatements", "maxOpenPreparedStatements", "connectionProperties"};

    public Object getObjectInstance(Object object, Name cloneable, Context context, Hashtable object2) {
        if (object == null || !(object instanceof Reference)) {
            return null;
        }
        if (!"javax.sql.DataSource".equals(((Reference)(object = (Reference)object)).getClassName())) {
            return null;
        }
        cloneable = new Properties();
        for (int i = 0; i < a.length; ++i) {
            object2 = a[i];
            Object object3 = ((Reference)object).get((String)object2);
            if (object3 == null) continue;
            object3 = ((RefAddr)object3).getContent().toString();
            ((Properties)cloneable).setProperty((String)object2, (String)object3);
        }
        return BasicDataSourceFactory.a((Properties)cloneable);
    }

    private static DataSource a(Properties enumeration) {
        BasicDataSource basicDataSource = new BasicDataSource();
        Object object = ((Properties)((Object)enumeration)).getProperty("defaultAutoCommit");
        if (object != null) {
            basicDataSource.a(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("defaultReadOnly")) != null) {
            basicDataSource.b(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("defaultTransactionIsolation")) != null) {
            int n;
            if ("NONE".equalsIgnoreCase((String)object)) {
                n = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase((String)object)) {
                n = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase((String)object)) {
                n = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase((String)object)) {
                n = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase((String)object)) {
                n = 8;
            } else {
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + (String)object);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    n = -1;
                }
            }
            basicDataSource.a(n);
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("defaultCatalog")) != null) {
            basicDataSource.a((String)object);
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("driverClassName")) != null) {
            basicDataSource.b((String)object);
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("maxActive")) != null) {
            basicDataSource.b(Integer.parseInt((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("maxIdle")) != null) {
            basicDataSource.c(Integer.parseInt((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("minIdle")) != null) {
            basicDataSource.d(Integer.parseInt((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("initialSize")) != null) {
            basicDataSource.e(Integer.parseInt((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("maxWait")) != null) {
            basicDataSource.a(Long.parseLong((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("testOnBorrow")) != null) {
            basicDataSource.d(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("testOnReturn")) != null) {
            basicDataSource.e(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("timeBetweenEvictionRunsMillis")) != null) {
            basicDataSource.b(Long.parseLong((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("numTestsPerEvictionRun")) != null) {
            basicDataSource.g(Integer.parseInt((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("minEvictableIdleTimeMillis")) != null) {
            basicDataSource.c(Long.parseLong((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("testWhileIdle")) != null) {
            basicDataSource.f(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("password")) != null) {
            basicDataSource.c((String)object);
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("url")) != null) {
            basicDataSource.d((String)object);
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("username")) != null) {
            basicDataSource.e((String)object);
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("validationQuery")) != null) {
            basicDataSource.f((String)object);
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("validationQueryTimeout")) != null) {
            basicDataSource.h(Integer.parseInt((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("accessToUnderlyingConnectionAllowed")) != null) {
            basicDataSource.g(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("removeAbandoned")) != null) {
            basicDataSource.h(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("removeAbandonedTimeout")) != null) {
            basicDataSource.i(Integer.parseInt((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("logAbandoned")) != null) {
            basicDataSource.i(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("poolPreparedStatements")) != null) {
            basicDataSource.c(Boolean.valueOf((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("maxOpenPreparedStatements")) != null) {
            basicDataSource.f(Integer.parseInt((String)object));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("initConnectionSqls")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ";");
            basicDataSource.a(Collections.list(stringTokenizer));
        }
        if ((object = ((Properties)((Object)enumeration)).getProperty("connectionProperties")) != null) {
            enumeration = object;
            object = new Properties();
            if (enumeration != null) {
                ((Properties)object).load(new ByteArrayInputStream(((String)((Object)enumeration)).replace(';', '\n').getBytes()));
            }
            Object object2 = object;
            enumeration = ((Properties)object2).propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                basicDataSource.a((String)object, ((Properties)object2).getProperty((String)object));
            }
        }
        if (basicDataSource.a() > 0) {
            basicDataSource.getLogWriter();
        }
        return basicDataSource;
    }
}

