/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp.datasources.PooledConnectionManager;
import org.apache.commons.dbcp.datasources.UserPassKey;

public abstract class InstanceKeyDataSource
implements Serializable,
Referenceable,
DataSource {
    private volatile boolean c = false;
    private ConnectionPoolDataSource d = null;
    private String e = null;
    private boolean f = true;
    private int g = -1;
    private boolean h = false;
    Properties a = null;
    private int i = 0;
    private PrintWriter j = null;
    private boolean k = false;
    private boolean l = false;
    private int m = (int)Math.min(Integer.MAX_VALUE, -1L);
    private int n = 3;
    private int o = (int)Math.min(Integer.MAX_VALUE, 1800000L);
    private boolean p = false;
    private String q = null;
    private boolean r = false;
    private boolean s = false;
    protected String b = null;

    protected final void a() {
        if (this.c) {
            throw new IllegalStateException("A Connection was already requested from this source, further initialization is not allowed.");
        }
    }

    protected abstract PooledConnectionManager a(UserPassKey var1);

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        throw new SQLException("InstanceKeyDataSource is not a wrapper.");
    }

    public final String b() {
        return this.e;
    }

    public final void a(String string) {
        this.a();
        if (this.d != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        if (this.e != null) {
            throw new IllegalStateException("The DataSourceName has already been set. It cannot be altered.");
        }
        this.e = string;
        this.b = InstanceKeyObjectFactory.a(this);
    }

    public final boolean c() {
        return this.f;
    }

    public final void a(boolean bl) {
        this.a();
        this.f = bl;
    }

    public final boolean d() {
        return this.h;
    }

    public final void b(boolean bl) {
        this.a();
        this.h = bl;
    }

    public final int e() {
        return this.g;
    }

    @Override
    public int getLoginTimeout() {
        return this.i;
    }

    @Override
    public void setLoginTimeout(int n) {
        this.i = n;
    }

    @Override
    public PrintWriter getLogWriter() {
        if (this.j == null) {
            this.j = new PrintWriter(System.out);
        }
        return this.j;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.j = printWriter;
    }

    public final boolean f() {
        return this.k;
    }

    public final void c(boolean bl) {
        this.a();
        this.k = bl;
        this.s = true;
    }

    public final boolean g() {
        return this.l;
    }

    public final void d(boolean bl) {
        this.a();
        this.l = bl;
        this.s = true;
    }

    public final int h() {
        return this.m;
    }

    public final void a(int n) {
        this.a();
        this.m = n;
    }

    public final int i() {
        return this.n;
    }

    public final void b(int n) {
        this.a();
        this.n = n;
    }

    public final int j() {
        return this.o;
    }

    public final void c(int n) {
        this.a();
        this.o = n;
    }

    public final boolean k() {
        return this.p;
    }

    public final void e(boolean bl) {
        this.a();
        this.p = bl;
        this.s = true;
    }

    public final String l() {
        return this.q;
    }

    public final void b(String string) {
        this.a();
        this.q = string;
        if (!this.s) {
            this.c(true);
        }
    }

    @Override
    public Connection getConnection() {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String string, String string2) {
        if (this.b == null) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.c = true;
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        try {
            pooledConnectionAndInfo = this.a(string, string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.a(pooledConnectionAndInfo);
            throw new SQLNestedException("Cannot borrow connection from pool", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            this.a(pooledConnectionAndInfo);
            throw runtimeException;
        }
        catch (SQLException sQLException) {
            this.a(pooledConnectionAndInfo);
            throw sQLException;
        }
        catch (Exception exception) {
            this.a(pooledConnectionAndInfo);
            throw new SQLNestedException("Cannot borrow connection from pool", exception);
        }
        if (!(string2 != null ? string2.equals(pooledConnectionAndInfo.c()) : null == pooledConnectionAndInfo.c())) {
            try {
                this.b(string, string2);
            }
            catch (SQLException sQLException) {
                this.a(pooledConnectionAndInfo);
                throw new SQLException("Given password did not match password used to create the PooledConnection.");
            }
            catch (NamingException namingException) {
                throw (SQLException)new SQLException("NamingException encountered connecting to database").initCause(namingException);
            }
            UserPassKey userPassKey = pooledConnectionAndInfo.b();
            PooledConnectionManager pooledConnectionManager = this.a(userPassKey);
            pooledConnectionManager.a(pooledConnectionAndInfo.a());
            pooledConnectionManager.a(userPassKey.a());
            pooledConnectionAndInfo = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    pooledConnectionAndInfo = this.a(string, string2);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.a(pooledConnectionAndInfo);
                    throw new SQLNestedException("Cannot borrow connection from pool", noSuchElementException);
                }
                catch (RuntimeException runtimeException) {
                    this.a(pooledConnectionAndInfo);
                    throw runtimeException;
                }
                catch (SQLException sQLException) {
                    this.a(pooledConnectionAndInfo);
                    throw sQLException;
                }
                catch (Exception exception) {
                    this.a(pooledConnectionAndInfo);
                    throw new SQLNestedException("Cannot borrow connection from pool", exception);
                }
                if (pooledConnectionAndInfo != null && string2.equals(pooledConnectionAndInfo.c())) break;
                if (pooledConnectionAndInfo != null) {
                    pooledConnectionManager.a(pooledConnectionAndInfo.a());
                }
                pooledConnectionAndInfo = null;
            }
            if (pooledConnectionAndInfo == null) {
                throw new SQLException("Cannot borrow connection from pool - password change failure.");
            }
        }
        Connection connection = pooledConnectionAndInfo.a().getConnection();
        try {
            this.a(connection, string);
            connection.clearWarnings();
            return connection;
        }
        catch (SQLException sQLException) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                this.getLogWriter().println("ignoring exception during close: " + exception);
            }
            throw sQLException;
        }
    }

    protected abstract PooledConnectionAndInfo a(String var1, String var2);

    protected abstract void a(Connection var1, String var2);

    private void a(PooledConnectionAndInfo pooledConnectionAndInfo) {
        if (pooledConnectionAndInfo != null) {
            try {
                pooledConnectionAndInfo.a().getConnection().close();
                return;
            }
            catch (Exception exception) {
                this.getLogWriter().println("[ERROR] Could not return connection to pool during exception handling. " + exception.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final ConnectionPoolDataSource b(String string, String string2) {
        Object object;
        Object object2 = this.d;
        if (object2 == null) {
            object = this.a == null ? new InitialContext() : new InitialContext(this.a);
            object2 = object.lookup(this.e);
            if (!(object2 instanceof ConnectionPoolDataSource)) throw new SQLException("Illegal configuration: DataSource " + this.e + " (" + object2.getClass().getName() + ") doesn't implement javax.sql.ConnectionPoolDataSource");
            object2 = (ConnectionPoolDataSource)object2;
        }
        object = null;
        try {
            object = string != null ? object2.getPooledConnection(string, string2) : object2.getPooledConnection();
            if (object == null) {
                throw new SQLException("Cannot connect using the supplied username/password");
            }
            if (object == null) return object2;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                object.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            object.close();
            return object2;
        }
        catch (SQLException sQLException) {}
        return object2;
    }

    protected static byte a(int n, int n2) {
        byte by = 1;
        if (n <= 0) {
            by = 2;
        } else if (n2 == 0) {
            by = 0;
        }
        return by;
    }

    @Override
    public Reference getReference() {
        Object object = this.getClass().getName();
        String string = (String)object + "Factory";
        object = new Reference((String)object, string, null);
        ((Reference)object).add(new StringRefAddr("instanceKey", this.b));
        return object;
    }
}

