/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp.managed.TransactionContext;

public class TransactionRegistry {
    private final TransactionManager a;
    private final Map b = new WeakHashMap();
    private final Map c = new WeakHashMap();

    public TransactionRegistry(TransactionManager transactionManager) {
        this.a = transactionManager;
    }

    public final synchronized void a(Connection connection, XAResource xAResource) {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        if (xAResource == null) {
            throw new NullPointerException("xaResource is null");
        }
        this.c.put(connection, xAResource);
    }

    public final synchronized XAResource a(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        XAResource xAResource = (XAResource)this.c.get(connection);
        if (xAResource == null) {
            throw new SQLException("Connection does not have a registered XAResource " + connection);
        }
        return xAResource;
    }

    public final TransactionContext a() {
        Transaction transaction;
        try {
            transaction = this.a.getTransaction();
            if (transaction == null) {
                return null;
            }
            int n = transaction.getStatus();
            if (n != 0 && n != 1) {
                return null;
            }
        }
        catch (SystemException systemException) {
            throw (SQLException)new SQLException("Unable to determine current transaction ").initCause(systemException);
        }
        TransactionRegistry transactionRegistry = this;
        synchronized (transactionRegistry) {
            TransactionContext transactionContext = (TransactionContext)this.b.get(transaction);
            if (transactionContext == null) {
                transactionContext = new TransactionContext(this, transaction);
                this.b.put(transaction, transactionContext);
            }
            return transactionContext;
        }
    }

    public final synchronized void b(Connection connection) {
        this.c.remove(connection);
    }
}

