package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.ext.doorNodeIdHeader
import com.ustadmobile.door.ext.setRepoUrl
import com.ustadmobile.door.http.RepoDaoFlowHelper
import com.ustadmobile.door.http.RepositoryDaoWithFlowHelper
import com.ustadmobile.door.http.replicateHttpRequestCatchAndLog
import com.ustadmobile.door.replication.onClientRepoDoorMessageHttpResponse
import com.ustadmobile.door.replication.withRepoChangeMonitorAsync
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.PersonPasskey
import io.ktor.client.HttpClient
import io.ktor.client.request.`get`
import io.ktor.client.request.`header`
import io.ktor.client.request.parameter
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow
import kotlinx.serialization.builtins.serializer

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class PersonPasskeyDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: PersonPasskeyDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : PersonPasskeyDao(), RepositoryDaoWithFlowHelper {
  override val repoDaoFlowHelper: RepoDaoFlowHelper = RepoDaoFlowHelper(_repo)


  override suspend fun insertAsync(personPasskey: PersonPasskey): Long {
    val _result = _repo.withRepoChangeMonitorAsync("PersonPasskey") {
      _dao.insertAsync(personPasskey)
    }
    return _result
  }

  override suspend fun allPasskey(): List<String> {
    val _result = _dao.allPasskey()
    return _result
  }

  override fun getAllActivePasskeys(uid: Long): Flow<List<PersonPasskey>> =
      repoDaoFlowHelper.asRepoFlow(
    dbFlow = _dao.getAllActivePasskeys(uid),
    onMakeHttpRequest =  {
      _repo.replicateHttpRequestCatchAndLog(repoPath = "PersonPasskeyDao/getAllActivePasskeys") {
        val _response = _httpClient.`get` {
          setRepoUrl(_repo.config, "PersonPasskeyDao/getAllActivePasskeys")
          doorNodeIdHeader(_repo)
          `header`("cache-control", "no-store")
          parameter("uid", _repo.config.json.encodeToString(Long.serializer(), uid))
        }

        _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
      }
    },
  )

  override fun getAllActivePasskeysPaging(uid: Long): PagingSource<Int, PersonPasskey> {
    val _result = _dao.getAllActivePasskeysPaging(uid)
    return _result
  }

  override suspend fun findPersonPasskeyFromClientDataJson(id: String): PersonPasskey? {
    val _result = _dao.findPersonPasskeyFromClientDataJson(id)
    return _result
  }

  override suspend fun revokePersonPasskey(uid: Long) {
    _repo.withRepoChangeMonitorAsync("PersonPasskey") {
      _dao.revokePersonPasskey(uid)
    }
  }
}
