package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.Report
import kotlin.Int
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ReportDao.deleteReportByUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_reportUid : Long = request.queryParam("reportUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _thisNodeId = request.db.doorWrapperNodeId
  val _result = deleteReportByUid(_arg_reportUid,)
  return DoorJsonResponse(
    bodyText = "",
    headers = listOf(DoorConstants.HEADER_NODE_ID to _thisNodeId.toString()),
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ReportDao.findAllReports_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findAllReports_pagingSource = findAllReports(
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findAllReports = _result_findAllReports_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findAllReports_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached = _result_findAllReports_pagingSource.endOfPaginationReached

  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllReports.map {
        _row ->
        DoorReplicationEntity(tableId = 101,
          orUid = 0,
          entity = json.encodeToJsonElement(Report.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ReportDao.findByUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_entityUid : Long = request.queryParam("entityUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUid = findByUid(
    entityUid = _arg_entityUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUid?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 101,
          orUid = 0,
          entity = json.encodeToJsonElement(Report.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
