/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.composites.CourseGroupMemberAndPerson;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.CourseGroupMember;
import com.ustadmobile.lib.db.entities.CourseGroupMemberAndName;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J<\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u000eJ<\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH'J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u0013J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u0013J<\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u001d\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010$J\u001c\u0010%\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010$J\u001c\u0010&\u001a\u00020\"2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010$\u00a8\u0006("}, d2={"Lcom/ustadmobile/core/db/dao/CourseGroupMemberDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseGroupMember;", "()V", "findByCourseGroupSetAndClazz", "", "Lcom/ustadmobile/lib/db/entities/CourseGroupMemberAndName;", "cgsUid", "", "clazzUid", "time", "activeFilter", "", "accountPersonUid", "(JJJIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByCourseGroupSetAndClazzAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findByCourseGroupSetAndClazzAsFlowEnrolments", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolment;", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByCourseGroupSetAndClazzAsFlowPersons", "Lcom/ustadmobile/lib/db/composites/PersonAndPicture;", "findByCourseGroupSetAndGroupNumAsync", "Lcom/ustadmobile/lib/db/composites/CourseGroupMemberAndPerson;", "courseGroupSetUid", "groupNum", "assignmentUid", "(JIJJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByGroupSetUidAsync", "groupSetUid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByPersonUid", "studentUid", "insertListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateListAsync", "upsertListAsync", "list", "lib-database_debug"})
@Dao
public abstract class CourseGroupMemberDao
implements BaseDao<CourseGroupMember> {
    @Query(value="\n        SELECT CourseGroupMember.*\n          FROM CourseGroupMember\n         WHERE cgmSetUid = :groupSetUid \n    ")
    @Nullable
    public abstract Object findByGroupSetUidAsync(long var1, @NotNull Continuation<? super List<CourseGroupMember>> var3);

    @Query(value="\n        SELECT * \n          FROM CourseGroupMember\n         WHERE cgmPersonUid = :studentUid \n          AND cgmSetUid = :groupSetUid\n         LIMIT 1\n    ")
    @Nullable
    public abstract Object findByPersonUid(long var1, long var3, @NotNull Continuation<? super CourseGroupMember> var5);

    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertListAsync(@NotNull List<CourseGroupMember> var1, @NotNull Continuation<? super Unit> var2);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateListAsync(@NotNull List<CourseGroupMember> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        --First get a list of all enrolments - this may contains duplicates for students who leave and re-enrol\n        WITH AllEnrollmentsAndActiveStatus(enrolledPersonUid, isActive) AS \n             (SELECT ClazzEnrolment.clazzEnrolmentPersonUid AS enrolledPersonUid,\n                     (:time BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) AS isActive\n                FROM ClazzEnrolment\n               WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(:clazzUid)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = :cgsUid)\n                         ELSE :clazzUid\n                     END\n    \n                 AND ClazzEnrolment.clazzEnrolmentRole = 1000),\n        --Consolidate and removes any duplicates\n             EnrolledStudentPersonUids(enrolledPersonUid, isActive) AS\n             (SELECT DISTINCT AllEnrollmentsAndActiveStatus.enrolledPersonUid,\n                     (SELECT CAST(AllEnrollmentsInner.isActive AS INTEGER)\n                        FROM AllEnrollmentsAndActiveStatus AllEnrollmentsInner\n                       WHERE AllEnrollmentsInner.enrolledPersonUid = AllEnrollmentsAndActiveStatus.enrolledPersonUid\n                    ORDER BY AllEnrollmentsInner.isActive DESC\n                       LIMIT 1) AS isActive\n                FROM AllEnrollmentsAndActiveStatus)\n        \n        -- Now create a list with each students name, the coursegroupmember object if any and active status        \n        SELECT (Person.firstNames || ' ' || Person.lastName) AS name,\n               Person.personUid,\n               CourseGroupMember.*,\n               PersonPicture.*,\n               EnrolledStudentPersonUids.isActive AS enrolmentIsActive,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM EnrolledStudentPersonUids\n               JOIN Person\n                    ON Person.personUid = EnrolledStudentPersonUids.enrolledPersonUid \n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid  \n               -- LEFT JOIN will use the most recent member in case of duplicate assignments eg if      \n               LEFT JOIN CourseGroupMember\n                         ON CourseGroupMember.cgmUid = \n                            (SELECT CourseGroupMember.cgmUid\n                               FROM CourseGroupMember\n                              WHERE CourseGroupMember.cgmPersonUid = EnrolledStudentPersonUids.enrolledPersonUid\n                                AND CourseGroupMember.cgmSetUid = :cgsUid \n                           ORDER BY CourseGroupMember.cgmLct DESC        \n                              LIMIT 1)\n         WHERE (:activeFilter = 0 OR :activeFilter = EnrolledStudentPersonUids.isActive)  \n               /* \n                * Begin permission check -  must have course view members permission, or active \n                * user must be in the same group \n                */ \n            AND (\n                    ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )\n                  OR EXISTS(\n                     SELECT 1\n                       FROM CourseGroupMember _CourseGroupMemberForActivePerson\n                      WHERE _CourseGroupMemberForActivePerson.cgmPersonUid = :accountPersonUid\n                        AND _CourseGroupMemberForActivePerson.cgmGroupNumber = CourseGroupMember.cgmGroupNumber)     \n                 )\n      ORDER BY Person.firstNames, Person.lastName ASC\n    ")
    @Nullable
    public abstract Object findByCourseGroupSetAndClazz(long var1, long var3, long var5, int var7, long var8, @NotNull Continuation<? super List<CourseGroupMemberAndName>> var10);

    @Query(value="\n        --First get a list of all enrolments - this may contains duplicates for students who leave and re-enrol\n        WITH AllEnrollmentsAndActiveStatus(enrolledPersonUid, isActive) AS \n             (SELECT ClazzEnrolment.clazzEnrolmentPersonUid AS enrolledPersonUid,\n                     (:time BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) AS isActive\n                FROM ClazzEnrolment\n               WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(:clazzUid)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = :cgsUid)\n                         ELSE :clazzUid\n                     END\n    \n                 AND ClazzEnrolment.clazzEnrolmentRole = 1000),\n        --Consolidate and removes any duplicates\n             EnrolledStudentPersonUids(enrolledPersonUid, isActive) AS\n             (SELECT DISTINCT AllEnrollmentsAndActiveStatus.enrolledPersonUid,\n                     (SELECT CAST(AllEnrollmentsInner.isActive AS INTEGER)\n                        FROM AllEnrollmentsAndActiveStatus AllEnrollmentsInner\n                       WHERE AllEnrollmentsInner.enrolledPersonUid = AllEnrollmentsAndActiveStatus.enrolledPersonUid\n                    ORDER BY AllEnrollmentsInner.isActive DESC\n                       LIMIT 1) AS isActive\n                FROM AllEnrollmentsAndActiveStatus)\n        \n        -- Now create a list with each students name, the coursegroupmember object if any and active status        \n        SELECT (Person.firstNames || ' ' || Person.lastName) AS name,\n               Person.personUid,\n               CourseGroupMember.*,\n               PersonPicture.*,\n               EnrolledStudentPersonUids.isActive AS enrolmentIsActive,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM EnrolledStudentPersonUids\n               JOIN Person\n                    ON Person.personUid = EnrolledStudentPersonUids.enrolledPersonUid \n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid  \n               -- LEFT JOIN will use the most recent member in case of duplicate assignments eg if      \n               LEFT JOIN CourseGroupMember\n                         ON CourseGroupMember.cgmUid = \n                            (SELECT CourseGroupMember.cgmUid\n                               FROM CourseGroupMember\n                              WHERE CourseGroupMember.cgmPersonUid = EnrolledStudentPersonUids.enrolledPersonUid\n                                AND CourseGroupMember.cgmSetUid = :cgsUid \n                           ORDER BY CourseGroupMember.cgmLct DESC        \n                              LIMIT 1)\n         WHERE (:activeFilter = 0 OR :activeFilter = EnrolledStudentPersonUids.isActive)  \n               /* \n                * Begin permission check -  must have course view members permission, or active \n                * user must be in the same group \n                */ \n            AND (\n                    ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )\n                  OR EXISTS(\n                     SELECT 1\n                       FROM CourseGroupMember _CourseGroupMemberForActivePerson\n                      WHERE _CourseGroupMemberForActivePerson.cgmPersonUid = :accountPersonUid\n                        AND _CourseGroupMemberForActivePerson.cgmGroupNumber = CourseGroupMember.cgmGroupNumber)     \n                 )\n      ORDER BY Person.firstNames, Person.lastName ASC\n    ")
    @NotNull
    public abstract Flow<List<CourseGroupMemberAndName>> findByCourseGroupSetAndClazzAsFlow(long var1, long var3, long var5, int var7, long var8);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(:clazzUid)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = :cgsUid)\n                         ELSE :clazzUid\n                     END\n    )\n    ")
    @Nullable
    public abstract Object findByCourseGroupSetAndClazzAsFlowPersons(long var1, long var3, @NotNull Continuation<? super List<PersonAndPicture>> var5);

    @Query(value="\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(:clazzUid)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = :cgsUid)\n                         ELSE :clazzUid\n                     END\n    \n    ")
    @Nullable
    public abstract Object findByCourseGroupSetAndClazzAsFlowEnrolments(long var1, long var3, @NotNull Continuation<? super List<? extends ClazzEnrolment>> var5);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertListAsync(@NotNull List<CourseGroupMember> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT CourseGroupMember.*, Person.*\n          FROM CourseGroupMember\n               JOIN Person \n                    ON Person.personUid = CourseGroupMember.cgmPersonUid\n         WHERE (    CourseGroupMember.cgmSetUid = :courseGroupSetUid\n                AND CourseGroupMember.cgmGroupNumber = :groupNum)\n           AND (    /* Grant permission where the active person is in the group */ \n                    EXISTS(SELECT 1\n                             FROM CourseGroupMember CourseGroupMemberInternal\n                            WHERE CourseGroupMemberInternal.cgmSetUid = :courseGroupSetUid\n                              AND CourseGroupMemberInternal.cgmPersonUid = :accountPersonUid)\n                    /* Grant permission where the activepersonuid is in a group assigned to mark this group */\n                 OR EXISTS(SELECT 1\n                             FROM PeerReviewerAllocation\n                            WHERE PeerReviewerAllocation.praAssignmentUid = :assignmentUid\n                              AND PeerReviewerAllocation.praMarkerSubmitterUid = :groupNum\n                              AND EXISTS(SELECT 1\n                                           FROM CourseGroupMember CourseGroupMemberInternal\n                                          WHERE CourseGroupMemberInternal.cgmSetUid = PeerReviewerAllocation.praMarkerSubmitterUid\n                                            AND CourseGroupMemberInternal.cgmPersonUid = :accountPersonUid)) \n                    /* Grant permission where the active person has the select person permission for the class */                        \n                 OR ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )    \n               )\n               \n    ")
    @Nullable
    public abstract Object findByCourseGroupSetAndGroupNumAsync(long var1, int var3, long var4, long var6, long var8, @NotNull Continuation<? super List<CourseGroupMemberAndPerson>> var10);
}

