/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.PersonDao;
import com.ustadmobile.lib.db.composites.PersonAndListDisplayDetails;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.composites.PersonNames;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonAndDisplayDetail;
import com.ustadmobile.lib.db.entities.PersonAuth;
import com.ustadmobile.lib.db.entities.PersonGroup;
import com.ustadmobile.lib.db.entities.PersonGroupMember;
import com.ustadmobile.lib.db.entities.PersonParentJoin;
import com.ustadmobile.lib.db.entities.PersonPicture;
import com.ustadmobile.lib.db.entities.PersonUidAndPasswordHash;
import com.ustadmobile.lib.db.entities.TransferJobItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class PersonDao_Impl
extends PersonDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Person> __insertionAdapterOfPerson;
    private final EntityInsertionAdapter<Person> __insertionAdapterOfPerson_1;
    private final EntityInsertionAdapter<PersonAuth> __insertionAdapterOfPersonAuth;
    private final EntityInsertionAdapter<PersonGroup> __insertionAdapterOfPersonGroup;
    private final EntityInsertionAdapter<PersonGroupMember> __insertionAdapterOfPersonGroupMember;
    private final EntityDeletionOrUpdateAdapter<Person> __updateAdapterOfPerson;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUsername;

    public PersonDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPerson = new EntityInsertionAdapter<Person>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Person` (`personUid`,`username`,`firstNames`,`lastName`,`emailAddr`,`phoneNum`,`gender`,`active`,`isPersonalAccount`,`dateOfBirth`,`personAddress`,`personOrgId`,`personGroupUid`,`personLct`,`personCountry`,`personType`,`personMasterChangeSeqNum`,`personLocalChangeSeqNum`,`personLastChangedBy`,`admin`,`personNotes`,`fatherName`,`fatherNumber`,`motherName`,`motherNum`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Person entity) {
                statement.bindLong(1, entity.getPersonUid());
                if (entity.getUsername() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getUsername());
                }
                if (entity.getFirstNames() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getFirstNames());
                }
                if (entity.getLastName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getLastName());
                }
                if (entity.getEmailAddr() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getEmailAddr());
                }
                if (entity.getPhoneNum() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getPhoneNum());
                }
                statement.bindLong(7, (long)entity.getGender());
                int _tmp = entity.getActive() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                int _tmp_1 = entity.isPersonalAccount() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_1);
                statement.bindLong(10, entity.getDateOfBirth());
                if (entity.getPersonAddress() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getPersonAddress());
                }
                if (entity.getPersonOrgId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindString(12, entity.getPersonOrgId());
                }
                statement.bindLong(13, entity.getPersonGroupUid());
                statement.bindLong(14, entity.getPersonLct());
                if (entity.getPersonCountry() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getPersonCountry());
                }
                statement.bindLong(16, (long)entity.getPersonType());
                statement.bindLong(17, entity.getPersonMasterChangeSeqNum());
                statement.bindLong(18, entity.getPersonLocalChangeSeqNum());
                statement.bindLong(19, (long)entity.getPersonLastChangedBy());
                int _tmp_2 = entity.getAdmin() ? 1 : 0;
                statement.bindLong(20, (long)_tmp_2);
                if (entity.getPersonNotes() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindString(21, entity.getPersonNotes());
                }
                if (entity.getFatherName() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindString(22, entity.getFatherName());
                }
                if (entity.getFatherNumber() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getFatherNumber());
                }
                if (entity.getMotherName() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindString(24, entity.getMotherName());
                }
                if (entity.getMotherNum() == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindString(25, entity.getMotherNum());
                }
            }
        };
        this.__insertionAdapterOfPerson_1 = new EntityInsertionAdapter<Person>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `Person` (`personUid`,`username`,`firstNames`,`lastName`,`emailAddr`,`phoneNum`,`gender`,`active`,`isPersonalAccount`,`dateOfBirth`,`personAddress`,`personOrgId`,`personGroupUid`,`personLct`,`personCountry`,`personType`,`personMasterChangeSeqNum`,`personLocalChangeSeqNum`,`personLastChangedBy`,`admin`,`personNotes`,`fatherName`,`fatherNumber`,`motherName`,`motherNum`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Person entity) {
                statement.bindLong(1, entity.getPersonUid());
                if (entity.getUsername() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getUsername());
                }
                if (entity.getFirstNames() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getFirstNames());
                }
                if (entity.getLastName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getLastName());
                }
                if (entity.getEmailAddr() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getEmailAddr());
                }
                if (entity.getPhoneNum() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getPhoneNum());
                }
                statement.bindLong(7, (long)entity.getGender());
                int _tmp = entity.getActive() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                int _tmp_1 = entity.isPersonalAccount() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_1);
                statement.bindLong(10, entity.getDateOfBirth());
                if (entity.getPersonAddress() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getPersonAddress());
                }
                if (entity.getPersonOrgId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindString(12, entity.getPersonOrgId());
                }
                statement.bindLong(13, entity.getPersonGroupUid());
                statement.bindLong(14, entity.getPersonLct());
                if (entity.getPersonCountry() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getPersonCountry());
                }
                statement.bindLong(16, (long)entity.getPersonType());
                statement.bindLong(17, entity.getPersonMasterChangeSeqNum());
                statement.bindLong(18, entity.getPersonLocalChangeSeqNum());
                statement.bindLong(19, (long)entity.getPersonLastChangedBy());
                int _tmp_2 = entity.getAdmin() ? 1 : 0;
                statement.bindLong(20, (long)_tmp_2);
                if (entity.getPersonNotes() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindString(21, entity.getPersonNotes());
                }
                if (entity.getFatherName() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindString(22, entity.getFatherName());
                }
                if (entity.getFatherNumber() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getFatherNumber());
                }
                if (entity.getMotherName() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindString(24, entity.getMotherName());
                }
                if (entity.getMotherNum() == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindString(25, entity.getMotherNum());
                }
            }
        };
        this.__insertionAdapterOfPersonAuth = new EntityInsertionAdapter<PersonAuth>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonAuth` (`personAuthUid`,`passwordHash`,`personAuthStatus`) VALUES (nullif(?, 0),?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonAuth entity) {
                statement.bindLong(1, entity.getPersonAuthUid());
                if (entity.getPasswordHash() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getPasswordHash());
                }
                statement.bindLong(3, (long)entity.getPersonAuthStatus());
            }
        };
        this.__insertionAdapterOfPersonGroup = new EntityInsertionAdapter<PersonGroup>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonGroup` (`groupUid`,`groupMasterCsn`,`groupLocalCsn`,`groupLastChangedBy`,`groupLct`,`groupName`,`groupActive`,`personGroupFlag`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonGroup entity) {
                statement.bindLong(1, entity.getGroupUid());
                statement.bindLong(2, entity.getGroupMasterCsn());
                statement.bindLong(3, entity.getGroupLocalCsn());
                statement.bindLong(4, (long)entity.getGroupLastChangedBy());
                statement.bindLong(5, entity.getGroupLct());
                if (entity.getGroupName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getGroupName());
                }
                int _tmp = entity.getGroupActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, (long)entity.getPersonGroupFlag());
            }
        };
        this.__insertionAdapterOfPersonGroupMember = new EntityInsertionAdapter<PersonGroupMember>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonGroupMember` (`groupMemberUid`,`groupMemberActive`,`groupMemberPersonUid`,`groupMemberGroupUid`,`groupMemberMasterCsn`,`groupMemberLocalCsn`,`groupMemberLastChangedBy`,`groupMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonGroupMember entity) {
                statement.bindLong(1, entity.getGroupMemberUid());
                int _tmp = entity.getGroupMemberActive() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                statement.bindLong(3, entity.getGroupMemberPersonUid());
                statement.bindLong(4, entity.getGroupMemberGroupUid());
                statement.bindLong(5, entity.getGroupMemberMasterCsn());
                statement.bindLong(6, entity.getGroupMemberLocalCsn());
                statement.bindLong(7, (long)entity.getGroupMemberLastChangedBy());
                statement.bindLong(8, entity.getGroupMemberLct());
            }
        };
        this.__updateAdapterOfPerson = new EntityDeletionOrUpdateAdapter<Person>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `Person` SET `personUid` = ?,`username` = ?,`firstNames` = ?,`lastName` = ?,`emailAddr` = ?,`phoneNum` = ?,`gender` = ?,`active` = ?,`isPersonalAccount` = ?,`dateOfBirth` = ?,`personAddress` = ?,`personOrgId` = ?,`personGroupUid` = ?,`personLct` = ?,`personCountry` = ?,`personType` = ?,`personMasterChangeSeqNum` = ?,`personLocalChangeSeqNum` = ?,`personLastChangedBy` = ?,`admin` = ?,`personNotes` = ?,`fatherName` = ?,`fatherNumber` = ?,`motherName` = ?,`motherNum` = ? WHERE `personUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Person entity) {
                statement.bindLong(1, entity.getPersonUid());
                if (entity.getUsername() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getUsername());
                }
                if (entity.getFirstNames() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getFirstNames());
                }
                if (entity.getLastName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getLastName());
                }
                if (entity.getEmailAddr() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getEmailAddr());
                }
                if (entity.getPhoneNum() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getPhoneNum());
                }
                statement.bindLong(7, (long)entity.getGender());
                int _tmp = entity.getActive() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                int _tmp_1 = entity.isPersonalAccount() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_1);
                statement.bindLong(10, entity.getDateOfBirth());
                if (entity.getPersonAddress() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getPersonAddress());
                }
                if (entity.getPersonOrgId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindString(12, entity.getPersonOrgId());
                }
                statement.bindLong(13, entity.getPersonGroupUid());
                statement.bindLong(14, entity.getPersonLct());
                if (entity.getPersonCountry() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getPersonCountry());
                }
                statement.bindLong(16, (long)entity.getPersonType());
                statement.bindLong(17, entity.getPersonMasterChangeSeqNum());
                statement.bindLong(18, entity.getPersonLocalChangeSeqNum());
                statement.bindLong(19, (long)entity.getPersonLastChangedBy());
                int _tmp_2 = entity.getAdmin() ? 1 : 0;
                statement.bindLong(20, (long)_tmp_2);
                if (entity.getPersonNotes() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindString(21, entity.getPersonNotes());
                }
                if (entity.getFatherName() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindString(22, entity.getFatherName());
                }
                if (entity.getFatherNumber() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getFatherNumber());
                }
                if (entity.getMotherName() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindString(24, entity.getMotherName());
                }
                if (entity.getMotherNum() == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindString(25, entity.getMotherNum());
                }
                statement.bindLong(26, entity.getPersonUid());
            }
        };
        this.__preparedStmtOfUpdateUsername = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE Person\n           SET username = ?,\n               personLct = ?\n         WHERE Person.personUid = ?  \n    ";
                return "\n        UPDATE Person\n           SET username = ?,\n               personLct = ?\n         WHERE Person.personUid = ?  \n    ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Person entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfPerson.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final Person entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonDao_Impl.this.__insertionAdapterOfPerson.insertAndReturnId((Object)entity);
                    PersonDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends Person> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPerson.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<Person> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PersonDao_Impl.this.__db.beginTransaction();
                try {
                    PersonDao_Impl.this.__insertionAdapterOfPerson.insert((Iterable)entityList);
                    PersonDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PersonDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insertOrReplace(final Person person, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PersonDao_Impl.this.__db.beginTransaction();
                try {
                    PersonDao_Impl.this.__insertionAdapterOfPerson_1.insert((Object)person);
                    PersonDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PersonDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertPersonAuth(PersonAuth personAuth) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPersonAuth.insert((Object)personAuth);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertPersonGroup(final PersonGroup personGroup, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonDao_Impl.this.__insertionAdapterOfPersonGroup.insertAndReturnId((Object)personGroup);
                    PersonDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insertPersonGroupMember(final PersonGroupMember personGroupMember, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonDao_Impl.this.__insertionAdapterOfPersonGroupMember.insertAndReturnId((Object)personGroupMember);
                    PersonDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(Person entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPerson.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final Person entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                PersonDao_Impl.this.__db.beginTransaction();
                try {
                    PersonDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += PersonDao_Impl.this.__updateAdapterOfPerson.handle((Object)entity);
                    return n;
                }
                finally {
                    PersonDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateUsername(final long personUid, final String username, final long currentTime, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = PersonDao_Impl.this.__preparedStmtOfUpdateUsername.acquire();
                int _argIndex = 1;
                _stmt.bindString(_argIndex, username);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, currentTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, personUid);
                try {
                    Integer n;
                    PersonDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result2 = _stmt.executeUpdateDelete();
                        PersonDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result2;
                    }
                    catch (Throwable throwable) {
                        PersonDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    PersonDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    PersonDao_Impl.this.__preparedStmtOfUpdateUsername.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object countUsername(String username, Continuation<? super Integer> $completion) {
        String _sql = "SELECT COUNT(*) FROM Person where Person.username = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM Person where Person.username = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, username);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findUidAndPasswordHashAsync(String username, Continuation<? super PersonUidAndPasswordHash> $completion) {
        String _sql = "\n        SELECT Person.personUid, Person.firstNames, Person.lastName, \n               PersonAuth.passwordHash\n          FROM Person\n               JOIN PersonAuth\n                    ON Person.personUid = PersonAuth.personAuthUid\n         WHERE Person.username = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.personUid, Person.firstNames, Person.lastName, \n               PersonAuth.passwordHash\n          FROM Person\n               JOIN PersonAuth\n                    ON Person.personUid = PersonAuth.personAuthUid\n         WHERE Person.username = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, username);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonUidAndPasswordHash>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonUidAndPasswordHash call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonUidAndPasswordHash _result2;
                    boolean _cursorIndexOfPersonUid = false;
                    boolean _cursorIndexOfFirstNames = true;
                    int _cursorIndexOfLastName = 2;
                    int _cursorIndexOfPasswordHash = 3;
                    if (_cursor.moveToFirst()) {
                        _result2 = new PersonUidAndPasswordHash();
                        long _tmpPersonUid = _cursor.getLong(0);
                        _result2.setPersonUid(_tmpPersonUid);
                        String _tmpFirstNames = _cursor.isNull(1) ? null : _cursor.getString(1);
                        _result2.setFirstNames(_tmpFirstNames);
                        String _tmpLastName = _cursor.isNull(2) ? null : _cursor.getString(2);
                        _result2.setLastName(_tmpLastName);
                        String _tmpPasswordHash = _cursor.isNull(3) ? null : _cursor.getString(3);
                        _result2.setPasswordHash(_tmpPasswordHash);
                    } else {
                        _result2 = null;
                    }
                    PersonUidAndPasswordHash personUidAndPasswordHash = _result2;
                    return personUidAndPasswordHash;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUsernameAndPasswordHash2(String username, String passwordHash, Continuation<? super Person> $completion) {
        String _sql = "\n        SELECT Person.*\n          FROM Person\n               JOIN PersonAuth2\n                    ON Person.personUid = PersonAuth2.pauthUid\n         WHERE Person.username = ? \n               AND PersonAuth2.pauthAuth = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*\n          FROM Person\n               JOIN PersonAuth2\n                    ON Person.personUid = PersonAuth2.pauthUid\n         WHERE Person.username = ? \n               AND PersonAuth2.pauthAuth = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindString(_argIndex, username);
        _argIndex = 2;
        _statement.bindString(_argIndex, passwordHash);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Person>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Person call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Person _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                        int _tmp = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                        _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _result2 = null;
                    }
                    Person person = _result2;
                    return person;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Person findByUsername(String username) {
        String _sql = "SELECT Person.* FROM PERSON Where Person.username = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT Person.* FROM PERSON Where Person.username = ?", (int)1);
        int _argIndex = 1;
        if (username == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, username);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Person _result2;
            int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
            int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
            int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
            int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
            int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
            int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
            int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
            int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
            int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
            int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
            int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
            int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
            int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
            int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
            int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
            int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
            int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
            int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
            int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
            int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
            int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
            int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
            int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
            if (_cursor.moveToFirst()) {
                long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                int _tmp = _cursor.getInt(_cursorIndexOfActive);
                boolean _tmpActive = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                boolean _tmpAdmin = _tmp_2 != 0;
                String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
            } else {
                _result2 = null;
            }
            Person person = _result2;
            return person;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByUsernameAsync(String username, Continuation<? super Person> $completion) {
        String _sql = "SELECT Person.* FROM PERSON Where Person.username = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT Person.* FROM PERSON Where Person.username = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, username);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Person>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Person call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Person _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                        int _tmp = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                        _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _result2 = null;
                    }
                    Person person = _result2;
                    return person;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findSystemAccount(long nodeId, Continuation<? super Person> $completion) {
        String _sql = "\n        SELECT Person.*\n          FROM Person\n         WHERE Person.dateOfBirth = ?\n           AND Person.personType = 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*\n          FROM Person\n         WHERE Person.dateOfBirth = ?\n           AND Person.personType = 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, nodeId);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Person>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Person call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Person _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                        int _tmp = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                        _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _result2 = null;
                    }
                    Person person = _result2;
                    return person;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Person findByUid(long uid) {
        String _sql = "SELECT * FROM PERSON WHERE Person.personUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PERSON WHERE Person.personUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Person _result2;
            int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
            int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
            int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
            int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
            int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
            int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
            int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
            int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
            int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
            int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
            int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
            int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
            int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
            int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
            int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
            int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
            int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
            int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
            int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
            int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
            int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
            int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
            int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
            if (_cursor.moveToFirst()) {
                long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                int _tmp = _cursor.getInt(_cursorIndexOfActive);
                boolean _tmpActive = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                boolean _tmpAdmin = _tmp_2 != 0;
                String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
            } else {
                _result2 = null;
            }
            Person person = _result2;
            return person;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByUidWithPicture(long accountPersonUid, Continuation<? super PersonAndPicture> $completion) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid = ?           \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid = ?           \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonAndPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonAndPicture call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonAndPicture _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    if (_cursor.moveToFirst()) {
                        PersonPicture _tmpPicture;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_3 != 0;
                            _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPicture = null;
                        }
                        _result2 = new PersonAndPicture(_tmpPerson, _tmpPicture);
                    } else {
                        _result2 = null;
                    }
                    PersonAndPicture personAndPicture = _result2;
                    return personAndPicture;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<PersonAndPicture> findByUidWithPictureAsFlow(long uid) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid = ?           \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid = ?           \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Person", "PersonPicture"}, (Callable)new Callable<PersonAndPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonAndPicture call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PersonAndPicture _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    if (_cursor.moveToFirst()) {
                        PersonPicture _tmpPicture;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_3 != 0;
                            _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPicture = null;
                        }
                        _result2 = new PersonAndPicture(_tmpPerson, _tmpPicture);
                    } else {
                        _result2 = null;
                    }
                    PersonAndPicture personAndPicture = _result2;
                    return personAndPicture;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<Person> findByUidLive(long uid) {
        String _sql = "SELECT * From Person WHERE personUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * From Person WHERE personUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Person"}, (Callable)new Callable<Person>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Person call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Person _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                        int _tmp = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                        _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _result2 = null;
                    }
                    Person person = _result2;
                    return person;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super Person> $completion) {
        String _sql = "SELECT * FROM Person WHERE personUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Person WHERE personUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Person>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Person call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Person _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                        int _tmp = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                        _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _result2 = null;
                    }
                    Person person = _result2;
                    return person;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Person> findByUidAsFlow(long uid) {
        String _sql = "SELECT * FROM Person WHERE personUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Person WHERE personUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Person"}, (Callable)new Callable<Person>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Person call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Person _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                        int _tmp = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                        _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _result2 = null;
                    }
                    Person person = _result2;
                    return person;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersonAndListDisplayDetails> findPersonsWithPermissionAsList(long timestamp, long excludeClazz, List<Long> excludeSelected, long accountPersonUid, int sortOrder, String searchText) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("         WITH CanViewPersonUidsViaCoursePermission(personUid) AS");
        _stringBuilder.append("\n");
        _stringBuilder.append("              /* Select personUids that can be viewed based on CoursePermission given the active user ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 for their enrolments ");
        _stringBuilder.append("\n");
        _stringBuilder.append("              */");
        _stringBuilder.append("\n");
        _stringBuilder.append("              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      JOIN CoursePermission ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive");
        _stringBuilder.append("\n");
        _stringBuilder.append("              ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               UNION");
        _stringBuilder.append("\n");
        _stringBuilder.append("               /* Select personUids that can be viewed based on CoursePermission for the active user");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  where the CoursePermission is granted directly to them");
        _stringBuilder.append("\n");
        _stringBuilder.append("                */   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM CoursePermission");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND CoursePermission.cpToPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ");
        _stringBuilder.append("\n");
        _stringBuilder.append("         SELECT Person.*, PersonPicture.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("           FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("                LEFT JOIN PersonPicture");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     ON PersonPicture.personPictureUid = Person.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("          WHERE /* Begin permission check */ ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                (         ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      (");
        _stringBuilder.append("\n");
        _stringBuilder.append("        EXISTS(SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM SystemPermission");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0 ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND SystemPermission.spToPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND (SystemPermission.spPermissionsFlag &");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       8192");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ) > 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND NOT SystemPermission.spIsDeleted)");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    OR (Person.personUid IN ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                               (SELECT CanViewPersonUidsViaCoursePermission.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                  FROM CanViewPersonUidsViaCoursePermission))");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    OR (Person.personUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("                )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                /* End permission check */");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 OR ");
        _stringBuilder.append("?");
        _stringBuilder.append(" NOT IN");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    (SELECT clazzEnrolmentClazzUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       FROM ClazzEnrolment ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      WHERE clazzEnrolmentPersonUid = Person.personUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            AND ");
        _stringBuilder.append("?");
        _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                AND ClazzEnrolment.clazzEnrolmentDateLeft");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        AND ClazzEnrolment.clazzEnrolmentActive))");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND Person.personType = 0                  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (Person.personUid NOT IN (");
        int _inputSize = excludeSelected.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (");
        _stringBuilder.append("?");
        _stringBuilder.append(" = '%' ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               OR Person.firstNames || ' ' || Person.lastName LIKE ");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("      GROUP BY Person.personUid, PersonPicture.personPictureUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("      ORDER BY CASE(");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 1 THEN Person.firstNames");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 3 THEN Person.lastName");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ELSE ''");
        _stringBuilder.append("\n");
        _stringBuilder.append("               END ASC,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               CASE(");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 2 THEN Person.firstNames");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 4 THEN Person.lastName");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ELSE ''");
        _stringBuilder.append("\n");
        _stringBuilder.append("               END DESC");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 14 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, excludeClazz);
        _argIndex = 9;
        _statement.bindLong(_argIndex, excludeClazz);
        _argIndex = 10;
        _statement.bindLong(_argIndex, timestamp);
        _argIndex = 11;
        for (long _item : excludeSelected) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 11 + _inputSize;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 12 + _inputSize;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 13 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 14 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
            int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
            int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
            int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
            int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
            int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
            int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
            int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
            int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
            int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
            int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
            int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
            int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
            int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
            int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
            int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
            int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
            int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
            int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
            int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
            int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
            int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
            int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
            int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
            int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
            int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
            int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
            ArrayList<PersonAndListDisplayDetails> _result2 = new ArrayList<PersonAndListDisplayDetails>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                PersonPicture _tmpPicture;
                Person _tmpPerson;
                if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                    long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                    String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                    String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                    String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                    String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                    String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                    int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                    int _tmp = _cursor.getInt(_cursorIndexOfActive);
                    boolean _tmpActive = _tmp != 0;
                    int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                    boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                    long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                    String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                    String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                    long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                    long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                    String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                    int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                    long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                    long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                    int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                    int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                    boolean _tmpAdmin = _tmp_2 != 0;
                    String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                    String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                    String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                    String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                    String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                    _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                } else {
                    _tmpPerson = null;
                }
                if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                    long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                    long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                    String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                    String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                    int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                    int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                    boolean _tmpPersonPictureActive = _tmp_3 != 0;
                    _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                } else {
                    _tmpPicture = null;
                }
                PersonAndListDisplayDetails _item_1 = new PersonAndListDisplayDetails(_tmpPerson, _tmpPicture);
                _result2.add(_item_1);
            }
            ArrayList<PersonAndListDisplayDetails> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public PagingSource<Integer, PersonAndListDisplayDetails> findPersonsWithPermissionAsPagingSource(long timestamp, long excludeClazz, List<Long> excludeSelected, long accountPersonUid, int sortOrder, String searchText) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("         WITH CanViewPersonUidsViaCoursePermission(personUid) AS");
        _stringBuilder.append("\n");
        _stringBuilder.append("              /* Select personUids that can be viewed based on CoursePermission given the active user ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 for their enrolments ");
        _stringBuilder.append("\n");
        _stringBuilder.append("              */");
        _stringBuilder.append("\n");
        _stringBuilder.append("              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      JOIN CoursePermission ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive");
        _stringBuilder.append("\n");
        _stringBuilder.append("              ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               UNION");
        _stringBuilder.append("\n");
        _stringBuilder.append("               /* Select personUids that can be viewed based on CoursePermission for the active user");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  where the CoursePermission is granted directly to them");
        _stringBuilder.append("\n");
        _stringBuilder.append("                */   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM CoursePermission");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND CoursePermission.cpToPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ");
        _stringBuilder.append("\n");
        _stringBuilder.append("         SELECT Person.*, PersonPicture.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("           FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("                LEFT JOIN PersonPicture");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     ON PersonPicture.personPictureUid = Person.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("          WHERE /* Begin permission check */ ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                (         ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      (");
        _stringBuilder.append("\n");
        _stringBuilder.append("        EXISTS(SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM SystemPermission");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0 ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND SystemPermission.spToPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND (SystemPermission.spPermissionsFlag &");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       8192");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ) > 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND NOT SystemPermission.spIsDeleted)");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    OR (Person.personUid IN ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                               (SELECT CanViewPersonUidsViaCoursePermission.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                  FROM CanViewPersonUidsViaCoursePermission))");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    OR (Person.personUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("                )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                /* End permission check */");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 OR ");
        _stringBuilder.append("?");
        _stringBuilder.append(" NOT IN");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    (SELECT clazzEnrolmentClazzUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       FROM ClazzEnrolment ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      WHERE clazzEnrolmentPersonUid = Person.personUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            AND ");
        _stringBuilder.append("?");
        _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                AND ClazzEnrolment.clazzEnrolmentDateLeft");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        AND ClazzEnrolment.clazzEnrolmentActive))");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND Person.personType = 0                  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (Person.personUid NOT IN (");
        int _inputSize = excludeSelected.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (");
        _stringBuilder.append("?");
        _stringBuilder.append(" = '%' ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               OR Person.firstNames || ' ' || Person.lastName LIKE ");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("      GROUP BY Person.personUid, PersonPicture.personPictureUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("      ORDER BY CASE(");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 1 THEN Person.firstNames");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 3 THEN Person.lastName");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ELSE ''");
        _stringBuilder.append("\n");
        _stringBuilder.append("               END ASC,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               CASE(");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 2 THEN Person.firstNames");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHEN 4 THEN Person.lastName");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ELSE ''");
        _stringBuilder.append("\n");
        _stringBuilder.append("               END DESC");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 14 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, excludeClazz);
        _argIndex = 9;
        _statement.bindLong(_argIndex, excludeClazz);
        _argIndex = 10;
        _statement.bindLong(_argIndex, timestamp);
        _argIndex = 11;
        for (long _item : excludeSelected) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 11 + _inputSize;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 12 + _inputSize;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 13 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 14 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<PersonAndListDisplayDetails>(_statement, this.__db, new String[]{"ClazzEnrolment", "CoursePermission", "Person", "PersonPicture", "SystemPermission"}){

            @NonNull
            protected List<PersonAndListDisplayDetails> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"active");
                int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPersonalAccount");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherNum");
                int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUid");
                int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureLct");
                int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUri");
                int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureThumbnailUri");
                int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fileSize");
                int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureActive");
                ArrayList<PersonAndListDisplayDetails> _result2 = new ArrayList<PersonAndListDisplayDetails>(cursor.getCount());
                while (cursor.moveToNext()) {
                    PersonPicture _tmpPicture;
                    Person _tmpPerson;
                    if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
                        long _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = cursor.getInt(_cursorIndexOfGender);
                        int _tmp = cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum);
                        _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _tmpPerson = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                        long _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp_3 != 0;
                        _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _tmpPicture = null;
                    }
                    PersonAndListDisplayDetails _item_1 = new PersonAndListDisplayDetails(_tmpPerson, _tmpPicture);
                    _result2.add(_item_1);
                }
                return _result2;
            }
        };
    }

    @Override
    public Flow<PersonAndDisplayDetail> findByUidWithDisplayDetailsLive(long personUid, long activeUserPersonUid) {
        String _sql = "\n        SELECT Person.*, PersonParentJoin.* \n          FROM Person\n     LEFT JOIN PersonParentJoin on ppjUid = (\n                SELECT ppjUid \n                  FROM PersonParentJoin\n                 WHERE ppjMinorPersonUid = ? \n                       AND ppjParentPersonUid = ? \n                LIMIT 1)     \n         WHERE Person.personUid = ?\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonParentJoin.* \n          FROM Person\n     LEFT JOIN PersonParentJoin on ppjUid = (\n                SELECT ppjUid \n                  FROM PersonParentJoin\n                 WHERE ppjMinorPersonUid = ? \n                       AND ppjParentPersonUid = ? \n                LIMIT 1)     \n         WHERE Person.personUid = ?\n        ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, activeUserPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, personUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Person", "PersonParentJoin"}, (Callable)new Callable<PersonAndDisplayDetail>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonAndDisplayDetail call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PersonAndDisplayDetail _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjUid");
                    int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPcsn");
                    int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcsn");
                    int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcb");
                    int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLct");
                    int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjParentPersonUid");
                    int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjMinorPersonUid");
                    int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjRelationship");
                    int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjEmail");
                    int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPhone");
                    int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjInactive");
                    int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjStatus");
                    int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalTiemstamp");
                    int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalIpAddr");
                    if (_cursor.moveToFirst()) {
                        PersonParentJoin _tmpParentJoin;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
                            long _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
                            long _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
                            long _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
                            int _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
                            long _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
                            long _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
                            long _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
                            int _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
                            String _tmpPpjEmail = _cursor.isNull(_cursorIndexOfPpjEmail) ? null : _cursor.getString(_cursorIndexOfPpjEmail);
                            String _tmpPpjPhone = _cursor.isNull(_cursorIndexOfPpjPhone) ? null : _cursor.getString(_cursorIndexOfPpjPhone);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPpjInactive);
                            boolean _tmpPpjInactive = _tmp_3 != 0;
                            int _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
                            long _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
                            String _tmpPpjApprovalIpAddr = _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr) ? null : _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
                            _tmpParentJoin = new PersonParentJoin(_tmpPpjUid, _tmpPpjPcsn, _tmpPpjLcsn, _tmpPpjLcb, _tmpPpjLct, _tmpPpjParentPersonUid, _tmpPpjMinorPersonUid, _tmpPpjRelationship, _tmpPpjEmail, _tmpPpjPhone, _tmpPpjInactive, _tmpPpjStatus, _tmpPpjApprovalTiemstamp, _tmpPpjApprovalIpAddr);
                        } else {
                            _tmpParentJoin = null;
                        }
                        _result2 = new PersonAndDisplayDetail(_tmpPerson, _tmpParentJoin, null, null);
                    } else {
                        _result2 = null;
                    }
                    PersonAndDisplayDetail personAndDisplayDetail = _result2;
                    return personAndDisplayDetail;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<PersonAndDisplayDetail> findByUidWithDisplayDetailsFlow(long personUid, long accountPersonUid) {
        String _sql = "\n        SELECT Person.*, PersonParentJoin.* , PersonPicture.*, TransferJobItem.*\n          FROM Person\n               LEFT JOIN PersonParentJoin \n                    ON ppjUid =\n                    (SELECT ppjUid \n                       FROM PersonParentJoin\n                      WHERE ppjMinorPersonUid = ? \n                        AND ppjParentPersonUid = ? \n                      LIMIT 1)  \n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = ?\n               LEFT JOIN TransferJobItem\n                    ON TransferJobItem.tjiUid = \n                       (SELECT TransferJobItem.tjiUid\n                          FROM TransferJobItem\n                         WHERE TransferJobItem.tjiEntityUid = ?\n                           AND TransferJobItem.tjiTableId = 50\n                           AND TransferJobItem.tjiEntityEtag = PersonPicture.personPictureLct\n                           AND TransferJobItem.tjiStatus != 21\n                         LIMIT 1)\n                          \n         WHERE Person.personUid = ?\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonParentJoin.* , PersonPicture.*, TransferJobItem.*\n          FROM Person\n               LEFT JOIN PersonParentJoin \n                    ON ppjUid =\n                    (SELECT ppjUid \n                       FROM PersonParentJoin\n                      WHERE ppjMinorPersonUid = ? \n                        AND ppjParentPersonUid = ? \n                      LIMIT 1)  \n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = ?\n               LEFT JOIN TransferJobItem\n                    ON TransferJobItem.tjiUid = \n                       (SELECT TransferJobItem.tjiUid\n                          FROM TransferJobItem\n                         WHERE TransferJobItem.tjiEntityUid = ?\n                           AND TransferJobItem.tjiTableId = 50\n                           AND TransferJobItem.tjiEntityEtag = PersonPicture.personPictureLct\n                           AND TransferJobItem.tjiStatus != 21\n                         LIMIT 1)\n                          \n         WHERE Person.personUid = ?\n        ", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, personUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Person", "PersonParentJoin", "PersonPicture", "TransferJobItem"}, (Callable)new Callable<PersonAndDisplayDetail>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonAndDisplayDetail call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PersonAndDisplayDetail _result2;
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjUid");
                    int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPcsn");
                    int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcsn");
                    int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLcb");
                    int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjLct");
                    int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjParentPersonUid");
                    int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjMinorPersonUid");
                    int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjRelationship");
                    int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjEmail");
                    int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjPhone");
                    int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjInactive");
                    int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjStatus");
                    int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalTiemstamp");
                    int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ppjApprovalIpAddr");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiUid");
                    int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTjUid");
                    int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTotalSize");
                    int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTransferred");
                    int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjAttemptCount");
                    int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiSrc");
                    int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiDest");
                    int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiType");
                    int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiStatus");
                    int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTableId");
                    int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityUid");
                    int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityEtag");
                    int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiLockIdToRelease");
                    int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiPartialTmpFile");
                    if (_cursor.moveToFirst()) {
                        TransferJobItem _tmpPersonPictureTransferJobItem;
                        PersonPicture _tmpPersonPicture;
                        PersonParentJoin _tmpParentJoin;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
                            long _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
                            long _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
                            long _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
                            int _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
                            long _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
                            long _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
                            long _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
                            int _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
                            String _tmpPpjEmail = _cursor.isNull(_cursorIndexOfPpjEmail) ? null : _cursor.getString(_cursorIndexOfPpjEmail);
                            String _tmpPpjPhone = _cursor.isNull(_cursorIndexOfPpjPhone) ? null : _cursor.getString(_cursorIndexOfPpjPhone);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPpjInactive);
                            boolean _tmpPpjInactive = _tmp_3 != 0;
                            int _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
                            long _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
                            String _tmpPpjApprovalIpAddr = _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr) ? null : _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
                            _tmpParentJoin = new PersonParentJoin(_tmpPpjUid, _tmpPpjPcsn, _tmpPpjLcsn, _tmpPpjLcb, _tmpPpjLct, _tmpPpjParentPersonUid, _tmpPpjMinorPersonUid, _tmpPpjRelationship, _tmpPpjEmail, _tmpPpjPhone, _tmpPpjInactive, _tmpPpjStatus, _tmpPpjApprovalTiemstamp, _tmpPpjApprovalIpAddr);
                        } else {
                            _tmpParentJoin = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_4 != 0;
                            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPersonPicture = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfTjiUid) && _cursor.isNull(_cursorIndexOfTjiTjUid) && _cursor.isNull(_cursorIndexOfTjTotalSize) && _cursor.isNull(_cursorIndexOfTjTransferred) && _cursor.isNull(_cursorIndexOfTjAttemptCount) && _cursor.isNull(_cursorIndexOfTjiSrc) && _cursor.isNull(_cursorIndexOfTjiDest) && _cursor.isNull(_cursorIndexOfTjiType) && _cursor.isNull(_cursorIndexOfTjiStatus) && _cursor.isNull(_cursorIndexOfTjiTableId) && _cursor.isNull(_cursorIndexOfTjiEntityUid) && _cursor.isNull(_cursorIndexOfTjiEntityEtag) && _cursor.isNull(_cursorIndexOfTjiLockIdToRelease) && _cursor.isNull(_cursorIndexOfTjiPartialTmpFile))) {
                            int _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
                            int _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
                            long _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
                            long _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
                            int _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
                            String _tmpTjiSrc = _cursor.isNull(_cursorIndexOfTjiSrc) ? null : _cursor.getString(_cursorIndexOfTjiSrc);
                            String _tmpTjiDest = _cursor.isNull(_cursorIndexOfTjiDest) ? null : _cursor.getString(_cursorIndexOfTjiDest);
                            int _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
                            int _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
                            int _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
                            long _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
                            long _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
                            long _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
                            String _tmpTjiPartialTmpFile = _cursor.isNull(_cursorIndexOfTjiPartialTmpFile) ? null : _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
                            _tmpPersonPictureTransferJobItem = new TransferJobItem(_tmpTjiUid, _tmpTjiTjUid, _tmpTjTotalSize, _tmpTjTransferred, _tmpTjAttemptCount, _tmpTjiSrc, _tmpTjiDest, _tmpTjiType, _tmpTjiStatus, _tmpTjiTableId, _tmpTjiEntityUid, _tmpTjiEntityEtag, _tmpTjiLockIdToRelease, _tmpTjiPartialTmpFile);
                        } else {
                            _tmpPersonPictureTransferJobItem = null;
                        }
                        _result2 = new PersonAndDisplayDetail(_tmpPerson, _tmpParentJoin, _tmpPersonPicture, _tmpPersonPictureTransferJobItem);
                    } else {
                        _result2 = null;
                    }
                    PersonAndDisplayDetail personAndDisplayDetail = _result2;
                    return personAndDisplayDetail;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Person> getAllPerson() {
        String _sql = "SELECT * FROM Person";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Person", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
            int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
            int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
            int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
            int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
            int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
            int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
            int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
            int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
            int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
            int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
            int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
            int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
            int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
            int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
            int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
            int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
            int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
            int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
            int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
            int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
            int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
            int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
            ArrayList<Person> _result2 = new ArrayList<Person>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                int _tmp = _cursor.getInt(_cursorIndexOfActive);
                boolean _tmpActive = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                boolean _tmpAdmin = _tmp_2 != 0;
                String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                Person _item = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                _result2.add(_item);
            }
            ArrayList<Person> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<PersonNames> getNamesByUid(long uid) {
        String _sql = "\n        SELECT Person.firstNames, Person.lastName\n          FROM Person\n         WHERE Person.personUid = ?  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.firstNames, Person.lastName\n          FROM Person\n         WHERE Person.personUid = ?  \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Person"}, (Callable)new Callable<PersonNames>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonNames call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PersonNames _result2;
                    boolean _cursorIndexOfFirstNames = false;
                    boolean _cursorIndexOfLastName = true;
                    if (_cursor.moveToFirst()) {
                        String _tmpFirstNames = _cursor.isNull(0) ? null : _cursor.getString(0);
                        String _tmpLastName = _cursor.isNull(1) ? null : _cursor.getString(1);
                        _result2 = new PersonNames(_tmpFirstNames, _tmpLastName);
                    } else {
                        _result2 = null;
                    }
                    PersonNames personNames = _result2;
                    return personNames;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getNamesByUidAsync(long uid, Continuation<? super PersonNames> $completion) {
        String _sql = "\n        SELECT Person.firstNames, Person.lastName\n          FROM Person\n         WHERE Person.personUid = ?  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.firstNames, Person.lastName\n          FROM Person\n         WHERE Person.personUid = ?  \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonNames>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonNames call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonNames _result2;
                    boolean _cursorIndexOfFirstNames = false;
                    boolean _cursorIndexOfLastName = true;
                    if (_cursor.moveToFirst()) {
                        String _tmpFirstNames = _cursor.isNull(0) ? null : _cursor.getString(0);
                        String _tmpLastName = _cursor.isNull(1) ? null : _cursor.getString(1);
                        _result2 = new PersonNames(_tmpFirstNames, _tmpLastName);
                    } else {
                        _result2 = null;
                    }
                    PersonNames personNames = _result2;
                    return personNames;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getMinorByParentPersonUidAsync(long uid, Continuation<? super List<Person>> $completion) {
        String _sql = "\n          SELECT Person.*\n             FROM Person\n             LEFT JOIN PersonParentJoin ON Person.personUid = PersonParentJoin.ppjMinorPersonUid\n              WHERE PersonParentJoin.ppjParentPersonUid =  ?  \n     ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n          SELECT Person.*\n             FROM Person\n             LEFT JOIN PersonParentJoin ON Person.personUid = PersonParentJoin.ppjMinorPersonUid\n              WHERE PersonParentJoin.ppjParentPersonUid =  ?  \n     ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Person>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<Person> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    ArrayList<Person> _result2 = new ArrayList<Person>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                        int _tmp = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                        Person _item = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        _result2.add(_item);
                    }
                    ArrayList<Person> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object selectExistingUsernames(List<String> usernames, Continuation<? super List<String>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT Person.username");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE Person.username IN (");
        int _inputSize = usernames.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : usernames) {
            _statement.bindString(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<String> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<String> _result2 = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item_1 = _cursor.isNull(0) ? null : _cursor.getString(0);
                        _result2.add(_item_1);
                    }
                    ArrayList<String> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

