/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.rest.clitools.passwordreset;

import com.ustadmobile.core.account.AuthManager;
import com.ustadmobile.core.account.LearningSpace;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.rest.clitools.passwordreset.PasswordResetKt;
import com.ustadmobile.lib.rest.dimodules.JvmBackendDiModuleKt;
import com.ustadmobile.lib.rest.ext.AppConfigExtKt;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.HoconApplicationConfigKt;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DI;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DIContext;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "app-ktor-server"})
@SourceDebugExtension(value={"SMAP\nPasswordReset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordReset.kt\ncom/ustadmobile/lib/rest/clitools/passwordreset/PasswordResetKt\n+ 2 Retrieving.kt\norg/kodein/di/RetrievingKt\n+ 3 typeTokensJVM.kt\norg/kodein/type/TypeTokensJVMKt\n*L\n1#1,91:1\n615#2:92\n307#2:93\n528#2:95\n615#2:96\n307#2:97\n528#2:99\n83#3:94\n83#3:98\n*S KotlinDebug\n*F\n+ 1 PasswordReset.kt\ncom/ustadmobile/lib/rest/clitools/passwordreset/PasswordResetKt\n*L\n77#1:92\n77#1:93\n77#1:95\n81#1:96\n81#1:97\n81#1:99\n77#1:94\n81#1:98\n*E\n"})
public final class PasswordResetKt {
    /*
     * WARNING - void declaration
     */
    public static final void main(@NotNull String[] args) {
        void $this$instance$iv;
        LearningSpace learningSpace;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ArgumentParser parser = ArgumentParsers.newFor((String)"PasswordReset").build().defaultHelp(true).description("Ustad server command line password reset");
        String[] stringArray = new String[]{"-c", "--config"};
        parser.addArgument(stringArray).setDefault((Object)"ustad-server.conf").help("Server config file path");
        stringArray = new String[]{"-l", "--learningspace"};
        parser.addArgument(stringArray).help("Server learning sapce url e.g. https://ustad.servername.com/");
        stringArray = new String[]{"-u", "--username"};
        parser.addArgument(stringArray).required(true).help("Username to reset password for");
        Namespace ns = null;
        try {
            Namespace namespace = parser.parseArgs(args);
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"parseArgs(...)");
            ns = namespace;
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        System.out.println((Object)("Loading " + ns.getString("config")));
        try {
            HoconApplicationConfigKt.ApplicationConfig((String)ns.getString("config"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ApplicationConfig conf = HoconApplicationConfigKt.ApplicationConfig((String)ns.getString("config"));
        System.out.println((Object)"Loaded config");
        if (Intrinsics.areEqual((Object)AppConfigExtKt.dbModeProperty(conf), (Object)"singleton")) {
            learningSpace = new LearningSpace("http://localhost/");
        } else {
            String endpointArg = ns.getString("endpoint");
            if (endpointArg == null) {
                System.out.println((Object)"ERROR: Configuration uses virtual hosting: but no endpoint specified");
                System.exit(2);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            learningSpace = new LearningSpace(endpointArg);
        }
        LearningSpace learningSpace2 = learningSpace;
        Json json2 = JsonKt.Json$default(null, (Function1)main.json.1.INSTANCE, (int)1, null);
        DI di2 = DI.Companion.invoke$default((DI.Companion)DI.Companion, (boolean)false, (Function1)((Function1)new Function1<DI.MainBuilder, Unit>(conf, json2){
            final /* synthetic */ ApplicationConfig $conf;
            final /* synthetic */ Json $json;
            {
                this.$conf = $conf;
                this.$json = $json;
                super(1);
            }

            public final void invoke(@NotNull DI.MainBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                DI.Builder.DefaultImpls.import$default((DI.Builder)((DI.Builder)$this$invoke), (DI.Module)JvmBackendDiModuleKt.makeJvmBackendDiModule$default(this.$conf, this.$json, null, 4, null), (boolean)false, (int)2, null);
            }
        }), (int)1, null);
        DirectDIAware $this$on$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)di2));
        boolean $i$f$on = false;
        DirectDI directDI = $this$on$iv.getDirectDI();
        boolean $i$f$diContext = false;
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<LearningSpace>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        $this$on$iv = (DirectDIAware)directDI.On(DIContext.Companion.invoke((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, LearningSpace.class), (Object)learningSpace2));
        Integer tag$iv = 1;
        boolean $i$f$instance = false;
        DirectDI directDI2 = $this$instance$iv.getDirectDI();
        $i$f$generic = false;
        JVMTypeToken jVMTypeToken2 = TypeTokensJVMKt.typeToken((Type)new TypeReference<UmAppDatabase>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken2, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        UmAppDatabase db = (UmAppDatabase)directDI2.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken2, UmAppDatabase.class), (Object)tag$iv);
        Person person = db.personDao().findByUsername(ns.getString("username"));
        if (person != null) {
            void $this$instance_u24default$iv;
            DirectDIAware $this$on$iv2 = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)di2));
            boolean $i$f$on2 = false;
            DirectDI directDI3 = $this$on$iv2.getDirectDI();
            boolean $i$f$diContext2 = false;
            boolean $i$f$generic2 = false;
            JVMTypeToken jVMTypeToken3 = TypeTokensJVMKt.typeToken((Type)new TypeReference<LearningSpace>(){}.getSuperType());
            Intrinsics.checkNotNull((Object)jVMTypeToken3, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
            $this$on$iv2 = (DirectDIAware)directDI3.On(DIContext.Companion.invoke((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken3, LearningSpace.class), (Object)learningSpace2));
            Object tag$iv2 = null;
            boolean $i$f$instance2 = false;
            DirectDI directDI4 = $this$instance_u24default$iv.getDirectDI();
            $i$f$generic2 = false;
            JVMTypeToken jVMTypeToken4 = TypeTokensJVMKt.typeToken((Type)new TypeReference<AuthManager>(){}.getSuperType());
            Intrinsics.checkNotNull((Object)jVMTypeToken4, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
            AuthManager authManager = (AuthManager)directDI4.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken4, AuthManager.class), tag$iv2);
            System.out.print((Object)"Please enter new password: ");
            String newPassword = ((Object)StringsKt.trim((CharSequence)ConsoleKt.readln())).toString();
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(authManager, person, newPassword, null){
                int label;
                final /* synthetic */ AuthManager $authManager;
                final /* synthetic */ Person $person;
                final /* synthetic */ String $newPassword;
                {
                    this.$authManager = $authManager;
                    this.$person = $person;
                    this.$newPassword = $newPassword;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$authManager.setAuth(this.$person.getPersonUid(), this.$newPassword, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            System.out.println((Object)"ERROR: user not found");
        }
    }
}

