/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.util.Formattable;
import java.util.Formatter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class SizeDecor
implements Formattable {
    private static final int MAX_POWER = 6;
    private static final ConcurrentMap<Integer, String> SUFFIXES = new ConcurrentHashMap<Integer, String>(0);
    private final transient Long size;

    SizeDecor(Long sze) {
        this.size = sze;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.size == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder format = new StringBuilder().append('%');
            if ((flags & 1) == 1) {
                format.append('-');
            }
            if (width > 0) {
                format.append(Integer.toString(width));
            }
            if ((flags & 2) == 2) {
                format.append('S');
            } else {
                format.append('s');
            }
            formatter.format(format.toString(), this.formatSizeWithSuffix(precision));
        }
    }

    private String formatSizeWithSuffix(int precision) {
        int power;
        double number = this.size.longValue();
        for (power = 0; number / 1024.0 >= 1.0 && power < 6; ++power) {
            number /= 1024.0;
        }
        String suffix = (String)SUFFIXES.get(power);
        String format = precision >= 0 ? String.format("%%.%df%%s", precision) : "%.0f%s";
        return String.format(format, number, suffix);
    }

    static {
        SUFFIXES.put(0, "b");
        SUFFIXES.put(1, "Kb");
        SUFFIXES.put(2, "Mb");
        SUFFIXES.put(3, "Gb");
        SUFFIXES.put(4, "Tb");
        SUFFIXES.put(5, "Pb");
        SUFFIXES.put(6, "Eb");
    }
}

