/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ComposeScene;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.awt.ComposeBridge;
import androidx.compose.ui.awt.ComposePanel;
import androidx.compose.ui.awt.LocalLayerContainer_desktopKt;
import androidx.compose.ui.awt.SwingComposeBridge;
import androidx.compose.ui.awt.Utils_desktopKt;
import androidx.compose.ui.awt.WindowComposeBridge;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.window.LayoutConfiguration_desktopKt;
import androidx.compose.ui.window.WindowExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipComponent;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.SkiaLayerAnalytics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0016J\u0012\u0010*\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010,\u001a\u00020\u0014H\u0016J\b\u0010-\u001a\u00020\rH\u0002J\b\u0010.\u001a\u00020\u0014H\u0007J\b\u0010/\u001a\u00020\nH\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u00020\nH\u0016J\b\u00103\u001a\u00020\u0014H\u0002J\b\u00104\u001a\u00020\nH\u0016J\b\u00105\u001a\u00020\nH\u0016J\b\u00106\u001a\u00020\nH\u0016J\u0010\u00107\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0010H\u0016J\u0012\u00108\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010\bH\u0016J\b\u00109\u001a\u00020\u0014H\u0016J\b\u0010:\u001a\u00020\u0014H\u0016J\u0012\u0010:\u001a\u00020\u00142\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0010\u0010:\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nH\u0016J\b\u0010>\u001a\u00020\nH\u0016J\u0012\u0010>\u001a\u00020\n2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J(\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020AH\u0016J\u0012\u0010E\u001a\u00020\u00142\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u001e\u0010H\u001a\u00020\u00142\u0011\u0010\u0012\u001a\r\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\nH\u0016J\u0010\u0010L\u001a\u00020\u00142\u0006\u0010M\u001a\u00020\nH\u0016J\u0012\u0010N\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010OH\u0016J\u0010\u0010P\u001a\u00020\u00142\u0006\u0010Q\u001a\u00020\nH\u0016J\b\u0010R\u001a\u00020\u0014H\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000f\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R0\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b \u0010\u0002\u001a\u0004\b\u001f\u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Landroidx/compose/ui/awt/ComposePanel;", "Ljavax/swing/JLayeredPane;", "()V", "skiaLayerAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "_focusListeners", "", "Ljava/awt/event/FocusListener;", "_isFocusable", "", "_isRequestFocusEnabled", "bridge", "Landroidx/compose/ui/awt/ComposeBridge;", "clipMap", "", "Ljava/awt/Component;", "Lorg/jetbrains/skiko/ClipComponent;", "content", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "Lkotlin/jvm/functions/Function2;", "value", "Landroidx/compose/ui/window/WindowExceptionHandler;", "exceptionHandler", "getExceptionHandler$annotations", "getExceptionHandler", "()Landroidx/compose/ui/window/WindowExceptionHandler;", "setExceptionHandler", "(Landroidx/compose/ui/window/WindowExceptionHandler;)V", "isDisposeOnRemove", "isDisposeOnRemove$annotations", "()Z", "setDisposeOnRemove", "(Z)V", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "add", "component", "addFocusListener", "l", "addNotify", "createComposeBridge", "dispose", "getFocusTraversalKeysEnabled", "getPreferredSize", "Ljava/awt/Dimension;", "hasFocus", "initContent", "isFocusOwner", "isFocusable", "isRequestFocusEnabled", "remove", "removeFocusListener", "removeNotify", "requestFocus", "cause", "Ljava/awt/event/FocusEvent$Cause;", "temporary", "requestFocusInWindow", "setBounds", "x", "", "y", "width", "height", "setComponentOrientation", "o", "Ljava/awt/ComponentOrientation;", "setContent", "(Lkotlin/jvm/functions/Function2;)V", "setFocusTraversalKeysEnabled", "focusTraversalKeysEnabled", "setFocusable", "focusable", "setLocale", "Ljava/util/Locale;", "setRequestFocusEnabled", "requestFocusEnabled", "updateLayoutDirection", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposePanel.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposePanel.desktop.kt\nandroidx/compose/ui/awt/ComposePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n1855#2,2:335\n*S KotlinDebug\n*F\n+ 1 ComposePanel.desktop.kt\nandroidx/compose/ui/awt/ComposePanel\n*L\n215#1:335,2\n*E\n"})
public final class ComposePanel
extends JLayeredPane {
    @NotNull
    private final SkiaLayerAnalytics skiaLayerAnalytics;
    @NotNull
    private final Set<FocusListener> _focusListeners;
    private boolean _isFocusable;
    private boolean _isRequestFocusEnabled;
    @Nullable
    private ComposeBridge bridge;
    @NotNull
    private final Map<Component, ClipComponent> clipMap;
    @Nullable
    private Function2<? super Composer, ? super Integer, Unit> content;
    private boolean isDisposeOnRemove;
    @Nullable
    private WindowExceptionHandler exceptionHandler;
    public static final int $stable = 8;

    @ExperimentalComposeUiApi
    public ComposePanel(@NotNull SkiaLayerAnalytics skiaLayerAnalytics) {
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"skiaLayerAnalytics");
        this.skiaLayerAnalytics = skiaLayerAnalytics;
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "ComposePanel should be created inside AWT Event Dispatch Thread (use SwingUtilities.invokeLater).\nCreating from another thread isn't supported.";
            throw new IllegalStateException(string.toString());
        }
        this.setBackground(Color.white);
        this.setLayout(null);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            @Nullable
            public Component getComponentAfter(@Nullable Container aContainer, @Nullable Component aComponent) {
                Container ancestor = this.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = ancestor.getFocusTraversalPolicy();
                return policy.getComponentAfter(ancestor, this);
            }

            @Override
            @Nullable
            public Component getComponentBefore(@Nullable Container aContainer, @Nullable Component aComponent) {
                Container ancestor = this.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = ancestor.getFocusTraversalPolicy();
                return policy.getComponentBefore(ancestor, this);
            }

            @Nullable
            public Void getFirstComponent(@Nullable Container aContainer) {
                return null;
            }

            @Nullable
            public Void getLastComponent(@Nullable Container aContainer) {
                return null;
            }

            @Nullable
            public Void getDefaultComponent(@Nullable Container aContainer) {
                return null;
            }
        });
        this.setFocusCycleRoot(true);
        this._focusListeners = new LinkedHashSet();
        this._isFocusable = true;
        this.clipMap = new LinkedHashMap();
        this.isDisposeOnRemove = true;
    }

    public ComposePanel() {
        this(SkiaLayerAnalytics.Companion.getEmpty());
    }

    public final boolean isDisposeOnRemove() {
        return this.isDisposeOnRemove;
    }

    public final void setDisposeOnRemove(boolean bl) {
        this.isDisposeOnRemove = bl;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void isDisposeOnRemove$annotations() {
    }

    @ExperimentalComposeUiApi
    public final void dispose() {
        if (this.bridge != null) {
            ComposeBridge composeBridge = this.bridge;
            Intrinsics.checkNotNull((Object)composeBridge);
            composeBridge.dispose();
            ComposeBridge composeBridge2 = this.bridge;
            Intrinsics.checkNotNull((Object)composeBridge2);
            super.remove(composeBridge2.getComponent());
            ComposeBridge composeBridge3 = this.bridge;
            Intrinsics.checkNotNull((Object)composeBridge3);
            super.remove(composeBridge3.getInvisibleComponent());
            this.bridge = null;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Object object = this.bridge;
        if (object != null && (object = ((ComposeBridge)object).getComponent()) != null) {
            ((Component)object).setSize(width, height);
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize() {
        Object object;
        return this.isPreferredSizeSet() ? super.getPreferredSize() : ((object = this.bridge) != null && (object = ((ComposeBridge)object).getComponent()) != null ? ((JComponent)object).getPreferredSize() : null);
    }

    public final void setContent(@NotNull Function2<? super Composer, ? super Integer, Unit> content) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.content = content;
        this.initContent();
    }

    @Nullable
    public final WindowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void setExceptionHandler(@Nullable WindowExceptionHandler value) {
        this.exceptionHandler = value;
        ComposeBridge composeBridge = this.bridge;
        if (composeBridge != null) {
            composeBridge.setExceptionHandler(value);
        }
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getExceptionHandler$annotations() {
    }

    private final void initContent() {
        if (this.bridge != null && this.content != null) {
            ComposeBridge composeBridge = this.bridge;
            Intrinsics.checkNotNull((Object)composeBridge);
            ComposeBridge.setContent$default(composeBridge, null, null, (Function2)ComposableLambdaKt.composableLambdaInstance((int)-991691413, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this){
                final /* synthetic */ ComposePanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @Composable
                public final void invoke(@Nullable Composer $composer, int $changed) {
                    ComposerKt.sourceInformation((Composer)$composer, (String)"C164@6404L138:ComposePanel.desktop.kt#ccs55x");
                    if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart((int)-991691413, (int)$changed, (int)-1, (String)"androidx.compose.ui.awt.ComposePanel.initContent.<anonymous> (ComposePanel.desktop.kt:163)");
                        }
                        ProvidedValue[] providedValueArray = new ProvidedValue[]{LocalLayerContainer_desktopKt.getLocalLayerContainer().provides((Object)this.this$0)};
                        Function2 function2 = ComposePanel.access$getContent$p(this.this$0);
                        Intrinsics.checkNotNull((Object)function2);
                        CompositionLocalKt.CompositionLocalProvider((ProvidedValue[])providedValueArray, (Function2)function2, (Composer)$composer, (int)8);
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            }), 3, null);
        }
    }

    @Override
    @NotNull
    public Component add(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.bridge == null) {
            return component2;
        }
        ClipComponent clipComponent = new ClipComponent(component2);
        this.clipMap.put(component2, clipComponent);
        ComposeBridge composeBridge = this.bridge;
        Intrinsics.checkNotNull((Object)composeBridge);
        composeBridge.getClipComponents().add((ClipRectangle)clipComponent);
        Component component3 = super.add(component2, 0);
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"super.add(component, Integer.valueOf(0))");
        return component3;
    }

    @Override
    public void remove(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        ComposeBridge composeBridge = this.bridge;
        Intrinsics.checkNotNull((Object)composeBridge);
        List<ClipRectangle> list = composeBridge.getClipComponents();
        ClipComponent clipComponent = this.clipMap.get(component2);
        Intrinsics.checkNotNull((Object)clipComponent);
        list.remove(clipComponent);
        this.clipMap.remove(component2);
        super.remove(component2);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.bridge == null) {
            this.bridge = this.createComposeBridge();
            this.initContent();
            ComposeBridge composeBridge = this.bridge;
            Intrinsics.checkNotNull((Object)composeBridge);
            super.add(composeBridge.getInvisibleComponent(), 1);
            ComposeBridge composeBridge2 = this.bridge;
            Intrinsics.checkNotNull((Object)composeBridge2);
            super.add((Component)composeBridge2.getComponent(), 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ComposeBridge createComposeBridge() {
        void $this$forEach$iv;
        ComposeBridge bridge;
        ComposeBridge composeBridge;
        boolean renderOnGraphics = Boolean.parseBoolean(System.getProperty("compose.swing.render.on.graphics"));
        ComposeBridge $this$createComposeBridge_u24lambda_u241 = composeBridge = (bridge = renderOnGraphics ? (ComposeBridge)new SwingComposeBridge(this.skiaLayerAnalytics, LayoutConfiguration_desktopKt.layoutDirectionFor(this)) : (ComposeBridge)new WindowComposeBridge(this.skiaLayerAnalytics, LayoutConfiguration_desktopKt.layoutDirectionFor(this)));
        boolean bl = false;
        $this$createComposeBridge_u24lambda_u241.getScene$ui().releaseFocus();
        $this$createComposeBridge_u24lambda_u241.getComponent().setSize(this.getWidth(), this.getHeight());
        $this$createComposeBridge_u24lambda_u241.getComponent().setFocusable(this._isFocusable);
        $this$createComposeBridge_u24lambda_u241.getComponent().setRequestFocusEnabled(this._isRequestFocusEnabled);
        Iterable iterable = this._focusListeners;
        JComponent jComponent = $this$createComposeBridge_u24lambda_u241.getComponent();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FocusListener p0 = (FocusListener)element$iv;
            boolean bl2 = false;
            jComponent.addFocusListener(p0);
        }
        $this$createComposeBridge_u24lambda_u241.setExceptionHandler(this.exceptionHandler);
        $this$createComposeBridge_u24lambda_u241.getComponent().addFocusListener(new FocusListener(this, bridge){
            final /* synthetic */ ComposePanel this$0;
            final /* synthetic */ ComposeBridge $bridge;
            {
                this.this$0 = $receiver;
                this.$bridge = $bridge;
            }

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!Utils_desktopKt.isParentOf(this.this$0, e.getOppositeComponent())) {
                    this.$bridge.getScene$ui().requestFocus();
                    FocusEvent.Cause cause = e.getCause();
                    switch (cause == null ? -1 : createComposeBridge.1.WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                        case 1: {
                            this.$bridge.getScene$ui().moveFocus-3ESFkO8(FocusDirection.Companion.getNext-dhqQ-8s());
                            break;
                        }
                        case 2: {
                            this.$bridge.getScene$ui().moveFocus-3ESFkO8(FocusDirection.Companion.getPrevious-dhqQ-8s());
                            break;
                        }
                    }
                }
            }

            public void focusLost(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        return composeBridge;
    }

    @Override
    public void removeNotify() {
        if (this.isDisposeOnRemove) {
            this.dispose();
        }
        super.removeNotify();
    }

    @Override
    public void setComponentOrientation(@Nullable ComponentOrientation o) {
        super.setComponentOrientation(o);
        this.updateLayoutDirection();
    }

    @Override
    public void setLocale(@Nullable Locale l) {
        super.setLocale(l);
        this.updateLayoutDirection();
    }

    private final void updateLayoutDirection() {
        ComposeBridge composeBridge = this.bridge;
        ComposeScene composeScene = composeBridge != null ? composeBridge.getScene$ui() : null;
        if (composeScene != null) {
            composeScene.setLayoutDirection(LayoutConfiguration_desktopKt.layoutDirectionFor(this));
        }
    }

    @Override
    public void addFocusListener(@Nullable FocusListener l) {
        Object object = this.bridge;
        if (object != null && (object = ((ComposeBridge)object).getComponent()) != null) {
            ((Component)object).addFocusListener(l);
        }
        this._focusListeners.add(l);
    }

    @Override
    public void removeFocusListener(@Nullable FocusListener l) {
        Object object = this.bridge;
        if (object != null && (object = ((ComposeBridge)object).getComponent()) != null) {
            ((Component)object).removeFocusListener(l);
        }
        this._focusListeners.remove(l);
    }

    @Override
    public boolean isFocusable() {
        return this._isFocusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this._isFocusable = focusable;
        ComposeBridge composeBridge = this.bridge;
        JComponent jComponent = composeBridge != null ? composeBridge.getComponent() : null;
        if (jComponent != null) {
            jComponent.setFocusable(focusable);
        }
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return this._isRequestFocusEnabled;
    }

    @Override
    public void setRequestFocusEnabled(boolean requestFocusEnabled) {
        this._isRequestFocusEnabled = requestFocusEnabled;
        ComposeBridge composeBridge = this.bridge;
        JComponent jComponent = composeBridge != null ? composeBridge.getComponent() : null;
        if (jComponent != null) {
            jComponent.setRequestFocusEnabled(requestFocusEnabled);
        }
    }

    @Override
    public boolean hasFocus() {
        Object object = this.bridge;
        return object != null && (object = ((ComposeBridge)object).getComponent()) != null ? ((Component)object).hasFocus() : false;
    }

    @Override
    public boolean isFocusOwner() {
        Object object = this.bridge;
        return object != null && (object = ((ComposeBridge)object).getComponent()) != null ? ((Component)object).isFocusOwner() : false;
    }

    @Override
    public void requestFocus() {
        block0: {
            Object object = this.bridge;
            if (object == null || (object = ((ComposeBridge)object).getComponent()) == null) break block0;
            ((JComponent)object).requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        Object object = this.bridge;
        return object != null && (object = ((ComposeBridge)object).getComponent()) != null ? ((JComponent)object).requestFocus(temporary) : false;
    }

    @Override
    public void requestFocus(@Nullable FocusEvent.Cause cause) {
        block0: {
            Object object = this.bridge;
            if (object == null || (object = ((ComposeBridge)object).getComponent()) == null) break block0;
            ((Component)object).requestFocus(cause);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        Object object = this.bridge;
        return object != null && (object = ((ComposeBridge)object).getComponent()) != null ? ((JComponent)object).requestFocusInWindow() : false;
    }

    @Override
    public boolean requestFocusInWindow(@Nullable FocusEvent.Cause cause) {
        Object object = this.bridge;
        return object != null && (object = ((ComposeBridge)object).getComponent()) != null ? ((Component)object).requestFocusInWindow(cause) : false;
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        GraphicsApi graphicsApi;
        if (this.bridge != null) {
            ComposeBridge composeBridge = this.bridge;
            Intrinsics.checkNotNull((Object)composeBridge);
            graphicsApi = composeBridge.getRenderApi();
        } else {
            graphicsApi = GraphicsApi.UNKNOWN;
        }
        return graphicsApi;
    }

    public static final /* synthetic */ Function2 access$getContent$p(ComposePanel $this) {
        return $this.content;
    }
}

