/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.ui.awt.ComposeBridge;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.im.InputMethodRequests;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoView;
import org.jetbrains.skiko.swing.SkiaSwingLayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/awt/SwingComposeBridge;", "Landroidx/compose/ui/awt/ComposeBridge;", "skiaLayerAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "(Lorg/jetbrains/skiko/SkiaLayerAnalytics;Landroidx/compose/ui/unit/LayoutDirection;)V", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "component", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer;", "getComponent", "()Lorg/jetbrains/skiko/swing/SkiaSwingLayer;", "focusComponentDelegate", "Ljava/awt/Component;", "getFocusComponentDelegate", "()Ljava/awt/Component;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "disposeComponentLayer", "", "onComposeInvalidation", "requestNativeFocusOnAccessible", "accessible", "Ljavax/accessibility/Accessible;", "ui"})
public final class SwingComposeBridge
extends ComposeBridge {
    @NotNull
    private final SkiaLayerAnalytics skiaLayerAnalytics;
    @NotNull
    private final SkiaSwingLayer component;

    public SwingComposeBridge(@NotNull SkiaLayerAnalytics skiaLayerAnalytics, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"skiaLayerAnalytics");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        super(layoutDirection);
        this.skiaLayerAnalytics = skiaLayerAnalytics;
        SkikoView skikoView2 = this.getSkikoView();
        SkiaLayerAnalytics skiaLayerAnalytics2 = this.skiaLayerAnalytics;
        this.component = new SkiaSwingLayer(this, skikoView2, skiaLayerAnalytics2){
            final /* synthetic */ SwingComposeBridge this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void addNotify() {
                super.addNotify();
                this.this$0.resetSceneDensity();
                this.this$0.initContent();
                this.this$0.updateSceneSize();
                this.this$0.setParentWindow(SwingUtilities.getWindowAncestor((Component)((Object)this)));
            }

            public void removeNotify() {
                this.this$0.setParentWindow(null);
                super.removeNotify();
            }

            public void paint(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                this.this$0.resetSceneDensity();
                super.paint(g);
            }

            @Nullable
            public InputMethodRequests getInputMethodRequests() {
                return this.this$0.getCurrentInputMethodRequests();
            }

            public void doLayout() {
                super.doLayout();
                this.this$0.updateSceneSize();
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension dimension;
                if (this.isPreferredSizeSet()) {
                    Dimension dimension2 = super.getPreferredSize();
                    dimension = dimension2;
                    Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"super.getPreferredSize()");
                } else {
                    dimension = this.this$0.getSceneDimension();
                }
                return dimension;
            }

            @Nullable
            public AccessibleContext getAccessibleContext() {
                return this.this$0.getSceneAccessible().getAccessibleContext();
            }
        };
        this.attachComposeToComponent();
    }

    @NotNull
    public SkiaSwingLayer getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public GraphicsApi getRenderApi() {
        return this.getComponent().getRenderApi();
    }

    @Override
    @NotNull
    public List<ClipRectangle> getClipComponents() {
        return this.getComponent().getClipComponents();
    }

    @Override
    @NotNull
    protected Component getFocusComponentDelegate() {
        return (Component)this.getComponent();
    }

    @Override
    protected void requestNativeFocusOnAccessible(@NotNull Accessible accessible) {
        Intrinsics.checkNotNullParameter((Object)accessible, (String)"accessible");
        this.getComponent().requestNativeFocusOnAccessible(accessible);
    }

    @Override
    protected void onComposeInvalidation() {
        this.getComponent().repaint();
    }

    @Override
    protected void disposeComponentLayer() {
        this.getComponent().dispose();
    }
}

