/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopPlatformInput_desktopKt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.platform.PlatformInput;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u0016\b\u0000\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0011H\u0016JI\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(\u0012\u0004\u0012\u00020\u00110'2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00110'H\u0016\u00f8\u0001\u0000J\b\u0010,\u001a\u00020\u0011H\u0016J\u001a\u0010-\u001a\u00020\u00112\b\u0010.\u001a\u0004\u0018\u00010#2\u0006\u0010/\u001a\u00020#H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Landroidx/compose/ui/platform/PlatformInput;", "Landroidx/compose/ui/text/input/PlatformTextInputService;", "component", "Landroidx/compose/ui/platform/PlatformComponent;", "(Landroidx/compose/ui/platform/PlatformComponent;)V", "charKeyPressed", "", "getCharKeyPressed", "()Z", "setCharKeyPressed", "(Z)V", "currentInput", "Landroidx/compose/ui/platform/PlatformInput$CurrentInput;", "needToDeletePreviousChar", "getNeedToDeletePreviousChar", "setNeedToDeletePreviousChar", "hideSoftwareKeyboard", "", "inputMethodTextChanged", "event", "Ljava/awt/event/InputMethodEvent;", "methodRequestsForInput", "androidx/compose/ui/platform/PlatformInput$methodRequestsForInput$1", "input", "(Landroidx/compose/ui/platform/PlatformInput$CurrentInput;)Landroidx/compose/ui/platform/PlatformInput$methodRequestsForInput$1;", "notifyFocusedRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "onKeyEvent", "keyEvent", "Ljava/awt/event/KeyEvent;", "replaceInputMethodText", "showSoftwareKeyboard", "startInput", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "stopInput", "updateState", "oldValue", "newValue", "CurrentInput", "ui"})
public final class PlatformInput
implements PlatformTextInputService {
    @NotNull
    private final PlatformComponent component;
    @Nullable
    private CurrentInput currentInput;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;

    public PlatformInput(@NotNull PlatformComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.component = component2;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    public final void setCharKeyPressed(boolean bl) {
        this.charKeyPressed = bl;
    }

    public final boolean getNeedToDeletePreviousChar() {
        return this.needToDeletePreviousChar;
    }

    public final void setNeedToDeletePreviousChar(boolean bl) {
        this.needToDeletePreviousChar = bl;
    }

    public void startInput(@NotNull TextFieldValue value, @NotNull ImeOptions imeOptions, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
        CurrentInput input2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.currentInput = input2 = new CurrentInput(value, onEditCommand, onImeActionPerformed, imeOptions.getImeAction-eUduSuo(), null, 16, null);
        this.component.enableInput(this.methodRequestsForInput(input2));
    }

    public void stopInput() {
        this.component.disableInput();
        this.currentInput = null;
    }

    public void showSoftwareKeyboard() {
    }

    public void hideSoftwareKeyboard() {
    }

    public void updateState(@Nullable TextFieldValue oldValue, @NotNull TextFieldValue newValue) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            CurrentInput currentInput = this.currentInput;
            if (currentInput == null) break block0;
            CurrentInput input2 = currentInput;
            boolean bl = false;
            input2.setValue(newValue);
        }
    }

    @Deprecated(message="This method should not be called, used BringIntoViewRequester instead.")
    public void notifyFocusedRect(@NotNull Rect rect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            CurrentInput currentInput = this.currentInput;
            if (currentInput == null) break block0;
            CurrentInput input2 = currentInput;
            boolean bl = false;
            input2.setFocusedRect(rect);
        }
    }

    public final void onKeyEvent(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        switch (keyEvent.getID()) {
            case 400: {
                this.charKeyPressed = true;
                break;
            }
            case 402: {
                this.charKeyPressed = false;
            }
        }
    }

    public final void inputMethodTextChanged(@NotNull InputMethodEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.isConsumed()) {
            this.replaceInputMethodText(event);
            event.consume();
        }
    }

    private final void replaceInputMethodText(InputMethodEvent event) {
        block8: {
            String string;
            String string2;
            AttributedCharacterIterator attributedCharacterIterator;
            String string3;
            String string4;
            AttributedCharacterIterator attributedCharacterIterator2;
            CurrentInput currentInput = this.currentInput;
            if (currentInput == null) break block8;
            CurrentInput input2 = currentInput;
            boolean bl = false;
            AttributedCharacterIterator attributedCharacterIterator3 = attributedCharacterIterator2 = event.getText();
            if (attributedCharacterIterator3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator3, (String)"text");
                string4 = DesktopPlatformInput_desktopKt.access$toStringUntil(attributedCharacterIterator2, event.getCommittedCharacterCount());
            } else {
                string4 = string3 = null;
            }
            if (string4 == null) {
                string3 = "";
            }
            String committed = string3;
            AttributedCharacterIterator attributedCharacterIterator4 = attributedCharacterIterator = event.getText();
            if (attributedCharacterIterator4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator4, (String)"text");
                string2 = DesktopPlatformInput_desktopKt.access$toStringFrom(attributedCharacterIterator, event.getCommittedCharacterCount());
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
            String composing = string;
            List ops = new ArrayList();
            if (this.needToDeletePreviousChar && DesktopPlatformInput_desktopKt.access$isMac$p() && TextRange.getMin-impl((long)input2.getValue().getSelection-d9O1mEE()) > 0 && ((CharSequence)composing).length() == 0) {
                this.needToDeletePreviousChar = false;
                ops.add(new DeleteSurroundingTextInCodePointsCommand(1, 0));
            }
            ops.add(new CommitTextCommand(committed, 1));
            if (((CharSequence)composing).length() > 0) {
                ops.add(new SetComposingTextCommand(composing, 1));
            }
            input2.getOnEditCommand().invoke((Object)ops);
        }
    }

    private final methodRequestsForInput.1 methodRequestsForInput(CurrentInput input2) {
        return new InputMethodRequests(input2, this){
            final /* synthetic */ CurrentInput $input;
            final /* synthetic */ PlatformInput this$0;
            {
                this.$input = $input;
                this.this$0 = $receiver;
            }

            @Nullable
            public TextHitInfo getLocationOffset(int x, int y) {
                if (this.$input.getValue().getComposition-MzsxiRA() != null) {
                    return TextHitInfo.leading(0);
                }
                return null;
            }

            @Nullable
            public AttributedCharacterIterator cancelLatestCommittedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
                return null;
            }

            public int getInsertPositionOffset() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                int composedStartIndex = textRange != null ? TextRange.getStart-impl((long)textRange.unbox-impl()) : 0;
                TextRange textRange2 = this.$input.getValue().getComposition-MzsxiRA();
                int composedEndIndex = textRange2 != null ? TextRange.getEnd-impl((long)textRange2.unbox-impl()) : 0;
                int caretIndex = TextRange.getStart-impl((long)this.$input.getValue().getSelection-d9O1mEE());
                if (caretIndex < composedStartIndex) {
                    return caretIndex;
                }
                if (caretIndex < composedEndIndex) {
                    return composedStartIndex;
                }
                return caretIndex - (composedEndIndex - composedStartIndex);
            }

            public int getCommittedTextLength() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                return this.$input.getValue().getText().length() - (textRange != null ? TextRange.getLength-impl((long)textRange.unbox-impl()) : 0);
            }

            @NotNull
            public AttributedCharacterIterator getSelectedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
                if (this.this$0.getCharKeyPressed()) {
                    this.this$0.setNeedToDeletePreviousChar(true);
                }
                String str = TextRangeKt.substring-FDrldGo((CharSequence)this.$input.getValue().getText(), (long)this.$input.getValue().getSelection-d9O1mEE());
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString(str).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"AttributedString(str).iterator");
                return attributedCharacterIterator;
            }

            @Nullable
            public Rectangle getTextLocation(@NotNull TextHitInfo offset) {
                Rectangle rectangle;
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                Rect rect = this.$input.getFocusedRect();
                if (rect != null) {
                    Rect rect2 = rect;
                    PlatformInput platformInput = this.this$0;
                    Rect it = rect2;
                    boolean bl = false;
                    int x = (int)(it.getRight() / PlatformInput.access$getComponent$p(platformInput).getDensity().getDensity()) + PlatformInput.access$getComponent$p((PlatformInput)platformInput).getLocationOnScreen().x;
                    int y = (int)(it.getTop() / PlatformInput.access$getComponent$p(platformInput).getDensity().getDensity()) + PlatformInput.access$getComponent$p((PlatformInput)platformInput).getLocationOnScreen().y;
                    rectangle = new Rectangle(x, y, (int)it.getWidth(), (int)it.getHeight());
                } else {
                    rectangle = null;
                }
                return rectangle;
            }

            @NotNull
            public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, @Nullable AttributedCharacterIterator.Attribute[] attributes) {
                TextRange comp = this.$input.getValue().getComposition-MzsxiRA();
                String text = this.$input.getValue().getText();
                long range = TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)beginIndex, (int)text.length()), (int)RangesKt.coerceAtMost((int)endIndex, (int)text.length()));
                if (comp == null) {
                    String res = TextRangeKt.substring-FDrldGo((CharSequence)text, (long)range);
                    AttributedCharacterIterator attributedCharacterIterator = new AttributedString(res).getIterator();
                    Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"AttributedString(res).iterator");
                    return attributedCharacterIterator;
                }
                String committed = TextRangeKt.substring-FDrldGo((CharSequence)text, (long)TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl((long)range), TextRange.getMin-impl((long)comp.unbox-impl())), (int)text.length()), (int)RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl((long)range), TextRange.getMax-impl((long)comp.unbox-impl())), (int)text.length())));
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"AttributedString(committed).iterator");
                return attributedCharacterIterator;
            }
        };
    }

    public static final /* synthetic */ PlatformComponent access$getComponent$p(PlatformInput $this) {
        return $this.component;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001BR\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u0018\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003\u00f8\u0001\u0000J\u0019\u0010 \u001a\u00020\nH\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\u0014J\u000b\u0010\"\u001a\u0004\u0018\u00010\rH\u00c6\u0003Jh\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00052\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u000b\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006-"}, d2={"Landroidx/compose/ui/platform/PlatformInput$CurrentInput;", "", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "imeAction", "focusedRect", "Landroidx/compose/ui/geometry/Rect;", "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ILandroidx/compose/ui/geometry/Rect;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getFocusedRect", "()Landroidx/compose/ui/geometry/Rect;", "setFocusedRect", "(Landroidx/compose/ui/geometry/Rect;)V", "getImeAction-eUduSuo", "()I", "I", "getOnEditCommand", "()Lkotlin/jvm/functions/Function1;", "getOnImeActionPerformed", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "component1", "component2", "component3", "component4", "component4-eUduSuo", "component5", "copy", "copy-tNiH39Q", "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ILandroidx/compose/ui/geometry/Rect;)Landroidx/compose/ui/platform/PlatformInput$CurrentInput;", "equals", "", "other", "hashCode", "", "toString", "", "ui"})
    @StabilityInferred(parameters=0)
    public static final class CurrentInput {
        @NotNull
        private TextFieldValue value;
        @NotNull
        private final Function1<List<? extends EditCommand>, Unit> onEditCommand;
        @NotNull
        private final Function1<ImeAction, Unit> onImeActionPerformed;
        private final int imeAction;
        @Nullable
        private Rect focusedRect;
        public static final int $stable = 8;

        private CurrentInput(TextFieldValue value, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed, int imeAction, Rect focusedRect) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            this.value = value;
            this.onEditCommand = onEditCommand;
            this.onImeActionPerformed = onImeActionPerformed;
            this.imeAction = imeAction;
            this.focusedRect = focusedRect;
        }

        public /* synthetic */ CurrentInput(TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n, Rect rect, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                rect = null;
            }
            this(textFieldValue, function1, function12, n, rect, null);
        }

        @NotNull
        public final TextFieldValue getValue() {
            return this.value;
        }

        public final void setValue(@NotNull TextFieldValue textFieldValue) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
            this.value = textFieldValue;
        }

        @NotNull
        public final Function1<List<? extends EditCommand>, Unit> getOnEditCommand() {
            return this.onEditCommand;
        }

        @NotNull
        public final Function1<ImeAction, Unit> getOnImeActionPerformed() {
            return this.onImeActionPerformed;
        }

        public final int getImeAction-eUduSuo() {
            return this.imeAction;
        }

        @Nullable
        public final Rect getFocusedRect() {
            return this.focusedRect;
        }

        public final void setFocusedRect(@Nullable Rect rect) {
            this.focusedRect = rect;
        }

        @NotNull
        public final TextFieldValue component1() {
            return this.value;
        }

        @NotNull
        public final Function1<List<? extends EditCommand>, Unit> component2() {
            return this.onEditCommand;
        }

        @NotNull
        public final Function1<ImeAction, Unit> component3() {
            return this.onImeActionPerformed;
        }

        public final int component4-eUduSuo() {
            return this.imeAction;
        }

        @Nullable
        public final Rect component5() {
            return this.focusedRect;
        }

        @NotNull
        public final CurrentInput copy-tNiH39Q(@NotNull TextFieldValue value, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed, int imeAction, @Nullable Rect focusedRect) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            return new CurrentInput(value, onEditCommand, onImeActionPerformed, imeAction, focusedRect, null);
        }

        public static /* synthetic */ CurrentInput copy-tNiH39Q$default(CurrentInput currentInput, TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n, Rect rect, int n2, Object object) {
            if ((n2 & 1) != 0) {
                textFieldValue = currentInput.value;
            }
            if ((n2 & 2) != 0) {
                function1 = currentInput.onEditCommand;
            }
            if ((n2 & 4) != 0) {
                function12 = currentInput.onImeActionPerformed;
            }
            if ((n2 & 8) != 0) {
                n = currentInput.imeAction;
            }
            if ((n2 & 0x10) != 0) {
                rect = currentInput.focusedRect;
            }
            return currentInput.copy-tNiH39Q(textFieldValue, function1, function12, n, rect);
        }

        @NotNull
        public String toString() {
            return "CurrentInput(value=" + this.value + ", onEditCommand=" + this.onEditCommand + ", onImeActionPerformed=" + this.onImeActionPerformed + ", imeAction=" + ImeAction.toString-impl((int)this.imeAction) + ", focusedRect=" + this.focusedRect + ')';
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.onEditCommand.hashCode();
            result2 = result2 * 31 + this.onImeActionPerformed.hashCode();
            result2 = result2 * 31 + ImeAction.hashCode-impl((int)this.imeAction);
            result2 = result2 * 31 + (this.focusedRect == null ? 0 : this.focusedRect.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CurrentInput)) {
                return false;
            }
            CurrentInput currentInput = (CurrentInput)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)currentInput.value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onEditCommand, currentInput.onEditCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onImeActionPerformed, currentInput.onImeActionPerformed)) {
                return false;
            }
            if (!ImeAction.equals-impl0((int)this.imeAction, (int)currentInput.imeAction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.focusedRect, (Object)currentInput.focusedRect);
        }

        public /* synthetic */ CurrentInput(TextFieldValue value, Function1 onEditCommand, Function1 onImeActionPerformed, int imeAction, Rect focusedRect, DefaultConstructorMarker $constructor_marker) {
            this(value, (Function1<? super List<? extends EditCommand>, Unit>)onEditCommand, (Function1<? super ImeAction, Unit>)onImeActionPerformed, imeAction, focusedRect);
        }
    }
}

