/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.report.formatter;

import com.ustadmobile.core.domain.report.formatter.GraphFormatter;
import com.ustadmobile.core.domain.report.model.ReportXAxis;
import com.ustadmobile.core.domain.report.utils.ReportFormatter_commonJvmKt;
import com.ustadmobile.core.impl.locale.StringUiText;
import com.ustadmobile.core.impl.locale.UiText;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/core/domain/report/formatter/DateGraphFormatter;", "Lcom/ustadmobile/core/domain/report/formatter/GraphFormatter;", "", "xAxisType", "Lcom/ustadmobile/core/domain/report/model/ReportXAxis;", "(Lcom/ustadmobile/core/domain/report/model/ReportXAxis;)V", "adjust", "value", "format", "Lcom/ustadmobile/core/impl/locale/UiText;", "core"})
public final class DateGraphFormatter
implements GraphFormatter<String> {
    @NotNull
    private final ReportXAxis xAxisType;

    public DateGraphFormatter(@NotNull ReportXAxis xAxisType) {
        Intrinsics.checkNotNullParameter((Object)xAxisType, (String)"xAxisType");
        this.xAxisType = xAxisType;
    }

    @Override
    @NotNull
    public String adjust(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value;
    }

    @Override
    @NotNull
    public UiText format(@NotNull String value) {
        UiText uiText;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            uiText = switch (WhenMappings.$EnumSwitchMapping$0[this.xAxisType.ordinal()]) {
                case 1 -> {
                    LocalDate date = LocalDateKt.toLocalDate((String)value);
                    String monthName = ReportFormatter_commonJvmKt.getMonthDisplayName(date.getMonthNumber());
                    yield new StringUiText(monthName + " - " + date.getYear());
                }
                case 2 -> new StringUiText(String.valueOf(LocalDateKt.toLocalDate((String)value).getYear()));
                default -> new StringUiText(value);
            };
        }
        catch (Exception e) {
            uiText = new StringUiText(value);
        }
        return uiText;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportXAxis.values().length];
            try {
                nArray[ReportXAxis.MONTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.YEAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

