/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.report.formatter;

import com.ustadmobile.core.domain.report.formatter.GraphFormatter;
import com.ustadmobile.core.domain.report.query.RunReportUseCase;
import com.ustadmobile.core.impl.locale.StringUiText;
import com.ustadmobile.core.impl.locale.UiText;
import com.ustadmobile.lib.db.composites.StatementReportRow;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/ustadmobile/core/domain/report/formatter/DurationGraphFormatter;", "Lcom/ustadmobile/core/domain/report/formatter/GraphFormatter;", "", "result", "Lcom/ustadmobile/core/domain/report/query/RunReportUseCase$RunReportResult;", "(Lcom/ustadmobile/core/domain/report/query/RunReportUseCase$RunReportResult;)V", "unit", "Lkotlin/time/DurationUnit;", "getUnit", "()Lkotlin/time/DurationUnit;", "unit$delegate", "Lkotlin/Lazy;", "adjust", "value", "(D)Ljava/lang/Double;", "format", "Lcom/ustadmobile/core/impl/locale/UiText;", "core"})
public final class DurationGraphFormatter
implements GraphFormatter<Double> {
    @NotNull
    private final RunReportUseCase.RunReportResult result;
    @NotNull
    private final Lazy unit$delegate;

    public DurationGraphFormatter(@NotNull RunReportUseCase.RunReportResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.result = result;
        this.unit$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DurationUnit>(this){
            final /* synthetic */ DurationGraphFormatter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DurationUnit invoke() {
                Double d;
                Iterator<T> iterator = ((Iterable)DurationGraphFormatter.access$getResult$p(this.this$0).getResults()).iterator();
                if (!iterator.hasNext()) {
                    d = null;
                } else {
                    double d2;
                    Double d3;
                    List list = (List)iterator.next();
                    boolean bl = false;
                    Iterator<T> iterator2 = ((Iterable)list).iterator();
                    if (!iterator2.hasNext()) {
                        d3 = null;
                    } else {
                        StatementReportRow it = (StatementReportRow)iterator2.next();
                        boolean bl2 = false;
                        double d4 = it.getYAxis();
                        while (iterator2.hasNext()) {
                            StatementReportRow it2 = (StatementReportRow)iterator2.next();
                            $i$a$-maxOfOrNull-DurationGraphFormatter$unit$2$maxVal$1$1 = false;
                            double d5 = it2.getYAxis();
                            d4 = Math.max(d4, d5);
                        }
                        d3 = d4;
                    }
                    double d6 = d2 = d3 != null ? d3 : 0.0;
                    while (iterator.hasNext()) {
                        Double d7;
                        List list2 = (List)iterator.next();
                        $i$a$-maxOfOrNull-DurationGraphFormatter$unit$2$maxVal$1 = false;
                        Iterator<T> iterator3 = ((Iterable)list2).iterator();
                        if (!iterator3.hasNext()) {
                            d7 = null;
                        } else {
                            StatementReportRow it = (StatementReportRow)iterator3.next();
                            boolean bl3 = false;
                            double d8 = it.getYAxis();
                            while (iterator3.hasNext()) {
                                StatementReportRow it3 = (StatementReportRow)iterator3.next();
                                $i$a$-maxOfOrNull-DurationGraphFormatter$unit$2$maxVal$1$1 = false;
                                double d9 = it3.getYAxis();
                                d8 = Math.max(d8, d9);
                            }
                            d7 = d8;
                        }
                        double d10 = d7 != null ? d7 : 0.0;
                        d2 = Math.max(d2, d10);
                    }
                    d = d2;
                }
                double maxVal = d != null ? d : 0.0;
                return maxVal > 3600000.0 ? DurationUnit.HOURS : DurationUnit.MINUTES;
            }
        }));
    }

    private final DurationUnit getUnit() {
        Lazy lazy = this.unit$delegate;
        return (DurationUnit)lazy.getValue();
    }

    @Override
    @NotNull
    public Double adjust(double value) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getUnit().ordinal()]) {
            case 1 -> value / (double)60000;
            case 2 -> value / (double)3600000;
            default -> throw new IllegalStateException();
        };
    }

    @Override
    @NotNull
    public UiText format(double value) {
        double roundedValue = (double)MathKt.roundToInt((double)(value * (double)100)) / 100.0;
        return new StringUiText(String.valueOf(roundedValue));
    }

    public static final /* synthetic */ RunReportUseCase.RunReportResult access$getResult$p(DurationGraphFormatter $this) {
        return $this.result;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DurationUnit.values().length];
            try {
                nArray[DurationUnit.MINUTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.HOURS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

