/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.report.query;

import com.ustadmobile.core.domain.report.model.ReportOptions2;
import com.ustadmobile.core.domain.report.model.ReportSeries2;
import com.ustadmobile.core.domain.report.model.ReportSeriesYAxis;
import com.ustadmobile.core.domain.report.model.ReportXAxis;
import com.ustadmobile.core.domain.report.query.RunReportUseCase;
import com.ustadmobile.door.util.SystemTimeKt;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/core/domain/report/query/GenerateReportQueriesUseCase;", "", "()V", "invoke", "", "Lcom/ustadmobile/core/domain/report/query/GenerateReportQueriesUseCase$ReportQueryParts2;", "request", "Lcom/ustadmobile/core/domain/report/query/RunReportUseCase$RunReportRequest;", "dbType", "", "xAxisOrSubgroupExpression", "", "field", "Lcom/ustadmobile/core/domain/report/model/ReportXAxis;", "ReportQueryParts2", "core"})
@SourceDebugExtension(value={"SMAP\nGenerateReportQueriesUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateReportQueriesUseCase.kt\ncom/ustadmobile/core/domain/report/query/GenerateReportQueriesUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,353:1\n1549#2:354\n1620#2,2:355\n1549#2:357\n1620#2,3:358\n1747#2,3:361\n1622#2:366\n37#3,2:364\n*S KotlinDebug\n*F\n+ 1 GenerateReportQueriesUseCase.kt\ncom/ustadmobile/core/domain/report/query/GenerateReportQueriesUseCase\n*L\n194#1:354\n194#1:355,2\n240#1:357\n240#1:358,3\n249#1:361,3\n194#1:366\n350#1:364,2\n*E\n"})
public final class GenerateReportQueriesUseCase {
    private final String xAxisOrSubgroupExpression(ReportXAxis field, int dbType, RunReportUseCase.RunReportRequest request2) {
        StringBuilder stringBuilder;
        ReportOptions2 reportOptions = request2.getReportOptions();
        TimeZone timeZone = request2.getTimeZone();
        int offsetMillis = TimeZoneKt.offsetAt((TimeZone)timeZone, (Instant)reportOptions.getPeriod().periodStartInstant(timeZone)).getTotalSeconds() * 1000;
        String timeFieldName = "(ResultSource.timestamp + " + offsetMillis + ")";
        StringBuilder $this$xAxisOrSubgroupExpression_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[field.ordinal()]) {
            case 1: {
                switch (dbType) {
                    case 1: {
                        $this$xAxisOrSubgroupExpression_u24lambda_u240.append("strftime('%Y-%m-%d', " + timeFieldName + "/1000, 'unixepoch')");
                        break block0;
                    }
                    case 2: {
                        $this$xAxisOrSubgroupExpression_u24lambda_u240.append("TO_CHAR(TO_TIMESTAMP(" + timeFieldName + "/1000), 'YYYY-MM-DD')");
                    }
                }
                break;
            }
            case 2: {
                switch (dbType) {
                    case 1: {
                        $this$xAxisOrSubgroupExpression_u24lambda_u240.append(StringsKt.trimIndent((String)("\n                              (CASE strftime('%w', " + timeFieldName + "/1000, 'unixepoch')\n                                    WHEN (SELECT StartOfWeekCte.TimeRangeStartDayOfWeek\n                                           FROM StartOfWeekCte)\n                                \tTHEN strftime('%Y-%m-%d', " + timeFieldName + "/1000, 'unixepoch')\n                                \n                                \tELSE strftime('%Y-%m-%d', " + timeFieldName + "/1000, \n                                                  'unixepoch', \n                                                  'weekday ' || \n                                                  (SELECT StartOfWeekCte.TimeRangeStartDayOfWeek\n                                                     FROM StartOfWeekCte), \n                                                  '-7 day')\n                                 END)\n                            ")));
                        break block0;
                    }
                    case 2: {
                        DayOfWeek periodStartDayOfWeek = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(reportOptions.getPeriod().periodStartMillis(timeZone)), (TimeZone)timeZone).getDayOfWeek();
                        int deltaDays = periodStartDayOfWeek.ordinal() - DayOfWeek.MONDAY.ordinal();
                        $this$xAxisOrSubgroupExpression_u24lambda_u240.append("TO_CHAR(DATE_TRUNC('week', TO_TIMESTAMP(" + timeFieldName + "/1000) - INTERVAL '" + deltaDays + " days') + INTERVAL '" + deltaDays + " days', 'YYYY-MM-DD')");
                    }
                }
                break;
            }
            case 3: {
                switch (dbType) {
                    case 1: {
                        $this$xAxisOrSubgroupExpression_u24lambda_u240.append("strftime('%Y-%m-%d', " + timeFieldName + "/1000, 'unixepoch', 'start of month') ");
                        break block0;
                    }
                    case 2: {
                        $this$xAxisOrSubgroupExpression_u24lambda_u240.append("TO_CHAR(DATE_TRUNC('month', TO_TIMESTAMP(" + timeFieldName + "/1000)), 'YYYY-MM-DD') ");
                    }
                }
                break;
            }
            case 4: {
                switch (dbType) {
                    case 1: {
                        $this$xAxisOrSubgroupExpression_u24lambda_u240.append("strftime('%Y-%m-%d', " + timeFieldName + "/1000, 'unixepoch', 'start of year') ");
                        break block0;
                    }
                    case 2: {
                        $this$xAxisOrSubgroupExpression_u24lambda_u240.append("TO_CHAR(DATE_TRUNC('year', TO_TIMESTAMP(" + timeFieldName + "/1000)), 'YYYY-MM-DD') ");
                    }
                }
                break;
            }
            case 5: {
                $this$xAxisOrSubgroupExpression_u24lambda_u240.append("ResultSource.statementClazzUid");
                break;
            }
            case 6: {
                $this$xAxisOrSubgroupExpression_u24lambda_u240.append("COALESCE(Person.gender, 0)");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ReportQueryParts2> invoke(@NotNull RunReportUseCase.RunReportRequest request2, int dbType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        ReportOptions2 reportOptions = request2.getReportOptions();
        ReportXAxis reportXAxis = reportOptions.getXAxis();
        if (reportXAxis == null) {
            throw new IllegalArgumentException("null x axis");
        }
        ReportXAxis xAxis = reportXAxis;
        long reportFromMs = reportOptions.getPeriod().periodStartMillis(request2.getTimeZone());
        long reportToMs = reportOptions.getPeriod().periodEndMillis(request2.getTimeZone());
        long timenow = SystemTimeKt.systemTimeInMillis();
        Iterable $this$map$iv = reportOptions.getSeries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object[] $this$any$iv;
            List paramsList;
            Object sql;
            void series;
            Collection collection;
            block28: {
                block27: {
                    ReportSeriesYAxis yAxis;
                    block25: {
                        block26: {
                            boolean bl;
                            block24: {
                                Iterator $this$mapTo$iv$iv2;
                                void $this$map$iv2;
                                ReportSeries2 reportSeries2 = (ReportSeries2)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl2 = false;
                                yAxis = series.getReportSeriesYAxis();
                                sql = null;
                                sql = "";
                                paramsList = new ArrayList();
                                sql = sql + "INSERT INTO ReportQueryResult(rqrReportUid, rqrLastModified,\nrqrReportSeriesUid, rqrLastValidated, rqrXAxis, rqrYAxis,\nrqrSubgroup, rqrTimeZone)\n\nWITH AllLearningRecordsPermission(hasPermission) AS (\n     SELECT EXISTS(\n            SELECT 1\n              FROM SystemPermission\n             WHERE SystemPermission.spToPersonUid = ?\n               AND (SystemPermission.spPermissionsFlag & 128))\n            AS hasPermission   \n),\n\nClazzesWithPermission(clazzUid) AS(\n     SELECT Clazz.clazzUid AS clazzUid\n       FROM Clazz\n      WHERE NOT (SELECT hasPermission FROM AllLearningRecordsPermission)\n        AND Clazz.clazzOwnerPersonUid = ?\n      UNION\n      SELECT CoursePermission.cpClazzUid AS clazzUid\n        FROM CoursePermission\n       WHERE NOT (SELECT hasPermission FROM AllLearningRecordsPermission)\n         AND (    CoursePermission.cpToPersonUid = ?\n              OR ((CoursePermission.cpToEnrolmentRole, CoursePermission.cpClazzUid) IN\n                  (SELECT ClazzEnrolment.clazzEnrolmentRole,\n                          ClazzEnrolment.clazzEnrolmentClazzUid\n                     FROM ClazzEnrolment      \n                    WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?)))\n         AND (CoursePermission.cpPermissionsFlag & 128) > 0         \n)";
                                Iterable iterable2 = (Iterable)RangesKt.until((int)0, (int)4);
                                List list = paramsList;
                                boolean $i$f$map2 = false;
                                void var26_25 = $this$map$iv2;
                                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                boolean $i$f$mapTo2 = false;
                                Iterator iterator = $this$mapTo$iv$iv2.iterator();
                                while (iterator.hasNext()) {
                                    int item$iv$iv2;
                                    int n = item$iv$iv2 = ((IntIterator)iterator).nextInt();
                                    Collection collection2 = destination$iv$iv2;
                                    boolean bl3 = false;
                                    collection2.add(request2.getAccountPersonUid());
                                }
                                list.addAll((List)destination$iv$iv2);
                                if (dbType != 1) break block25;
                                if (xAxis == ReportXAxis.WEEK) break block26;
                                $this$any$iv = (Object[])reportOptions.getSeries();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    $this$mapTo$iv$iv2 = $this$any$iv.iterator();
                                    while ($this$mapTo$iv$iv2.hasNext()) {
                                        Object element$iv = $this$mapTo$iv$iv2.next();
                                        ReportSeries2 it = (ReportSeries2)element$iv;
                                        boolean bl4 = false;
                                        if (!(it.getReportSeriesSubGroup() == ReportXAxis.WEEK)) continue;
                                        bl = true;
                                        break block24;
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) break block25;
                        }
                        sql = sql + ",StartOfWeekCte(TimeRangeStartDayOfWeek) AS (\nSELECT strftime('%w', ?, 'unixepoch') AS TimeRangeStartDayOfWeek\n)\n";
                        paramsList.add(reportFromMs / (long)1000);
                    }
                    sql = sql + ",ResultSourceCte AS (\n ";
                    sql = sql + "SELECT ";
                    switch (WhenMappings.$EnumSwitchMapping$1[yAxis.ordinal()]) {
                        case -1: {
                            throw new IllegalArgumentException((ReportSeries2)series + " y axis is null");
                        }
                        case 1: {
                            sql = sql + "SUM(ResultSource.resultDuration)";
                            break;
                        }
                        case 2: {
                            sql = sql + "SUM(ResultSource.resultDuration) /COUNT(DISTINCT ResultSource.contextRegistrationHash)";
                            break;
                        }
                        case 3: {
                            sql = sql + "COUNT(DISTINCT ResultSource.contextRegistrationHash)";
                            break;
                        }
                        case 4: {
                            sql = sql + "COUNT(*)";
                            break;
                        }
                        case 5: {
                            sql = sql + "COUNT(DISTINCT ResultSource.statementActorPersonUid)";
                            break;
                        }
                        case 6: {
                            sql = sql + "SUM(ResultSource.resultDuration) / COUNT(DISTINCT ResultSource.statementActorPersonUid)";
                        }
                    }
                    sql = sql + " AS yAxis,\n";
                    sql = sql + this.xAxisOrSubgroupExpression(xAxis, dbType, request2) + " AS xAxis,\n";
                    ReportXAxis reportXAxis2 = series.getReportSeriesSubGroup();
                    sql = (reportXAxis2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[reportXAxis2.ordinal()]) == -1 ? sql + "'' AS subgroup\n" : sql + this.xAxisOrSubgroupExpression(series.getReportSeriesSubGroup(), dbType, request2) + " AS subgroup\n";
                    sql = sql + "FROM StatementEntity ResultSource\n";
                    if (reportOptions.getXAxis().getPersonJoinRequired()) break block27;
                    ReportXAxis reportXAxis3 = series.getReportSeriesSubGroup();
                    boolean bl = reportXAxis3 != null ? reportXAxis3.getPersonJoinRequired() : false;
                    if (!bl) break block28;
                }
                sql = sql + "LEFT JOIN Person\nON Person.personUid = ResultSource.statementActorPersonUid\n";
            }
            sql = sql + "WHERE ResultSource.timestamp BETWEEN ? AND ?\n";
            paramsList.add(reportFromMs);
            paramsList.add(reportToMs);
            sql = sql + "AND (     (SELECT AllLearningRecordsPermission.hasPermission\n             FROM AllLearningRecordsPermission)\n       OR ResultSource.statementActorPersonUid = ? \n       OR ResultSource.statementClazzUid IN \n          (SELECT ClazzesWithPermission.clazzUid\n             FROM ClazzesWithPermission)\n    )         ";
            paramsList.add(request2.getAccountPersonUid());
            sql = sql + " GROUP BY xAxis";
            if (series.getReportSeriesSubGroup() != null) {
                ReportXAxis $i$f$any;
                ReportXAxis it = $i$f$any;
                boolean bl = false;
                sql = sql + ", subgroup";
            }
            sql = sql + "\n)\n";
            sql = sql + "SELECT ? AS rqrReportUid,\n       ? AS rqrLastModified,\n       ? AS rqrReportSeriesUid,\n       ? AS rqrLastValidated,\n       ResultSourceCte.xAxis AS rqrXAxis,\n       ResultSourceCte.yAxis AS rqrYAxis,\n       ResultSourceCte.subgroup AS rqrSubgroup,\n       ? AS rqrSubgroup\n  FROM ResultSourceCte  ";
            $this$any$iv = new Object[]{request2.getReportUid(), timenow, series.getReportSeriesUid(), timenow, request2.getTimeZone().getId()};
            paramsList.addAll(CollectionsKt.listOf((Object[])$this$any$iv));
            Collection $this$toTypedArray$iv = paramsList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            collection.add(new ReportQueryParts2((String)sql, thisCollection$iv.toArray(new Object[0]), timenow));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J2\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/core/domain/report/query/GenerateReportQueriesUseCase$ReportQueryParts2;", "", "sql", "", "params", "", "timestamp", "", "(Ljava/lang/String;[Ljava/lang/Object;J)V", "getParams", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getSql", "()Ljava/lang/String;", "getTimestamp", "()J", "component1", "component2", "component3", "copy", "(Ljava/lang/String;[Ljava/lang/Object;J)Lcom/ustadmobile/core/domain/report/query/GenerateReportQueriesUseCase$ReportQueryParts2;", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class ReportQueryParts2 {
        @NotNull
        private final String sql;
        @NotNull
        private final Object[] params;
        private final long timestamp;

        public ReportQueryParts2(@NotNull String sql, @NotNull Object[] params, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.sql = sql;
            this.params = params;
            this.timestamp = timestamp;
        }

        @NotNull
        public final String getSql() {
            return this.sql;
        }

        @NotNull
        public final Object[] getParams() {
            return this.params;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReportQueryParts2)) {
                return false;
            }
            if (this.timestamp != ((ReportQueryParts2)other).timestamp) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sql, (Object)((ReportQueryParts2)other).sql)) {
                return false;
            }
            return Arrays.equals(this.params, ((ReportQueryParts2)other).params);
        }

        public int hashCode() {
            int result = Long.hashCode(this.timestamp);
            result = 31 * result + this.sql.hashCode();
            result = 31 * result + Arrays.hashCode(this.params);
            return result;
        }

        @NotNull
        public final String component1() {
            return this.sql;
        }

        @NotNull
        public final Object[] component2() {
            return this.params;
        }

        public final long component3() {
            return this.timestamp;
        }

        @NotNull
        public final ReportQueryParts2 copy(@NotNull String sql, @NotNull Object[] params, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return new ReportQueryParts2(sql, params, timestamp);
        }

        public static /* synthetic */ ReportQueryParts2 copy$default(ReportQueryParts2 reportQueryParts2, String string, Object[] objectArray, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = reportQueryParts2.sql;
            }
            if ((n & 2) != 0) {
                objectArray = reportQueryParts2.params;
            }
            if ((n & 4) != 0) {
                l = reportQueryParts2.timestamp;
            }
            return reportQueryParts2.copy(string, objectArray, l);
        }

        @NotNull
        public String toString() {
            return "ReportQueryParts2(sql=" + this.sql + ", params=" + Arrays.toString(this.params) + ", timestamp=" + this.timestamp + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ReportXAxis.values().length];
            try {
                nArray[ReportXAxis.DAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.WEEK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.MONTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.YEAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.GENDER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReportSeriesYAxis.values().length];
            try {
                nArray[ReportSeriesYAxis.TOTAL_DURATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportSeriesYAxis.AVERAGE_DURATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportSeriesYAxis.NUMBER_SESSIONS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportSeriesYAxis.INTERACTIONS_RECORDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportSeriesYAxis.NUMBER_ACTIVE_USERS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportSeriesYAxis.AVERAGE_USAGE_TIME_PER_USER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

