/*
 * Decompiled with CFR 0.152.
 */
package nl.adaptivity.xmlutil.util;

import java.io.Closeable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.adaptivity.xmlutil.IterableNamespaceContext;
import nl.adaptivity.xmlutil.Namespace;
import nl.adaptivity.xmlutil.SimpleNamespaceContext;
import nl.adaptivity.xmlutil.XmlDeserializerFactory;
import nl.adaptivity.xmlutil.XmlException;
import nl.adaptivity.xmlutil.XmlReader;
import nl.adaptivity.xmlutil.XmlReaderUtil;
import nl.adaptivity.xmlutil.XmlWriter;
import nl.adaptivity.xmlutil.XmlWriterUtil;
import nl.adaptivity.xmlutil.util.CompactFragment;
import nl.adaptivity.xmlutil.util.ICompactFragment;
import nl.adaptivity.xmlutil.util.XMLFragmentStreamReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0002$%B\u001f\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000bB\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lnl/adaptivity/xmlutil/util/CompactFragment;", "Lnl/adaptivity/xmlutil/util/ICompactFragment;", "namespaces", "", "Lnl/adaptivity/xmlutil/Namespace;", "content", "", "(Ljava/lang/Iterable;[C)V", "", "(Ljava/lang/String;)V", "orig", "(Lnl/adaptivity/xmlutil/util/ICompactFragment;)V", "(Ljava/lang/Iterable;Ljava/lang/String;)V", "getContent", "()[C", "contentString", "getContentString", "()Ljava/lang/String;", "isEmpty", "", "()Z", "Lnl/adaptivity/xmlutil/IterableNamespaceContext;", "getNamespaces", "()Lnl/adaptivity/xmlutil/IterableNamespaceContext;", "equals", "other", "", "getXmlReader", "Lnl/adaptivity/xmlutil/XmlReader;", "hashCode", "", "serialize", "", "out", "Lnl/adaptivity/xmlutil/XmlWriter;", "toString", "Companion", "Factory", "xmlutil"})
public final class CompactFragment
implements ICompactFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IterableNamespaceContext namespaces;
    @NotNull
    private final transient char[] content;
    @NotNull
    private static final XmlDeserializerFactory<CompactFragment> FACTORY = new Factory();

    @Override
    public boolean isEmpty() {
        return this.getContent().length == 0;
    }

    @Override
    @NotNull
    public IterableNamespaceContext getNamespaces() {
        return this.namespaces;
    }

    @Override
    @NotNull
    public char[] getContent() {
        return this.content;
    }

    public CompactFragment(@NotNull Iterable<? extends Namespace> namespaces, @Nullable char[] content) {
        Intrinsics.checkNotNullParameter(namespaces, (String)"namespaces");
        this.namespaces = SimpleNamespaceContext.Companion.from(namespaces);
        char[] cArray = content;
        if (content == null) {
            cArray = new char[]{};
        }
        this.content = cArray;
    }

    public CompactFragment(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Iterable iterable = CollectionsKt.emptyList();
        char[] cArray = content.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        this((Iterable<? extends Namespace>)iterable, cArray);
    }

    public CompactFragment(@NotNull ICompactFragment orig) {
        Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
        this.namespaces = SimpleNamespaceContext.Companion.from(orig.getNamespaces());
        this.content = orig.getContent();
    }

    public CompactFragment(@NotNull Iterable<? extends Namespace> namespaces, @NotNull String content) {
        Intrinsics.checkNotNullParameter(namespaces, (String)"namespaces");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        char[] cArray = content.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        this(namespaces, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(@NotNull XmlWriter out) throws XmlException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Closeable closeable = XMLFragmentStreamReader.Companion.from(this);
        Throwable throwable = null;
        try {
            XMLFragmentStreamReader reader = (XMLFragmentStreamReader)closeable;
            boolean bl = false;
            XmlWriterUtil.serialize(out, reader);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public XmlReader getXmlReader() {
        return XMLFragmentStreamReader.Companion.from(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        ICompactFragment that = (ICompactFragment)other;
        if (!Intrinsics.areEqual((Object)this.getNamespaces(), (Object)that.getNamespaces())) {
            return false;
        }
        return Arrays.equals(this.getContent(), that.getContent());
    }

    public int hashCode() {
        int result = this.getNamespaces().hashCode();
        result = 31 * result + Arrays.hashCode(this.getContent());
        return result;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.getNamespaces(), null, (CharSequence)"{namespaces=[", (CharSequence)("], content=" + this.getContentString() + '}'), (int)0, null, (Function1)toString.1.INSTANCE, (int)25, null);
    }

    @Override
    @NotNull
    public String getContentString() {
        return new String(this.getContent());
    }

    @NotNull
    public static final XmlDeserializerFactory<CompactFragment> getFACTORY() {
        return Companion.getFACTORY();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lnl/adaptivity/xmlutil/util/CompactFragment$Companion;", "", "()V", "FACTORY", "Lnl/adaptivity/xmlutil/XmlDeserializerFactory;", "Lnl/adaptivity/xmlutil/util/CompactFragment;", "getFACTORY$annotations", "getFACTORY", "()Lnl/adaptivity/xmlutil/XmlDeserializerFactory;", "deserialize", "reader", "Lnl/adaptivity/xmlutil/XmlReader;", "xmlutil"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XmlDeserializerFactory<CompactFragment> getFACTORY() {
            return FACTORY;
        }

        @JvmStatic
        public static /* synthetic */ void getFACTORY$annotations() {
        }

        @NotNull
        public final CompactFragment deserialize(@NotNull XmlReader reader) throws XmlException {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return XmlReaderUtil.siblingsToFragment(reader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lnl/adaptivity/xmlutil/util/CompactFragment$Factory;", "Lnl/adaptivity/xmlutil/XmlDeserializerFactory;", "Lnl/adaptivity/xmlutil/util/CompactFragment;", "()V", "deserialize", "reader", "Lnl/adaptivity/xmlutil/XmlReader;", "xmlutil"})
    public static final class Factory
    implements XmlDeserializerFactory<CompactFragment> {
        @Override
        @NotNull
        public CompactFragment deserialize(@NotNull XmlReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return Companion.deserialize(reader);
        }
    }
}

