/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.cors;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.server.response.ApplicationSendPipeline;
import io.ktor.server.response.ResponseTypeKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001ab\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b0\u00062\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a>\u0010\u000e\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000b0\nH\u0000\u001a*\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00032\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000b0\nH\u0000\u001a \u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u001a$\u0010\u001d\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u001e\u001a\u00020\u001a*\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u001a\u0010 \u001a\u00020\u0001*\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0006H\u0000\u001a\u001a\u0010#\u001a\u00020\u0001*\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0006H\u0000\u001a\f\u0010$\u001a\u00020\u001a*\u00020\u001bH\u0000\u001a\u0015\u0010%\u001a\u00020\u001a*\u00020\u001bH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"corsCheckOrigins", "", "origin", "", "allowsAnyHost", "hostsNormalized", "", "hostsWithWildcard", "Lkotlin/Pair;", "originPredicates", "", "Lkotlin/Function1;", "numberRegex", "Lkotlin/text/Regex;", "corsCheckRequestHeaders", "requestHeaders", "allHeadersSet", "headerPredicates", "headerMatchesAPredicate", "header", "isSameOrigin", "point", "Lio/ktor/http/RequestConnectionPoint;", "isValidOrigin", "normalizeOrigin", "accessControlAllowCredentials", "", "Lio/ktor/server/application/ApplicationCall;", "allowCredentials", "accessControlAllowOrigin", "accessControlMaxAge", "maxAgeHeaderValue", "corsCheckCurrentMethod", "methods", "Lio/ktor/http/HttpMethod;", "corsCheckRequestMethod", "corsVary", "respondCorsFailed", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-server-cors"})
@SourceDebugExtension(value={"SMAP\nCORSUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CORSUtils.kt\nio/ktor/server/plugins/cors/CORSUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ApplicationResponseFunctions.kt\nio/ktor/server/response/ApplicationResponseFunctionsKt\n+ 5 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,131:1\n1747#2,3:132\n1747#2,3:135\n1726#2,3:138\n1747#2,3:141\n1#3:144\n26#4,2:145\n29#4,2:150\n17#5,3:147\n1064#6,2:152\n*S KotlinDebug\n*F\n+ 1 CORSUtils.kt\nio/ktor/server/plugins/cors/CORSUtilsKt\n*L\n53#1:132,3\n55#1:135,3\n62#1:138,3\n67#1:141,3\n77#1:145,2\n77#1:150,2\n77#1:147,3\n88#1:152,2\n*E\n"})
public final class CORSUtilsKt {
    public static final void accessControlAllowOrigin(@NotNull ApplicationCall $this$accessControlAllowOrigin, @NotNull String origin, boolean allowsAnyHost, boolean allowCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$accessControlAllowOrigin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        String headerOrigin = allowsAnyHost && !allowCredentials ? "*" : origin;
        ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$accessControlAllowOrigin.getResponse(), (String)HttpHeaders.INSTANCE.getAccessControlAllowOrigin(), (String)headerOrigin);
    }

    public static final void corsVary(@NotNull ApplicationCall $this$corsVary) {
        Intrinsics.checkNotNullParameter((Object)$this$corsVary, (String)"<this>");
        String vary = $this$corsVary.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getVary());
        String varyValue = vary == null ? HttpHeaders.INSTANCE.getOrigin() : vary + ", " + HttpHeaders.INSTANCE.getOrigin();
        ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$corsVary.getResponse(), (String)HttpHeaders.INSTANCE.getVary(), (String)varyValue);
    }

    public static final void accessControlAllowCredentials(@NotNull ApplicationCall $this$accessControlAllowCredentials, boolean allowCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$accessControlAllowCredentials, (String)"<this>");
        if (allowCredentials) {
            ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$accessControlAllowCredentials.getResponse(), (String)HttpHeaders.INSTANCE.getAccessControlAllowCredentials(), (String)"true");
        }
    }

    public static final void accessControlMaxAge(@NotNull ApplicationCall $this$accessControlMaxAge, @Nullable String maxAgeHeaderValue) {
        Intrinsics.checkNotNullParameter((Object)$this$accessControlMaxAge, (String)"<this>");
        if (maxAgeHeaderValue != null) {
            ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$accessControlMaxAge.getResponse(), (String)HttpHeaders.INSTANCE.getAccessControlMaxAge(), (String)maxAgeHeaderValue);
        }
    }

    public static final boolean isSameOrigin(@NotNull String origin, @NotNull RequestConnectionPoint point, @NotNull Regex numberRegex) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)numberRegex, (String)"numberRegex");
        String requestOrigin = point.getScheme() + "://" + point.getServerHost() + ':' + point.getServerPort();
        return Intrinsics.areEqual((Object)CORSUtilsKt.normalizeOrigin(requestOrigin, numberRegex), (Object)CORSUtilsKt.normalizeOrigin(origin, numberRegex));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean corsCheckOrigins(@NotNull String origin, boolean allowsAnyHost, @NotNull Set<String> hostsNormalized, @NotNull Set<Pair<String, String>> hostsWithWildcard, @NotNull List<? extends Function1<? super String, Boolean>> originPredicates, @NotNull Regex numberRegex) {
        Function1 it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(hostsNormalized, (String)"hostsNormalized");
        Intrinsics.checkNotNullParameter(hostsWithWildcard, (String)"hostsWithWildcard");
        Intrinsics.checkNotNullParameter(originPredicates, (String)"originPredicates");
        Intrinsics.checkNotNullParameter((Object)numberRegex, (String)"numberRegex");
        String normalizedOrigin = CORSUtilsKt.normalizeOrigin(origin, numberRegex);
        if (allowsAnyHost) return true;
        if (hostsNormalized.contains(normalizedOrigin)) return true;
        Iterable $this$any$iv = hostsWithWildcard;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                String prefix = (String)pair.component1();
                String suffix = (String)pair.component2();
                if (StringsKt.startsWith$default((String)normalizedOrigin, (String)prefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)normalizedOrigin, (String)suffix, (boolean)false, (int)2, null)) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = originPredicates;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (Function1)element$iv;
            boolean bl4 = false;
        } while (!((Boolean)it.invoke((Object)origin)).booleanValue());
        return true;
    }

    public static final boolean corsCheckRequestHeaders(@NotNull List<String> requestHeaders, @NotNull Set<String> allHeadersSet, @NotNull List<? extends Function1<? super String, Boolean>> headerPredicates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            Intrinsics.checkNotNullParameter(allHeadersSet, (String)"allHeadersSet");
            Intrinsics.checkNotNullParameter(headerPredicates, (String)"headerPredicates");
            Iterable $this$all$iv = requestHeaders;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String header = (String)element$iv;
                    boolean bl2 = false;
                    if (allHeadersSet.contains(header) || CORSUtilsKt.headerMatchesAPredicate(header, headerPredicates)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean headerMatchesAPredicate(@NotNull String header, @NotNull List<? extends Function1<? super String, Boolean>> headerPredicates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter(headerPredicates, (String)"headerPredicates");
            Iterable $this$any$iv = headerPredicates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)it.invoke((Object)header)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean corsCheckCurrentMethod(@NotNull ApplicationCall $this$corsCheckCurrentMethod, @NotNull Set<HttpMethod> methods) {
        Intrinsics.checkNotNullParameter((Object)$this$corsCheckCurrentMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        return methods.contains(ApplicationRequestPropertiesKt.getHttpMethod((ApplicationRequest)$this$corsCheckCurrentMethod.getRequest()));
    }

    public static final boolean corsCheckRequestMethod(@NotNull ApplicationCall $this$corsCheckRequestMethod, @NotNull Set<HttpMethod> methods) {
        HttpMethod httpMethod;
        Intrinsics.checkNotNullParameter((Object)$this$corsCheckRequestMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        String string = ApplicationRequestPropertiesKt.header((ApplicationRequest)$this$corsCheckRequestMethod.getRequest(), (String)HttpHeaders.INSTANCE.getAccessControlRequestMethod());
        if (string != null) {
            String it = string;
            boolean bl = false;
            httpMethod = new HttpMethod(it);
        } else {
            httpMethod = null;
        }
        HttpMethod requestMethod = httpMethod;
        return requestMethod != null && methods.contains(requestMethod);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object respondCorsFailed(@NotNull ApplicationCall $this$respondCorsFailed, @NotNull Continuation<? super Unit> $completion) {
        void $this$respond$iv;
        ApplicationCall applicationCall = $this$respondCorsFailed;
        HttpStatusCode message$iv = HttpStatusCode.Companion.getForbidden();
        boolean $i$f$respondWithType = false;
        if (!(message$iv instanceof OutgoingContent) && !(message$iv instanceof byte[])) {
            boolean $i$f$typeInfo = false;
            KType kType$iv$iv = Reflection.typeOf(HttpStatusCode.class);
            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
            ResponseTypeKt.setResponseType((ApplicationResponse)$this$respond$iv.getResponse(), (TypeInfo)TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(HttpStatusCode.class), (KType)kType$iv$iv));
        }
        ApplicationSendPipeline applicationSendPipeline = $this$respond$iv.getResponse().getPipeline();
        Intrinsics.checkNotNull((Object)message$iv, (String)"null cannot be cast to non-null type kotlin.Any");
        Object object = applicationSendPipeline.execute((Object)$this$respond$iv, (Object)message$iv, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidOrigin(@NotNull String origin) {
        int index;
        int n;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (((CharSequence)origin).length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (Intrinsics.areEqual((Object)origin, (Object)"null")) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)origin, (CharSequence)"%", (boolean)false, (int)2, null)) {
            return false;
        }
        int protoDelimiter = StringsKt.indexOf$default((CharSequence)origin, (String)"://", (int)0, (boolean)false, (int)6, null);
        if (protoDelimiter <= 0) {
            return false;
        }
        if (!Character.isLetter(origin.charAt(0))) return false;
        CharSequence $this$all$iv = origin.subSequence(0, protoDelimiter);
        boolean $i$f$all = false;
        for (n = 0; n < $this$all$iv.length(); ++n) {
            char element$iv;
            char ch = element$iv = $this$all$iv.charAt(n);
            boolean bl2 = false;
            if (!Character.isLetter(ch) && !Character.isDigit(ch) && ch != '-' && ch != '+') {
                if (ch != '.') return false;
            }
            boolean bl3 = true;
            if (bl3) continue;
            return false;
        }
        boolean bl4 = true;
        if (!bl4) return false;
        boolean bl5 = true;
        boolean protoValid = bl5;
        if (!protoValid) {
            return false;
        }
        int portIndex = origin.length();
        n = origin.length();
        for (index = protoDelimiter + 3; index < n; ++index) {
            char ch = origin.charAt(index);
            if (ch == ':' || ch == '/') {
                portIndex = index + 1;
                break;
            }
            if (ch != '?') continue;
            return false;
        }
        index = portIndex;
        n = origin.length();
        while (index < n) {
            if (!Character.isDigit(origin.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @NotNull
    public static final String normalizeOrigin(@NotNull String origin, @NotNull Regex numberRegex) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)numberRegex, (String)"numberRegex");
        if (Intrinsics.areEqual((Object)origin, (Object)"null") || Intrinsics.areEqual((Object)origin, (Object)"*")) {
            return origin;
        }
        StringBuilder builder = new StringBuilder(origin.length());
        builder.append(origin);
        if (!numberRegex.matches((CharSequence)StringsKt.substringAfterLast((String)origin, (String)":", (String)""))) {
            String port;
            String string = StringsKt.substringBefore$default((String)origin, (char)':', null, (int)2, null);
            String string2 = Intrinsics.areEqual((Object)string, (Object)"http") ? "80" : (port = Intrinsics.areEqual((Object)string, (Object)"https") ? "443" : null);
            if (port != null) {
                builder.append(':' + port);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }
}

