/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.door.paging;

import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import com.ustadmobile.door.DoorDatabaseRepository;
import com.ustadmobile.door.log.DoorLogLevel;
import com.ustadmobile.door.log.DoorLogger;
import com.ustadmobile.door.paging.DoorRepositoryPagingSource;
import com.ustadmobile.door.paging.PagingSourceWithHttpLoader;
import io.github.aakira.napier.Napier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u00020\u00040\u0005:\u0001,B|\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\"\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u000bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000`\f\u0012A\u0010\r\u001a=\b\u0001\u0012#\u0012!\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J3\u0010!\u001a\u0004\u0018\u00010\u00042\"\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000#j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000`$H\u0016\u00a2\u0006\u0002\u0010%JB\u0010&\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000'j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000`(2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010H\u0096@\u00a2\u0006\u0002\u0010)J&\u0010*\u001a\u00020\u00152\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010H\u0096@\u00a2\u0006\u0002\u0010)J\b\u0010+\u001a\u00020\u001dH\u0002R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u000bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000fj\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000RK\u0010\r\u001a=\b\u0001\u0012#\u0012!\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/ustadmobile/door/paging/DoorRepositoryReplicatePullPagingSource;", "Value", "", "Lcom/ustadmobile/door/paging/DoorRepositoryPagingSource;", "", "Lcom/ustadmobile/door/paging/PagingSourceWithHttpLoader;", "repo", "Lcom/ustadmobile/door/DoorDatabaseRepository;", "repoPath", "", "dbPagingSource", "Landroidx/paging/PagingSource;", "Lapp/cash/paging/PagingSource;", "onLoadHttp", "Lkotlin/Function2;", "Landroidx/paging/PagingSource$LoadParams;", "Lapp/cash/paging/PagingSourceLoadParams;", "Lkotlin/ParameterName;", "name", "params", "Lkotlin/coroutines/Continuation;", "", "(Lcom/ustadmobile/door/DoorDatabaseRepository;Ljava/lang/String;Landroidx/paging/PagingSource;Lkotlin/jvm/functions/Function2;)V", "dbInvalidateCallbackRegistered", "Lkotlinx/atomicfu/AtomicBoolean;", "invalidated", "lastLoadParams", "onDbInvalidatedCallback", "Lkotlin/Function0;", "", "Lkotlin/jvm/functions/Function2;", "getRepo$door_runtime", "()Lcom/ustadmobile/door/DoorDatabaseRepository;", "getRefreshKey", "state", "Landroidx/paging/PagingState;", "Lapp/cash/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Integer;", "load", "Landroidx/paging/PagingSource$LoadResult;", "Lapp/cash/paging/PagingSourceLoadResult;", "(Landroidx/paging/PagingSource$LoadParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadHttp", "onDbInvalidated", "Companion", "door-runtime"})
public final class DoorRepositoryReplicatePullPagingSource<Value>
extends DoorRepositoryPagingSource<Integer, Value>
implements PagingSourceWithHttpLoader<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoorDatabaseRepository repo;
    @NotNull
    private final String repoPath;
    @NotNull
    private final PagingSource<Integer, Value> dbPagingSource;
    @NotNull
    private final Function2<PagingSource.LoadParams<Integer>, Continuation<? super Boolean>, Object> onLoadHttp;
    @NotNull
    private final AtomicBoolean dbInvalidateCallbackRegistered;
    @NotNull
    private final AtomicBoolean invalidated;
    @Nullable
    private PagingSource.LoadParams<Integer> lastLoadParams;
    @NotNull
    private final Function0<Unit> onDbInvalidatedCallback;
    @NotNull
    public static final String PARAM_BATCHSIZE = "pagingBatchSize";
    @NotNull
    public static final String PARAM_KEY = "pagingKey";
    @NotNull
    public static final String PARAM_LOAD_PARAM_TYPE = "pagingLoadParamType";

    public DoorRepositoryReplicatePullPagingSource(@NotNull DoorDatabaseRepository repo, @NotNull String repoPath, @NotNull PagingSource<Integer, Value> dbPagingSource, @NotNull Function2<? super PagingSource.LoadParams<Integer>, ? super Continuation<? super Boolean>, ? extends Object> onLoadHttp) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
        Intrinsics.checkNotNullParameter(dbPagingSource, (String)"dbPagingSource");
        Intrinsics.checkNotNullParameter(onLoadHttp, (String)"onLoadHttp");
        this.repo = repo;
        this.repoPath = repoPath;
        this.dbPagingSource = dbPagingSource;
        this.onLoadHttp = onLoadHttp;
        this.dbInvalidateCallbackRegistered = AtomicFU.atomic((boolean)false);
        this.invalidated = AtomicFU.atomic((boolean)false);
        this.onDbInvalidatedCallback = (Function0)new Function0<Unit>(this){
            final /* synthetic */ DoorRepositoryReplicatePullPagingSource<Value> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DoorRepositoryReplicatePullPagingSource.access$onDbInvalidated(this.this$0);
            }
        };
    }

    @NotNull
    public final DoorDatabaseRepository getRepo$door_runtime() {
        return this.repo;
    }

    private final void onDbInvalidated() {
        Napier.v$default((Napier)Napier.INSTANCE, (String)"DoorRepositoryReplicatePullPagingSource: onDbInvalidated", null, null, (int)6, null);
        this.dbPagingSource.unregisterInvalidatedCallback(this.onDbInvalidatedCallback);
        if (!this.invalidated.getAndSet(true)) {
            Napier.v$default((Napier)Napier.INSTANCE, (String)"DoorRepositoryReplicatePullPagingSource: call invalidate", null, null, (int)6, null);
            this.invalidate();
        }
    }

    @Nullable
    public Integer getRefreshKey(@NotNull PagingState<Integer, Value> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Object object = this.dbPagingSource.getRefreshKey(state);
        Integer it = (Integer)object;
        boolean bl = false;
        DoorLogger.DefaultImpls.log$default(this.repo.getConfig().getLogger(), DoorLogLevel.VERBOSE, "DoorRepositoryReplicatePullPagingSource: getRefreshKey: " + it, null, 4, null);
        return (Integer)object;
    }

    @Nullable
    public Object load(@NotNull PagingSource.LoadParams<Integer> params, @NotNull Continuation<? super PagingSource.LoadResult<Integer, Value>> $completion) {
        Napier.v$default((Napier)Napier.INSTANCE, (String)("DoorRepositoryReplicatePullPagingSource: load key=" + params.getKey()), null, null, (int)6, null);
        this.lastLoadParams = params;
        if (!this.dbInvalidateCallbackRegistered.getAndSet(true)) {
            Napier.v$default((Napier)Napier.INSTANCE, (String)"DoorRepositoryReplicatePullPagingSource: register db invalidate callback", null, null, (int)6, null);
            this.dbPagingSource.registerInvalidatedCallback(this.onDbInvalidatedCallback);
        }
        return this.dbPagingSource.load(params, $completion);
    }

    @Override
    @Nullable
    public Object loadHttp(@NotNull PagingSource.LoadParams<Integer> params, @NotNull Continuation<? super Boolean> $completion) {
        return this.onLoadHttp.invoke(params, $completion);
    }

    public static final /* synthetic */ void access$onDbInvalidated(DoorRepositoryReplicatePullPagingSource $this) {
        $this.onDbInvalidated();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/door/paging/DoorRepositoryReplicatePullPagingSource$Companion;", "", "()V", "PARAM_BATCHSIZE", "", "PARAM_KEY", "PARAM_LOAD_PARAM_TYPE", "door-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

