/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.door.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J4\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/door/util/DoorSqlGenerator;", "", "()V", "generateSyncableEntityFunctionAndTriggerPostgres", "", "", "entityName", "tableId", "", "pkFieldName", "localCsnFieldName", "primaryCsnFieldName", "generateSyncableEntityInsertTriggersSqlite", "generateSyncableEntityUpdateTriggersSqlite", "door-runtime"})
public final class DoorSqlGenerator {
    @NotNull
    public static final DoorSqlGenerator INSTANCE = new DoorSqlGenerator();

    private DoorSqlGenerator() {
    }

    @NotNull
    public final List<String> generateSyncableEntityInsertTriggersSqlite(@NotNull String entityName, int tableId, @NotNull String pkFieldName, @NotNull String localCsnFieldName, @NotNull String primaryCsnFieldName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)pkFieldName, (String)"pkFieldName");
        Intrinsics.checkNotNullParameter((Object)localCsnFieldName, (String)"localCsnFieldName");
        Intrinsics.checkNotNullParameter((Object)primaryCsnFieldName, (String)"primaryCsnFieldName");
        String localCsnTrigger = "CREATE TRIGGER INS_LOC_" + tableId + "\n            AFTER INSERT ON " + entityName + "\n            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0) AND\n                NEW." + localCsnFieldName + " = 0)\n            BEGIN\n                UPDATE " + entityName + "\n                SET " + primaryCsnFieldName + " = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = " + tableId + ")\n                WHERE " + pkFieldName + " = NEW." + pkFieldName + ";\n                \n                UPDATE SqliteChangeSeqNums\n                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                WHERE sCsnTableId = " + tableId + ";\n            END";
        String primaryCsnTrigger = StringsKt.trimIndent((String)("\n            CREATE TRIGGER INS_PRI_" + tableId + "\n                           AFTER INSERT ON " + entityName + "\n                            \n         FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1) AND NEW." + primaryCsnFieldName + " = 0)\n                           BEGIN\n                                 UPDATE " + entityName + "\n                                    SET " + primaryCsnFieldName + " = (\n                                        SELECT sCsnNextPrimary \n                                          FROM SqliteChangeSeqNums \n                                         WHERE sCsnTableId = " + tableId + ")\n                                  WHERE " + pkFieldName + " = NEW." + pkFieldName + ";\n                            \n                                 UPDATE SqliteChangeSeqNums\n                                    SET sCsnNextPrimary = sCsnNextPrimary + 1\n                                  WHERE sCsnTableId = " + tableId + ";\n                            \n                                 INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                                 SELECT " + tableId + ", NEW." + pkFieldName + ", 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);    \n                           END      \n        "));
        Object[] objectArray = new String[]{localCsnTrigger, primaryCsnTrigger};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> generateSyncableEntityUpdateTriggersSqlite(@NotNull String entityName, int tableId, @NotNull String pkFieldName, @NotNull String localCsnFieldName, @NotNull String primaryCsnFieldName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)pkFieldName, (String)"pkFieldName");
        Intrinsics.checkNotNullParameter((Object)localCsnFieldName, (String)"localCsnFieldName");
        Intrinsics.checkNotNullParameter((Object)primaryCsnFieldName, (String)"primaryCsnFieldName");
        String localCsnTrigger = StringsKt.trimIndent((String)("\n            CREATE TRIGGER UPD_LOC_" + tableId + "\n            AFTER UPDATE ON " + entityName + "\n            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 0)\n                AND (NEW." + localCsnFieldName + " == OLD." + localCsnFieldName + " OR\n                    NEW." + localCsnFieldName + " == 0))\n            BEGIN\n                UPDATE " + entityName + "\n                SET " + localCsnFieldName + " = (SELECT sCsnNextLocal FROM SqliteChangeSeqNums WHERE sCsnTableId = " + tableId + ") \n                WHERE " + pkFieldName + " = NEW." + pkFieldName + ";\n                \n                UPDATE SqliteChangeSeqNums \n                SET sCsnNextLocal = sCsnNextLocal + 1\n                WHERE sCsnTableId = " + tableId + ";\n            END\n        "));
        String primaryCsnTrigger = StringsKt.trimIndent((String)("\n            CREATE TRIGGER UPD_PRI_" + tableId + "\n            AFTER UPDATE ON " + entityName + "\n            FOR EACH ROW WHEN (((SELECT CAST(master AS INTEGER) FROM SyncNode) = 1)\n                AND (NEW." + primaryCsnFieldName + " == OLD." + primaryCsnFieldName + " OR\n                    NEW." + primaryCsnFieldName + " == 0))\n            BEGIN\n                UPDATE " + entityName + "\n                SET " + primaryCsnFieldName + " = (SELECT sCsnNextPrimary FROM SqliteChangeSeqNums WHERE sCsnTableId = " + tableId + ")\n                WHERE " + pkFieldName + " = NEW." + pkFieldName + ";\n                \n                UPDATE SqliteChangeSeqNums\n                SET sCsnNextPrimary = sCsnNextPrimary + 1\n                WHERE sCsnTableId = " + tableId + ";\n                \n                INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                SELECT " + tableId + ", NEW." + pkFieldName + ", 0, (strftime('%s','now') * 1000) + ((strftime('%f','now') * 1000) % 1000);    \n\n            END            \n        "));
        Object[] objectArray = new String[]{localCsnTrigger, primaryCsnTrigger};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> generateSyncableEntityFunctionAndTriggerPostgres(@NotNull String entityName, int tableId, @NotNull String pkFieldName, @NotNull String localCsnFieldName, @NotNull String primaryCsnFieldName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)pkFieldName, (String)"pkFieldName");
        Intrinsics.checkNotNullParameter((Object)localCsnFieldName, (String)"localCsnFieldName");
        Intrinsics.checkNotNullParameter((Object)primaryCsnFieldName, (String)"primaryCsnFieldName");
        String functionSql = StringsKt.trimMargin$default((String)("CREATE OR REPLACE FUNCTION \n                    | inccsn_" + tableId + "_fn() RETURNS trigger AS $$\n                    | BEGIN  \n                    | UPDATE " + entityName + " SET " + localCsnFieldName + " =\n                    | (SELECT CASE WHEN (SELECT master FROM SyncNode) THEN NEW." + localCsnFieldName + " \n                    | ELSE NEXTVAL('" + entityName + "_lcsn_seq') END),\n                    | " + primaryCsnFieldName + " = \n                    | (SELECT CASE WHEN (SELECT master FROM SyncNode) \n                    | THEN NEXTVAL('" + entityName + "_mcsn_seq') \n                    | ELSE NEW." + primaryCsnFieldName + " END)\n                    | WHERE " + pkFieldName + " = NEW." + pkFieldName + ";\n                    | INSERT INTO ChangeLog(chTableId, chEntityPk, dispatched, chTime) \n                    | SELECT " + tableId + ", NEW." + pkFieldName + ", false, cast(extract(epoch from now()) * 1000 AS BIGINT)\n                    | WHERE COALESCE((SELECT master From SyncNode LIMIT 1), false);\n                    | RETURN null;\n                    | END $$\n                    | LANGUAGE plpgsql\n                "), null, (int)1, null);
        String triggerSql = StringsKt.trimIndent((String)("\n            CREATE TRIGGER inccsn_" + tableId + "_trig \n                   AFTER UPDATE OR INSERT ON " + entityName + "             \n                   FOR EACH ROW WHEN (pg_trigger_depth() = 0) \n                   EXECUTE PROCEDURE inccsn_" + tableId + "_fn()\n        "));
        Object[] objectArray = new String[]{functionSql, triggerSql};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

