/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.Handle;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionManager;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a!\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\f\u0010\u0014\u001a\u00020\u0010*\u00020\u0015H\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"calculateSelectionMagnifierCenterAndroid", "Landroidx/compose/ui/geometry/Offset;", "manager", "Landroidx/compose/foundation/text/selection/SelectionManager;", "magnifierSize", "Landroidx/compose/ui/unit/IntSize;", "calculateSelectionMagnifierCenterAndroid-O0kMr_c", "(Landroidx/compose/foundation/text/selection/SelectionManager;J)J", "getCurrentSelectedText", "Landroidx/compose/ui/text/AnnotatedString;", "selectable", "Landroidx/compose/foundation/text/selection/Selectable;", "selection", "Landroidx/compose/foundation/text/selection/Selection;", "containsInclusive", "", "Landroidx/compose/ui/geometry/Rect;", "offset", "containsInclusive-Uv8p0NA", "(Landroidx/compose/ui/geometry/Rect;J)Z", "visibleBounds", "Landroidx/compose/ui/layout/LayoutCoordinates;", "foundation"})
public final class SelectionManagerKt {
    public static final long calculateSelectionMagnifierCenterAndroid-O0kMr_c(@NotNull SelectionManager manager, long magnifierSize) {
        long l;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Selection selection = manager.getSelection();
        if (selection == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selection selection2 = selection;
        Handle handle = manager.getDraggingHandle();
        switch (handle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[handle.ordinal()]) {
            case -1: {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
            case 1: {
                l = SelectionManagerKt.calculateSelectionMagnifierCenterAndroid_O0kMr_c$getMagnifierCenter(manager, magnifierSize, selection2.getStart(), true);
                break;
            }
            case 2: {
                l = SelectionManagerKt.calculateSelectionMagnifierCenterAndroid_O0kMr_c$getMagnifierCenter(manager, magnifierSize, selection2.getEnd(), false);
                break;
            }
            case 3: {
                throw new IllegalStateException("SelectionContainer does not support cursor".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    @NotNull
    public static final AnnotatedString getCurrentSelectedText(@NotNull Selectable selectable2, @NotNull Selection selection) {
        Intrinsics.checkNotNullParameter((Object)selectable2, (String)"selectable");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        AnnotatedString currentText = selectable2.getText();
        return selectable2.getSelectableId() != selection.getStart().getSelectableId() && selectable2.getSelectableId() != selection.getEnd().getSelectableId() ? currentText : (selectable2.getSelectableId() == selection.getStart().getSelectableId() && selectable2.getSelectableId() == selection.getEnd().getSelectableId() ? (selection.getHandlesCrossed() ? currentText.subSequence(selection.getEnd().getOffset(), selection.getStart().getOffset()) : currentText.subSequence(selection.getStart().getOffset(), selection.getEnd().getOffset())) : (selectable2.getSelectableId() == selection.getStart().getSelectableId() ? (selection.getHandlesCrossed() ? currentText.subSequence(0, selection.getStart().getOffset()) : currentText.subSequence(selection.getStart().getOffset(), currentText.length())) : (selection.getHandlesCrossed() ? currentText.subSequence(selection.getEnd().getOffset(), currentText.length()) : currentText.subSequence(0, selection.getEnd().getOffset()))));
    }

    @NotNull
    public static final Rect visibleBounds(@NotNull LayoutCoordinates $this$visibleBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$visibleBounds, (String)"<this>");
        Rect boundsInWindow = LayoutCoordinatesKt.boundsInWindow((LayoutCoordinates)$this$visibleBounds);
        return RectKt.Rect-0a9Yr6o((long)$this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getTopLeft-F1C5BW0()), (long)$this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getBottomRight-F1C5BW0()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsInclusive-Uv8p0NA(@NotNull Rect $this$containsInclusive_u2dUv8p0NA, long offset) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInclusive_u2dUv8p0NA, (String)"$this$containsInclusive");
        float f = $this$containsInclusive_u2dUv8p0NA.getLeft();
        float f2 = $this$containsInclusive_u2dUv8p0NA.getRight();
        float f3 = Offset.getX-impl((long)offset);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = $this$containsInclusive_u2dUv8p0NA.getTop();
        f2 = $this$containsInclusive_u2dUv8p0NA.getBottom();
        f3 = Offset.getY-impl((long)offset);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        return true;
    }

    private static final long calculateSelectionMagnifierCenterAndroid_O0kMr_c$getMagnifierCenter(SelectionManager $manager, long $magnifierSize, Selection.AnchorInfo anchor, boolean isStartHandle) {
        int offset;
        Selectable selectable2 = $manager.getAnchorSelectable$foundation(anchor);
        if (selectable2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selectable selectable3 = selectable2;
        LayoutCoordinates layoutCoordinates = $manager.getContainerLayoutCoordinates();
        if (layoutCoordinates == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates containerCoordinates = layoutCoordinates;
        LayoutCoordinates layoutCoordinates2 = selectable3.getLayoutCoordinates();
        if (layoutCoordinates2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates selectableCoordinates = layoutCoordinates2;
        int n = offset = isStartHandle ? anchor.getOffset() : anchor.getOffset() - 1;
        if (offset > selectable3.getLastVisibleOffset()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Offset offset2 = $manager.getCurrentDragPosition-_m7T9-E();
        Intrinsics.checkNotNull((Object)offset2);
        long localDragPosition = selectableCoordinates.localPositionOf-R5De75A(containerCoordinates, offset2.unbox-impl());
        float dragX = Offset.getX-impl((long)localDragPosition);
        long line = selectable3.getRangeOfLineContaining--jx7JFs(offset);
        boolean bl = false;
        Rect lineMin = selectable3.getBoundingBox(TextRange.getMin-impl((long)line));
        Rect lineMax = selectable3.getBoundingBox(RangesKt.coerceAtLeast((int)(TextRange.getMax-impl((long)line) - 1), (int)TextRange.getMin-impl((long)line)));
        float minX = Math.min(lineMin.getLeft(), lineMax.getLeft());
        float maxX = Math.max(lineMin.getRight(), lineMax.getRight());
        float centerX = RangesKt.coerceIn((float)dragX, (float)minX, (float)maxX);
        if (Math.abs(dragX - centerX) > (float)(IntSize.getWidth-impl((long)$magnifierSize) / 2)) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Rect anchorBounds = selectable3.getBoundingBox(offset);
        float centerY = Offset.getY-impl((long)anchorBounds.getCenter-F1C5BW0());
        return containerCoordinates.localPositionOf-R5De75A(selectableCoordinates, OffsetKt.Offset((float)centerX, (float)centerY));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Handle.values().length];
            try {
                nArray[Handle.SelectionStart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.SelectionEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.Cursor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

