/*
 * Decompiled with CFR 0.152.
 */
package dev.icerock.moko.resources;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.imageio.ImageIO;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Ldev/icerock/moko/resources/ImageResource;", "", "resourcesClassLoader", "Ljava/lang/ClassLoader;", "filePath", "", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", "getFilePath", "()Ljava/lang/String;", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "image$delegate", "Lkotlin/Lazy;", "getResourcesClassLoader", "()Ljava/lang/ClassLoader;", "readSvg", "inputStream", "Ljava/io/InputStream;", "resources"})
public final class ImageResource {
    @NotNull
    private final ClassLoader resourcesClassLoader;
    @NotNull
    private final String filePath;
    @NotNull
    private final Lazy image$delegate;

    public ImageResource(@NotNull ClassLoader resourcesClassLoader, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)resourcesClassLoader, (String)"resourcesClassLoader");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.resourcesClassLoader = resourcesClassLoader;
        this.filePath = filePath;
        this.image$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BufferedImage>(this){
            final /* synthetic */ ImageResource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final BufferedImage invoke() {
                BufferedImage bufferedImage;
                Closeable closeable = this.this$0.getResourcesClassLoader().getResourceAsStream(this.this$0.getFilePath());
                if (closeable == null) {
                    throw new FileNotFoundException("Couldn't open resource as stream at: " + this.this$0.getFilePath());
                }
                InputStream stream = closeable;
                closeable = stream;
                ImageResource imageResource = this.this$0;
                Throwable throwable = null;
                try {
                    Closeable it = closeable;
                    boolean bl = false;
                    bufferedImage = StringsKt.endsWith((String)imageResource.getFilePath(), (String)".svg", (boolean)true) ? ImageResource.access$readSvg(imageResource, it) : ImageIO.read(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return bufferedImage;
            }
        }));
    }

    @NotNull
    public final ClassLoader getResourcesClassLoader() {
        return this.resourcesClassLoader;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final BufferedImage getImage() {
        Lazy lazy = this.image$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-image>(...)");
        return (BufferedImage)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BufferedImage readSvg(InputStream inputStream) {
        Transcoder t = (Transcoder)new PNGTranscoder();
        TranscoderInput input = new TranscoderInput(inputStream);
        PipedOutputStream outputStream = new PipedOutputStream();
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            PipedOutputStream it = (PipedOutputStream)closeable;
            boolean bl = false;
            TranscoderOutput output = new TranscoderOutput((OutputStream)it);
            t.transcode(input, output);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BufferedImage bufferedImage = ImageIO.read(new PipedInputStream(outputStream));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(PipedInputStream(outputStream))");
        return bufferedImage;
    }

    public static final /* synthetic */ BufferedImage access$readSvg(ImageResource $this, InputStream inputStream) {
        return $this.readSvg(inputStream);
    }
}

