/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.cachecontrol;

import com.ustadmobile.libcache.cachecontrol.CacheControlDirectivesUtilKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBM\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/libcache/cachecontrol/RequestCacheControlHeader;", "", "maxAge", "", "maxStale", "minFresh", "noCache", "", "noStore", "noTransform", "onlyIfCached", "staleIfError", "(Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;ZZZZLjava/lang/Long;)V", "getMaxAge", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getMaxStale", "getMinFresh", "getNoCache", "()Z", "getNoStore", "getNoTransform", "getOnlyIfCached", "staleAtAge", "getStaleAtAge", "getStaleIfError", "Companion", "lib-cache"})
public final class RequestCacheControlHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Long maxAge;
    @Nullable
    private final Long maxStale;
    @Nullable
    private final Long minFresh;
    private final boolean noCache;
    private final boolean noStore;
    private final boolean noTransform;
    private final boolean onlyIfCached;
    @Nullable
    private final Long staleIfError;

    public RequestCacheControlHeader(@Nullable Long maxAge, @Nullable Long maxStale, @Nullable Long minFresh, boolean noCache, boolean noStore, boolean noTransform, boolean onlyIfCached, @Nullable Long staleIfError) {
        this.maxAge = maxAge;
        this.maxStale = maxStale;
        this.minFresh = minFresh;
        this.noCache = noCache;
        this.noStore = noStore;
        this.noTransform = noTransform;
        this.onlyIfCached = onlyIfCached;
        this.staleIfError = staleIfError;
    }

    @Nullable
    public final Long getMaxAge() {
        return this.maxAge;
    }

    @Nullable
    public final Long getMaxStale() {
        return this.maxStale;
    }

    @Nullable
    public final Long getMinFresh() {
        return this.minFresh;
    }

    public final boolean getNoCache() {
        return this.noCache;
    }

    public final boolean getNoStore() {
        return this.noStore;
    }

    public final boolean getNoTransform() {
        return this.noTransform;
    }

    public final boolean getOnlyIfCached() {
        return this.onlyIfCached;
    }

    @Nullable
    public final Long getStaleIfError() {
        return this.staleIfError;
    }

    @Nullable
    public final Long getStaleAtAge() {
        Long l;
        if (this.maxAge != null && this.minFresh != null) {
            l = Math.max(this.maxAge, this.minFresh);
        } else {
            l = this.maxAge;
            if (l == null) {
                l = this.minFresh;
            }
        }
        return l;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/libcache/cachecontrol/RequestCacheControlHeader$Companion;", "", "()V", "parse", "Lcom/ustadmobile/libcache/cachecontrol/RequestCacheControlHeader;", "header", "", "lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RequestCacheControlHeader parse(@NotNull String header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Map<String, String> directivesMap = CacheControlDirectivesUtilKt.headerDirectivesToMap(header);
            String string = directivesMap.get("max-age");
            Long maxAge = string != null ? Long.valueOf(Long.parseLong(string)) : null;
            String string2 = directivesMap.get("max-stale");
            Long maxStale = string2 != null ? Long.valueOf(Long.parseLong(string2)) : null;
            String string3 = directivesMap.get("min-fresh");
            Long minFresh = string3 != null ? Long.valueOf(Long.parseLong(string3)) : null;
            boolean noCache = directivesMap.containsKey("no-cache");
            boolean noStore = directivesMap.containsKey("no-store");
            boolean noTransform = directivesMap.containsKey("no-transform");
            boolean onlyIfCached = directivesMap.containsKey("only-if-cached");
            String string4 = directivesMap.get("stale-if-error");
            Long staleIfError = string4 != null ? Long.valueOf(Long.parseLong(string4)) : null;
            return new RequestCacheControlHeader(maxAge, maxStale, minFresh, noCache, noStore, noTransform, onlyIfCached, staleIfError);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

