/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.builder;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.bramp.ffmpeg.FFmpegUtils;
import net.bramp.ffmpeg.Preconditions;
import net.bramp.ffmpeg.builder.FFmpegBuilder;
import net.bramp.ffmpeg.builder.MetadataSpecifier;
import net.bramp.ffmpeg.modelmapper.Mapper;
import net.bramp.ffmpeg.options.AudioEncodingOptions;
import net.bramp.ffmpeg.options.EncodingOptions;
import net.bramp.ffmpeg.options.MainEncodingOptions;
import net.bramp.ffmpeg.options.VideoEncodingOptions;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.Fraction;

public abstract class AbstractFFmpegStreamBuilder<T extends AbstractFFmpegStreamBuilder<T>> {
    private static final String DEVNULL = SystemUtils.IS_OS_WINDOWS ? "NUL" : "/dev/null";
    final FFmpegBuilder parent;
    public String filename;
    public URI uri;
    public String format;
    public Long startOffset;
    public Long duration;
    public final List<String> meta_tags = new ArrayList<String>();
    public boolean audio_enabled = true;
    public String audio_codec;
    public int audio_channels;
    public int audio_sample_rate;
    public String audio_preset;
    public boolean video_enabled = true;
    public String video_codec;
    public boolean video_copyinkf;
    public Fraction video_frame_rate;
    public int video_width;
    public int video_height;
    public String video_size;
    public String video_movflags;
    public Integer video_frames;
    public String video_pixel_format;
    public boolean subtitle_enabled = true;
    public String subtitle_preset;
    private String subtitle_codec;
    public String preset;
    public String presetFilename;
    public final List<String> extra_args = new ArrayList<String>();
    public FFmpegBuilder.Strict strict = FFmpegBuilder.Strict.NORMAL;
    public long targetSize = 0L;
    public long pass_padding_bitrate = 1024L;
    public boolean throwWarnings = true;

    protected AbstractFFmpegStreamBuilder() {
        this.parent = null;
    }

    protected AbstractFFmpegStreamBuilder(FFmpegBuilder parent, String filename) {
        this.parent = (FFmpegBuilder)com.google.common.base.Preconditions.checkNotNull((Object)parent);
        this.filename = Preconditions.checkNotEmpty(filename, "filename must not be empty");
    }

    protected AbstractFFmpegStreamBuilder(FFmpegBuilder parent, URI uri) {
        this.parent = (FFmpegBuilder)com.google.common.base.Preconditions.checkNotNull((Object)parent);
        this.uri = Preconditions.checkValidStream(uri);
    }

    protected abstract T getThis();

    public T useOptions(EncodingOptions opts) {
        Mapper.map(opts, this);
        return this.getThis();
    }

    public T useOptions(MainEncodingOptions opts) {
        Mapper.map(opts, this);
        return this.getThis();
    }

    public T useOptions(AudioEncodingOptions opts) {
        Mapper.map(opts, this);
        return this.getThis();
    }

    public T useOptions(VideoEncodingOptions opts) {
        Mapper.map(opts, this);
        return this.getThis();
    }

    public T disableVideo() {
        this.video_enabled = false;
        return this.getThis();
    }

    public T disableAudio() {
        this.audio_enabled = false;
        return this.getThis();
    }

    public T disableSubtitle() {
        this.subtitle_enabled = false;
        return this.getThis();
    }

    public T setPresetFilename(String presetFilename) {
        this.presetFilename = Preconditions.checkNotEmpty(presetFilename, "file preset must not be empty");
        return this.getThis();
    }

    public T setPreset(String preset) {
        this.preset = Preconditions.checkNotEmpty(preset, "preset must not be empty");
        return this.getThis();
    }

    public T setFilename(String filename) {
        this.filename = Preconditions.checkNotEmpty(filename, "filename must not be empty");
        return this.getThis();
    }

    public String getFilename() {
        return this.filename;
    }

    public T setUri(URI uri) {
        this.uri = Preconditions.checkValidStream(uri);
        return this.getThis();
    }

    public URI getUri() {
        return this.uri;
    }

    public T setFormat(String format) {
        this.format = Preconditions.checkNotEmpty(format, "format must not be empty");
        return this.getThis();
    }

    public T setVideoCodec(String codec) {
        this.video_enabled = true;
        this.video_codec = Preconditions.checkNotEmpty(codec, "codec must not be empty");
        return this.getThis();
    }

    public T setVideoCopyInkf(boolean copyinkf) {
        this.video_enabled = true;
        this.video_copyinkf = copyinkf;
        return this.getThis();
    }

    public T setVideoMovFlags(String movflags) {
        this.video_enabled = true;
        this.video_movflags = Preconditions.checkNotEmpty(movflags, "movflags must not be empty");
        return this.getThis();
    }

    public T setVideoFrameRate(Fraction frame_rate) {
        this.video_enabled = true;
        this.video_frame_rate = (Fraction)com.google.common.base.Preconditions.checkNotNull((Object)frame_rate);
        return this.getThis();
    }

    public T setVideoFrameRate(int frames, int per) {
        return this.setVideoFrameRate(Fraction.getFraction((int)frames, (int)per));
    }

    public T setVideoFrameRate(double frame_rate) {
        return this.setVideoFrameRate(Fraction.getFraction((double)frame_rate));
    }

    public T setFrames(int frames) {
        this.video_enabled = true;
        this.video_frames = frames;
        return this.getThis();
    }

    protected static boolean isValidSize(int widthOrHeight) {
        return widthOrHeight > 0 || widthOrHeight == -1;
    }

    public T setVideoWidth(int width) {
        com.google.common.base.Preconditions.checkArgument((boolean)AbstractFFmpegStreamBuilder.isValidSize(width), (Object)"Width must be -1 or greater than zero");
        this.video_enabled = true;
        this.video_width = width;
        return this.getThis();
    }

    public T setVideoHeight(int height) {
        com.google.common.base.Preconditions.checkArgument((boolean)AbstractFFmpegStreamBuilder.isValidSize(height), (Object)"Height must be -1 or greater than zero");
        this.video_enabled = true;
        this.video_height = height;
        return this.getThis();
    }

    public T setVideoResolution(int width, int height) {
        com.google.common.base.Preconditions.checkArgument((AbstractFFmpegStreamBuilder.isValidSize(width) && AbstractFFmpegStreamBuilder.isValidSize(height) ? 1 : 0) != 0, (Object)"Both width and height must be -1 or greater than zero");
        this.video_enabled = true;
        this.video_width = width;
        this.video_height = height;
        return this.getThis();
    }

    public T setVideoResolution(String abbreviation) {
        this.video_enabled = true;
        this.video_size = Preconditions.checkNotEmpty(abbreviation, "video abbreviation must not be empty");
        return this.getThis();
    }

    public T setVideoPixelFormat(String format) {
        this.video_enabled = true;
        this.video_pixel_format = Preconditions.checkNotEmpty(format, "format must not be empty");
        return this.getThis();
    }

    public T addMetaTag(String key, String value) {
        MetadataSpecifier.checkValidKey(key);
        Preconditions.checkNotEmpty(value, "value must not be empty");
        this.meta_tags.add("-metadata");
        this.meta_tags.add(key + "=" + value);
        return this.getThis();
    }

    public T addMetaTag(MetadataSpecifier spec, String key, String value) {
        MetadataSpecifier.checkValidKey(key);
        Preconditions.checkNotEmpty(value, "value must not be empty");
        this.meta_tags.add("-metadata:" + spec.spec());
        this.meta_tags.add(key + "=" + value);
        return this.getThis();
    }

    public T setAudioCodec(String codec) {
        this.audio_enabled = true;
        this.audio_codec = Preconditions.checkNotEmpty(codec, "codec must not be empty");
        return this.getThis();
    }

    public T setSubtitleCodec(String codec) {
        this.subtitle_enabled = true;
        this.subtitle_codec = Preconditions.checkNotEmpty(codec, "codec must not be empty");
        return this.getThis();
    }

    public T setAudioChannels(int channels) {
        com.google.common.base.Preconditions.checkArgument((channels > 0 ? 1 : 0) != 0, (Object)"channels must be positive");
        this.audio_enabled = true;
        this.audio_channels = channels;
        return this.getThis();
    }

    public T setAudioSampleRate(int sample_rate) {
        com.google.common.base.Preconditions.checkArgument((sample_rate > 0 ? 1 : 0) != 0, (Object)"sample rate must be positive");
        this.audio_enabled = true;
        this.audio_sample_rate = sample_rate;
        return this.getThis();
    }

    public T setTargetSize(long targetSize) {
        com.google.common.base.Preconditions.checkArgument((targetSize > 0L ? 1 : 0) != 0, (Object)"target size must be positive");
        this.targetSize = targetSize;
        return this.getThis();
    }

    public T setStartOffset(long offset, TimeUnit units) {
        com.google.common.base.Preconditions.checkNotNull((Object)((Object)units));
        this.startOffset = units.toMillis(offset);
        return this.getThis();
    }

    public T setDuration(long duration, TimeUnit units) {
        com.google.common.base.Preconditions.checkNotNull((Object)((Object)units));
        this.duration = units.toMillis(duration);
        return this.getThis();
    }

    public T setStrict(FFmpegBuilder.Strict strict) {
        this.strict = (FFmpegBuilder.Strict)((Object)com.google.common.base.Preconditions.checkNotNull((Object)((Object)strict)));
        return this.getThis();
    }

    public T setPassPaddingBitrate(long bitrate) {
        com.google.common.base.Preconditions.checkArgument((bitrate > 0L ? 1 : 0) != 0, (Object)"bitrate must be positive");
        this.pass_padding_bitrate = bitrate;
        return this.getThis();
    }

    public T setAudioPreset(String preset) {
        this.audio_enabled = true;
        this.audio_preset = Preconditions.checkNotEmpty(preset, "audio preset must not be empty");
        return this.getThis();
    }

    public T setSubtitlePreset(String preset) {
        this.subtitle_enabled = true;
        this.subtitle_preset = Preconditions.checkNotEmpty(preset, "subtitle preset must not be empty");
        return this.getThis();
    }

    public T addExtraArgs(String ... values) {
        com.google.common.base.Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"one or more values must be supplied");
        Preconditions.checkNotEmpty(values[0], "first extra arg may not be empty");
        for (String value : values) {
            this.extra_args.add((String)com.google.common.base.Preconditions.checkNotNull((Object)value));
        }
        return this.getThis();
    }

    public FFmpegBuilder done() {
        com.google.common.base.Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"Can not call done without parent being set");
        return this.parent;
    }

    public abstract EncodingOptions buildOptions();

    protected List<String> build(int pass) {
        com.google.common.base.Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"Can not build without parent being set");
        return this.build(this.parent, pass);
    }

    protected List<String> build(FFmpegBuilder parent, int pass) {
        com.google.common.base.Preconditions.checkNotNull((Object)parent);
        if (pass > 0) {
            com.google.common.base.Preconditions.checkArgument((this.format != null ? 1 : 0) != 0, (Object)"Format must be specified when using two-pass");
        }
        ImmutableList.Builder args = new ImmutableList.Builder();
        this.addGlobalFlags(parent, (ImmutableList.Builder<String>)args);
        if (this.video_enabled) {
            this.addVideoFlags(parent, (ImmutableList.Builder<String>)args);
        } else {
            args.add((Object)"-vn");
        }
        if (this.audio_enabled && pass != 1) {
            this.addAudioFlags((ImmutableList.Builder<String>)args);
        } else {
            args.add((Object)"-an");
        }
        if (this.subtitle_enabled) {
            if (!Strings.isNullOrEmpty((String)this.subtitle_codec)) {
                args.add((Object[])new String[]{"-scodec", this.subtitle_codec});
            }
            if (!Strings.isNullOrEmpty((String)this.subtitle_preset)) {
                args.add((Object[])new String[]{"-spre", this.subtitle_preset});
            }
        } else {
            args.add((Object)"-sn");
        }
        args.addAll(this.extra_args);
        if (this.filename != null && this.uri != null) {
            throw new IllegalStateException("Only one of filename and uri can be set");
        }
        if (pass == 1) {
            args.add((Object)DEVNULL);
        } else if (this.filename != null) {
            args.add((Object)this.filename);
        } else if (this.uri != null) {
            args.add((Object)this.uri.toString());
        } else assert (false);
        return args.build();
    }

    protected void addGlobalFlags(FFmpegBuilder parent, ImmutableList.Builder<String> args) {
        if (this.strict != FFmpegBuilder.Strict.NORMAL) {
            args.add((Object[])new String[]{"-strict", this.strict.toString()});
        }
        if (!Strings.isNullOrEmpty((String)this.format)) {
            args.add((Object[])new String[]{"-f", this.format});
        }
        if (!Strings.isNullOrEmpty((String)this.preset)) {
            args.add((Object[])new String[]{"-preset", this.preset});
        }
        if (!Strings.isNullOrEmpty((String)this.presetFilename)) {
            args.add((Object[])new String[]{"-fpre", this.presetFilename});
        }
        if (this.startOffset != null) {
            args.add((Object[])new String[]{"-ss", FFmpegUtils.toTimecode(this.startOffset, TimeUnit.MILLISECONDS)});
        }
        if (this.duration != null) {
            args.add((Object[])new String[]{"-t", FFmpegUtils.toTimecode(this.duration, TimeUnit.MILLISECONDS)});
        }
        args.addAll(this.meta_tags);
    }

    protected void addAudioFlags(ImmutableList.Builder<String> args) {
        if (!Strings.isNullOrEmpty((String)this.audio_codec)) {
            args.add((Object[])new String[]{"-acodec", this.audio_codec});
        }
        if (this.audio_channels > 0) {
            args.add((Object[])new String[]{"-ac", String.valueOf(this.audio_channels)});
        }
        if (this.audio_sample_rate > 0) {
            args.add((Object[])new String[]{"-ar", String.valueOf(this.audio_sample_rate)});
        }
        if (!Strings.isNullOrEmpty((String)this.audio_preset)) {
            args.add((Object[])new String[]{"-apre", this.audio_preset});
        }
    }

    protected void addVideoFlags(FFmpegBuilder parent, ImmutableList.Builder<String> args) {
        if (this.video_frames != null) {
            args.add((Object[])new String[]{"-vframes", this.video_frames.toString()});
        }
        if (!Strings.isNullOrEmpty((String)this.video_codec)) {
            args.add((Object[])new String[]{"-vcodec", this.video_codec});
        }
        if (!Strings.isNullOrEmpty((String)this.video_pixel_format)) {
            args.add((Object[])new String[]{"-pix_fmt", this.video_pixel_format});
        }
        if (this.video_copyinkf) {
            args.add((Object)"-copyinkf");
        }
        if (!Strings.isNullOrEmpty((String)this.video_movflags)) {
            args.add((Object[])new String[]{"-movflags", this.video_movflags});
        }
        if (this.video_size != null) {
            com.google.common.base.Preconditions.checkArgument((this.video_width == 0 && this.video_height == 0 ? 1 : 0) != 0, (Object)"Can not specific width or height, as well as an abbreviatied video size");
            args.add((Object[])new String[]{"-s", this.video_size});
        } else if (this.video_width != 0 && this.video_height != 0) {
            args.add((Object[])new String[]{"-s", String.format("%dx%d", this.video_width, this.video_height)});
        }
        if (this.video_frame_rate != null) {
            args.add((Object[])new String[]{"-r", this.video_frame_rate.toString()});
        }
    }
}

