/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.info;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class Codec {
    final String name;
    final String longName;
    final boolean canDecode;
    final boolean canEncode;
    final Type type;

    public Codec(String name, String longName, String flags) {
        this.name = ((String)Preconditions.checkNotNull((Object)name)).trim();
        this.longName = ((String)Preconditions.checkNotNull((Object)longName)).trim();
        Preconditions.checkNotNull((Object)flags);
        Preconditions.checkArgument((flags.length() == 6 ? 1 : 0) != 0, (String)"Format flags is invalid '{}'", (Object)flags);
        this.canDecode = flags.charAt(0) == 'D';
        this.canEncode = flags.charAt(1) == 'E';
        switch (flags.charAt(2)) {
            case 'V': {
                this.type = Type.VIDEO;
                break;
            }
            case 'A': {
                this.type = Type.AUDIO;
                break;
            }
            case 'S': {
                this.type = Type.SUBTITLE;
                break;
            }
            case 'D': {
                this.type = Type.DATA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid codec type '" + flags.charAt(2) + "'");
            }
        }
    }

    public String toString() {
        return this.name + " " + this.longName;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public boolean getCanDecode() {
        return this.canDecode;
    }

    public boolean getCanEncode() {
        return this.canEncode;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        VIDEO,
        AUDIO,
        SUBTITLE,
        DATA;

    }
}

