/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.nut;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import net.bramp.ffmpeg.nut.NutDataInputStream;
import net.bramp.ffmpeg.nut.PacketFooter;
import net.bramp.ffmpeg.nut.PacketHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Packet {
    static final Logger LOG = LoggerFactory.getLogger(Packet.class);
    public final PacketHeader header = new PacketHeader();
    public final PacketFooter footer = new PacketFooter();

    protected void readBody(NutDataInputStream in) throws IOException {
    }

    public void read(NutDataInputStream in, long startcode) throws IOException {
        this.header.read(in, startcode);
        this.readBody(in);
        this.seekToPacketFooter(in);
        this.footer.read(in);
    }

    public void seekToPacketFooter(NutDataInputStream in) throws IOException {
        long current = in.offset();
        if (current > this.header.end) {
            throw new IOException("Can not seek backwards at:" + current + " end:" + this.header.end);
        }
        in.skipBytes((int)(this.header.end - current));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("footer", (Object)this.footer).toString();
    }

    public static enum Startcode {
        MAIN(5642300418477196461L),
        STREAM(5643873726143592923L),
        SYNCPOINT(5641854393898386793L),
        INDEX(5645505568151168590L),
        INFO(5641228474469759608L);

        private final long startcode;

        private Startcode(long startcode) {
            this.startcode = startcode;
        }

        public long value() {
            return this.startcode;
        }

        public boolean equalsCode(long startcode) {
            return this.startcode == startcode;
        }

        public static Startcode of(long startcode) {
            for (Startcode c : Startcode.values()) {
                if (!c.equalsCode(startcode)) continue;
                return c;
            }
            return null;
        }

        public static boolean isPossibleStartcode(long startcode) {
            return (startcode & 0xFFL) == 78L;
        }

        public static String toString(long startcode) {
            Startcode c = Startcode.of(startcode);
            if (c != null) {
                return c.name();
            }
            return String.format("%X", startcode);
        }
    }
}

