(function (_, kotlin_kotlin) {
  'use strict';
  //region block: imports
  var until = kotlin_kotlin.$_$.ch;
  var listOf = kotlin_kotlin.$_$.ta;
  var _Char___init__impl__6a9atx = kotlin_kotlin.$_$.o3;
  var Char__rangeTo_impl_tkncvp = kotlin_kotlin.$_$.u3;
  var plus = kotlin_kotlin.$_$.hb;
  var Default_getInstance = kotlin_kotlin.$_$.w5;
  var Long = kotlin_kotlin.$_$.am;
  var toLong = kotlin_kotlin.$_$.ag;
  var downTo = kotlin_kotlin.$_$.yg;
  var Char__toInt_impl_vasixd = kotlin_kotlin.$_$.v3;
  var protoOf = kotlin_kotlin.$_$.xf;
  var objectCreate = kotlin_kotlin.$_$.vf;
  var objectMeta = kotlin_kotlin.$_$.wf;
  var setMetadataFor = kotlin_kotlin.$_$.yf;
  var toString = kotlin_kotlin.$_$.cg;
  var IllegalArgumentException_init_$Create$ = kotlin_kotlin.$_$.h2;
  var charArray = kotlin_kotlin.$_$.ee;
  var concatToString = kotlin_kotlin.$_$.gi;
  var contentEquals = kotlin_kotlin.$_$.k8;
  var contentHashCode = kotlin_kotlin.$_$.m8;
  var compareTo = kotlin_kotlin.$_$.je;
  var THROW_CCE = kotlin_kotlin.$_$.hm;
  var Comparable = kotlin_kotlin.$_$.ql;
  var classMeta = kotlin_kotlin.$_$.ie;
  var VOID = kotlin_kotlin.$_$.g;
  var toByte = kotlin_kotlin.$_$.zf;
  var Collection = kotlin_kotlin.$_$.r6;
  var isInterface = kotlin_kotlin.$_$.hf;
  var charSequenceGet = kotlin_kotlin.$_$.fe;
  //endregion
  //region block: pre-declaration
  setMetadataFor(Companion, 'Companion', objectMeta);
  setMetadataFor(Uuid, 'Uuid', classMeta, VOID, [Comparable]);
  //endregion
  function get_UUID_CHAR_RANGES() {
    _init_properties_uuid_kt__7swked();
    return UUID_CHAR_RANGES;
  }
  var UUID_CHAR_RANGES;
  function get_UUID_HYPHEN_INDICES() {
    _init_properties_uuid_kt__7swked();
    return UUID_HYPHEN_INDICES;
  }
  var UUID_HYPHEN_INDICES;
  function get_UUID_CHARS() {
    _init_properties_uuid_kt__7swked();
    return UUID_CHARS;
  }
  var UUID_CHARS;
  function get_UUID_BYTES() {
    return UUID_BYTES;
  }
  var UUID_BYTES;
  function get_UUID_STRING_LENGTH() {
    return UUID_STRING_LENGTH;
  }
  var UUID_STRING_LENGTH;
  var properties_initialized_uuid_kt_pyvynx;
  function _init_properties_uuid_kt__7swked() {
    if (!properties_initialized_uuid_kt_pyvynx) {
      properties_initialized_uuid_kt_pyvynx = true;
      UUID_CHAR_RANGES = listOf([until(0, 8), until(9, 13), until(14, 18), until(19, 23), until(24, 36)]);
      UUID_HYPHEN_INDICES = listOf([8, 13, 18, 23]);
      UUID_CHARS = plus(Char__rangeTo_impl_tkncvp(_Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(57)), Char__rangeTo_impl_tkncvp(_Char___init__impl__6a9atx(97), _Char___init__impl__6a9atx(102)));
    }
  }
  function freeze(_this__u8e3s4) {
    return _this__u8e3s4;
  }
  function getRandomUuidBytes() {
    return Default_getInstance().nextBytes_dtk0kg_k$(get_UUID_BYTES());
  }
  function bits(_this__u8e3s4, $this, start, end) {
    var b = new Long(0, 0);
    var i = start;
    $l$1: do {
      $l$0: do {
        b = b.shl_bg8if3_k$(8).or_v7fvkl_k$(toLong(_this__u8e3s4[i]).and_4spn93_k$(new Long(255, 0)));
      }
       while (false);
      i = i + 1 | 0;
    }
     while (i < end);
    return b;
  }
  function fromBits($this, msb, lsb) {
    // Inline function 'kotlin.also' call
    var this_0 = new Int8Array(get_UUID_BYTES());
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'com.benasher44.uuid.Companion.fromBits.<anonymous>' call
    // Inline function 'kotlin.collections.fold' call
    var accumulator = msb;
    var tmp0_iterator = downTo(7, 0).iterator_jk1svi_k$();
    while (tmp0_iterator.hasNext_bitz1p_k$()) {
      var element = tmp0_iterator.next_20eer_k$();
      // Inline function 'com.benasher44.uuid.Companion.fromBits.<anonymous>.<anonymous>' call
      var x = accumulator;
      this_0[element] = x.and_4spn93_k$(new Long(255, 0)).toByte_edm0nx_k$();
      accumulator = x.shr_9fl3wl_k$(8);
    }
    // Inline function 'kotlin.collections.fold' call
    var accumulator_0 = lsb;
    var tmp0_iterator_0 = downTo(15, 8).iterator_jk1svi_k$();
    while (tmp0_iterator_0.hasNext_bitz1p_k$()) {
      var element_0 = tmp0_iterator_0.next_20eer_k$();
      // Inline function 'com.benasher44.uuid.Companion.fromBits.<anonymous>.<anonymous>' call
      var x_0 = accumulator_0;
      this_0[element_0] = x_0.and_4spn93_k$(new Long(255, 0)).toByte_edm0nx_k$();
      accumulator_0 = x_0.shr_9fl3wl_k$(8);
    }
    return this_0;
  }
  function halfByteFromChar($this, char) {
    var tmp;
    if (_Char___init__impl__6a9atx(48) <= char ? char <= _Char___init__impl__6a9atx(57) : false) {
      // Inline function 'kotlin.code' call
      tmp = Char__toInt_impl_vasixd(char) - 48 | 0;
    } else if (_Char___init__impl__6a9atx(97) <= char ? char <= _Char___init__impl__6a9atx(102) : false) {
      // Inline function 'kotlin.code' call
      tmp = Char__toInt_impl_vasixd(char) - 87 | 0;
    } else if (_Char___init__impl__6a9atx(65) <= char ? char <= _Char___init__impl__6a9atx(70) : false) {
      // Inline function 'kotlin.code' call
      tmp = Char__toInt_impl_vasixd(char) - 55 | 0;
    } else {
      tmp = null;
    }
    return tmp;
  }
  function _get_uuidByteRanges__vs2yge($this) {
    return $this.uuidByteRanges_1;
  }
  function Uuid_init_$Init$(msb, lsb, $this) {
    Uuid.call($this, fromBits(Companion_getInstance(), msb, lsb));
    return $this;
  }
  function Uuid_init_$Create$(msb, lsb) {
    return Uuid_init_$Init$(msb, lsb, objectCreate(protoOf(Uuid)));
  }
  function Companion() {
    Companion_instance = this;
    this.uuidByteRanges_1 = listOf([until(0, 4), until(4, 6), until(6, 8), until(8, 10), until(10, 16)]);
  }
  var Companion_instance;
  function Companion_getInstance() {
    if (Companion_instance == null)
      new Companion();
    return Companion_instance;
  }
  function Uuid(uuidBytes) {
    Companion_getInstance();
    this.uuidBytes_1 = uuidBytes;
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.collections.count' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(this.uuidBytes_1.length === get_UUID_BYTES())) {
      // Inline function 'com.benasher44.uuid.Uuid.<anonymous>' call
      var tmp = get_UUID_BYTES();
      // Inline function 'kotlin.collections.count' call
      var message = 'Invalid UUID bytes. Expected ' + tmp + ' bytes; found ' + this.uuidBytes_1.length;
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    freeze(this);
  }
  protoOf(Uuid).get_uuidBytes_in7ak9_k$ = function () {
    return this.uuidBytes_1;
  };
  protoOf(Uuid).get_mostSignificantBits_50ugdp_k$ = function () {
    return bits(this.uuidBytes_1, Companion_getInstance(), 0, 8);
  };
  protoOf(Uuid).get_leastSignificantBits_mmkdbt_k$ = function () {
    return bits(this.uuidBytes_1, Companion_getInstance(), 8, 16);
  };
  protoOf(Uuid).toString = function () {
    var characters = charArray(get_UUID_STRING_LENGTH());
    var charIndex = 0;
    var tmp0_iterator = Companion_getInstance().uuidByteRanges_1.iterator_jk1svi_k$();
    while (tmp0_iterator.hasNext_bitz1p_k$()) {
      var range = tmp0_iterator.next_20eer_k$();
      var inductionVariable = range.get_first_irdx8n_k$();
      var last = range.get_last_wopotb_k$();
      if (inductionVariable <= last)
        do {
          var i = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          var octetPair = this.uuidBytes_1[i];
          var left = octetPair >> 4 & 15;
          var right = octetPair & 15;
          var tmp2 = charIndex;
          charIndex = tmp2 + 1 | 0;
          characters[tmp2] = get_UUID_CHARS().get_c1px32_k$(left).value_1;
          var tmp3 = charIndex;
          charIndex = tmp3 + 1 | 0;
          characters[tmp3] = get_UUID_CHARS().get_c1px32_k$(right).value_1;
        }
         while (!(i === last));
      if (charIndex < get_UUID_STRING_LENGTH()) {
        var tmp4 = charIndex;
        charIndex = tmp4 + 1 | 0;
        characters[tmp4] = _Char___init__impl__6a9atx(45);
      }
    }
    return concatToString(characters);
  };
  protoOf(Uuid).equals = function (other) {
    var tmp;
    if (other instanceof Uuid) {
      tmp = contentEquals(this.uuidBytes_1, other.uuidBytes_1);
    } else {
      tmp = false;
    }
    return tmp;
  };
  protoOf(Uuid).hashCode = function () {
    return contentHashCode(this.uuidBytes_1);
  };
  protoOf(Uuid).compareTo_lun2th_k$ = function (other) {
    var inductionVariable = 0;
    var last = get_UUID_BYTES();
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var compareResult = compareTo(this.uuidBytes_1[i], other.uuidBytes_1[i]);
        if (!(compareResult === 0))
          return compareResult;
      }
       while (inductionVariable < last);
    return 0;
  };
  protoOf(Uuid).compareTo_hpufkf_k$ = function (other) {
    return this.compareTo_lun2th_k$(other instanceof Uuid ? other : THROW_CCE());
  };
  function uuid4() {
    // Inline function 'com.benasher44.uuid.setVersion' call
    // Inline function 'kotlin.apply' call
    var this_0 = getRandomUuidBytes();
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'com.benasher44.uuid.setVersion.<anonymous>' call
    this_0[6] = toByte(this_0[6] & 15 | 4 << 4);
    this_0[8] = toByte(this_0[8] & 63 | 128);
    return new Uuid(this_0);
  }
  function uuidFrom(string) {
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.contracts.contract' call
    if (!(string.length === get_UUID_STRING_LENGTH())) {
      // Inline function 'com.benasher44.uuid.uuidFrom.<anonymous>' call
      var message = 'Uuid string has invalid length: ' + string;
      throw IllegalArgumentException_init_$Create$(toString(message));
    }
    // Inline function 'kotlin.require' call
    var tmp$ret$1;
    $l$block_0: {
      // Inline function 'kotlin.collections.all' call
      var this_0 = get_UUID_HYPHEN_INDICES();
      var tmp;
      if (isInterface(this_0, Collection)) {
        tmp = this_0.isEmpty_y1axqb_k$();
      } else {
        tmp = false;
      }
      if (tmp) {
        tmp$ret$1 = true;
        break $l$block_0;
      }
      var tmp0_iterator = this_0.iterator_jk1svi_k$();
      while (tmp0_iterator.hasNext_bitz1p_k$()) {
        var element = tmp0_iterator.next_20eer_k$();
        // Inline function 'com.benasher44.uuid.uuidFrom.<anonymous>' call
        if (!(charSequenceGet(string, element) === _Char___init__impl__6a9atx(45))) {
          tmp$ret$1 = false;
          break $l$block_0;
        }
      }
      tmp$ret$1 = true;
    }
    // Inline function 'kotlin.contracts.contract' call
    if (!tmp$ret$1) {
      // Inline function 'com.benasher44.uuid.uuidFrom.<anonymous>' call
      var message_0 = 'Uuid string has invalid format: ' + string;
      throw IllegalArgumentException_init_$Create$(toString(message_0));
    }
    var bytes = new Int8Array(get_UUID_BYTES());
    var byte = 0;
    var tmp0_iterator_0 = get_UUID_CHAR_RANGES().iterator_jk1svi_k$();
    while (tmp0_iterator_0.hasNext_bitz1p_k$()) {
      var range = tmp0_iterator_0.next_20eer_k$();
      var i = range.get_first_irdx8n_k$();
      while (i < range.get_last_wopotb_k$()) {
        var tmp1 = i;
        i = tmp1 + 1 | 0;
        var left = halfByteFromChar_0(charSequenceGet(string, tmp1));
        var tmp2 = i;
        i = tmp2 + 1 | 0;
        var right = halfByteFromChar_0(charSequenceGet(string, tmp2));
        // Inline function 'kotlin.require' call
        // Inline function 'kotlin.contracts.contract' call
        if (!(!(left == null) ? !(right == null) : false)) {
          // Inline function 'com.benasher44.uuid.uuidFrom.<anonymous>' call
          var message_1 = 'Uuid string has invalid characters: ' + string;
          throw IllegalArgumentException_init_$Create$(toString(message_1));
        }
        var tmp3 = byte;
        byte = tmp3 + 1 | 0;
        bytes[tmp3] = toByte(left << 4 | right);
      }
    }
    return new Uuid(bytes);
  }
  function setVersion(_this__u8e3s4, version) {
    // Inline function 'kotlin.apply' call
    // Inline function 'kotlin.contracts.contract' call
    // Inline function 'com.benasher44.uuid.setVersion.<anonymous>' call
    _this__u8e3s4[6] = toByte(_this__u8e3s4[6] & 15 | version << 4);
    _this__u8e3s4[8] = toByte(_this__u8e3s4[8] & 63 | 128);
    return _this__u8e3s4;
  }
  function halfByteFromChar_0(char) {
    var tmp;
    if (_Char___init__impl__6a9atx(48) <= char ? char <= _Char___init__impl__6a9atx(57) : false) {
      // Inline function 'kotlin.code' call
      tmp = Char__toInt_impl_vasixd(char) - 48 | 0;
    } else if (_Char___init__impl__6a9atx(97) <= char ? char <= _Char___init__impl__6a9atx(102) : false) {
      // Inline function 'kotlin.code' call
      tmp = Char__toInt_impl_vasixd(char) - 87 | 0;
    } else if (_Char___init__impl__6a9atx(65) <= char ? char <= _Char___init__impl__6a9atx(70) : false) {
      // Inline function 'kotlin.code' call
      tmp = Char__toInt_impl_vasixd(char) - 55 | 0;
    } else {
      tmp = null;
    }
    return tmp;
  }
  //region block: init
  UUID_BYTES = 16;
  UUID_STRING_LENGTH = 36;
  //endregion
  //region block: exports
  _.$_$ = _.$_$ || {};
  _.$_$.a = uuid4;
  _.$_$.b = uuidFrom;
  _.$_$.c = Uuid_init_$Create$;
  //endregion
  return _;
}(module.exports, require('./kotlin-kotlin-stdlib.js')));
