/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Query;
import com.ustadmobile.lib.db.entities.DeletedItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH'J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u0015J,\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/core/db/dao/DeletedItemDao;", "", "()V", "findByTableIdAndEntityUid", "", "Lcom/ustadmobile/lib/db/entities/DeletedItem;", "tableId", "", "entityUid", "", "(IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findDeletedItemsForUser", "Landroidx/paging/PagingSource;", "personUid", "includeActionedItems", "", "insertDeletedItemForContentEntryParentChildJoin", "", "cepcjUid", "time", "deletedByPersonUid", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStatusByUids", "uidList", "newStatus", "updateTime", "(Ljava/util/List;IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_debug"})
@Dao
public abstract class DeletedItemDao {
    @Query(value="\n        INSERT INTO DeletedItem(delItemName, delItemIconUri, delItemLastModTime, delItemTimeDeleted, delItemEntityTable, delItemEntityUid, delItemDeletedByPersonUid, delItemStatus, delItemIsFolder)\n        SELECT (SELECT ContentEntry.title\n                  FROM ContentEntry\n                 WHERE ContentEntry.contentEntryUid = \n                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n                          FROM ContentEntryParentChildJoin\n                         WHERE ContentEntryParentChildJoin.cepcjUid = :cepcjUid)) AS delItemName,\n               NULL as delItemIconUri,\n               :time AS delItemLastModTime,\n               :time AS delItemTimeDeleted,\n               7 AS delItemEntityTable,\n               :cepcjUid AS delItemEntityUid,\n               :deletedByPersonUid AS delItemDeletedByPersonUid,\n               1 AS delItemStatus,\n               (SELECT NOT ContentEntry.leaf\n                  FROM ContentEntry\n                 WHERE ContentEntry.contentEntryUid = \n                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n                          FROM ContentEntryParentChildJoin\n                         WHERE ContentEntryParentChildJoin.cepcjUid = :cepcjUid)) AS delItemIsFolder\n    ")
    @Nullable
    public abstract Object insertDeletedItemForContentEntryParentChildJoin(long var1, long var3, long var5, @NotNull Continuation<? super Unit> var7);

    @Query(value="\n        SELECT DeletedItem.*\n          FROM DeletedItem\n         WHERE DeletedItem.delItemEntityTable = :tableId\n           AND DeletedItem.delItemEntityUid = :entityUid\n    ")
    @Nullable
    public abstract Object findByTableIdAndEntityUid(int var1, long var2, @NotNull Continuation<? super List<DeletedItem>> var4);

    @Query(value="\n        SELECT DeletedItem.*\n          FROM DeletedItem\n         WHERE (  (CAST(:includeActionedItems AS INTEGER) = 1)\n                OR DeletedItem.delItemStatus = 1)\n           AND DeletedItem.delItemDeletedByPersonUid = :personUid       \n      ORDER BY DeletedItem.delItemTimeDeleted DESC            \n    ")
    @NotNull
    public abstract PagingSource<Integer, DeletedItem> findDeletedItemsForUser(long var1, boolean var3);

    @Query(value="\n        UPDATE DeletedItem\n           SET delItemStatus = :newStatus,\n               delItemLastModTime = :updateTime\n         WHERE delItemUid IN (:uidList)\n    ")
    @Nullable
    public abstract Object updateStatusByUids(@NotNull List<Long> var1, int var2, long var3, @NotNull Continuation<? super Unit> var5);
}

