/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.entities.UserSession;
import com.ustadmobile.lib.db.entities.UserSessionAndPerson;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u000bJ6\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u0012J.\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u00a7@\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u00a7@\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018H\u00a7@\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00180!H'J\u0018\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0!2\u0006\u0010\u0014\u001a\u00020\u0006H'J\u001a\u0010$\u001a\u0004\u0018\u00010\u001e2\b\u0010%\u001a\u0004\u0018\u00010&H\u00a7@\u00a2\u0006\u0002\u0010'J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020#0\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020#H\u00a7@\u00a2\u0006\u0002\u0010+\u00a8\u0006,"}, d2={"Lcom/ustadmobile/core/db/dao/UserSessionDao;", "", "()V", "countActiveSessionsForUserAndNode", "", "personUid", "", "nodeId", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "countAllLocalSessionsAsync", "maxDateOfBirth", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endOtherSessions", "", "exemptNodeId", "newStatus", "reason", "changeTime", "(JJIIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endSession", "sessionUid", "endTime", "(JIIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findActiveNodeIdsByPersonUids", "", "personUids", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findActiveNodesIdsByGroupUids", "groupUids", "findAllLocalSessionsAsync", "Lcom/ustadmobile/lib/db/entities/UserSessionAndPerson;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllLocalSessionsLive", "Lkotlinx/coroutines/flow/Flow;", "findByUidLive", "Lcom/ustadmobile/lib/db/entities/UserSession;", "findLocalSessionByUsername", "username", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSessionsByPerson", "insertSession", "session", "(Lcom/ustadmobile/lib/db/entities/UserSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_debug"})
@Dao
public abstract class UserSessionDao {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertSession(@NotNull UserSession var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n        SELECT UserSession.*\n          FROM UserSession\n         WHERE usPersonUid = :personUid \n    ")
    @Nullable
    public abstract Object findSessionsByPerson(long var1, @NotNull Continuation<? super List<UserSession>> var3);

    @Query(value="\n            SELECT UserSession.*, Person.*, PersonPicture.*\n              FROM UserSession\n                   JOIN Person \n                        ON Person.personUid = UserSession.usPersonUid\n                   LEFT JOIN PersonPicture\n                        ON PersonPicture.personPictureUid = UserSession.usPersonUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n               AND (UserSession.usSessionType & 8) != 8\n            ")
    @NotNull
    public abstract Flow<List<UserSessionAndPerson>> findAllLocalSessionsLive();

    @Query(value="\n            SELECT UserSession.*, Person.*, PersonPicture.*\n              FROM UserSession\n                   JOIN Person \n                        ON Person.personUid = UserSession.usPersonUid\n                   LEFT JOIN PersonPicture\n                        ON PersonPicture.personPictureUid = UserSession.usPersonUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n               AND (UserSession.usSessionType & 8) != 8\n            ")
    @Nullable
    public abstract Object findAllLocalSessionsAsync(@NotNull Continuation<? super List<UserSessionAndPerson>> var1);

    @Query(value="\n            SELECT UserSession.*, Person.*\n              FROM UserSession\n                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n             WHERE Person.username = :username\n               AND UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n            ")
    @Nullable
    public abstract Object findLocalSessionByUsername(@Nullable String var1, @NotNull Continuation<? super UserSessionAndPerson> var2);

    @Query(value="\n        SELECT COUNT(*)\n          FROM UserSession\n               JOIN Person \n                    ON UserSession.usPersonUid = Person.personUid\n         WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n           AND UserSession.usStatus = 1                \n           AND (:maxDateOfBirth = 0 OR Person.dateOfBirth < :maxDateOfBirth)\n           AND (UserSession.usSessionType & 8) != 8            \n    ")
    @Nullable
    public abstract Object countAllLocalSessionsAsync(long var1, @NotNull Continuation<? super Integer> var3);

    @Query(value="\n        UPDATE UserSession\n           SET usAuth = null,\n               usStatus = :newStatus,\n               usReason = :reason,\n               usEndTime = :endTime,\n               usLct = :endTime\n         WHERE UserSession.usUid = :sessionUid\n    ")
    @Nullable
    public abstract Object endSession(long var1, int var3, int var4, long var5, @NotNull Continuation<? super Unit> var7);

    @Query(value="\n        SELECT UserSession.*\n          FROM UserSession\n         WHERE UserSession.usUid = :sessionUid\n         LIMIT 1\n    ")
    @NotNull
    public abstract Flow<UserSession> findByUidLive(long var1);

    @Query(value="\n        UPDATE UserSession\n           SET usAuth = null,\n               usStatus = :newStatus,\n               usReason = :reason,\n               usLct = :changeTime\n         WHERE usPersonUid = :personUid\n           AND usClientNodeId != :exemptNodeId\n           AND usStatus != :newStatus                     \n    ")
    @Nullable
    public abstract Object endOtherSessions(long var1, long var3, int var5, int var6, long var7, @NotNull Continuation<? super Unit> var9);

    @Query(value="\n        SELECT DISTINCT UserSession.usClientNodeId\n          FROM UserSession\n         WHERE UserSession.usPersonUid IN (:personUids)\n           AND UserSession.usStatus = 1\n    ")
    @Nullable
    public abstract Object findActiveNodeIdsByPersonUids(@NotNull List<Long> var1, @NotNull Continuation<? super List<Long>> var2);

    @Query(value="\n        SELECT DISTINCT UserSession.usClientNodeId\n          FROM UserSession\n               JOIN PersonGroupMember \n                    ON PersonGroupMember.groupMemberPersonUid = UserSession.usPersonUid\n         WHERE PersonGroupMember.groupMemberGroupUid IN (:groupUids)            \n    ")
    @Nullable
    public abstract Object findActiveNodesIdsByGroupUids(@NotNull List<Long> var1, @NotNull Continuation<? super List<Long>> var2);

    @Query(value="\n        SELECT COUNT(*)\n          FROM UserSession\n         WHERE UserSession.usPersonUid = :personUid\n           AND UserSession.usStatus = 1\n           AND UserSession.usClientNodeId = :nodeId\n    ")
    @Nullable
    public abstract Object countActiveSessionsForUserAndNode(long var1, long var3, @NotNull Continuation<? super Integer> var5);
}

