/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.entities.Language;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0005H'J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH'J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\tH'J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\tH'J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H'J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006H'J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\tH'J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H'J\u001c\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H'J,\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010&\u001a\u00020\u0011H\u00a7@\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0018H'J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u0002H'J\u0016\u0010+\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010,\u00a8\u0006-"}, d2={"Lcom/ustadmobile/core/db/dao/LanguageDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Language;", "()V", "findAllLanguageLive", "Lkotlinx/coroutines/flow/Flow;", "", "findByName", "name", "", "findByThreeCode", "langCode", "findByTwoCode", "findByTwoCodeAsync", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUid", "primaryLanguageUid", "", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidList", "uidList", "findLanguagesAsSource", "Landroidx/paging/PagingSource;", "", "sortOrder", "searchText", "findLanguagesList", "insertListAsync", "", "languageList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replaceList", "entityList", "toggleVisibilityLanguage", "toggleVisibility", "", "selectedItem", "updateTime", "(ZLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "totalLanguageCount", "update", "entity", "updateAsync", "(Lcom/ustadmobile/lib/db/entities/Language;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class LanguageDao
implements BaseDao<Language> {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertListAsync(@NotNull List<Language> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT Language.* \n        FROM Language\n        WHERE name LIKE :searchText\n        ORDER BY CASE(:sortOrder)\n            WHEN 1 THEN Language.name \n            WHEN 3 THEN Language.iso_639_1_standard \n            WHEN 5 THEN Language.iso_639_2_standard \n            ELSE ''\n        END ASC,\n        CASE(:sortOrder)\n            WHEN 2 THEN Language.name \n            WHEN 4 THEN Language.iso_639_1_standard \n            WHEN 6 THEN Language.iso_639_2_standard \n            ELSE ''\n        END DESC\n    ")
    @NotNull
    public abstract PagingSource<Integer, Language> findLanguagesAsSource(int var1, @NotNull String var2);

    @Query(value="SELECT * FROM Language")
    @NotNull
    public abstract List<Language> findLanguagesList();

    @Query(value="SELECT * FROM Language WHERE name = :name LIMIT 1")
    @Nullable
    public abstract Language findByName(@NotNull String var1);

    @Query(value="SELECT * FROM Language WHERE iso_639_1_standard = :langCode LIMIT 1")
    @Nullable
    public abstract Language findByTwoCode(@NotNull String var1);

    @Query(value="SELECT * FROM Language WHERE iso_639_1_standard = :langCode LIMIT 1")
    @Nullable
    public abstract Object findByTwoCodeAsync(@NotNull String var1, @NotNull Continuation<? super Language> var2);

    @Query(value="SELECT * FROM LANGUAGE WHERE iso_639_3_standard = :langCode OR iso_639_2_standard = :langCode LIMIT 1 ")
    @Nullable
    public abstract Language findByThreeCode(@NotNull String var1);

    @Query(value="SELECT COUNT(*) FROM LANGUAGE")
    public abstract int totalLanguageCount();

    @Override
    @Update(entity=Object.class, onConflict=3)
    public abstract void update(@NotNull Language var1);

    @Query(value="SELECT *  FROM LANGUAGE where langUid = :primaryLanguageUid LIMIT 1")
    @Nullable
    public abstract Language findByUid(long var1);

    @Query(value="SELECT *  FROM LANGUAGE where langUid = :primaryLanguageUid LIMIT 1")
    @Nullable
    public abstract Object findByUidAsync(long var1, @NotNull Continuation<? super Language> var3);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull Language var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="SELECT * FROM LANGUAGE")
    @NotNull
    public abstract Flow<List<Language>> findAllLanguageLive();

    @Query(value="SELECT langUid FROM LANGUAGE WHERE langUid IN (:uidList)")
    @NotNull
    public abstract List<Long> findByUidList(@NotNull List<Long> var1);

    @Query(value="\n        UPDATE Language \n           SET languageActive = :toggleVisibility, \n               langLct = :updateTime\n         WHERE langUid IN (:selectedItem)")
    @Nullable
    public abstract Object toggleVisibilityLanguage(boolean var1, @NotNull List<Long> var2, long var3, @NotNull Continuation<? super Unit> var5);

    @Insert(entity=Object.class, onConflict=1)
    public abstract void replaceList(@NotNull List<Language> var1);
}

