/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH'J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH'J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u00052\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH'J\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0016\u001a\u00020\bH'J \u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u00052\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH'J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH'J$\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH'J \u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH'J\u001c\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u00a7@\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"Lcom/ustadmobile/core/db/dao/CourseAssignmentSubmissionDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseAssignmentSubmission;", "()V", "checkNoSubmissionsMade", "Lkotlinx/coroutines/flow/Flow;", "", "assignmentUid", "", "checkNoSubmissionsMadeAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkNoSubmissionsMadeFlow", "countFileSubmissionFromStudent", "", "submitterUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "countSubmissionsFromSubmitter", "doesUserHaveSubmissions", "accountPersonUid", "findByAssignmentUidAndAccountPersonUid", "", "findByUidAsFlow", "submissionUid", "findLastSubmissionFromStudent", "getAllSubmissionsForUser", "getAllSubmissionsFromSubmitter", "Landroidx/paging/PagingSource;", "getAllSubmissionsFromSubmitterAsFlow", "getLatestSubmissionForUserAsync", "getStatusOfAssignmentForSubmitter", "insertListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_debug"})
@Dao
public abstract class CourseAssignmentSubmissionDao
implements BaseDao<CourseAssignmentSubmission> {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertListAsync(@NotNull List<CourseAssignmentSubmission> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT * \n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = :assignmentUid\n           AND casSubmitterUid = :submitterUid\n      ORDER BY casTimestamp DESC\n    ")
    @NotNull
    public abstract PagingSource<Integer, CourseAssignmentSubmission> getAllSubmissionsFromSubmitter(long var1, long var3);

    @Query(value="\n         SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = :assignmentUid)\n                              AND CourseGroupMember.cgmPersonUid = :accountPersonUid\n                            LIMIT 1), -1)\n                    END\n    )\n    ")
    @NotNull
    public abstract Flow<List<CourseAssignmentSubmission>> getAllSubmissionsForUser(long var1, long var3);

    @Query(value="\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n           AND CourseAssignmentSubmission.casSubmitterUid = :submitterUid\n      ORDER BY CourseAssignmentSubmission.casTimestamp DESC      \n    ")
    @NotNull
    public abstract Flow<List<CourseAssignmentSubmission>> getAllSubmissionsFromSubmitterAsFlow(long var1, long var3);

    @Query(value="\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = :assignmentUid)\n                              AND CourseGroupMember.cgmPersonUid = :accountPersonUid\n                            LIMIT 1), -1)\n                    END\n    )\n           AND CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n      ORDER BY casTimestamp DESC\n         LIMIT 1\n    ")
    @Nullable
    public abstract Object getLatestSubmissionForUserAsync(long var1, long var3, @NotNull Continuation<? super CourseAssignmentSubmission> var5);

    @Query(value="\n        SELECT EXISTS\n               (SELECT CourseAssignmentSubmission.casUid\n                  FROM CourseAssignmentSubmission\n                 WHERE CourseAssignmentSubmission.casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = :assignmentUid)\n                              AND CourseGroupMember.cgmPersonUid = :accountPersonUid\n                            LIMIT 1), -1)\n                    END\n    )\n                   AND CourseAssignmentSubmission.casAssignmentUid = :assignmentUid)\n    ")
    @Nullable
    public abstract Object doesUserHaveSubmissions(long var1, long var3, @NotNull Continuation<? super Boolean> var5);

    @Query(value="\n        SELECT Count(casUid)\n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = :assignmentUid\n           AND casSubmitterUid = :submitterUid\n           AND casType = 2\n    ")
    @Nullable
    public abstract Object countFileSubmissionFromStudent(long var1, long var3, @NotNull Continuation<? super Integer> var5);

    @Query(value="\n        SELECT Count(casUid)\n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = :assignmentUid\n           AND casSubmitterUid = :submitterUid\n    ")
    @Nullable
    public abstract Object countSubmissionsFromSubmitter(long var1, long var3, @NotNull Continuation<? super Integer> var5);

    @Query(value="\n           SELECT COALESCE((\n                SELECT (CASE WHEN CourseAssignmentMark.camAssignmentUid IS NOT NULL \n                             THEN 2\n                             ELSE 1 \n                             END) AS status\n                  FROM CourseAssignmentSubmission\n                       \n                       LEFT JOIN CourseAssignmentMark\n                       ON CourseAssignmentMark.camAssignmentUid = :assignmentUid\n                       AND CourseAssignmentMark.camSubmitterUid = :submitterUid\n                       \n                 WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n                   AND CourseAssignmentSubmission.casSubmitterUid = :submitterUid\n                 LIMIT 1\n           ),0) AS Status\n    ")
    @NotNull
    public abstract Flow<Integer> getStatusOfAssignmentForSubmitter(long var1, long var3);

    @Query(value="\n        SELECT * \n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n           AND CourseAssignmentSubmission.casSubmitterUid = :submitterUid\n      ORDER BY casTimestamp DESC\n         LIMIT 1\n    ")
    @Nullable
    public abstract Object findLastSubmissionFromStudent(long var1, long var3, @NotNull Continuation<? super CourseAssignmentSubmission> var5);

    @Query(value="\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n                       LIMIT 1)\n    ")
    @NotNull
    public abstract Flow<Boolean> checkNoSubmissionsMade(long var1);

    @Query(value="\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n                       LIMIT 1)\n    ")
    @Nullable
    public abstract Object checkNoSubmissionsMadeAsync(long var1, @NotNull Continuation<? super Boolean> var3);

    @Query(value="\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n                       LIMIT 1)\n    ")
    @NotNull
    public abstract Flow<Boolean> checkNoSubmissionsMadeFlow(long var1);

    @Query(value="\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casUid = :submissionUid\n    ")
    @NotNull
    public abstract Flow<CourseAssignmentSubmission> findByUidAsFlow(long var1);

    @Query(value="\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n           AND CourseAssignmentSubmission.casSubmitterUid = \n               (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = :assignmentUid)\n                              AND CourseGroupMember.cgmPersonUid = :accountPersonUid\n                            LIMIT 1), -1)\n                    END\n    )\n      ORDER BY CourseAssignmentSubmission.casTimestamp DESC\n    ")
    @NotNull
    public abstract Flow<List<CourseAssignmentSubmission>> findByAssignmentUidAndAccountPersonUid(long var1, long var3);
}

