/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.PersonGroupMemberDao;
import com.ustadmobile.lib.db.entities.PersonGroupMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class PersonGroupMemberDao_Impl
extends PersonGroupMemberDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PersonGroupMember> __insertionAdapterOfPersonGroupMember;
    private final EntityDeletionOrUpdateAdapter<PersonGroupMember> __updateAdapterOfPersonGroupMember;
    private final SharedSQLiteStatement __preparedStmtOfMoveGroupAsync;
    private final SharedSQLiteStatement __preparedStmtOfUpdateGroupMemberActive;

    public PersonGroupMemberDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPersonGroupMember = new EntityInsertionAdapter<PersonGroupMember>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonGroupMember` (`groupMemberUid`,`groupMemberActive`,`groupMemberPersonUid`,`groupMemberGroupUid`,`groupMemberMasterCsn`,`groupMemberLocalCsn`,`groupMemberLastChangedBy`,`groupMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonGroupMember entity) {
                statement.bindLong(1, entity.getGroupMemberUid());
                int _tmp = entity.getGroupMemberActive() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                statement.bindLong(3, entity.getGroupMemberPersonUid());
                statement.bindLong(4, entity.getGroupMemberGroupUid());
                statement.bindLong(5, entity.getGroupMemberMasterCsn());
                statement.bindLong(6, entity.getGroupMemberLocalCsn());
                statement.bindLong(7, (long)entity.getGroupMemberLastChangedBy());
                statement.bindLong(8, entity.getGroupMemberLct());
            }
        };
        this.__updateAdapterOfPersonGroupMember = new EntityDeletionOrUpdateAdapter<PersonGroupMember>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `PersonGroupMember` SET `groupMemberUid` = ?,`groupMemberActive` = ?,`groupMemberPersonUid` = ?,`groupMemberGroupUid` = ?,`groupMemberMasterCsn` = ?,`groupMemberLocalCsn` = ?,`groupMemberLastChangedBy` = ?,`groupMemberLct` = ? WHERE `groupMemberUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonGroupMember entity) {
                statement.bindLong(1, entity.getGroupMemberUid());
                int _tmp = entity.getGroupMemberActive() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                statement.bindLong(3, entity.getGroupMemberPersonUid());
                statement.bindLong(4, entity.getGroupMemberGroupUid());
                statement.bindLong(5, entity.getGroupMemberMasterCsn());
                statement.bindLong(6, entity.getGroupMemberLocalCsn());
                statement.bindLong(7, (long)entity.getGroupMemberLastChangedBy());
                statement.bindLong(8, entity.getGroupMemberLct());
                statement.bindLong(9, entity.getGroupMemberUid());
            }
        };
        this.__preparedStmtOfMoveGroupAsync = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE PersonGroupMember \n           SET groupMemberGroupUid = ?,\n               groupMemberLct = ?\n         WHERE groupMemberPersonUid = ? \n           AND groupMemberGroupUid = ? \n           AND PersonGroupMember.groupMemberActive";
                return "\n        UPDATE PersonGroupMember \n           SET groupMemberGroupUid = ?,\n               groupMemberLct = ?\n         WHERE groupMemberPersonUid = ? \n           AND groupMemberGroupUid = ? \n           AND PersonGroupMember.groupMemberActive";
            }
        };
        this.__preparedStmtOfUpdateGroupMemberActive = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE PersonGroupMember \n           SET groupMemberActive = ?,\n               groupMemberLct = ?\n        WHERE groupMemberPersonUid = ? \n          AND groupMemberGroupUid = ? \n          AND PersonGroupMember.groupMemberActive";
                return "\n        UPDATE PersonGroupMember \n           SET groupMemberActive = ?,\n               groupMemberLct = ?\n        WHERE groupMemberPersonUid = ? \n          AND groupMemberGroupUid = ? \n          AND PersonGroupMember.groupMemberActive";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(PersonGroupMember entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfPersonGroupMember.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final PersonGroupMember entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonGroupMemberDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonGroupMemberDao_Impl.this.__insertionAdapterOfPersonGroupMember.insertAndReturnId((Object)entity);
                    PersonGroupMemberDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonGroupMemberDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends PersonGroupMember> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPersonGroupMember.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(PersonGroupMember entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPersonGroupMember.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object moveGroupAsync(final long personUid, final long newGroup, final long oldGroup, final long changeTime, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = PersonGroupMemberDao_Impl.this.__preparedStmtOfMoveGroupAsync.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, newGroup);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, personUid);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, oldGroup);
                try {
                    Integer n;
                    PersonGroupMemberDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result2 = _stmt.executeUpdateDelete();
                        PersonGroupMemberDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result2;
                    }
                    catch (Throwable throwable) {
                        PersonGroupMemberDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    PersonGroupMemberDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    PersonGroupMemberDao_Impl.this.__preparedStmtOfMoveGroupAsync.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateGroupMemberActive(final boolean activeStatus, final long personUid, final long groupUid, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PersonGroupMemberDao_Impl.this.__preparedStmtOfUpdateGroupMemberActive.acquire();
                int _argIndex = 1;
                int _tmp = activeStatus ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, personUid);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, groupUid);
                try {
                    Unit unit;
                    PersonGroupMemberDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        PersonGroupMemberDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        PersonGroupMemberDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    PersonGroupMemberDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    PersonGroupMemberDao_Impl.this.__preparedStmtOfUpdateGroupMemberActive.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllGroupWherePersonIsIn(long personUid, Continuation<? super List<PersonGroupMember>> $completion) {
        String _sql = "SELECT * FROM PersonGroupMember WHERE groupMemberPersonUid = ? AND PersonGroupMember.groupMemberActive";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PersonGroupMember WHERE groupMemberPersonUid = ? AND PersonGroupMember.groupMemberActive", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonGroupMember>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonGroupMember> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberUid");
                    int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberActive");
                    int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberPersonUid");
                    int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberGroupUid");
                    int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberMasterCsn");
                    int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLocalCsn");
                    int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLastChangedBy");
                    int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLct");
                    ArrayList<PersonGroupMember> _result2 = new ArrayList<PersonGroupMember>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonGroupMember _item = new PersonGroupMember();
                        long _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
                        _item.setGroupMemberUid(_tmpGroupMemberUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
                        boolean _tmpGroupMemberActive = _tmp != 0;
                        _item.setGroupMemberActive(_tmpGroupMemberActive);
                        long _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
                        _item.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
                        long _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
                        _item.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
                        long _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
                        _item.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
                        long _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
                        _item.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
                        int _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
                        _item.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
                        long _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
                        _item.setGroupMemberLct(_tmpGroupMemberLct);
                        _result2.add(_item);
                    }
                    ArrayList<PersonGroupMember> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object checkPersonBelongsToGroup(long groupUid, long personUid, Continuation<? super List<PersonGroupMember>> $completion) {
        String _sql = "SELECT * FROM PersonGroupMember WHERE groupMemberGroupUid = ? \n             AND groupMemberPersonUid = ? AND PersonGroupMember.groupMemberActive";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PersonGroupMember WHERE groupMemberGroupUid = ? \n             AND groupMemberPersonUid = ? AND PersonGroupMember.groupMemberActive", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, groupUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, personUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonGroupMember>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonGroupMember> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberUid");
                    int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberActive");
                    int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberPersonUid");
                    int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberGroupUid");
                    int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberMasterCsn");
                    int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLocalCsn");
                    int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLastChangedBy");
                    int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLct");
                    ArrayList<PersonGroupMember> _result2 = new ArrayList<PersonGroupMember>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonGroupMember _item = new PersonGroupMember();
                        long _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
                        _item.setGroupMemberUid(_tmpGroupMemberUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
                        boolean _tmpGroupMemberActive = _tmp != 0;
                        _item.setGroupMemberActive(_tmpGroupMemberActive);
                        long _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
                        _item.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
                        long _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
                        _item.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
                        long _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
                        _item.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
                        long _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
                        _item.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
                        int _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
                        _item.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
                        long _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
                        _item.setGroupMemberLct(_tmpGroupMemberLct);
                        _result2.add(_item);
                    }
                    ArrayList<PersonGroupMember> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByPersonUidAndGroupUid(long personUid, long groupUid, Continuation<? super PersonGroupMember> $completion) {
        String _sql = "\n        SELECT PersonGroupMember.*\n          FROM PersonGroupMember\n         WHERE PersonGroupMember.groupMemberPersonUid = ?\n           AND PersonGroupMember.groupMemberGroupUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PersonGroupMember.*\n          FROM PersonGroupMember\n         WHERE PersonGroupMember.groupMemberPersonUid = ?\n           AND PersonGroupMember.groupMemberGroupUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, groupUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonGroupMember>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonGroupMember call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonGroupMember _result2;
                    int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberUid");
                    int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberActive");
                    int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberPersonUid");
                    int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberGroupUid");
                    int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberMasterCsn");
                    int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLocalCsn");
                    int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLastChangedBy");
                    int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMemberLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new PersonGroupMember();
                        long _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
                        _result2.setGroupMemberUid(_tmpGroupMemberUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
                        boolean _tmpGroupMemberActive = _tmp != 0;
                        _result2.setGroupMemberActive(_tmpGroupMemberActive);
                        long _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
                        _result2.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
                        long _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
                        _result2.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
                        long _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
                        _result2.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
                        long _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
                        _result2.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
                        int _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
                        _result2.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
                        long _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
                        _result2.setGroupMemberLct(_tmpGroupMemberLct);
                    } else {
                        _result2 = null;
                    }
                    PersonGroupMember personGroupMember = _result2;
                    return personGroupMember;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

