/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.composites.CommentsAndName;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.Comments;
import com.ustadmobile.lib.db.entities.Person;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH'J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH'J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH'J,\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH'J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u00a7@\u00a2\u0006\u0002\u0010\u001aJ&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"Lcom/ustadmobile/core/db/dao/CommentsDao;", "", "()V", "findCourseCommentsByAssignmentUid", "Landroidx/paging/PagingSource;", "", "Lcom/ustadmobile/lib/db/composites/CommentsAndName;", "assignmentUid", "", "includeDeleted", "", "findCourseCommentsByAssignmentUidPersons", "", "Lcom/ustadmobile/lib/db/entities/Person;", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPrivateCommentsForSubmitterByAssignmentUid", "submitterUid", "findPrivateCommentsForSubmitterByAssignmentUidPersons", "Lcom/ustadmobile/lib/db/composites/PersonAndPicture;", "findPrivateCommentsForUserByAssignmentUid", "accountPersonUid", "findPrivateCommentsForUserByAssignmentUidPersons", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertAsync", "comments", "Lcom/ustadmobile/lib/db/entities/Comments;", "(Lcom/ustadmobile/lib/db/entities/Comments;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateDeletedByCommentUid", "", "uid", "deleted", "changeTime", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class CommentsDao {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertAsync(@NotNull Comments var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n        UPDATE Comments \n           SET commentsDeleted = :deleted,\n               commentsLct = :changeTime\n         WHERE Comments.commentsUid = :uid\n    ")
    @Nullable
    public abstract Object updateDeletedByCommentUid(long var1, boolean var3, long var4, @NotNull Continuation<? super Unit> var6);

    @Query(value="\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsForSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = :assignmentUid)\n                              AND CourseGroupMember.cgmPersonUid = :accountPersonUid\n                            LIMIT 1), -1)\n                    END\n    )\n           AND Comments.commentsForSubmitterUid != 0\n           AND Comments.commentsEntityUid = :assignmentUid\n           AND (CAST(Comments.commentsDeleted AS INTEGER) = 0 OR CAST(:includeDeleted AS INTEGER) = 1) \n      ORDER BY Comments.commentsDateTimeAdded DESC     \n    ")
    @NotNull
    public abstract PagingSource<Integer, CommentsAndName> findPrivateCommentsForUserByAssignmentUid(long var1, long var3, boolean var5);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT Comments.commentsFromPersonUid\n                  FROM Comments\n                 WHERE Comments.commentsForSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = :assignmentUid)\n                              AND CourseGroupMember.cgmPersonUid = :accountPersonUid\n                            LIMIT 1), -1)\n                    END\n    )\n                   AND Comments.commentsForSubmitterUid != 0\n                   AND Comments.commentsEntityUid = :assignmentUid\n                   AND CAST(Comments.commentsDeleted AS INTEGER) = 0)\n    ")
    @Nullable
    public abstract Object findPrivateCommentsForUserByAssignmentUidPersons(long var1, long var3, @NotNull Continuation<? super List<PersonAndPicture>> var5);

    @Query(value="\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsForSubmitterUid = :submitterUid\n           AND Comments.commentsEntityUid = :assignmentUid\n           AND (NOT Comments.commentsDeleted OR CAST(:includeDeleted AS INTEGER) = 1)\n      ORDER BY Comments.commentsDateTimeAdded DESC        \n    ")
    @NotNull
    public abstract PagingSource<Integer, CommentsAndName> findPrivateCommentsForSubmitterByAssignmentUid(long var1, long var3, boolean var5);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid \n         WHERE Person.personUid IN \n               (SELECT Comments.commentsFromPersonUid\n                  FROM Comments\n                 WHERE Comments.commentsForSubmitterUid = :submitterUid\n                   AND Comments.commentsEntityUid = :assignmentUid\n                   AND NOT Comments.commentsDeleted) \n    ")
    @NotNull
    public abstract List<PersonAndPicture> findPrivateCommentsForSubmitterByAssignmentUidPersons(long var1, long var3);

    @Query(value="\n        SELECT Comments.*,\n               Person.firstNames AS firstNames, \n               Person.lastName AS lastName,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM Comments\n               LEFT JOIN Person \n                    ON Person.personUid = Comments.commentsFromPersonUid\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n         WHERE Comments.commentsEntityUid = :assignmentUid\n           AND Comments.commentsForSubmitterUid = 0\n           AND (CAST(Comments.commentsDeleted AS INTEGER) = 0 OR CAST(:includeDeleted AS INTEGER) = 1)\n      ORDER BY Comments.commentsDateTimeAdded DESC     \n    ")
    @NotNull
    public abstract PagingSource<Integer, CommentsAndName> findCourseCommentsByAssignmentUid(long var1, boolean var3);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT Comments.commentsFromPersonUid\n                  FROM Comments\n                       LEFT JOIN Person \n                            ON Person.personUid = Comments.commentsFromPersonUid\n                 WHERE Comments.commentsEntityUid = :assignmentUid\n                   AND Comments.commentsForSubmitterUid = 0)\n    ")
    @Nullable
    public abstract Object findCourseCommentsByAssignmentUidPersons(long var1, @NotNull Continuation<? super List<Person>> var3);
}

