/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.composites.TransferJobAndTotals;
import com.ustadmobile.lib.db.entities.TransferJob;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH'J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00042\u0006\u0010\r\u001a\u00020\nH'J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\fH\u00a7@\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/ustadmobile/core/db/dao/TransferJobDao;", "", "()V", "findByContentEntryUidWithTotalsAsFlow", "Lkotlinx/coroutines/flow/Flow;", "", "Lcom/ustadmobile/lib/db/composites/TransferJobAndTotals;", "contentEntryUid", "", "jobType", "", "findByUid", "Lcom/ustadmobile/lib/db/entities/TransferJob;", "jobUid", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsFlow", "findJobByEntityAndTableUid", "tableId", "entityUid", "(IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findOfflineItemUidForTransferJobUid", "getJobStatus", "insert", "job", "(Lcom/ustadmobile/lib/db/entities/TransferJob;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStatus", "", "status", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStatusIfComplete", "lib-database_release"})
@Dao
public abstract class TransferJobDao {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insert(@NotNull TransferJob var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE TransferJob.tjUid = :jobUid\n    ")
    @Nullable
    public abstract Object findByUid(int var1, @NotNull Continuation<? super TransferJob> var2);

    @Query(value="\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE TransferJob.tjUid = :jobUid\n    ")
    @NotNull
    public abstract Flow<TransferJob> findByUidAsFlow(int var1);

    @Query(value="\n        UPDATE TransferJob\n           SET tjStatus = :status\n         WHERE tjUid = :jobUid  \n    ")
    @Nullable
    public abstract Object updateStatus(int var1, int var2, @NotNull Continuation<? super Unit> var3);

    @Query(value="\n        SELECT COALESCE(\n            (SELECT TransferJob.tjStatus\n               FROM TransferJob\n              WHERE tjUid = :jobUid), 0)\n    ")
    @Nullable
    public abstract Object getJobStatus(int var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="\n        UPDATE TransferJob\n           SET tjStatus = 21\n         WHERE tjUid = :jobUid\n          AND NOT EXISTS(\n              SELECT TransferJobItem.tjiUid\n                FROM TransferJobItem\n               WHERE TransferJobItem.tjiTjUid = :jobUid\n                 AND TransferJobItem.tjiStatus != 21) \n    ")
    @Nullable
    public abstract Object updateStatusIfComplete(int var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE EXISTS(\n               SELECT TransferJobItem.tjiUid\n                 FROM TransferJobItem\n                WHERE TransferJobItem.tjiTjUid = TransferJob.tjUid\n                  AND TransferJobItem.tjiTableId = :tableId\n                  AND TransferJobItem.tjiEntityUid = :entityUid) \n    ")
    @Nullable
    public abstract Object findJobByEntityAndTableUid(int var1, long var2, @NotNull Continuation<? super List<TransferJob>> var4);

    @Query(value="\n        SELECT TransferJob.*,\n               \n        (SELECT SUM(TransferJobItem.tjTotalSize)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS totalSize,\n                (SELECT SUM(TransferJobItem.tjTransferred)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS transferred \n    ,\n               TransferJobError.tjeErrorStr AS latestErrorStr\n          FROM TransferJob\n               LEFT JOIN TransferJobError\n                         ON TransferJobError.tjeId = \n                            (SELECT TransferJobError.tjeId\n                               FROM TransferJobError\n                              WHERE TransferJob.tjStatus = 22\n                                AND TransferJobError.tjeTjUid = TransferJob.tjUid\n                           ORDER BY TransferJobError.tjeDismissed DESC \n                              LIMIT 1)\n         WHERE TransferJob.tjTableId = 738\n           AND TransferJob.tjEntityUid IN \n               \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = :contentEntryUid)\n     \n           AND (   TransferJob.tjStatus < 21\n                OR (TransferJobError.tjeErrorStr IS NOT NULL AND NOT TransferJobError.tjeDismissed))\n           AND TransferJob.tjType = :jobType   \n    ")
    @NotNull
    public abstract Flow<List<TransferJobAndTotals>> findByContentEntryUidWithTotalsAsFlow(long var1, int var3);

    @Query(value="\n        SELECT COALESCE(\n               (SELECT TransferJob.tjOiUid\n                  FROM TransferJob\n                 WHERE TransferJob.tjUid = :jobUid), 0)\n    ")
    @Nullable
    public abstract Object findOfflineItemUidForTransferJobUid(int var1, @NotNull Continuation<? super Long> var2);
}

