/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CourseGroupSetDao;
import com.ustadmobile.lib.db.entities.CourseGroupSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class CourseGroupSetDao_Impl
extends CourseGroupSetDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CourseGroupSet> __insertionAdapterOfCourseGroupSet;
    private final EntityInsertionAdapter<CourseGroupSet> __insertionAdapterOfCourseGroupSet_1;
    private final EntityDeletionOrUpdateAdapter<CourseGroupSet> __updateAdapterOfCourseGroupSet;

    public CourseGroupSetDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCourseGroupSet = new EntityInsertionAdapter<CourseGroupSet>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `CourseGroupSet` (`cgsUid`,`cgsName`,`cgsTotalGroups`,`cgsActive`,`cgsClazzUid`,`cgsLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseGroupSet entity) {
                statement.bindLong(1, entity.getCgsUid());
                if (entity.getCgsName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getCgsName());
                }
                statement.bindLong(3, (long)entity.getCgsTotalGroups());
                int _tmp = entity.getCgsActive() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getCgsClazzUid());
                statement.bindLong(6, entity.getCgsLct());
            }
        };
        this.__insertionAdapterOfCourseGroupSet_1 = new EntityInsertionAdapter<CourseGroupSet>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `CourseGroupSet` (`cgsUid`,`cgsName`,`cgsTotalGroups`,`cgsActive`,`cgsClazzUid`,`cgsLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseGroupSet entity) {
                statement.bindLong(1, entity.getCgsUid());
                if (entity.getCgsName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getCgsName());
                }
                statement.bindLong(3, (long)entity.getCgsTotalGroups());
                int _tmp = entity.getCgsActive() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getCgsClazzUid());
                statement.bindLong(6, entity.getCgsLct());
            }
        };
        this.__updateAdapterOfCourseGroupSet = new EntityDeletionOrUpdateAdapter<CourseGroupSet>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `CourseGroupSet` SET `cgsUid` = ?,`cgsName` = ?,`cgsTotalGroups` = ?,`cgsActive` = ?,`cgsClazzUid` = ?,`cgsLct` = ? WHERE `cgsUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseGroupSet entity) {
                statement.bindLong(1, entity.getCgsUid());
                if (entity.getCgsName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getCgsName());
                }
                statement.bindLong(3, (long)entity.getCgsTotalGroups());
                int _tmp = entity.getCgsActive() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getCgsClazzUid());
                statement.bindLong(6, entity.getCgsLct());
                statement.bindLong(7, entity.getCgsUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(CourseGroupSet entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfCourseGroupSet.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final CourseGroupSet entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                CourseGroupSetDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = CourseGroupSetDao_Impl.this.__insertionAdapterOfCourseGroupSet.insertAndReturnId((Object)entity);
                    CourseGroupSetDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    CourseGroupSetDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends CourseGroupSet> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCourseGroupSet.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object upsertAsync(final CourseGroupSet entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseGroupSetDao_Impl.this.__db.beginTransaction();
                try {
                    CourseGroupSetDao_Impl.this.__insertionAdapterOfCourseGroupSet_1.insert((Object)entity);
                    CourseGroupSetDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseGroupSetDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(CourseGroupSet entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCourseGroupSet.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final CourseGroupSet entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                CourseGroupSetDao_Impl.this.__db.beginTransaction();
                try {
                    CourseGroupSetDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += CourseGroupSetDao_Impl.this.__updateAdapterOfCourseGroupSet.handle((Object)entity);
                    return n;
                }
                finally {
                    CourseGroupSetDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, CourseGroupSet> findAllCourseGroupSetForClazz(long clazzUid, String searchText, int sortOrder) {
        String _sql = "\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = ?\n          AND ((? = '%') OR (cgsName LIKE ?))\n     ORDER BY CASE(?)\n              WHEN 1 THEN cgsName\n              ELSE ''\n              END ASC,\n              CASE(?)\n              WHEN 2 THEN cgsName\n              ELSE ''\n              END DESC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = ?\n          AND ((? = '%') OR (cgsName LIKE ?))\n     ORDER BY CASE(?)\n              WHEN 1 THEN cgsName\n              ELSE ''\n              END ASC,\n              CASE(?)\n              WHEN 2 THEN cgsName\n              ELSE ''\n              END DESC\n    ", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 3;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<CourseGroupSet>(_statement, this.__db, new String[]{"CourseGroupSet"}){

            @NonNull
            protected List<CourseGroupSet> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cgsUid");
                int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cgsName");
                int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cgsTotalGroups");
                int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cgsActive");
                int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cgsClazzUid");
                int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cgsLct");
                ArrayList<CourseGroupSet> _result2 = new ArrayList<CourseGroupSet>(cursor.getCount());
                while (cursor.moveToNext()) {
                    CourseGroupSet _item = new CourseGroupSet();
                    long _tmpCgsUid = cursor.getLong(_cursorIndexOfCgsUid);
                    _item.setCgsUid(_tmpCgsUid);
                    String _tmpCgsName = cursor.isNull(_cursorIndexOfCgsName) ? null : cursor.getString(_cursorIndexOfCgsName);
                    _item.setCgsName(_tmpCgsName);
                    int _tmpCgsTotalGroups = cursor.getInt(_cursorIndexOfCgsTotalGroups);
                    _item.setCgsTotalGroups(_tmpCgsTotalGroups);
                    int _tmp = cursor.getInt(_cursorIndexOfCgsActive);
                    boolean _tmpCgsActive = _tmp != 0;
                    _item.setCgsActive(_tmpCgsActive);
                    long _tmpCgsClazzUid = cursor.getLong(_cursorIndexOfCgsClazzUid);
                    _item.setCgsClazzUid(_tmpCgsClazzUid);
                    long _tmpCgsLct = cursor.getLong(_cursorIndexOfCgsLct);
                    _item.setCgsLct(_tmpCgsLct);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CourseGroupSet> findAllCourseGroupSetForClazzList(long clazzUid) {
        String _sql = "\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = ?\n     ORDER BY cgsName   \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = ?\n     ORDER BY cgsName   \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsUid");
            int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsName");
            int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsTotalGroups");
            int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsActive");
            int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsClazzUid");
            int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsLct");
            ArrayList<CourseGroupSet> _result2 = new ArrayList<CourseGroupSet>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CourseGroupSet _item = new CourseGroupSet();
                long _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
                _item.setCgsUid(_tmpCgsUid);
                String _tmpCgsName = _cursor.isNull(_cursorIndexOfCgsName) ? null : _cursor.getString(_cursorIndexOfCgsName);
                _item.setCgsName(_tmpCgsName);
                int _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
                _item.setCgsTotalGroups(_tmpCgsTotalGroups);
                int _tmp = _cursor.getInt(_cursorIndexOfCgsActive);
                boolean _tmpCgsActive = _tmp != 0;
                _item.setCgsActive(_tmpCgsActive);
                long _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
                _item.setCgsClazzUid(_tmpCgsClazzUid);
                long _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
                _item.setCgsLct(_tmpCgsLct);
                _result2.add(_item);
            }
            ArrayList<CourseGroupSet> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findAllCourseGroupSetForClazzListAsync(long clazzUid, Continuation<? super List<CourseGroupSet>> $completion) {
        String _sql = "\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = ?\n     ORDER BY cgsName   \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = ?\n     ORDER BY cgsName   \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseGroupSet>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseGroupSet> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupSetDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsUid");
                    int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsName");
                    int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsTotalGroups");
                    int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsActive");
                    int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsClazzUid");
                    int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsLct");
                    ArrayList<CourseGroupSet> _result2 = new ArrayList<CourseGroupSet>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CourseGroupSet _item = new CourseGroupSet();
                        long _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
                        _item.setCgsUid(_tmpCgsUid);
                        String _tmpCgsName = _cursor.isNull(_cursorIndexOfCgsName) ? null : _cursor.getString(_cursorIndexOfCgsName);
                        _item.setCgsName(_tmpCgsName);
                        int _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
                        _item.setCgsTotalGroups(_tmpCgsTotalGroups);
                        int _tmp = _cursor.getInt(_cursorIndexOfCgsActive);
                        boolean _tmpCgsActive = _tmp != 0;
                        _item.setCgsActive(_tmpCgsActive);
                        long _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
                        _item.setCgsClazzUid(_tmpCgsClazzUid);
                        long _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
                        _item.setCgsLct(_tmpCgsLct);
                        _result2.add(_item);
                    }
                    ArrayList<CourseGroupSet> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super CourseGroupSet> $completion) {
        String _sql = "\n        SELECT * \n         FROM CourseGroupSet \n        WHERE cgsUid = ?\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n         FROM CourseGroupSet \n        WHERE cgsUid = ?\n        ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseGroupSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseGroupSet call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupSetDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseGroupSet _result2;
                    int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsUid");
                    int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsName");
                    int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsTotalGroups");
                    int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsActive");
                    int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsClazzUid");
                    int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new CourseGroupSet();
                        long _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
                        _result2.setCgsUid(_tmpCgsUid);
                        String _tmpCgsName = _cursor.isNull(_cursorIndexOfCgsName) ? null : _cursor.getString(_cursorIndexOfCgsName);
                        _result2.setCgsName(_tmpCgsName);
                        int _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
                        _result2.setCgsTotalGroups(_tmpCgsTotalGroups);
                        int _tmp = _cursor.getInt(_cursorIndexOfCgsActive);
                        boolean _tmpCgsActive = _tmp != 0;
                        _result2.setCgsActive(_tmpCgsActive);
                        long _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
                        _result2.setCgsClazzUid(_tmpCgsClazzUid);
                        long _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
                        _result2.setCgsLct(_tmpCgsLct);
                    } else {
                        _result2 = null;
                    }
                    CourseGroupSet courseGroupSet = _result2;
                    return courseGroupSet;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<CourseGroupSet> findByUidAsFlow(long uid) {
        String _sql = "\n        SELECT * \n         FROM CourseGroupSet \n        WHERE cgsUid = ?\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n         FROM CourseGroupSet \n        WHERE cgsUid = ?\n        ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseGroupSet"}, (Callable)new Callable<CourseGroupSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseGroupSet call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupSetDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CourseGroupSet _result2;
                    int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsUid");
                    int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsName");
                    int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsTotalGroups");
                    int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsActive");
                    int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsClazzUid");
                    int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgsLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new CourseGroupSet();
                        long _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
                        _result2.setCgsUid(_tmpCgsUid);
                        String _tmpCgsName = _cursor.isNull(_cursorIndexOfCgsName) ? null : _cursor.getString(_cursorIndexOfCgsName);
                        _result2.setCgsName(_tmpCgsName);
                        int _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
                        _result2.setCgsTotalGroups(_tmpCgsTotalGroups);
                        int _tmp = _cursor.getInt(_cursorIndexOfCgsActive);
                        boolean _tmpCgsActive = _tmp != 0;
                        _result2.setCgsActive(_tmpCgsActive);
                        long _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
                        _result2.setCgsClazzUid(_tmpCgsClazzUid);
                        long _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
                        _result2.setCgsLct(_tmpCgsLct);
                    } else {
                        _result2 = null;
                    }
                    CourseGroupSet courseGroupSet = _result2;
                    return courseGroupSet;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

