/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.TransferJobItemDao;
import com.ustadmobile.lib.db.entities.TransferJobItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class TransferJobItemDao_Impl
extends TransferJobItemDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<TransferJobItem> __insertionAdapterOfTransferJobItem;
    private final SharedSQLiteStatement __preparedStmtOfUpdateTransferredProgress;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;
    private final SharedSQLiteStatement __preparedStmtOfInsertOutgoingReplicationForTransferJobItemIfDone;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatusIfNotCompleteForAllInJob;

    public TransferJobItemDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTransferJobItem = new EntityInsertionAdapter<TransferJobItem>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `TransferJobItem` (`tjiUid`,`tjiTjUid`,`tjTotalSize`,`tjTransferred`,`tjAttemptCount`,`tjiSrc`,`tjiDest`,`tjiType`,`tjiStatus`,`tjiTableId`,`tjiEntityUid`,`tjiEntityEtag`,`tjiLockIdToRelease`,`tjiPartialTmpFile`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull TransferJobItem entity) {
                statement.bindLong(1, (long)entity.getTjiUid());
                statement.bindLong(2, (long)entity.getTjiTjUid());
                statement.bindLong(3, entity.getTjTotalSize());
                statement.bindLong(4, entity.getTjTransferred());
                statement.bindLong(5, (long)entity.getTjAttemptCount());
                if (entity.getTjiSrc() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getTjiSrc());
                }
                if (entity.getTjiDest() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getTjiDest());
                }
                statement.bindLong(8, (long)entity.getTjiType());
                statement.bindLong(9, (long)entity.getTjiStatus());
                statement.bindLong(10, (long)entity.getTjiTableId());
                statement.bindLong(11, entity.getTjiEntityUid());
                statement.bindLong(12, entity.getTjiEntityEtag());
                statement.bindLong(13, entity.getTjiLockIdToRelease());
                if (entity.getTjiPartialTmpFile() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getTjiPartialTmpFile());
                }
            }
        };
        this.__preparedStmtOfUpdateTransferredProgress = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE TransferJobItem\n           SET tjTransferred = ?\n         WHERE tjiUid = ?\n    ";
                return "\n        UPDATE TransferJobItem\n           SET tjTransferred = ?\n         WHERE tjiUid = ?\n    ";
            }
        };
        this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE TransferJobItem\n           SET tjiStatus = ?\n         WHERE tjiUid = ?  \n    ";
                return "\n        UPDATE TransferJobItem\n           SET tjiStatus = ?\n         WHERE tjiUid = ?  \n    ";
            }
        };
        this.__preparedStmtOfInsertOutgoingReplicationForTransferJobItemIfDone = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        INSERT INTO OutgoingReplication(destNodeId, orTableId, orPk1, orPk2)\n        SELECT ? AS destNodeId, \n              TransferJobItem.tjiTableId AS orTableId,\n              TransferJobItem.tjiEntityUid AS orPk1,\n              0 AS orPk2\n        FROM TransferJobItem\n       WHERE TransferJobItem.tjiUid = ?\n         AND TransferJobItem.tjiTableId != 0\n         AND TransferJobItem.tjiStatus = 21\n         AND NOT EXISTS(\n             SELECT OtherJob.tjiUid\n               FROM TransferJobItem OtherJob\n              WHERE OtherJob.tjiTableId = TransferJobItem.tjiTableId\n                AND OtherJob.tjiEntityUid = TransferJobItem.tjiEntityUid\n                AND OtherJob.tjiEntityEtag = TransferJobItem.tjiEntityEtag\n                AND OtherJob.tjiStatus != 21)\n    ";
                return "\n        INSERT INTO OutgoingReplication(destNodeId, orTableId, orPk1, orPk2)\n        SELECT ? AS destNodeId, \n              TransferJobItem.tjiTableId AS orTableId,\n              TransferJobItem.tjiEntityUid AS orPk1,\n              0 AS orPk2\n        FROM TransferJobItem\n       WHERE TransferJobItem.tjiUid = ?\n         AND TransferJobItem.tjiTableId != 0\n         AND TransferJobItem.tjiStatus = 21\n         AND NOT EXISTS(\n             SELECT OtherJob.tjiUid\n               FROM TransferJobItem OtherJob\n              WHERE OtherJob.tjiTableId = TransferJobItem.tjiTableId\n                AND OtherJob.tjiEntityUid = TransferJobItem.tjiEntityUid\n                AND OtherJob.tjiEntityEtag = TransferJobItem.tjiEntityEtag\n                AND OtherJob.tjiStatus != 21)\n    ";
            }
        };
        this.__preparedStmtOfUpdateStatusIfNotCompleteForAllInJob = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE TransferJobItem\n           SET tjiStatus = ?\n         WHERE tjiTjUid = ?\n           AND tjiStatus != 21 \n    ";
                return "\n        UPDATE TransferJobItem\n           SET tjiStatus = ?\n         WHERE tjiTjUid = ?\n           AND tjiStatus != 21 \n    ";
            }
        };
    }

    @Override
    public Object insertList(final List<TransferJobItem> items, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                TransferJobItemDao_Impl.this.__db.beginTransaction();
                try {
                    TransferJobItemDao_Impl.this.__insertionAdapterOfTransferJobItem.insert((Iterable)items);
                    TransferJobItemDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TransferJobItemDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insert(final TransferJobItem item, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                TransferJobItemDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = TransferJobItemDao_Impl.this.__insertionAdapterOfTransferJobItem.insertAndReturnId((Object)item);
                    TransferJobItemDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    TransferJobItemDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateTransferredProgress(final int jobItemUid, final long transferred, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TransferJobItemDao_Impl.this.__preparedStmtOfUpdateTransferredProgress.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, transferred);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)jobItemUid);
                try {
                    Unit unit;
                    TransferJobItemDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        TransferJobItemDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        TransferJobItemDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    TransferJobItemDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    TransferJobItemDao_Impl.this.__preparedStmtOfUpdateTransferredProgress.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateStatus(final int jobItemUid, final int status, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TransferJobItemDao_Impl.this.__preparedStmtOfUpdateStatus.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)status);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)jobItemUid);
                try {
                    Unit unit;
                    TransferJobItemDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        TransferJobItemDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        TransferJobItemDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    TransferJobItemDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    TransferJobItemDao_Impl.this.__preparedStmtOfUpdateStatus.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object insertOutgoingReplicationForTransferJobItemIfDone(final long destNodeId, final int transferJobItemUid, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TransferJobItemDao_Impl.this.__preparedStmtOfInsertOutgoingReplicationForTransferJobItemIfDone.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, destNodeId);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)transferJobItemUid);
                try {
                    Unit unit;
                    TransferJobItemDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeInsert();
                        TransferJobItemDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        TransferJobItemDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    TransferJobItemDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    TransferJobItemDao_Impl.this.__preparedStmtOfInsertOutgoingReplicationForTransferJobItemIfDone.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateStatusIfNotCompleteForAllInJob(final int jobUid, final int status, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TransferJobItemDao_Impl.this.__preparedStmtOfUpdateStatusIfNotCompleteForAllInJob.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)status);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)jobUid);
                try {
                    Unit unit;
                    TransferJobItemDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        TransferJobItemDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        TransferJobItemDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    TransferJobItemDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    TransferJobItemDao_Impl.this.__preparedStmtOfUpdateStatusIfNotCompleteForAllInJob.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByJobUid(int jobUid, Continuation<? super List<TransferJobItem>> $completion) {
        String _sql = "\n        SELECT TransferJobItem.*\n          FROM TransferJobItem\n         WHERE TransferJobItem.tjiTjUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT TransferJobItem.*\n          FROM TransferJobItem\n         WHERE TransferJobItem.tjiTjUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)jobUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<TransferJobItem>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<TransferJobItem> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobItemDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiUid");
                    int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTjUid");
                    int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTotalSize");
                    int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTransferred");
                    int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjAttemptCount");
                    int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiSrc");
                    int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiDest");
                    int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiType");
                    int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiStatus");
                    int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTableId");
                    int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityUid");
                    int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityEtag");
                    int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiLockIdToRelease");
                    int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiPartialTmpFile");
                    ArrayList<TransferJobItem> _result2 = new ArrayList<TransferJobItem>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
                        int _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
                        long _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
                        long _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
                        int _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
                        String _tmpTjiSrc = _cursor.isNull(_cursorIndexOfTjiSrc) ? null : _cursor.getString(_cursorIndexOfTjiSrc);
                        String _tmpTjiDest = _cursor.isNull(_cursorIndexOfTjiDest) ? null : _cursor.getString(_cursorIndexOfTjiDest);
                        int _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
                        int _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
                        int _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
                        long _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
                        long _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
                        long _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
                        String _tmpTjiPartialTmpFile = _cursor.isNull(_cursorIndexOfTjiPartialTmpFile) ? null : _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
                        TransferJobItem _item = new TransferJobItem(_tmpTjiUid, _tmpTjiTjUid, _tmpTjTotalSize, _tmpTjTransferred, _tmpTjAttemptCount, _tmpTjiSrc, _tmpTjiDest, _tmpTjiType, _tmpTjiStatus, _tmpTjiTableId, _tmpTjiEntityUid, _tmpTjiEntityEtag, _tmpTjiLockIdToRelease, _tmpTjiPartialTmpFile);
                        _result2.add(_item);
                    }
                    ArrayList<TransferJobItem> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findPendingByJobUid(int jobUid, Continuation<? super List<TransferJobItem>> $completion) {
        String _sql = "\n        SELECT TransferJobItem.*\n          FROM TransferJobItem\n         WHERE TransferJobItem.tjiTjUid = ?\n           AND TransferJobItem.tjiStatus < 21\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT TransferJobItem.*\n          FROM TransferJobItem\n         WHERE TransferJobItem.tjiTjUid = ?\n           AND TransferJobItem.tjiStatus < 21\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)jobUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<TransferJobItem>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<TransferJobItem> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobItemDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiUid");
                    int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTjUid");
                    int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTotalSize");
                    int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTransferred");
                    int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjAttemptCount");
                    int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiSrc");
                    int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiDest");
                    int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiType");
                    int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiStatus");
                    int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTableId");
                    int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityUid");
                    int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityEtag");
                    int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiLockIdToRelease");
                    int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiPartialTmpFile");
                    ArrayList<TransferJobItem> _result2 = new ArrayList<TransferJobItem>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
                        int _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
                        long _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
                        long _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
                        int _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
                        String _tmpTjiSrc = _cursor.isNull(_cursorIndexOfTjiSrc) ? null : _cursor.getString(_cursorIndexOfTjiSrc);
                        String _tmpTjiDest = _cursor.isNull(_cursorIndexOfTjiDest) ? null : _cursor.getString(_cursorIndexOfTjiDest);
                        int _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
                        int _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
                        int _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
                        long _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
                        long _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
                        long _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
                        String _tmpTjiPartialTmpFile = _cursor.isNull(_cursorIndexOfTjiPartialTmpFile) ? null : _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
                        TransferJobItem _item = new TransferJobItem(_tmpTjiUid, _tmpTjiTjUid, _tmpTjTotalSize, _tmpTjTransferred, _tmpTjAttemptCount, _tmpTjiSrc, _tmpTjiDest, _tmpTjiType, _tmpTjiStatus, _tmpTjiTableId, _tmpTjiEntityUid, _tmpTjiEntityEtag, _tmpTjiLockIdToRelease, _tmpTjiPartialTmpFile);
                        _result2.add(_item);
                    }
                    ArrayList<TransferJobItem> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findNumberJobItemsNotComplete(int jobUid, Continuation<? super Integer> $completion) {
        String _sql = "\n       SELECT COUNT(*)\n         FROM TransferJobItem\n        WHERE TransferJobItem.tjiTjUid = ?\n          AND TransferjobItem.tjiStatus != 21\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n       SELECT COUNT(*)\n         FROM TransferJobItem\n        WHERE TransferJobItem.tjiTjUid = ?\n          AND TransferjobItem.tjiStatus != 21\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)jobUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobItemDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<TransferJobItem>> findByEntityUidList(List<Long> entityUidList, int tableId) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT TransferJobItem.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM TransferJobItem");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE TransferJobItem.tjiTableId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND TransferJobItem.tjiEntityUid IN (");
        int _inputSize = entityUidList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)tableId);
        _argIndex = 2;
        for (long _item : entityUidList) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"TransferJobItem"}, (Callable)new Callable<List<TransferJobItem>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<TransferJobItem> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobItemDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiUid");
                    int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTjUid");
                    int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTotalSize");
                    int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTransferred");
                    int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjAttemptCount");
                    int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiSrc");
                    int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiDest");
                    int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiType");
                    int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiStatus");
                    int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTableId");
                    int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityUid");
                    int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityEtag");
                    int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiLockIdToRelease");
                    int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiPartialTmpFile");
                    ArrayList<TransferJobItem> _result2 = new ArrayList<TransferJobItem>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
                        int _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
                        long _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
                        long _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
                        int _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
                        String _tmpTjiSrc = _cursor.isNull(_cursorIndexOfTjiSrc) ? null : _cursor.getString(_cursorIndexOfTjiSrc);
                        String _tmpTjiDest = _cursor.isNull(_cursorIndexOfTjiDest) ? null : _cursor.getString(_cursorIndexOfTjiDest);
                        int _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
                        int _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
                        int _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
                        long _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
                        long _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
                        long _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
                        String _tmpTjiPartialTmpFile = _cursor.isNull(_cursorIndexOfTjiPartialTmpFile) ? null : _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
                        TransferJobItem _item_1 = new TransferJobItem(_tmpTjiUid, _tmpTjiTjUid, _tmpTjTotalSize, _tmpTjTransferred, _tmpTjAttemptCount, _tmpTjiSrc, _tmpTjiDest, _tmpTjiType, _tmpTjiStatus, _tmpTjiTableId, _tmpTjiEntityUid, _tmpTjiEntityEtag, _tmpTjiLockIdToRelease, _tmpTjiPartialTmpFile);
                        _result2.add(_item_1);
                    }
                    ArrayList<TransferJobItem> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

