/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.StatementDao;
import com.ustadmobile.lib.db.composites.BlockStatus;
import com.ustadmobile.lib.db.composites.PersonAndPictureAndNumAttempts;
import com.ustadmobile.lib.db.composites.StatementReportRow;
import com.ustadmobile.lib.db.composites.xapi.SessionTimeAndProgressInfo;
import com.ustadmobile.lib.db.composites.xapi.StatementAndActivity;
import com.ustadmobile.lib.db.composites.xapi.StatementEntityAndRelated;
import com.ustadmobile.lib.db.composites.xapi.StatementEntityAndVerb;
import com.ustadmobile.lib.db.composites.xapi.VerbEntityAndName;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import com.ustadmobile.lib.db.entities.StatementEntityAndDisplayDetails;
import com.ustadmobile.lib.db.entities.StatementReportData;
import com.ustadmobile.lib.db.entities.xapi.ActivityEntity;
import com.ustadmobile.lib.db.entities.xapi.ActivityLangMapEntry;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import com.ustadmobile.lib.db.entities.xapi.GroupMemberActorJoin;
import com.ustadmobile.lib.db.entities.xapi.StatementEntity;
import com.ustadmobile.lib.db.entities.xapi.VerbEntity;
import com.ustadmobile.lib.db.entities.xapi.VerbLangMapEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class StatementDao_Impl
extends StatementDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<StatementEntity> __insertionAdapterOfStatementEntity;

    public StatementDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfStatementEntity = new EntityInsertionAdapter<StatementEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `StatementEntity` (`statementIdHi`,`statementIdLo`,`statementActorPersonUid`,`statementVerbUid`,`statementObjectType`,`statementObjectUid1`,`statementObjectUid2`,`statementActorUid`,`authorityActorUid`,`teamUid`,`resultCompletion`,`resultSuccess`,`resultScoreScaled`,`resultScoreRaw`,`resultScoreMin`,`resultScoreMax`,`resultDuration`,`resultResponse`,`timestamp`,`stored`,`contextRegistrationHi`,`contextRegistrationLo`,`contextRegistrationHash`,`contextPlatform`,`contextStatementRefIdHi`,`contextStatementRefIdLo`,`contextInstructorActorUid`,`statementLct`,`extensionProgress`,`completionOrProgress`,`statementContentEntryUid`,`statementLearnerGroupUid`,`statementClazzUid`,`statementCbUid`,`statementDoorNode`,`isSubStatement`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull StatementEntity entity) {
                Integer _tmp_1;
                Integer _tmp;
                statement.bindLong(1, entity.getStatementIdHi());
                statement.bindLong(2, entity.getStatementIdLo());
                statement.bindLong(3, entity.getStatementActorPersonUid());
                statement.bindLong(4, entity.getStatementVerbUid());
                statement.bindLong(5, (long)entity.getStatementObjectType());
                statement.bindLong(6, entity.getStatementObjectUid1());
                statement.bindLong(7, entity.getStatementObjectUid2());
                statement.bindLong(8, entity.getStatementActorUid());
                statement.bindLong(9, entity.getAuthorityActorUid());
                statement.bindLong(10, entity.getTeamUid());
                Integer n = entity.getResultCompletion() == null ? null : (_tmp = Integer.valueOf(entity.getResultCompletion() != false ? 1 : 0));
                if (_tmp == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindLong(11, (long)_tmp.intValue());
                }
                Integer n2 = entity.getResultSuccess() == null ? null : (_tmp_1 = Integer.valueOf(entity.getResultSuccess() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindLong(12, (long)_tmp_1.intValue());
                }
                if (entity.getResultScoreScaled() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindDouble(13, (double)entity.getResultScoreScaled().floatValue());
                }
                if (entity.getResultScoreRaw() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindDouble(14, (double)entity.getResultScoreRaw().floatValue());
                }
                if (entity.getResultScoreMin() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindDouble(15, (double)entity.getResultScoreMin().floatValue());
                }
                if (entity.getResultScoreMax() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindDouble(16, (double)entity.getResultScoreMax().floatValue());
                }
                if (entity.getResultDuration() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindLong(17, entity.getResultDuration().longValue());
                }
                if (entity.getResultResponse() == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindString(18, entity.getResultResponse());
                }
                statement.bindLong(19, entity.getTimestamp());
                statement.bindLong(20, entity.getStored());
                statement.bindLong(21, entity.getContextRegistrationHi());
                statement.bindLong(22, entity.getContextRegistrationLo());
                statement.bindLong(23, entity.getContextRegistrationHash());
                if (entity.getContextPlatform() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindString(24, entity.getContextPlatform());
                }
                statement.bindLong(25, entity.getContextStatementRefIdHi());
                statement.bindLong(26, entity.getContextStatementRefIdLo());
                statement.bindLong(27, entity.getContextInstructorActorUid());
                statement.bindLong(28, entity.getStatementLct());
                if (entity.getExtensionProgress() == null) {
                    statement.bindNull(29);
                } else {
                    statement.bindLong(29, (long)entity.getExtensionProgress().intValue());
                }
                int _tmp_2 = entity.getCompletionOrProgress() ? 1 : 0;
                statement.bindLong(30, (long)_tmp_2);
                statement.bindLong(31, entity.getStatementContentEntryUid());
                statement.bindLong(32, entity.getStatementLearnerGroupUid());
                statement.bindLong(33, entity.getStatementClazzUid());
                statement.bindLong(34, entity.getStatementCbUid());
                statement.bindLong(35, entity.getStatementDoorNode());
                int _tmp_3 = entity.isSubStatement() ? 1 : 0;
                statement.bindLong(36, (long)_tmp_3);
            }
        };
    }

    @Override
    public Object insertOrIgnoreListAsync(final List<StatementEntity> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                StatementDao_Impl.this.__db.beginTransaction();
                try {
                    StatementDao_Impl.this.__insertionAdapterOfStatementEntity.insert((Iterable)entityList);
                    StatementDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    StatementDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<StatementEntity> getOneStatement() {
        String _sql = "SELECT * From StatementEntity LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * From StatementEntity LIMIT 1", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"StatementEntity"}, (Callable)new Callable<StatementEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public StatementEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    StatementEntity _result2;
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    if (_cursor.moveToFirst()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        _result2 = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                    } else {
                        _result2 = null;
                    }
                    StatementEntity statementEntity = _result2;
                    return statementEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Person getPerson() {
        String _sql = "SELECT * FROM PERSON LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PERSON LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Person _result2;
            int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
            int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
            int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
            int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
            int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
            int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
            int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
            int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
            int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
            int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
            int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
            int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
            int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
            int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
            int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
            int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
            int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
            int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
            int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
            int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
            int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
            int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
            int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
            if (_cursor.moveToFirst()) {
                long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                int _tmp = _cursor.getInt(_cursorIndexOfActive);
                boolean _tmpActive = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                boolean _tmpAdmin = _tmp_2 != 0;
                String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
            } else {
                _result2 = null;
            }
            Person person = _result2;
            return person;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object getStatements(long statementIdHi, long statementIdLo, Continuation<? super List<StatementEntity>> $completion) {
        String _sql = "\n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE (    (? = 0 AND ? = 0) \n                 OR (statementIdHi = ? AND statementIdLo = ?))\n                  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE (    (? = 0 AND ? = 0) \n                 OR (statementIdHi = ? AND statementIdLo = ?))\n                  \n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, statementIdHi);
        _argIndex = 2;
        _statement.bindLong(_argIndex, statementIdLo);
        _argIndex = 3;
        _statement.bindLong(_argIndex, statementIdHi);
        _argIndex = 4;
        _statement.bindLong(_argIndex, statementIdLo);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    ArrayList<StatementEntity> _result2 = new ArrayList<StatementEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        StatementEntity _item = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findById(long statementIdHi, long statementIdLo, Continuation<? super StatementEntity> $completion) {
        String _sql = "\n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE statementIdHi = ? \n           AND statementIdLo = ?       \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE statementIdHi = ? \n           AND statementIdLo = ?       \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, statementIdHi);
        _argIndex = 2;
        _statement.bindLong(_argIndex, statementIdLo);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<StatementEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public StatementEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    StatementEntity _result2;
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    if (_cursor.moveToFirst()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        _result2 = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                    } else {
                        _result2 = null;
                    }
                    StatementEntity statementEntity = _result2;
                    return statementEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findStatusStatementsByContentEntryUid(long contentEntryUid, long courseBlockUid, long accountPersonUid, Continuation<? super List<StatementEntity>> $completion) {
        String _sql = "\n        SELECT StatementEntity.*\n               \n            \n          FROM StatementEntity\n         WHERE StatementEntity.statementActorPersonUid = ?\n           AND StatementEntity.statementContentEntryUid = ?\n           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n           AND (? = 0 OR StatementEntity.statementCbUid = ?)\n    \n        AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n              OR (StatementEntity.extensionProgress IS NOT NULL))\n        \n        \n    \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StatementEntity.*\n               \n            \n          FROM StatementEntity\n         WHERE StatementEntity.statementActorPersonUid = ?\n           AND StatementEntity.statementContentEntryUid = ?\n           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n           AND (? = 0 OR StatementEntity.statementCbUid = ?)\n    \n        AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n              OR (StatementEntity.extensionProgress IS NOT NULL))\n        \n        \n    \n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, courseBlockUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, courseBlockUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    ArrayList<StatementEntity> _result2 = new ArrayList<StatementEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        StatementEntity _item = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findStatusStatementByParentContentEntryUid(long parentUid, long accountPersonUid, Continuation<? super List<StatementEntity>> $completion) {
        String _sql = "\n        SELECT StatementEntity.*\n               \n        FROM StatementEntity\n       WHERE StatementEntity.statementActorPersonUid = ?\n         AND StatementEntity.statementContentEntryUid IN (\n             SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n               FROM ContentEntryParentChildJoin\n              WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?)\n         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n         AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n              OR (StatementEntity.extensionProgress IS NOT NULL))     \n    \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StatementEntity.*\n               \n        FROM StatementEntity\n       WHERE StatementEntity.statementActorPersonUid = ?\n         AND StatementEntity.statementContentEntryUid IN (\n             SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n               FROM ContentEntryParentChildJoin\n              WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?)\n         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n         AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n              OR (StatementEntity.extensionProgress IS NOT NULL))     \n    \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, parentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    ArrayList<StatementEntity> _result2 = new ArrayList<StatementEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        StatementEntity _item = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findStatusStatementsForStudentByClazzUid(long clazzUid, long accountPersonUid, Continuation<? super List<StatementEntity>> $completion) {
        String _sql = "\n        WITH PersonUids(personUid) AS (\n            SELECT ? AS personUid\n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n        \n        SELECT StatementEntity.*\n               \n               FROM StatementEntity\n              WHERE (\n        (SELECT EXISTS(\n                SELECT 1\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                   AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n    )\n                AND StatementEntity.statementActorUid IN (\n                    SELECT ActorUidsForPersonUid.actorUid\n                      FROM ActorUidsForPersonUid)\n                AND StatementEntity.statementClazzUid = ?\n                AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n                      OR (StatementEntity.extensionProgress IS NOT NULL))\n    \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH PersonUids(personUid) AS (\n            SELECT ? AS personUid\n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n        \n        SELECT StatementEntity.*\n               \n               FROM StatementEntity\n              WHERE (\n        (SELECT EXISTS(\n                SELECT 1\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                   AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n    )\n                AND StatementEntity.statementActorUid IN (\n                    SELECT ActorUidsForPersonUid.actorUid\n                      FROM ActorUidsForPersonUid)\n                AND StatementEntity.statementClazzUid = ?\n                AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n                      OR (StatementEntity.extensionProgress IS NOT NULL))\n    \n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    ArrayList<StatementEntity> _result2 = new ArrayList<StatementEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        StatementEntity _item = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findStatusForStudentsInClazzStatements(long clazzUid, int roleId, int sortOrder, String searchText, int filter, long accountPersonUid, long currentTime, int studentsLimit, int studentsOffset, boolean completionOrProgressTrueVal, Continuation<? super List<StatementEntityAndRelated>> $completion) {
        String _sql = "\n        -- Get the PersonUids for those that are within the current page as per studentsLimit and \n        -- studentsOffset\n        WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n                               AND (? != 1 \n                                     OR (? \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = ?\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(?)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(?)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(?)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(?)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT ?\n            OFFSET ?   \n         )\n    ,\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n\n        \n        -- Fetch all statements that could be completion or progress for the Gradebook report\n        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*\n          FROM StatementEntity\n               JOIN ActorEntity\n                    ON ActorEntity.actorUid = StatementEntity.statementActorUid\n               LEFT JOIN GroupMemberActorJoin\n                    ON ActorEntity.actorObjectType = 2\n                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                       AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                           SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                             FROM ActorUidsForPersonUid)\n         WHERE StatementEntity.statementClazzUid = ?\n           AND StatementEntity.completionOrProgress = ?\n           AND StatementEntity.statementActorUid IN (\n               SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                 FROM ActorUidsForPersonUid) \n           AND (      StatementEntity.resultScoreScaled IS NOT NULL\n                   OR StatementEntity.resultCompletion IS NOT NULL\n                   OR StatementEntity.resultSuccess IS NOT NULL\n                   OR StatementEntity.extensionProgress IS NOT NULL \n               )\n    \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        -- Get the PersonUids for those that are within the current page as per studentsLimit and \n        -- studentsOffset\n        WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n                               AND (? != 1 \n                                     OR (? \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = ?\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(?)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(?)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(?)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(?)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT ?\n            OFFSET ?   \n         )\n    ,\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n\n        \n        -- Fetch all statements that could be completion or progress for the Gradebook report\n        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*\n          FROM StatementEntity\n               JOIN ActorEntity\n                    ON ActorEntity.actorUid = StatementEntity.statementActorUid\n               LEFT JOIN GroupMemberActorJoin\n                    ON ActorEntity.actorObjectType = 2\n                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                       AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                           SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                             FROM ActorUidsForPersonUid)\n         WHERE StatementEntity.statementClazzUid = ?\n           AND StatementEntity.completionOrProgress = ?\n           AND StatementEntity.statementActorUid IN (\n               SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                 FROM ActorUidsForPersonUid) \n           AND (      StatementEntity.resultScoreScaled IS NOT NULL\n                   OR StatementEntity.resultCompletion IS NOT NULL\n                   OR StatementEntity.resultSuccess IS NOT NULL\n                   OR StatementEntity.extensionProgress IS NOT NULL \n               )\n    \n    ", (int)21);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)roleId);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)filter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 14;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 15;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 16;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 17;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 18;
        _statement.bindLong(_argIndex, (long)studentsLimit);
        _argIndex = 19;
        _statement.bindLong(_argIndex, (long)studentsOffset);
        _argIndex = 20;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 21;
        int _tmp = completionOrProgressTrueVal ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntityAndRelated>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntityAndRelated> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorUid");
                    int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorPersonUid");
                    int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorName");
                    int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox");
                    int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox_sha1sum");
                    int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorOpenid");
                    int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountName");
                    int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountHomePage");
                    int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorEtag");
                    int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorLct");
                    int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorObjectType");
                    int _cursorIndexOfGmajGroupActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gmajGroupActorUid");
                    int _cursorIndexOfGmajMemberActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gmajMemberActorUid");
                    int _cursorIndexOfGmajLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gmajLastMod");
                    ArrayList<StatementEntityAndRelated> _result2 = new ArrayList<StatementEntityAndRelated>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        GroupMemberActorJoin _tmpGroupMemberActorJoin;
                        ActorEntity _tmpActorEntity;
                        StatementEntity _tmpStatementEntity;
                        if (!(_cursor.isNull(_cursorIndexOfStatementIdHi) && _cursor.isNull(_cursorIndexOfStatementIdLo) && _cursor.isNull(_cursorIndexOfStatementActorPersonUid) && _cursor.isNull(_cursorIndexOfStatementVerbUid) && _cursor.isNull(_cursorIndexOfStatementObjectType) && _cursor.isNull(_cursorIndexOfStatementObjectUid1) && _cursor.isNull(_cursorIndexOfStatementObjectUid2) && _cursor.isNull(_cursorIndexOfStatementActorUid) && _cursor.isNull(_cursorIndexOfAuthorityActorUid) && _cursor.isNull(_cursorIndexOfTeamUid) && _cursor.isNull(_cursorIndexOfResultCompletion) && _cursor.isNull(_cursorIndexOfResultSuccess) && _cursor.isNull(_cursorIndexOfResultScoreScaled) && _cursor.isNull(_cursorIndexOfResultScoreRaw) && _cursor.isNull(_cursorIndexOfResultScoreMin) && _cursor.isNull(_cursorIndexOfResultScoreMax) && _cursor.isNull(_cursorIndexOfResultDuration) && _cursor.isNull(_cursorIndexOfResultResponse) && _cursor.isNull(_cursorIndexOfTimestamp) && _cursor.isNull(_cursorIndexOfStored) && _cursor.isNull(_cursorIndexOfContextRegistrationHi) && _cursor.isNull(_cursorIndexOfContextRegistrationLo) && _cursor.isNull(_cursorIndexOfContextRegistrationHash) && _cursor.isNull(_cursorIndexOfContextPlatform) && _cursor.isNull(_cursorIndexOfContextStatementRefIdHi) && _cursor.isNull(_cursorIndexOfContextStatementRefIdLo) && _cursor.isNull(_cursorIndexOfContextInstructorActorUid) && _cursor.isNull(_cursorIndexOfStatementLct) && _cursor.isNull(_cursorIndexOfExtensionProgress) && _cursor.isNull(_cursorIndexOfCompletionOrProgress) && _cursor.isNull(_cursorIndexOfStatementContentEntryUid) && _cursor.isNull(_cursorIndexOfStatementLearnerGroupUid) && _cursor.isNull(_cursorIndexOfStatementClazzUid) && _cursor.isNull(_cursorIndexOfStatementCbUid) && _cursor.isNull(_cursorIndexOfStatementDoorNode) && _cursor.isNull(_cursorIndexOfIsSubStatement))) {
                            long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                            long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                            long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                            long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                            int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                            long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                            long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                            long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                            long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                            long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                            Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                            Boolean _tmpResultCompletion = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                            Integer _tmp_2 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                            Boolean _tmpResultSuccess = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                            Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                            Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                            Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                            Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                            Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                            String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                            long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                            long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                            long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                            long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                            long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                            String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                            long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                            long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                            long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                            long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                            Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                            boolean _tmpCompletionOrProgress = _tmp_3 != 0;
                            long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                            long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                            long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                            long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                            long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                            boolean _tmpIsSubStatement = _tmp_4 != 0;
                            _tmpStatementEntity = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        } else {
                            _tmpStatementEntity = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfActorUid) && _cursor.isNull(_cursorIndexOfActorPersonUid) && _cursor.isNull(_cursorIndexOfActorName) && _cursor.isNull(_cursorIndexOfActorMbox) && _cursor.isNull(_cursorIndexOfActorMboxSha1sum) && _cursor.isNull(_cursorIndexOfActorOpenid) && _cursor.isNull(_cursorIndexOfActorAccountName) && _cursor.isNull(_cursorIndexOfActorAccountHomePage) && _cursor.isNull(_cursorIndexOfActorEtag) && _cursor.isNull(_cursorIndexOfActorLct) && _cursor.isNull(_cursorIndexOfActorObjectType))) {
                            long _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
                            long _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
                            String _tmpActorName = _cursor.isNull(_cursorIndexOfActorName) ? null : _cursor.getString(_cursorIndexOfActorName);
                            String _tmpActorMbox = _cursor.isNull(_cursorIndexOfActorMbox) ? null : _cursor.getString(_cursorIndexOfActorMbox);
                            String _tmpActorMbox_sha1sum = _cursor.isNull(_cursorIndexOfActorMboxSha1sum) ? null : _cursor.getString(_cursorIndexOfActorMboxSha1sum);
                            String _tmpActorOpenid = _cursor.isNull(_cursorIndexOfActorOpenid) ? null : _cursor.getString(_cursorIndexOfActorOpenid);
                            String _tmpActorAccountName = _cursor.isNull(_cursorIndexOfActorAccountName) ? null : _cursor.getString(_cursorIndexOfActorAccountName);
                            String _tmpActorAccountHomePage = _cursor.isNull(_cursorIndexOfActorAccountHomePage) ? null : _cursor.getString(_cursorIndexOfActorAccountHomePage);
                            long _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
                            long _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
                            int _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
                            _tmpActorEntity = new ActorEntity(_tmpActorUid, _tmpActorPersonUid, _tmpActorName, _tmpActorMbox, _tmpActorMbox_sha1sum, _tmpActorOpenid, _tmpActorAccountName, _tmpActorAccountHomePage, _tmpActorEtag, _tmpActorLct, _tmpActorObjectType);
                        } else {
                            _tmpActorEntity = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfGmajGroupActorUid) && _cursor.isNull(_cursorIndexOfGmajMemberActorUid) && _cursor.isNull(_cursorIndexOfGmajLastMod))) {
                            long _tmpGmajGroupActorUid = _cursor.getLong(_cursorIndexOfGmajGroupActorUid);
                            long _tmpGmajMemberActorUid = _cursor.getLong(_cursorIndexOfGmajMemberActorUid);
                            long _tmpGmajLastMod = _cursor.getLong(_cursorIndexOfGmajLastMod);
                            _tmpGroupMemberActorJoin = new GroupMemberActorJoin(_tmpGmajGroupActorUid, _tmpGmajMemberActorUid, _tmpGmajLastMod);
                        } else {
                            _tmpGroupMemberActorJoin = null;
                        }
                        StatementEntityAndRelated _item = new StatementEntityAndRelated(_tmpStatementEntity, _tmpGroupMemberActorJoin, _tmpActorEntity);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntityAndRelated> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findStatusForStudentsInClazzByUidList(long clazzUid, List<Long> studentPersonUids, boolean completionOrProgressTrueVal, Continuation<? super List<StatementEntityAndRelated>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        WITH PersonUids(personUid) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT Person.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE Person.personUid IN (");
        int _inputSize = studentPersonUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ),");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT ActorEntity.actorUid AS actorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ActorEntity.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE ActorEntity.actorPersonUid IN");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    (SELECT PersonUids.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       FROM PersonUids)           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ),");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Add in group actor uids");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM AgentActorUidsForPersonUid     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("              UNION ");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM AgentActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    JOIN GroupMemberActorJoin ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        )");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Fetch all statements that could be completion or progress for the Gradebook report");
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("               JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           SELECT DISTINCT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                             FROM ActorUidsForPersonUid)");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE StatementEntity.statementClazzUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND StatementEntity.completionOrProgress = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("               SELECT DISTINCT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM ActorUidsForPersonUid) ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (      StatementEntity.resultScoreScaled IS NOT NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   OR StatementEntity.resultCompletion IS NOT NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   OR StatementEntity.resultSuccess IS NOT NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   OR StatementEntity.extensionProgress IS NOT NULL ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               )");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : studentPersonUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2 + _inputSize;
        int _tmp = completionOrProgressTrueVal ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntityAndRelated>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntityAndRelated> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorUid");
                    int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorPersonUid");
                    int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorName");
                    int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox");
                    int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox_sha1sum");
                    int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorOpenid");
                    int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountName");
                    int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountHomePage");
                    int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorEtag");
                    int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorLct");
                    int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorObjectType");
                    int _cursorIndexOfGmajGroupActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gmajGroupActorUid");
                    int _cursorIndexOfGmajMemberActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gmajMemberActorUid");
                    int _cursorIndexOfGmajLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gmajLastMod");
                    ArrayList<StatementEntityAndRelated> _result2 = new ArrayList<StatementEntityAndRelated>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        GroupMemberActorJoin _tmpGroupMemberActorJoin;
                        ActorEntity _tmpActorEntity;
                        StatementEntity _tmpStatementEntity;
                        if (!(_cursor.isNull(_cursorIndexOfStatementIdHi) && _cursor.isNull(_cursorIndexOfStatementIdLo) && _cursor.isNull(_cursorIndexOfStatementActorPersonUid) && _cursor.isNull(_cursorIndexOfStatementVerbUid) && _cursor.isNull(_cursorIndexOfStatementObjectType) && _cursor.isNull(_cursorIndexOfStatementObjectUid1) && _cursor.isNull(_cursorIndexOfStatementObjectUid2) && _cursor.isNull(_cursorIndexOfStatementActorUid) && _cursor.isNull(_cursorIndexOfAuthorityActorUid) && _cursor.isNull(_cursorIndexOfTeamUid) && _cursor.isNull(_cursorIndexOfResultCompletion) && _cursor.isNull(_cursorIndexOfResultSuccess) && _cursor.isNull(_cursorIndexOfResultScoreScaled) && _cursor.isNull(_cursorIndexOfResultScoreRaw) && _cursor.isNull(_cursorIndexOfResultScoreMin) && _cursor.isNull(_cursorIndexOfResultScoreMax) && _cursor.isNull(_cursorIndexOfResultDuration) && _cursor.isNull(_cursorIndexOfResultResponse) && _cursor.isNull(_cursorIndexOfTimestamp) && _cursor.isNull(_cursorIndexOfStored) && _cursor.isNull(_cursorIndexOfContextRegistrationHi) && _cursor.isNull(_cursorIndexOfContextRegistrationLo) && _cursor.isNull(_cursorIndexOfContextRegistrationHash) && _cursor.isNull(_cursorIndexOfContextPlatform) && _cursor.isNull(_cursorIndexOfContextStatementRefIdHi) && _cursor.isNull(_cursorIndexOfContextStatementRefIdLo) && _cursor.isNull(_cursorIndexOfContextInstructorActorUid) && _cursor.isNull(_cursorIndexOfStatementLct) && _cursor.isNull(_cursorIndexOfExtensionProgress) && _cursor.isNull(_cursorIndexOfCompletionOrProgress) && _cursor.isNull(_cursorIndexOfStatementContentEntryUid) && _cursor.isNull(_cursorIndexOfStatementLearnerGroupUid) && _cursor.isNull(_cursorIndexOfStatementClazzUid) && _cursor.isNull(_cursorIndexOfStatementCbUid) && _cursor.isNull(_cursorIndexOfStatementDoorNode) && _cursor.isNull(_cursorIndexOfIsSubStatement))) {
                            long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                            long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                            long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                            long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                            int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                            long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                            long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                            long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                            long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                            long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                            Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                            Boolean _tmpResultCompletion = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                            Integer _tmp_2 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                            Boolean _tmpResultSuccess = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                            Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                            Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                            Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                            Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                            Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                            String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                            long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                            long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                            long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                            long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                            long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                            String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                            long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                            long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                            long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                            long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                            Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                            boolean _tmpCompletionOrProgress = _tmp_3 != 0;
                            long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                            long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                            long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                            long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                            long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                            boolean _tmpIsSubStatement = _tmp_4 != 0;
                            _tmpStatementEntity = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        } else {
                            _tmpStatementEntity = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfActorUid) && _cursor.isNull(_cursorIndexOfActorPersonUid) && _cursor.isNull(_cursorIndexOfActorName) && _cursor.isNull(_cursorIndexOfActorMbox) && _cursor.isNull(_cursorIndexOfActorMboxSha1sum) && _cursor.isNull(_cursorIndexOfActorOpenid) && _cursor.isNull(_cursorIndexOfActorAccountName) && _cursor.isNull(_cursorIndexOfActorAccountHomePage) && _cursor.isNull(_cursorIndexOfActorEtag) && _cursor.isNull(_cursorIndexOfActorLct) && _cursor.isNull(_cursorIndexOfActorObjectType))) {
                            long _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
                            long _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
                            String _tmpActorName = _cursor.isNull(_cursorIndexOfActorName) ? null : _cursor.getString(_cursorIndexOfActorName);
                            String _tmpActorMbox = _cursor.isNull(_cursorIndexOfActorMbox) ? null : _cursor.getString(_cursorIndexOfActorMbox);
                            String _tmpActorMbox_sha1sum = _cursor.isNull(_cursorIndexOfActorMboxSha1sum) ? null : _cursor.getString(_cursorIndexOfActorMboxSha1sum);
                            String _tmpActorOpenid = _cursor.isNull(_cursorIndexOfActorOpenid) ? null : _cursor.getString(_cursorIndexOfActorOpenid);
                            String _tmpActorAccountName = _cursor.isNull(_cursorIndexOfActorAccountName) ? null : _cursor.getString(_cursorIndexOfActorAccountName);
                            String _tmpActorAccountHomePage = _cursor.isNull(_cursorIndexOfActorAccountHomePage) ? null : _cursor.getString(_cursorIndexOfActorAccountHomePage);
                            long _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
                            long _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
                            int _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
                            _tmpActorEntity = new ActorEntity(_tmpActorUid, _tmpActorPersonUid, _tmpActorName, _tmpActorMbox, _tmpActorMbox_sha1sum, _tmpActorOpenid, _tmpActorAccountName, _tmpActorAccountHomePage, _tmpActorEtag, _tmpActorLct, _tmpActorObjectType);
                        } else {
                            _tmpActorEntity = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfGmajGroupActorUid) && _cursor.isNull(_cursorIndexOfGmajMemberActorUid) && _cursor.isNull(_cursorIndexOfGmajLastMod))) {
                            long _tmpGmajGroupActorUid = _cursor.getLong(_cursorIndexOfGmajGroupActorUid);
                            long _tmpGmajMemberActorUid = _cursor.getLong(_cursorIndexOfGmajMemberActorUid);
                            long _tmpGmajLastMod = _cursor.getLong(_cursorIndexOfGmajLastMod);
                            _tmpGroupMemberActorJoin = new GroupMemberActorJoin(_tmpGmajGroupActorUid, _tmpGmajMemberActorUid, _tmpGmajLastMod);
                        } else {
                            _tmpGroupMemberActorJoin = null;
                        }
                        StatementEntityAndRelated _item_1 = new StatementEntityAndRelated(_tmpStatementEntity, _tmpGroupMemberActorJoin, _tmpActorEntity);
                        _result2.add(_item_1);
                    }
                    ArrayList<StatementEntityAndRelated> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findActorEntitiesForStudentInClazzByUidList(long clazzUid, List<Long> studentPersonUids, long accountPersonUid, Continuation<? super List<ActorEntity>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        WITH PersonUids(personUid) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT Person.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE Person.personUid IN (");
        int _inputSize = studentPersonUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ),");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT ActorEntity.actorUid AS actorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ActorEntity.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE ActorEntity.actorPersonUid IN");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    (SELECT PersonUids.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       FROM PersonUids)           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ),");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Add in group actor uids");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM AgentActorUidsForPersonUid     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("              UNION ");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM AgentActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    JOIN GroupMemberActorJoin ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        )");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT ActorEntity.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE ActorEntity.actorPersonUid IN ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT PersonUids.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  FROM PersonUids)");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 4 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : studentPersonUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2 + _inputSize;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3 + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4 + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ActorEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ActorEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorUid");
                    int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorPersonUid");
                    int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorName");
                    int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox");
                    int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox_sha1sum");
                    int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorOpenid");
                    int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountName");
                    int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountHomePage");
                    int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorEtag");
                    int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorLct");
                    int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorObjectType");
                    ArrayList<ActorEntity> _result2 = new ArrayList<ActorEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
                        long _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
                        String _tmpActorName = _cursor.isNull(_cursorIndexOfActorName) ? null : _cursor.getString(_cursorIndexOfActorName);
                        String _tmpActorMbox = _cursor.isNull(_cursorIndexOfActorMbox) ? null : _cursor.getString(_cursorIndexOfActorMbox);
                        String _tmpActorMbox_sha1sum = _cursor.isNull(_cursorIndexOfActorMboxSha1sum) ? null : _cursor.getString(_cursorIndexOfActorMboxSha1sum);
                        String _tmpActorOpenid = _cursor.isNull(_cursorIndexOfActorOpenid) ? null : _cursor.getString(_cursorIndexOfActorOpenid);
                        String _tmpActorAccountName = _cursor.isNull(_cursorIndexOfActorAccountName) ? null : _cursor.getString(_cursorIndexOfActorAccountName);
                        String _tmpActorAccountHomePage = _cursor.isNull(_cursorIndexOfActorAccountHomePage) ? null : _cursor.getString(_cursorIndexOfActorAccountHomePage);
                        long _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
                        long _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
                        int _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
                        ActorEntity _item_1 = new ActorEntity(_tmpActorUid, _tmpActorPersonUid, _tmpActorName, _tmpActorMbox, _tmpActorMbox_sha1sum, _tmpActorOpenid, _tmpActorAccountName, _tmpActorAccountHomePage, _tmpActorEtag, _tmpActorLct, _tmpActorObjectType);
                        _result2.add(_item_1);
                    }
                    ArrayList<ActorEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findStatusForStudentsInClazz(long clazzUid, List<Long> studentPersonUids, long accountPersonUid, Continuation<? super List<BlockStatus>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        WITH PersonUids(personUid) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT Person.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE Person.personUid IN (");
        int _inputSize = studentPersonUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ),");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT ActorEntity.actorUid AS actorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ActorEntity.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE ActorEntity.actorPersonUid IN");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    (SELECT PersonUids.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       FROM PersonUids)           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ),");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Add in group actor uids");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM AgentActorUidsForPersonUid     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("              UNION ");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM AgentActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    JOIN GroupMemberActorJoin ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        )");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ,");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        PersonUidsAndCourseBlocks(personUid, cbUid, cbType, caMarkingType) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT Person.personUid AS personUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    CourseBlock.cbUid AS cbUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    CourseBlock.cbType AS cbType,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ClazzAssignment.caMarkingType AS caMarkingType");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    JOIN CourseBlock");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON CourseBlock.cbClazzUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    LEFT JOIN ClazzAssignment");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON CourseBlock.cbType = 103");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        AND ClazzAssignment.caUid = CourseBlock.cbEntityUid     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE Person.personUid IN (");
        int _inputSize_1 = studentPersonUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")       ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        )");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT PersonUidsAndCourseBlocks.personUid AS sPersonUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               PersonUidsAndCourseBlocks.cbUid AS sCbUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT MAX(StatementEntity.extensionProgress)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 WHERE ");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ) AS sProgress,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT EXISTS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("               )) AS sIsCompleted,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT CASE");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       /*If there is a statement marked as success, then count as successful even if");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        *there were subsequent failed attempts");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        */");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       WHEN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            SELECT EXISTS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   )                           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ) THEN 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       /*If there are no statements marked as success, however there are statements marekd as fail,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        *then count as fail ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        */");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       WHEN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            SELECT EXISTS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   )                           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ) THEN 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       /* Else there is no known success/fail result*/");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ELSE NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       END");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ) AS sIsSuccess,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               -- See ClazzGradebookScreen for info on which score is selected");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT CASE");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       -- When there is a peer marked assignment, take the average of the latest distinct ...");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       WHEN (     PersonUidsAndCourseBlocks.cbType = 103");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              AND PersonUidsAndCourseBlocks.caMarkingType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            ) ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            THEN (SELECT AVG(StatementEntity.resultScoreScaled)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                         ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                     AND StatementEntity.timestamp = (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                         SELECT MAX(StatementEntity_Inner.timestamp)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                           FROM StatementEntity StatementEntity_Inner");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                                ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity ActorEntity_Inner");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity_Inner.actorUid = StatementEntity_Inner.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin GroupMemberActorJoin_Inner");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity_Inner.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin_Inner.gmajGroupActorUid, GroupMemberActorJoin_Inner.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                          WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity_Inner.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity_Inner.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                            AND StatementEntity_Inner.contextInstructorActorUid = StatementEntity.contextInstructorActorUid)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   LIMIT 1)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       -- When an assignment, but not peer marked, then the latest score     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       WHEN PersonUidsAndCourseBlocks.cbType = 103");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            THEN (SELECT StatementEntity.resultScoreScaled");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                         ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                ORDER BY StatementEntity.timestamp DESC");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   LIMIT 1)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       -- else the best score accomplished so far            ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ELSE (SELECT MAX(StatementEntity.resultScoreScaled) ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                               FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ))            ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       END");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ) AS sScoreScaled");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM PersonUidsAndCourseBlocks");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 3 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : studentPersonUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2 + _inputSize;
        for (long _item_1 : studentPersonUids) {
            _statement.bindLong(_argIndex, _item_1);
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<BlockStatus>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<BlockStatus> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfSPersonUid = false;
                    boolean _cursorIndexOfSCbUid = true;
                    int _cursorIndexOfSProgress = 2;
                    int _cursorIndexOfSIsCompleted = 3;
                    int _cursorIndexOfSIsSuccess = 4;
                    int _cursorIndexOfSScoreScaled = 5;
                    ArrayList<BlockStatus> _result2 = new ArrayList<BlockStatus>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpSPersonUid = _cursor.getLong(0);
                        long _tmpSCbUid = _cursor.getLong(1);
                        Integer _tmpSProgress = _cursor.isNull(2) ? null : Integer.valueOf(_cursor.getInt(2));
                        int _tmp = _cursor.getInt(3);
                        boolean _tmpSIsCompleted = _tmp != 0;
                        Integer _tmp_1 = _cursor.isNull(4) ? null : Integer.valueOf(_cursor.getInt(4));
                        Boolean _tmpSIsSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpSScoreScaled = _cursor.isNull(5) ? null : Float.valueOf(_cursor.getFloat(5));
                        BlockStatus _item_2 = new BlockStatus(_tmpSPersonUid, _tmpSCbUid, _tmpSProgress, _tmpSIsCompleted, _tmpSIsSuccess, _tmpSScoreScaled);
                        _result2.add(_item_2);
                    }
                    ArrayList<BlockStatus> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<BlockStatus>> findStatusForStudentsInClazzAsFlow(long clazzUid, List<Long> studentPersonUids, long accountPersonUid) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        WITH PersonUids(personUid) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT Person.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE Person.personUid IN (");
        int _inputSize = studentPersonUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ),");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT ActorEntity.actorUid AS actorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ActorEntity.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE ActorEntity.actorPersonUid IN");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    (SELECT PersonUids.personUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       FROM PersonUids)           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ),");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        -- Add in group actor uids");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM AgentActorUidsForPersonUid     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("              UNION ");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM AgentActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    JOIN GroupMemberActorJoin ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        )");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ,");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        PersonUidsAndCourseBlocks(personUid, cbUid, cbType, caMarkingType) AS (");
        _stringBuilder.append("\n");
        _stringBuilder.append("             SELECT Person.personUid AS personUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    CourseBlock.cbUid AS cbUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    CourseBlock.cbType AS cbType,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    ClazzAssignment.caMarkingType AS caMarkingType");
        _stringBuilder.append("\n");
        _stringBuilder.append("               FROM Person");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    JOIN CourseBlock");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON CourseBlock.cbClazzUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    LEFT JOIN ClazzAssignment");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON CourseBlock.cbType = 103");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        AND ClazzAssignment.caUid = CourseBlock.cbEntityUid     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("              WHERE Person.personUid IN (");
        int _inputSize_1 = studentPersonUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")       ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        )");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT PersonUidsAndCourseBlocks.personUid AS sPersonUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               PersonUidsAndCourseBlocks.cbUid AS sCbUid,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT MAX(StatementEntity.extensionProgress)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 WHERE ");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ) AS sProgress,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT EXISTS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("               )) AS sIsCompleted,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT CASE");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       /*If there is a statement marked as success, then count as successful even if");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        *there were subsequent failed attempts");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        */");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       WHEN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            SELECT EXISTS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   )                           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ) THEN 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       /*If there are no statements marked as success, however there are statements marekd as fail,");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        *then count as fail ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                        */");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       WHEN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            SELECT EXISTS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   )                           ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ) THEN 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       /* Else there is no known success/fail result*/");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ELSE NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       END");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ) AS sIsSuccess,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               -- See ClazzGradebookScreen for info on which score is selected");
        _stringBuilder.append("\n");
        _stringBuilder.append("               (SELECT CASE");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       -- When there is a peer marked assignment, take the average of the latest distinct ...");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       WHEN (     PersonUidsAndCourseBlocks.cbType = 103");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              AND PersonUidsAndCourseBlocks.caMarkingType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            ) ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            THEN (SELECT AVG(StatementEntity.resultScoreScaled)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                         ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                     AND StatementEntity.timestamp = (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                         SELECT MAX(StatementEntity_Inner.timestamp)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                           FROM StatementEntity StatementEntity_Inner");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                                ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity ActorEntity_Inner");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity_Inner.actorUid = StatementEntity_Inner.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin GroupMemberActorJoin_Inner");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity_Inner.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin_Inner.gmajGroupActorUid, GroupMemberActorJoin_Inner.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                          WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity_Inner.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity_Inner.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                            AND StatementEntity_Inner.contextInstructorActorUid = StatementEntity.contextInstructorActorUid)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   LIMIT 1)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       -- When an assignment, but not peer marked, then the latest score     ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       WHEN PersonUidsAndCourseBlocks.cbType = 103");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            THEN (SELECT StatementEntity.resultScoreScaled");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                         ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                ORDER BY StatementEntity.timestamp DESC");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                   LIMIT 1)");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       -- else the best score accomplished so far            ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       ELSE (SELECT MAX(StatementEntity.resultScoreScaled) ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                               FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("                                    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("       JOIN ActorEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
        _stringBuilder.append("\n");
        _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     FROM GroupMemberActorJoin");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                              WHERE (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("              FROM ActorUidsForPersonUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ))            ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                       END");
        _stringBuilder.append("\n");
        _stringBuilder.append("               ) AS sScoreScaled");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM PersonUidsAndCourseBlocks");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 3 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : studentPersonUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2 + _inputSize;
        for (long _item_1 : studentPersonUids) {
            _statement.bindLong(_argIndex, _item_1);
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Person", "ActorEntity", "GroupMemberActorJoin", "CourseBlock", "ClazzAssignment", "StatementEntity"}, (Callable)new Callable<List<BlockStatus>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<BlockStatus> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    boolean _cursorIndexOfSPersonUid = false;
                    boolean _cursorIndexOfSCbUid = true;
                    int _cursorIndexOfSProgress = 2;
                    int _cursorIndexOfSIsCompleted = 3;
                    int _cursorIndexOfSIsSuccess = 4;
                    int _cursorIndexOfSScoreScaled = 5;
                    ArrayList<BlockStatus> _result2 = new ArrayList<BlockStatus>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpSPersonUid = _cursor.getLong(0);
                        long _tmpSCbUid = _cursor.getLong(1);
                        Integer _tmpSProgress = _cursor.isNull(2) ? null : Integer.valueOf(_cursor.getInt(2));
                        int _tmp = _cursor.getInt(3);
                        boolean _tmpSIsCompleted = _tmp != 0;
                        Integer _tmp_1 = _cursor.isNull(4) ? null : Integer.valueOf(_cursor.getInt(4));
                        Boolean _tmpSIsSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpSScoreScaled = _cursor.isNull(5) ? null : Float.valueOf(_cursor.getFloat(5));
                        BlockStatus _item_2 = new BlockStatus(_tmpSPersonUid, _tmpSCbUid, _tmpSProgress, _tmpSIsCompleted, _tmpSIsSuccess, _tmpSScoreScaled);
                        _result2.add(_item_2);
                    }
                    ArrayList<BlockStatus> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findResumableRegistration(long activityUid, long accountPersonUid, long actorUid, Continuation<? super StatementEntity> $completion) {
        String _sql = "\n        WITH MostRecentRegistration(statementIdHi, statementIdLo, contextRegistrationHi, contextRegistrationLo) AS (\n             SELECT StatementEntity.statementIdHi, StatementEntity.contextRegistrationLo,\n                    StatementEntity.contextRegistrationHi, StatementEntity.contextRegistrationLo\n               FROM StatementEntity\n              WHERE StatementEntity.statementActorUid = ?\n                AND StatementEntity.statementObjectUid1 = ?\n                AND StatementEntity.contextRegistrationHi != 0\n           ORDER BY StatementEntity.timestamp DESC\n              LIMIT 1\n        )\n        \n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE StatementEntity.statementIdHi = (SELECT statementIdHi FROM MostRecentRegistration)\n           AND StatementEntity.statementIdLo = (SELECT statementIdLo FROM MostRecentRegistration)\n           AND NOT EXISTS(\n                   SELECT 1\n                     FROM StatementEntity StatementEntity_Inner\n                    WHERE StatementEntity_Inner.statementActorUid = ?\n                      AND StatementEntity_Inner.statementObjectUid1 = ?\n                      AND StatementEntity_Inner.contextRegistrationHi = (SELECT contextRegistrationHi FROM MostRecentRegistration)\n                      AND StatementEntity_Inner.contextRegistrationLo = (SELECT contextRegistrationLo FROM MostRecentRegistration)\n                      AND CAST(StatementEntity_Inner.completionOrProgress AS INTEGER) = 1\n                      AND (     StatementEntity_Inner.resultCompletion IS NOT NULL \n                            AND CAST(StatementEntity_Inner.resultCompletion AS INTEGER) = 1)\n                     )\n           AND ? IN \n               (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?)          \n                     \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH MostRecentRegistration(statementIdHi, statementIdLo, contextRegistrationHi, contextRegistrationLo) AS (\n             SELECT StatementEntity.statementIdHi, StatementEntity.contextRegistrationLo,\n                    StatementEntity.contextRegistrationHi, StatementEntity.contextRegistrationLo\n               FROM StatementEntity\n              WHERE StatementEntity.statementActorUid = ?\n                AND StatementEntity.statementObjectUid1 = ?\n                AND StatementEntity.contextRegistrationHi != 0\n           ORDER BY StatementEntity.timestamp DESC\n              LIMIT 1\n        )\n        \n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE StatementEntity.statementIdHi = (SELECT statementIdHi FROM MostRecentRegistration)\n           AND StatementEntity.statementIdLo = (SELECT statementIdLo FROM MostRecentRegistration)\n           AND NOT EXISTS(\n                   SELECT 1\n                     FROM StatementEntity StatementEntity_Inner\n                    WHERE StatementEntity_Inner.statementActorUid = ?\n                      AND StatementEntity_Inner.statementObjectUid1 = ?\n                      AND StatementEntity_Inner.contextRegistrationHi = (SELECT contextRegistrationHi FROM MostRecentRegistration)\n                      AND StatementEntity_Inner.contextRegistrationLo = (SELECT contextRegistrationLo FROM MostRecentRegistration)\n                      AND CAST(StatementEntity_Inner.completionOrProgress AS INTEGER) = 1\n                      AND (     StatementEntity_Inner.resultCompletion IS NOT NULL \n                            AND CAST(StatementEntity_Inner.resultCompletion AS INTEGER) = 1)\n                     )\n           AND ? IN \n               (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?)          \n                     \n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, activityUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, activityUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, actorUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<StatementEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public StatementEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    StatementEntity _result2;
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    if (_cursor.moveToFirst()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        _result2 = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                    } else {
                        _result2 = null;
                    }
                    StatementEntity statementEntity = _result2;
                    return statementEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findPersonsWithAttemptsStatements(long contentEntryUid, long accountPersonUid, String searchText, Continuation<? super List<StatementEntity>> $completion) {
        String _sql = "\n        SELECT StatementEntity.*\n          FROM Person\n               JOIN StatementEntity\n                    ON (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN\n                            (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                               FROM StatementEntity\n                              WHERE StatementEntity.statementContentEntryUid = ?\n                                AND StatementEntity.statementActorPersonUid = Person.personUid\n                                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                           ORDER BY StatementEntity.extensionProgress DESC\n                              LIMIT 1)\n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN    \n                          (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = ?\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                       ORDER BY StatementEntity.resultScoreScaled DESC\n                       LIMIT 1)\n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN    \n                          (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = ?\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                       ORDER BY StatementEntity.timestamp DESC\n                       LIMIT 1)    \n         WHERE Person.personUid IN\n            (SELECT DISTINCT StatementEntity.statementActorPersonUid\n                    \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = ?\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = ?\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = ? \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    )      \n            AND (   ? = '%' \n                 OR Person.firstNames || ' ' || Person.lastName LIKE ?) \n                          \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StatementEntity.*\n          FROM Person\n               JOIN StatementEntity\n                    ON (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN\n                            (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                               FROM StatementEntity\n                              WHERE StatementEntity.statementContentEntryUid = ?\n                                AND StatementEntity.statementActorPersonUid = Person.personUid\n                                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                           ORDER BY StatementEntity.extensionProgress DESC\n                              LIMIT 1)\n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN    \n                          (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = ?\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                       ORDER BY StatementEntity.resultScoreScaled DESC\n                       LIMIT 1)\n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN    \n                          (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = ?\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                       ORDER BY StatementEntity.timestamp DESC\n                       LIMIT 1)    \n         WHERE Person.personUid IN\n            (SELECT DISTINCT StatementEntity.statementActorPersonUid\n                    \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = ?\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = ?\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = ? \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    )      \n            AND (   ? = '%' \n                 OR Person.firstNames || ' ' || Person.lastName LIKE ?) \n                          \n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 11;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    ArrayList<StatementEntity> _result2 = new ArrayList<StatementEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        StatementEntity _item = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, PersonAndPictureAndNumAttempts> findPersonsWithAttempts(long contentEntryUid, long accountPersonUid, String searchText, int sortOrder) {
        String _sql = "\n     SELECT Person.*, PersonPicture.*,\n            (SELECT COUNT(*)\n               FROM (SELECT DISTINCT StatementEntity.contextRegistrationHi, StatementEntity.contextRegistrationLo\n                       FROM StatementEntity\n                      WHERE StatementEntity.statementContentEntryUid = ?\n                        AND StatementEntity.statementActorPersonUid = Person.personUid\n                    ) AS DistinctRegistrations) AS numAttempts,\n            (SELECT EXISTS(\n                    SELECT 1\n                      FROM StatementEntity\n                     WHERE StatementEntity.statementContentEntryUid = ?\n                       AND StatementEntity.statementActorPersonUid = Person.personUid\n                       AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                       AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1)) AS isCompleted,\n            (SELECT CASE\n                    WHEN EXISTS(\n                         SELECT 1\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = ?\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                            AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 1\n                    WHEN EXISTS(\n                         SELECT 1\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = ?\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                            AND StatementEntity.resultSuccess IS NOT NULL\n                            AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 0\n                    ELSE NULL\n                    END) AS isSuccessful,\n            (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    ) AS maxProgress,\n            (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    ) AS maxScore,\n            \n            (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    ) AS mostRecentAttemptTime    \n       FROM Person\n            LEFT JOIN PersonPicture\n                 ON PersonPicture.personPictureUid = Person.personUid\n      WHERE Person.personUid IN\n            (SELECT DISTINCT StatementEntity.statementActorPersonUid\n                    \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = ?\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = ?\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = ? \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    )      \n            AND (   ? = '%' \n                 OR Person.firstNames || ' ' || Person.lastName LIKE ?)\n     ORDER BY \n    CASE \n        WHEN ? = 5 THEN (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN ? = 7 THEN (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN ? = 9 THEN (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    )\n        ELSE 0\n    END ASC,\n    CASE \n        WHEN ? = 1 THEN Person.firstNames\n        WHEN ? = 3 THEN Person.lastName\n        ELSE ''\n    END ASC,    \n    CASE \n        WHEN ? = 6 THEN (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN ? = 8 THEN (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN ? = 10 THEN (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    )\n        ELSE 0\n    END DESC,\n    CASE\n        WHEN ? = 2 THEN Person.firstNames\n        WHEN ? = 4 THEN Person.lastName\n    END DESC    \n";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n     SELECT Person.*, PersonPicture.*,\n            (SELECT COUNT(*)\n               FROM (SELECT DISTINCT StatementEntity.contextRegistrationHi, StatementEntity.contextRegistrationLo\n                       FROM StatementEntity\n                      WHERE StatementEntity.statementContentEntryUid = ?\n                        AND StatementEntity.statementActorPersonUid = Person.personUid\n                    ) AS DistinctRegistrations) AS numAttempts,\n            (SELECT EXISTS(\n                    SELECT 1\n                      FROM StatementEntity\n                     WHERE StatementEntity.statementContentEntryUid = ?\n                       AND StatementEntity.statementActorPersonUid = Person.personUid\n                       AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                       AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1)) AS isCompleted,\n            (SELECT CASE\n                    WHEN EXISTS(\n                         SELECT 1\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = ?\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                            AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 1\n                    WHEN EXISTS(\n                         SELECT 1\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = ?\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                            AND StatementEntity.resultSuccess IS NOT NULL\n                            AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 0\n                    ELSE NULL\n                    END) AS isSuccessful,\n            (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    ) AS maxProgress,\n            (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    ) AS maxScore,\n            \n            (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    ) AS mostRecentAttemptTime    \n       FROM Person\n            LEFT JOIN PersonPicture\n                 ON PersonPicture.personPictureUid = Person.personUid\n      WHERE Person.personUid IN\n            (SELECT DISTINCT StatementEntity.statementActorPersonUid\n                    \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = ?\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = ?\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = ? \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    )      \n            AND (   ? = '%' \n                 OR Person.firstNames || ' ' || Person.lastName LIKE ?)\n     ORDER BY \n    CASE \n        WHEN ? = 5 THEN (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN ? = 7 THEN (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN ? = 9 THEN (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    )\n        ELSE 0\n    END ASC,\n    CASE \n        WHEN ? = 1 THEN Person.firstNames\n        WHEN ? = 3 THEN Person.lastName\n        ELSE ''\n    END ASC,    \n    CASE \n        WHEN ? = 6 THEN (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN ? = 8 THEN (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN ? = 10 THEN (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = ?\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    )\n        ELSE 0\n    END DESC,\n    CASE\n        WHEN ? = 2 THEN Person.firstNames\n        WHEN ? = 4 THEN Person.lastName\n    END DESC    \n", (int)31);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 14;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 15;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 16;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 17;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 19;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 21;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 22;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 23;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 24;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 25;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 26;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 27;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 28;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 29;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 30;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 31;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<PersonAndPictureAndNumAttempts>(_statement, this.__db, new String[]{"StatementEntity", "Person", "PersonPicture", "ClazzEnrolment", "CoursePermission", "SystemPermission"}){

            @NonNull
            protected List<PersonAndPictureAndNumAttempts> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"active");
                int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPersonalAccount");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherNum");
                int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUid");
                int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureLct");
                int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUri");
                int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureThumbnailUri");
                int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fileSize");
                int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureActive");
                int _cursorIndexOfNumAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"numAttempts");
                int _cursorIndexOfIsCompleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isCompleted");
                int _cursorIndexOfIsSuccessful = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isSuccessful");
                int _cursorIndexOfMaxProgress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"maxProgress");
                int _cursorIndexOfMaxScore = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"maxScore");
                ArrayList<PersonAndPictureAndNumAttempts> _result2 = new ArrayList<PersonAndPictureAndNumAttempts>(cursor.getCount());
                while (cursor.moveToNext()) {
                    PersonPicture _tmpPicture;
                    int _tmpNumAttempts = cursor.getInt(_cursorIndexOfNumAttempts);
                    int _tmp = cursor.getInt(_cursorIndexOfIsCompleted);
                    boolean _tmpIsCompleted = _tmp != 0;
                    Integer _tmp_1 = cursor.isNull(_cursorIndexOfIsSuccessful) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsSuccessful));
                    Boolean _tmpIsSuccessful = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    Integer _tmpMaxProgress = cursor.isNull(_cursorIndexOfMaxProgress) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMaxProgress));
                    Float _tmpMaxScore = cursor.isNull(_cursorIndexOfMaxScore) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfMaxScore));
                    long _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                    String _tmpUsername = cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername);
                    String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                    String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                    String _tmpEmailAddr = cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr);
                    String _tmpPhoneNum = cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum);
                    int _tmpGender = cursor.getInt(_cursorIndexOfGender);
                    int _tmp_2 = cursor.getInt(_cursorIndexOfActive);
                    boolean _tmpActive = _tmp_2 != 0;
                    int _tmp_3 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
                    boolean _tmpIsPersonalAccount = _tmp_3 != 0;
                    long _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                    String _tmpPersonAddress = cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress);
                    String _tmpPersonOrgId = cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId);
                    long _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                    long _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                    String _tmpPersonCountry = cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry);
                    int _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                    long _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                    long _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                    int _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                    int _tmp_4 = cursor.getInt(_cursorIndexOfAdmin);
                    boolean _tmpAdmin = _tmp_4 != 0;
                    String _tmpPersonNotes = cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes);
                    String _tmpFatherName = cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName);
                    String _tmpFatherNumber = cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber);
                    String _tmpMotherName = cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName);
                    String _tmpMotherNum = cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum);
                    Person _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                        long _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp_5 = cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp_5 != 0;
                        _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _tmpPicture = null;
                    }
                    PersonAndPictureAndNumAttempts _item = new PersonAndPictureAndNumAttempts(_tmpPerson, _tmpPicture, _tmpNumAttempts, _tmpIsCompleted, _tmpIsSuccessful, _tmpMaxScore, _tmpMaxProgress);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findSessionsByPersonAndContentStatements(long contentEntryUid, long personUid, long accountPersonUid, Continuation<? super List<StatementEntity>> $completion) {
        String _sql = "\n        WITH \n             DistinctRegistrationUids(contextRegistrationHi, contextRegistrationLo, statementClazzUid) AS (\n      SELECT DISTINCT StatementEntity.contextRegistrationHi, \n                     StatementEntity.contextRegistrationLo,\n                     StatementEntity.statementClazzUid\n                 FROM StatementEntity\n                WHERE StatementEntity.statementContentEntryUid = ?\n                  AND StatementEntity.statementActorPersonUid = ?)\n    \n        SELECT StatementEntity.*\n          FROM DistinctRegistrationUids\n               JOIN StatementEntity \n                    ON (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                        -- Statement for time started\n                        (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                           FROM StatementEntity\n                          WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                            AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                       ORDER BY StatementEntity.timestamp ASC\n                          LIMIT 1)\n                          \n                       --statement for max progress   \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                      ORDER BY StatementEntity.extensionProgress DESC\n                         LIMIT 1) \n                         \n                       --statement for max score  \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                      ORDER BY StatementEntity.resultScoreScaled DESC\n                         LIMIT 1)\n                         \n                        --statement with completion  \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                           AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                         LIMIT 1)\n         WHERE (\n            ? = ? \n                OR EXISTS(\n                    SELECT CoursePermission.cpUid\n                      FROM CoursePermission\n                           LEFT JOIN ClazzEnrolment \n                                ON ClazzEnrolment.clazzEnrolmentUid =\n                                  COALESCE(\n                                   (SELECT ClazzEnrolment.clazzEnrolmentUid \n                                      FROM ClazzEnrolment\n                                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                       AND ClazzEnrolment.clazzEnrolmentActive\n                                       AND ClazzEnrolment.clazzEnrolmentClazzUid = DistinctRegistrationUids.statementClazzUid \n                                  ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0)\n                     WHERE CoursePermission.cpClazzUid = DistinctRegistrationUids.statementClazzUid\n                       AND (   CoursePermission.cpToPersonUid = ? \n                            OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                       AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                       AND NOT CoursePermission.cpIsDeleted)\n                OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                    128\n                    \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n    )\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH \n             DistinctRegistrationUids(contextRegistrationHi, contextRegistrationLo, statementClazzUid) AS (\n      SELECT DISTINCT StatementEntity.contextRegistrationHi, \n                     StatementEntity.contextRegistrationLo,\n                     StatementEntity.statementClazzUid\n                 FROM StatementEntity\n                WHERE StatementEntity.statementContentEntryUid = ?\n                  AND StatementEntity.statementActorPersonUid = ?)\n    \n        SELECT StatementEntity.*\n          FROM DistinctRegistrationUids\n               JOIN StatementEntity \n                    ON (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                        -- Statement for time started\n                        (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                           FROM StatementEntity\n                          WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                            AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                       ORDER BY StatementEntity.timestamp ASC\n                          LIMIT 1)\n                          \n                       --statement for max progress   \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                      ORDER BY StatementEntity.extensionProgress DESC\n                         LIMIT 1) \n                         \n                       --statement for max score  \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                      ORDER BY StatementEntity.resultScoreScaled DESC\n                         LIMIT 1)\n                         \n                        --statement with completion  \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                           AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                         LIMIT 1)\n         WHERE (\n            ? = ? \n                OR EXISTS(\n                    SELECT CoursePermission.cpUid\n                      FROM CoursePermission\n                           LEFT JOIN ClazzEnrolment \n                                ON ClazzEnrolment.clazzEnrolmentUid =\n                                  COALESCE(\n                                   (SELECT ClazzEnrolment.clazzEnrolmentUid \n                                      FROM ClazzEnrolment\n                                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                       AND ClazzEnrolment.clazzEnrolmentActive\n                                       AND ClazzEnrolment.clazzEnrolmentClazzUid = DistinctRegistrationUids.statementClazzUid \n                                  ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0)\n                     WHERE CoursePermission.cpClazzUid = DistinctRegistrationUids.statementClazzUid\n                       AND (   CoursePermission.cpToPersonUid = ? \n                            OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                       AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                       AND NOT CoursePermission.cpIsDeleted)\n                OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                    128\n                    \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n    )\n    ", (int)8);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    ArrayList<StatementEntity> _result2 = new ArrayList<StatementEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        StatementEntity _item = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, SessionTimeAndProgressInfo> findSessionsByPersonAndContent(long contentEntryUid, long personUid, long accountPersonUid, int sortOrder) {
        String _sql = "\n WITH \n             DistinctRegistrationUids(contextRegistrationHi, contextRegistrationLo, statementClazzUid) AS (\n      SELECT DISTINCT StatementEntity.contextRegistrationHi, \n                     StatementEntity.contextRegistrationLo,\n                     StatementEntity.statementClazzUid\n                 FROM StatementEntity\n                WHERE StatementEntity.statementContentEntryUid = ?\n                  AND StatementEntity.statementActorPersonUid = ?)\n    ,\n      SessionsByPerson(contextRegistrationHi, contextRegistrationLo, timeStarted, maxProgress, maxScore, isCompleted, isSuccessful, resultDuration) AS (\n       SELECT DistinctRegistrationUids.contextRegistrationHi AS contextRegistrationHi,\n              DistinctRegistrationUids.contextRegistrationLo AS contextRegistrationLo,\n              (SELECT MIN(StatementEntity.timestamp)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = ?\n                  AND StatementEntity.statementContentEntryUid = ?\n              ) AS timeStarted,\n              \n              (SELECT MAX(StatementEntity.extensionProgress)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = ?\n                  AND StatementEntity.statementContentEntryUid = ?\n                  AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n               ) AS maxProgress,\n               \n              (SELECT MAX(StatementEntity.resultScoreScaled)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = ?\n                  AND StatementEntity.statementContentEntryUid = ?\n                  AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n               ) AS maxScore,\n               \n              (SELECT EXISTS(\n                      SELECT 1 \n                        FROM StatementEntity\n                       WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                         AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                         AND StatementEntity.statementActorPersonUid = ?\n                         AND StatementEntity.statementContentEntryUid = ?\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                         AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n              )) AS isCompleted,\n              (SELECT CASE \n                      WHEN EXISTS(\n                           SELECT 1 \n                             FROM StatementEntity\n                            WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                              AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ?\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                              AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 1\n                      WHEN EXISTS(\n                           SELECT 1 \n                             FROM StatementEntity\n                            WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                              AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ?\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                              AND StatementEntity.resultSuccess IS NOT NULL\n                              AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0) THEN 0\n                      ELSE NULL\n                      END) AS isSuccessful,\n                      (SELECT MAX(StatementEntity.resultDuration)\n                         FROM StatementEntity\n                        WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                          AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                          AND StatementEntity.statementActorPersonUid = ?\n                          AND StatementEntity.statementContentEntryUid = ?) AS resultDuration\n         FROM DistinctRegistrationUids\n         WHERE (\n            ? = ? \n                OR EXISTS(\n                    SELECT CoursePermission.cpUid\n                      FROM CoursePermission\n                           LEFT JOIN ClazzEnrolment \n                                ON ClazzEnrolment.clazzEnrolmentUid =\n                                  COALESCE(\n                                   (SELECT ClazzEnrolment.clazzEnrolmentUid \n                                      FROM ClazzEnrolment\n                                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                       AND ClazzEnrolment.clazzEnrolmentActive\n                                       AND ClazzEnrolment.clazzEnrolmentClazzUid = DistinctRegistrationUids.statementClazzUid \n                                  ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0)\n                     WHERE CoursePermission.cpClazzUid = DistinctRegistrationUids.statementClazzUid\n                       AND (   CoursePermission.cpToPersonUid = ? \n                            OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                       AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                       AND NOT CoursePermission.cpIsDeleted)\n                OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                    128\n                    \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n    )) \n      SELECT SessionsByPerson.*\n        FROM SessionsByPerson\n    ORDER BY  \n        CASE ?\n            WHEN 1 THEN timeStarted\n            ELSE NULL\n        END DESC,\n        CASE ?\n            WHEN 2 THEN timeStarted\n            ELSE NULL\n        END ASC,\n        CASE ?\n            WHEN 4 THEN maxScore\n            ELSE NULL\n        END DESC,\n        CASE ?\n            WHEN 3 THEN maxScore\n            ELSE NULL\n        END ASC,\n        CASE ?\n            WHEN 6 THEN maxProgress\n            ELSE NULL\n        END DESC,\n        CASE ?\n            WHEN 5 THEN maxProgress\n            ELSE NULL\n        END ASC\n   ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n WITH \n             DistinctRegistrationUids(contextRegistrationHi, contextRegistrationLo, statementClazzUid) AS (\n      SELECT DISTINCT StatementEntity.contextRegistrationHi, \n                     StatementEntity.contextRegistrationLo,\n                     StatementEntity.statementClazzUid\n                 FROM StatementEntity\n                WHERE StatementEntity.statementContentEntryUid = ?\n                  AND StatementEntity.statementActorPersonUid = ?)\n    ,\n      SessionsByPerson(contextRegistrationHi, contextRegistrationLo, timeStarted, maxProgress, maxScore, isCompleted, isSuccessful, resultDuration) AS (\n       SELECT DistinctRegistrationUids.contextRegistrationHi AS contextRegistrationHi,\n              DistinctRegistrationUids.contextRegistrationLo AS contextRegistrationLo,\n              (SELECT MIN(StatementEntity.timestamp)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = ?\n                  AND StatementEntity.statementContentEntryUid = ?\n              ) AS timeStarted,\n              \n              (SELECT MAX(StatementEntity.extensionProgress)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = ?\n                  AND StatementEntity.statementContentEntryUid = ?\n                  AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n               ) AS maxProgress,\n               \n              (SELECT MAX(StatementEntity.resultScoreScaled)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = ?\n                  AND StatementEntity.statementContentEntryUid = ?\n                  AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n               ) AS maxScore,\n               \n              (SELECT EXISTS(\n                      SELECT 1 \n                        FROM StatementEntity\n                       WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                         AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                         AND StatementEntity.statementActorPersonUid = ?\n                         AND StatementEntity.statementContentEntryUid = ?\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                         AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n              )) AS isCompleted,\n              (SELECT CASE \n                      WHEN EXISTS(\n                           SELECT 1 \n                             FROM StatementEntity\n                            WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                              AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ?\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                              AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 1\n                      WHEN EXISTS(\n                           SELECT 1 \n                             FROM StatementEntity\n                            WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                              AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ?\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                              AND StatementEntity.resultSuccess IS NOT NULL\n                              AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0) THEN 0\n                      ELSE NULL\n                      END) AS isSuccessful,\n                      (SELECT MAX(StatementEntity.resultDuration)\n                         FROM StatementEntity\n                        WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                          AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                          AND StatementEntity.statementActorPersonUid = ?\n                          AND StatementEntity.statementContentEntryUid = ?) AS resultDuration\n         FROM DistinctRegistrationUids\n         WHERE (\n            ? = ? \n                OR EXISTS(\n                    SELECT CoursePermission.cpUid\n                      FROM CoursePermission\n                           LEFT JOIN ClazzEnrolment \n                                ON ClazzEnrolment.clazzEnrolmentUid =\n                                  COALESCE(\n                                   (SELECT ClazzEnrolment.clazzEnrolmentUid \n                                      FROM ClazzEnrolment\n                                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                       AND ClazzEnrolment.clazzEnrolmentActive\n                                       AND ClazzEnrolment.clazzEnrolmentClazzUid = DistinctRegistrationUids.statementClazzUid \n                                  ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0)\n                     WHERE CoursePermission.cpClazzUid = DistinctRegistrationUids.statementClazzUid\n                       AND (   CoursePermission.cpToPersonUid = ? \n                            OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                       AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                       AND NOT CoursePermission.cpIsDeleted)\n                OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                    128\n                    \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n    )) \n      SELECT SessionsByPerson.*\n        FROM SessionsByPerson\n    ORDER BY  \n        CASE ?\n            WHEN 1 THEN timeStarted\n            ELSE NULL\n        END DESC,\n        CASE ?\n            WHEN 2 THEN timeStarted\n            ELSE NULL\n        END ASC,\n        CASE ?\n            WHEN 4 THEN maxScore\n            ELSE NULL\n        END DESC,\n        CASE ?\n            WHEN 3 THEN maxScore\n            ELSE NULL\n        END ASC,\n        CASE ?\n            WHEN 6 THEN maxProgress\n            ELSE NULL\n        END DESC,\n        CASE ?\n            WHEN 5 THEN maxProgress\n            ELSE NULL\n        END ASC\n   ", (int)28);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 22;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 23;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 24;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 25;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 26;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 27;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 28;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<SessionTimeAndProgressInfo>(_statement, this.__db, new String[]{"StatementEntity", "CoursePermission", "ClazzEnrolment", "SystemPermission"}){

            @NonNull
            protected List<SessionTimeAndProgressInfo> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextRegistrationHi");
                int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextRegistrationLo");
                int _cursorIndexOfTimeStarted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"timeStarted");
                int _cursorIndexOfMaxProgress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"maxProgress");
                int _cursorIndexOfMaxScore = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"maxScore");
                int _cursorIndexOfIsCompleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isCompleted");
                int _cursorIndexOfIsSuccessful = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isSuccessful");
                int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultDuration");
                ArrayList<SessionTimeAndProgressInfo> _result2 = new ArrayList<SessionTimeAndProgressInfo>(cursor.getCount());
                while (cursor.moveToNext()) {
                    long _tmpContextRegistrationHi = cursor.getLong(_cursorIndexOfContextRegistrationHi);
                    long _tmpContextRegistrationLo = cursor.getLong(_cursorIndexOfContextRegistrationLo);
                    long _tmpTimeStarted = cursor.getLong(_cursorIndexOfTimeStarted);
                    Integer _tmpMaxProgress = cursor.isNull(_cursorIndexOfMaxProgress) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMaxProgress));
                    Float _tmpMaxScore = cursor.isNull(_cursorIndexOfMaxScore) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfMaxScore));
                    int _tmp = cursor.getInt(_cursorIndexOfIsCompleted);
                    boolean _tmpIsCompleted = _tmp != 0;
                    Integer _tmp_1 = cursor.isNull(_cursorIndexOfIsSuccessful) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsSuccessful));
                    Boolean _tmpIsSuccessful = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    long _tmpResultDuration = cursor.getLong(_cursorIndexOfResultDuration);
                    SessionTimeAndProgressInfo _item = new SessionTimeAndProgressInfo(_tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpTimeStarted, _tmpMaxProgress, _tmpMaxScore, _tmpIsCompleted, _tmpIsSuccessful, _tmpResultDuration);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findActivityEntryLangMapsForStatementsBySession(long registrationHi, long registrationLo, Continuation<? super List<ActivityLangMapEntry>> $completion) {
        String _sql = "\n        SELECT ActivityLangMapEntry.*\n          FROM ActivityLangMapEntry\n         WHERE ActivityLangMapEntry.almeActivityUid IN (\n               SELECT DISTINCT StatementEntity.statementObjectUid1\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = ?\n                  AND StatementEntity.contextRegistrationLo = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ActivityLangMapEntry.*\n          FROM ActivityLangMapEntry\n         WHERE ActivityLangMapEntry.almeActivityUid IN (\n               SELECT DISTINCT StatementEntity.statementObjectUid1\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = ?\n                  AND StatementEntity.contextRegistrationLo = ?)\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, registrationHi);
        _argIndex = 2;
        _statement.bindLong(_argIndex, registrationLo);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ActivityLangMapEntry>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ActivityLangMapEntry> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfAlmeActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeActivityUid");
                    int _cursorIndexOfAlmeHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeHash");
                    int _cursorIndexOfAlmeLangCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeLangCode");
                    int _cursorIndexOfAlmePropName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almePropName");
                    int _cursorIndexOfAlmeValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeValue");
                    int _cursorIndexOfAlmeAieHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeAieHash");
                    int _cursorIndexOfAlmeLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeLastMod");
                    ArrayList<ActivityLangMapEntry> _result2 = new ArrayList<ActivityLangMapEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpAlmeActivityUid = _cursor.getLong(_cursorIndexOfAlmeActivityUid);
                        long _tmpAlmeHash = _cursor.getLong(_cursorIndexOfAlmeHash);
                        String _tmpAlmeLangCode = _cursor.isNull(_cursorIndexOfAlmeLangCode) ? null : _cursor.getString(_cursorIndexOfAlmeLangCode);
                        String _tmpAlmePropName = _cursor.isNull(_cursorIndexOfAlmePropName) ? null : _cursor.getString(_cursorIndexOfAlmePropName);
                        String _tmpAlmeValue = _cursor.isNull(_cursorIndexOfAlmeValue) ? null : _cursor.getString(_cursorIndexOfAlmeValue);
                        long _tmpAlmeAieHash = _cursor.getLong(_cursorIndexOfAlmeAieHash);
                        long _tmpAlmeLastMod = _cursor.getLong(_cursorIndexOfAlmeLastMod);
                        ActivityLangMapEntry _item = new ActivityLangMapEntry(_tmpAlmeActivityUid, _tmpAlmeHash, _tmpAlmeLangCode, _tmpAlmePropName, _tmpAlmeValue, _tmpAlmeAieHash, _tmpAlmeLastMod);
                        _result2.add(_item);
                    }
                    ArrayList<ActivityLangMapEntry> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, StatementEntityAndVerb> findStatementsBySession(long registrationHi, long registrationLo, long accountPersonUid, long selectedPersonUid, long contentEntryUid, String searchText, int sortOrder, List<Long> deSelectedVerbUids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("    SELECT StatementEntity.*, VerbEntity.*, VerbLangMapEntry.*, ActivityEntity.*,");
        _stringBuilder.append("\n");
        _stringBuilder.append("           ActivityLangMapEntry.*,");
        _stringBuilder.append("\n");
        _stringBuilder.append("           ActivityLangMapDescription.almeValue AS statementActivityDescription");
        _stringBuilder.append("\n");
        _stringBuilder.append("    FROM StatementEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("    LEFT JOIN VerbEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ON StatementEntity.statementVerbUid = VerbEntity.verbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("    LEFT JOIN VerbLangMapEntry ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ON (VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash) = ");
        _stringBuilder.append("\n");
        _stringBuilder.append("            (SELECT VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash");
        _stringBuilder.append("\n");
        _stringBuilder.append("            FROM VerbLangMapEntry");
        _stringBuilder.append("\n");
        _stringBuilder.append("            WHERE VerbLangMapEntry.vlmeVerbUid = VerbEntity.verbUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ORDER BY VerbLangMapEntry.vlmeLastModified DESC");
        _stringBuilder.append("\n");
        _stringBuilder.append("            LIMIT 1)");
        _stringBuilder.append("\n");
        _stringBuilder.append("    LEFT JOIN ActivityEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("              ON ActivityEntity.actUid = StatementEntity.statementObjectUid1");
        _stringBuilder.append("\n");
        _stringBuilder.append("    LEFT JOIN ActivityLangMapEntry");
        _stringBuilder.append("\n");
        _stringBuilder.append("              ON (ActivityLangMapEntry.almeActivityUid, ActivityLangMapEntry.almeHash) = ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 (SELECT ActivityLangMapEntry.almeActivityUid, ActivityLangMapEntry.almeHash");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    FROM ActivityLangMapEntry");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   WHERE ActivityLangMapEntry.almeActivityUid = StatementEntity.statementObjectUid1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     AND ActivityLangMapEntry.almePropName = 'name'");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   LIMIT 1)");
        _stringBuilder.append("\n");
        _stringBuilder.append("    LEFT JOIN ActivityLangMapEntry ActivityLangMapDescription");
        _stringBuilder.append("\n");
        _stringBuilder.append("              ON (ActivityLangMapDescription.almeActivityUid, ActivityLangMapDescription.almeHash) = ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 (SELECT ActivityLangMapDescription.almeActivityUid, ActivityLangMapDescription.almeHash");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    FROM ActivityLangMapEntry ActivityLangMapDescription");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   WHERE ActivityLangMapDescription.almeActivityUid = StatementEntity.statementObjectUid1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                     AND ActivityLangMapDescription.almePropName = 'description'");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   LIMIT 1)");
        _stringBuilder.append("\n");
        _stringBuilder.append("    LEFT JOIN ClazzEnrolment ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ON ClazzEnrolment.clazzEnrolmentUid =");
        _stringBuilder.append("\n");
        _stringBuilder.append("            COALESCE(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                (SELECT ClazzEnrolment.clazzEnrolmentUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                FROM ClazzEnrolment");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AND ClazzEnrolment.clazzEnrolmentActive");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                LIMIT 1), 0)");
        _stringBuilder.append("\n");
        _stringBuilder.append("    WHERE StatementEntity.contextRegistrationHi = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("    AND StatementEntity.contextRegistrationLo = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    AND StatementEntity.statementActorPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("    AND StatementEntity.statementContentEntryUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("    AND (");
        _stringBuilder.append("?");
        _stringBuilder.append(" = '%' OR VerbEntity.verbUrlId LIKE ");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    AND StatementEntity.statementVerbUid NOT IN (");
        int _inputSize = deSelectedVerbUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    /* Permission check */");
        _stringBuilder.append("\n");
        _stringBuilder.append("    AND (");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        OR EXISTS(");
        _stringBuilder.append("\n");
        _stringBuilder.append("            SELECT CoursePermission.cpUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("            FROM CoursePermission");
        _stringBuilder.append("\n");
        _stringBuilder.append("            WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("            AND (");
        _stringBuilder.append("\n");
        _stringBuilder.append("                CoursePermission.cpToPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole");
        _stringBuilder.append("\n");
        _stringBuilder.append("            )");
        _stringBuilder.append("\n");
        _stringBuilder.append("            AND (CoursePermission.cpPermissionsFlag & 128) > 0 ");
        _stringBuilder.append("\n");
        _stringBuilder.append("            AND NOT CoursePermission.cpIsDeleted");
        _stringBuilder.append("\n");
        _stringBuilder.append("        )");
        _stringBuilder.append("\n");
        _stringBuilder.append("        OR (");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        EXISTS(SELECT 1");
        _stringBuilder.append("\n");
        _stringBuilder.append("                 FROM SystemPermission");
        _stringBuilder.append("\n");
        _stringBuilder.append("                WHERE ");
        _stringBuilder.append("?");
        _stringBuilder.append(" != 0 ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND SystemPermission.spToPersonUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND (SystemPermission.spPermissionsFlag &");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("            128");
        _stringBuilder.append("\n");
        _stringBuilder.append("            ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ) > 0");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  AND NOT SystemPermission.spIsDeleted)");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        )");
        _stringBuilder.append("\n");
        _stringBuilder.append("    )");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ORDER BY ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    CASE ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("        WHEN 1 THEN StatementEntity.timestamp");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ELSE NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("    END DESC,");
        _stringBuilder.append("\n");
        _stringBuilder.append("    CASE ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("        WHEN 2 THEN StatementEntity.timestamp");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ELSE NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("    END ASC,");
        _stringBuilder.append("\n");
        _stringBuilder.append("    CASE ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("        WHEN 3 THEN StatementEntity.resultScoreRaw");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ELSE NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("    END DESC,");
        _stringBuilder.append("\n");
        _stringBuilder.append("    CASE ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("        WHEN 4 THEN StatementEntity.resultScoreRaw");
        _stringBuilder.append("\n");
        _stringBuilder.append("        ELSE NULL");
        _stringBuilder.append("\n");
        _stringBuilder.append("    END ASC");
        _stringBuilder.append("\n");
        String _sql = _stringBuilder.toString();
        int _argCount = 16 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, registrationHi);
        _argIndex = 3;
        _statement.bindLong(_argIndex, registrationLo);
        _argIndex = 4;
        _statement.bindLong(_argIndex, selectedPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 6;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 7;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 8;
        for (long _item : deSelectedVerbUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 8 + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9 + _inputSize;
        _statement.bindLong(_argIndex, selectedPersonUid);
        _argIndex = 10 + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11 + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12 + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 14 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 15 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 16 + _inputSize;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<StatementEntityAndVerb>(_statement, this.__db, new String[]{"StatementEntity", "VerbEntity", "VerbLangMapEntry", "ActivityEntity", "ActivityLangMapEntry", "ClazzEnrolment", "CoursePermission", "SystemPermission"}){

            @NonNull
            protected List<StatementEntityAndVerb> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementIdHi");
                int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementIdLo");
                int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementActorPersonUid");
                int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementVerbUid");
                int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementObjectType");
                int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementObjectUid1");
                int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementObjectUid2");
                int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementActorUid");
                int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"authorityActorUid");
                int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"teamUid");
                int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultCompletion");
                int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultSuccess");
                int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultScoreScaled");
                int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultScoreRaw");
                int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultScoreMin");
                int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultScoreMax");
                int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultDuration");
                int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resultResponse");
                int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"timestamp");
                int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"stored");
                int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextRegistrationHi");
                int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextRegistrationLo");
                int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextRegistrationHash");
                int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextPlatform");
                int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextStatementRefIdHi");
                int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextStatementRefIdLo");
                int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contextInstructorActorUid");
                int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementLct");
                int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"extensionProgress");
                int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"completionOrProgress");
                int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementContentEntryUid");
                int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementLearnerGroupUid");
                int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementClazzUid");
                int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementCbUid");
                int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementDoorNode");
                int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isSubStatement");
                int _cursorIndexOfVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"verbUid");
                int _cursorIndexOfVerbUrlId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"verbUrlId");
                int _cursorIndexOfVerbDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"verbDeleted");
                int _cursorIndexOfVerbLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"verbLct");
                int _cursorIndexOfVlmeVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"vlmeVerbUid");
                int _cursorIndexOfVlmeLangHash = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"vlmeLangHash");
                int _cursorIndexOfVlmeLangCode = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"vlmeLangCode");
                int _cursorIndexOfVlmeEntryString = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"vlmeEntryString");
                int _cursorIndexOfVlmeLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"vlmeLastModified");
                int _cursorIndexOfActUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"actUid");
                int _cursorIndexOfActIdIri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"actIdIri");
                int _cursorIndexOfActType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"actType");
                int _cursorIndexOfActMoreInfo = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"actMoreInfo");
                int _cursorIndexOfActInteractionType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"actInteractionType");
                int _cursorIndexOfActCorrectResponsePatterns = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"actCorrectResponsePatterns");
                int _cursorIndexOfActLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"actLct");
                int _cursorIndexOfAlmeActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"almeActivityUid");
                int _cursorIndexOfAlmeHash = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"almeHash");
                int _cursorIndexOfAlmeLangCode = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"almeLangCode");
                int _cursorIndexOfAlmePropName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"almePropName");
                int _cursorIndexOfAlmeValue = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"almeValue");
                int _cursorIndexOfAlmeAieHash = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"almeAieHash");
                int _cursorIndexOfAlmeLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"almeLastMod");
                int _cursorIndexOfStatementActivityDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statementActivityDescription");
                ArrayList<StatementEntityAndVerb> _result2 = new ArrayList<StatementEntityAndVerb>(cursor.getCount());
                while (cursor.moveToNext()) {
                    ActivityLangMapEntry _tmpActivityLangMapEntry;
                    ActivityEntity _tmpActivity;
                    VerbLangMapEntry _tmpVerbDisplay;
                    VerbEntity _tmpVerb;
                    String _tmpStatementActivityDescription = cursor.isNull(_cursorIndexOfStatementActivityDescription) ? null : cursor.getString(_cursorIndexOfStatementActivityDescription);
                    long _tmpStatementIdHi = cursor.getLong(_cursorIndexOfStatementIdHi);
                    long _tmpStatementIdLo = cursor.getLong(_cursorIndexOfStatementIdLo);
                    long _tmpStatementActorPersonUid = cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                    long _tmpStatementVerbUid = cursor.getLong(_cursorIndexOfStatementVerbUid);
                    int _tmpStatementObjectType = cursor.getInt(_cursorIndexOfStatementObjectType);
                    long _tmpStatementObjectUid1 = cursor.getLong(_cursorIndexOfStatementObjectUid1);
                    long _tmpStatementObjectUid2 = cursor.getLong(_cursorIndexOfStatementObjectUid2);
                    long _tmpStatementActorUid = cursor.getLong(_cursorIndexOfStatementActorUid);
                    long _tmpAuthorityActorUid = cursor.getLong(_cursorIndexOfAuthorityActorUid);
                    long _tmpTeamUid = cursor.getLong(_cursorIndexOfTeamUid);
                    Integer _tmp = cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResultCompletion));
                    Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                    Integer _tmp_1 = cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResultSuccess));
                    Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    Float _tmpResultScoreScaled = cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfResultScoreScaled));
                    Float _tmpResultScoreRaw = cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfResultScoreRaw));
                    Float _tmpResultScoreMin = cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfResultScoreMin));
                    Float _tmpResultScoreMax = cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfResultScoreMax));
                    Long _tmpResultDuration = cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfResultDuration));
                    String _tmpResultResponse = cursor.isNull(_cursorIndexOfResultResponse) ? null : cursor.getString(_cursorIndexOfResultResponse);
                    long _tmpTimestamp = cursor.getLong(_cursorIndexOfTimestamp);
                    long _tmpStored = cursor.getLong(_cursorIndexOfStored);
                    long _tmpContextRegistrationHi = cursor.getLong(_cursorIndexOfContextRegistrationHi);
                    long _tmpContextRegistrationLo = cursor.getLong(_cursorIndexOfContextRegistrationLo);
                    long _tmpContextRegistrationHash = cursor.getLong(_cursorIndexOfContextRegistrationHash);
                    String _tmpContextPlatform = cursor.isNull(_cursorIndexOfContextPlatform) ? null : cursor.getString(_cursorIndexOfContextPlatform);
                    long _tmpContextStatementRefIdHi = cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                    long _tmpContextStatementRefIdLo = cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                    long _tmpContextInstructorActorUid = cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                    long _tmpStatementLct = cursor.getLong(_cursorIndexOfStatementLct);
                    Integer _tmpExtensionProgress = cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfExtensionProgress));
                    int _tmp_2 = cursor.getInt(_cursorIndexOfCompletionOrProgress);
                    boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                    long _tmpStatementContentEntryUid = cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                    long _tmpStatementLearnerGroupUid = cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                    long _tmpStatementClazzUid = cursor.getLong(_cursorIndexOfStatementClazzUid);
                    long _tmpStatementCbUid = cursor.getLong(_cursorIndexOfStatementCbUid);
                    long _tmpStatementDoorNode = cursor.getLong(_cursorIndexOfStatementDoorNode);
                    int _tmp_3 = cursor.getInt(_cursorIndexOfIsSubStatement);
                    boolean _tmpIsSubStatement = _tmp_3 != 0;
                    StatementEntity _tmpStatementEntity = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                    if (!(cursor.isNull(_cursorIndexOfVerbUid) && cursor.isNull(_cursorIndexOfVerbUrlId) && cursor.isNull(_cursorIndexOfVerbDeleted) && cursor.isNull(_cursorIndexOfVerbLct))) {
                        long _tmpVerbUid = cursor.getLong(_cursorIndexOfVerbUid);
                        String _tmpVerbUrlId = cursor.isNull(_cursorIndexOfVerbUrlId) ? null : cursor.getString(_cursorIndexOfVerbUrlId);
                        int _tmp_4 = cursor.getInt(_cursorIndexOfVerbDeleted);
                        boolean _tmpVerbDeleted = _tmp_4 != 0;
                        long _tmpVerbLct = cursor.getLong(_cursorIndexOfVerbLct);
                        _tmpVerb = new VerbEntity(_tmpVerbUid, _tmpVerbUrlId, _tmpVerbDeleted, _tmpVerbLct);
                    } else {
                        _tmpVerb = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfVlmeVerbUid) && cursor.isNull(_cursorIndexOfVlmeLangHash) && cursor.isNull(_cursorIndexOfVlmeLangCode) && cursor.isNull(_cursorIndexOfVlmeEntryString) && cursor.isNull(_cursorIndexOfVlmeLastModified))) {
                        long _tmpVlmeVerbUid = cursor.getLong(_cursorIndexOfVlmeVerbUid);
                        long _tmpVlmeLangHash = cursor.getLong(_cursorIndexOfVlmeLangHash);
                        String _tmpVlmeLangCode = cursor.isNull(_cursorIndexOfVlmeLangCode) ? null : cursor.getString(_cursorIndexOfVlmeLangCode);
                        String _tmpVlmeEntryString = cursor.isNull(_cursorIndexOfVlmeEntryString) ? null : cursor.getString(_cursorIndexOfVlmeEntryString);
                        long _tmpVlmeLastModified = cursor.getLong(_cursorIndexOfVlmeLastModified);
                        _tmpVerbDisplay = new VerbLangMapEntry(_tmpVlmeVerbUid, _tmpVlmeLangHash, _tmpVlmeLangCode, _tmpVlmeEntryString, _tmpVlmeLastModified);
                    } else {
                        _tmpVerbDisplay = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfActUid) && cursor.isNull(_cursorIndexOfActIdIri) && cursor.isNull(_cursorIndexOfActType) && cursor.isNull(_cursorIndexOfActMoreInfo) && cursor.isNull(_cursorIndexOfActInteractionType) && cursor.isNull(_cursorIndexOfActCorrectResponsePatterns) && cursor.isNull(_cursorIndexOfActLct))) {
                        long _tmpActUid = cursor.getLong(_cursorIndexOfActUid);
                        String _tmpActIdIri = cursor.isNull(_cursorIndexOfActIdIri) ? null : cursor.getString(_cursorIndexOfActIdIri);
                        String _tmpActType = cursor.isNull(_cursorIndexOfActType) ? null : cursor.getString(_cursorIndexOfActType);
                        String _tmpActMoreInfo = cursor.isNull(_cursorIndexOfActMoreInfo) ? null : cursor.getString(_cursorIndexOfActMoreInfo);
                        int _tmpActInteractionType = cursor.getInt(_cursorIndexOfActInteractionType);
                        String _tmpActCorrectResponsePatterns = cursor.isNull(_cursorIndexOfActCorrectResponsePatterns) ? null : cursor.getString(_cursorIndexOfActCorrectResponsePatterns);
                        long _tmpActLct = cursor.getLong(_cursorIndexOfActLct);
                        _tmpActivity = new ActivityEntity(_tmpActUid, _tmpActIdIri, _tmpActType, _tmpActMoreInfo, _tmpActInteractionType, _tmpActCorrectResponsePatterns, _tmpActLct);
                    } else {
                        _tmpActivity = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfAlmeActivityUid) && cursor.isNull(_cursorIndexOfAlmeHash) && cursor.isNull(_cursorIndexOfAlmeLangCode) && cursor.isNull(_cursorIndexOfAlmePropName) && cursor.isNull(_cursorIndexOfAlmeValue) && cursor.isNull(_cursorIndexOfAlmeAieHash) && cursor.isNull(_cursorIndexOfAlmeLastMod))) {
                        long _tmpAlmeActivityUid = cursor.getLong(_cursorIndexOfAlmeActivityUid);
                        long _tmpAlmeHash = cursor.getLong(_cursorIndexOfAlmeHash);
                        String _tmpAlmeLangCode = cursor.isNull(_cursorIndexOfAlmeLangCode) ? null : cursor.getString(_cursorIndexOfAlmeLangCode);
                        String _tmpAlmePropName = cursor.isNull(_cursorIndexOfAlmePropName) ? null : cursor.getString(_cursorIndexOfAlmePropName);
                        String _tmpAlmeValue = cursor.isNull(_cursorIndexOfAlmeValue) ? null : cursor.getString(_cursorIndexOfAlmeValue);
                        long _tmpAlmeAieHash = cursor.getLong(_cursorIndexOfAlmeAieHash);
                        long _tmpAlmeLastMod = cursor.getLong(_cursorIndexOfAlmeLastMod);
                        _tmpActivityLangMapEntry = new ActivityLangMapEntry(_tmpAlmeActivityUid, _tmpAlmeHash, _tmpAlmeLangCode, _tmpAlmePropName, _tmpAlmeValue, _tmpAlmeAieHash, _tmpAlmeLastMod);
                    } else {
                        _tmpActivityLangMapEntry = null;
                    }
                    StatementEntityAndVerb _item_1 = new StatementEntityAndVerb(_tmpStatementEntity, _tmpVerb, _tmpVerbDisplay, _tmpActivity, _tmpActivityLangMapEntry, _tmpStatementActivityDescription);
                    _result2.add(_item_1);
                }
                return _result2;
            }
        };
    }

    @Override
    public Flow<List<VerbEntityAndName>> getUniqueVerbsForSession(long registrationHi, long registrationLo, long selectedPersonUid, long contentEntryUid) {
        String _sql = "\n    WITH DistinctVerbUrls(statementVerbUid) AS (\n        SELECT DISTINCT StatementEntity.statementVerbUid\n        FROM StatementEntity\n        WHERE StatementEntity.contextRegistrationHi = ?\n            AND StatementEntity.contextRegistrationLo = ?\n            AND StatementEntity.statementActorPersonUid = ?\n            AND StatementEntity.statementContentEntryUid = ?\n    )\n    \n    SELECT VerbEntity.*,\n           VerbLangMapEntry.*\n    FROM DistinctVerbUrls\n         JOIN VerbEntity \n              ON VerbEntity.verbUid = DistinctVerbUrls.statementVerbUid\n         LEFT JOIN VerbLangMapEntry\n                  ON (VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash) = \n                     (SELECT VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash\n                      FROM VerbLangMapEntry\n                      WHERE VerbLangMapEntry.vlmeVerbUid = DistinctVerbUrls.statementVerbUid\n                      ORDER BY VerbLangMapEntry.vlmeLastModified DESC\n                      LIMIT 1)\n";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n    WITH DistinctVerbUrls(statementVerbUid) AS (\n        SELECT DISTINCT StatementEntity.statementVerbUid\n        FROM StatementEntity\n        WHERE StatementEntity.contextRegistrationHi = ?\n            AND StatementEntity.contextRegistrationLo = ?\n            AND StatementEntity.statementActorPersonUid = ?\n            AND StatementEntity.statementContentEntryUid = ?\n    )\n    \n    SELECT VerbEntity.*,\n           VerbLangMapEntry.*\n    FROM DistinctVerbUrls\n         JOIN VerbEntity \n              ON VerbEntity.verbUid = DistinctVerbUrls.statementVerbUid\n         LEFT JOIN VerbLangMapEntry\n                  ON (VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash) = \n                     (SELECT VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash\n                      FROM VerbLangMapEntry\n                      WHERE VerbLangMapEntry.vlmeVerbUid = DistinctVerbUrls.statementVerbUid\n                      ORDER BY VerbLangMapEntry.vlmeLastModified DESC\n                      LIMIT 1)\n", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, registrationHi);
        _argIndex = 2;
        _statement.bindLong(_argIndex, registrationLo);
        _argIndex = 3;
        _statement.bindLong(_argIndex, selectedPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, contentEntryUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"StatementEntity", "VerbEntity", "VerbLangMapEntry"}, (Callable)new Callable<List<VerbEntityAndName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<VerbEntityAndName> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verbUid");
                    int _cursorIndexOfVerbUrlId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verbUrlId");
                    int _cursorIndexOfVerbDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verbDeleted");
                    int _cursorIndexOfVerbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verbLct");
                    int _cursorIndexOfVlmeVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeVerbUid");
                    int _cursorIndexOfVlmeLangHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeLangHash");
                    int _cursorIndexOfVlmeLangCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeLangCode");
                    int _cursorIndexOfVlmeEntryString = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeEntryString");
                    int _cursorIndexOfVlmeLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeLastModified");
                    ArrayList<VerbEntityAndName> _result2 = new ArrayList<VerbEntityAndName>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        VerbLangMapEntry _tmpVerbName;
                        long _tmpVerbUid = _cursor.getLong(_cursorIndexOfVerbUid);
                        String _tmpVerbUrlId = _cursor.isNull(_cursorIndexOfVerbUrlId) ? null : _cursor.getString(_cursorIndexOfVerbUrlId);
                        int _tmp = _cursor.getInt(_cursorIndexOfVerbDeleted);
                        boolean _tmpVerbDeleted = _tmp != 0;
                        long _tmpVerbLct = _cursor.getLong(_cursorIndexOfVerbLct);
                        VerbEntity _tmpVerbEntity = new VerbEntity(_tmpVerbUid, _tmpVerbUrlId, _tmpVerbDeleted, _tmpVerbLct);
                        if (!(_cursor.isNull(_cursorIndexOfVlmeVerbUid) && _cursor.isNull(_cursorIndexOfVlmeLangHash) && _cursor.isNull(_cursorIndexOfVlmeLangCode) && _cursor.isNull(_cursorIndexOfVlmeEntryString) && _cursor.isNull(_cursorIndexOfVlmeLastModified))) {
                            long _tmpVlmeVerbUid = _cursor.getLong(_cursorIndexOfVlmeVerbUid);
                            long _tmpVlmeLangHash = _cursor.getLong(_cursorIndexOfVlmeLangHash);
                            String _tmpVlmeLangCode = _cursor.isNull(_cursorIndexOfVlmeLangCode) ? null : _cursor.getString(_cursorIndexOfVlmeLangCode);
                            String _tmpVlmeEntryString = _cursor.isNull(_cursorIndexOfVlmeEntryString) ? null : _cursor.getString(_cursorIndexOfVlmeEntryString);
                            long _tmpVlmeLastModified = _cursor.getLong(_cursorIndexOfVlmeLastModified);
                            _tmpVerbName = new VerbLangMapEntry(_tmpVlmeVerbUid, _tmpVlmeLangHash, _tmpVlmeLangCode, _tmpVlmeEntryString, _tmpVlmeLastModified);
                        } else {
                            _tmpVerbName = null;
                        }
                        VerbEntityAndName _item = new VerbEntityAndName(_tmpVerbEntity, _tmpVerbName);
                        _result2.add(_item);
                    }
                    ArrayList<VerbEntityAndName> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object scoreOrProgressDataExistsForContent(long contentEntryUid, long accountPersonUid, Continuation<? super List<StatementEntity>> $completion) {
        String _sql = "\n        SELECT * \n          FROM (SELECT StatementEntity.*\n                 \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = ?\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = ?\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = ? \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    \n                   AND (     StatementEntity.extensionProgress IS NOT NULL\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                 LIMIT 1) AS ProgressStatements\n        UNION\n        SELECT * \n          FROM (SELECT StatementEntity.*\n                 \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = ?\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = ?\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = ? \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    \n                   AND (     StatementEntity.resultScoreScaled IS NOT NULL\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                 LIMIT 1) AS ScoreStatements\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM (SELECT StatementEntity.*\n                 \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = ?\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = ?\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = ? \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    \n                   AND (     StatementEntity.extensionProgress IS NOT NULL\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                 LIMIT 1) AS ProgressStatements\n        UNION\n        SELECT * \n          FROM (SELECT StatementEntity.*\n                 \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = ?\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = ?\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = ? \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    \n                   AND (     StatementEntity.resultScoreScaled IS NOT NULL\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                 LIMIT 1) AS ScoreStatements\n    ", (int)12);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    ArrayList<StatementEntity> _result2 = new ArrayList<StatementEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        StatementEntity _item = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidWithActivityAsync(long statementIdHi, long statementIdLo, Continuation<? super StatementAndActivity> $completion) {
        String _sql = "\n        SELECT StatementEntity.*, ActivityEntity.*\n          FROM StatementEntity\n               LEFT JOIN ActivityEntity\n                         ON ActivityEntity.actUid = StatementEntity.statementObjectUid1\n         WHERE StatementEntity.statementIdHi = ?\n           AND StatementEntity.statementIdLo = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StatementEntity.*, ActivityEntity.*\n          FROM StatementEntity\n               LEFT JOIN ActivityEntity\n                         ON ActivityEntity.actUid = StatementEntity.statementObjectUid1\n         WHERE StatementEntity.statementIdHi = ?\n           AND StatementEntity.statementIdLo = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, statementIdHi);
        _argIndex = 2;
        _statement.bindLong(_argIndex, statementIdLo);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<StatementAndActivity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public StatementAndActivity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    StatementAndActivity _result2;
                    int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdHi");
                    int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementIdLo");
                    int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorPersonUid");
                    int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementVerbUid");
                    int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectType");
                    int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid1");
                    int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementObjectUid2");
                    int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementActorUid");
                    int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authorityActorUid");
                    int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"teamUid");
                    int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultCompletion");
                    int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultSuccess");
                    int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreScaled");
                    int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreRaw");
                    int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMin");
                    int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultScoreMax");
                    int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultDuration");
                    int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resultResponse");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stored");
                    int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHi");
                    int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationLo");
                    int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextRegistrationHash");
                    int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextPlatform");
                    int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdHi");
                    int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextStatementRefIdLo");
                    int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contextInstructorActorUid");
                    int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLct");
                    int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensionProgress");
                    int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionOrProgress");
                    int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementContentEntryUid");
                    int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementLearnerGroupUid");
                    int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementClazzUid");
                    int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementCbUid");
                    int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statementDoorNode");
                    int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSubStatement");
                    int _cursorIndexOfActUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actUid");
                    int _cursorIndexOfActIdIri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actIdIri");
                    int _cursorIndexOfActType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actType");
                    int _cursorIndexOfActMoreInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actMoreInfo");
                    int _cursorIndexOfActInteractionType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actInteractionType");
                    int _cursorIndexOfActCorrectResponsePatterns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actCorrectResponsePatterns");
                    int _cursorIndexOfActLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actLct");
                    if (_cursor.moveToFirst()) {
                        ActivityEntity _tmpActivityEntity;
                        long _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultCompletion));
                        Boolean _tmpResultCompletion = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResultSuccess));
                        Boolean _tmpResultSuccess = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Float _tmpResultScoreScaled = _cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreScaled));
                        Float _tmpResultScoreRaw = _cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreRaw));
                        Float _tmpResultScoreMin = _cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMin));
                        Float _tmpResultScoreMax = _cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfResultScoreMax));
                        Long _tmpResultDuration = _cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResultDuration));
                        String _tmpResultResponse = _cursor.isNull(_cursorIndexOfResultResponse) ? null : _cursor.getString(_cursorIndexOfResultResponse);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursor.isNull(_cursorIndexOfContextPlatform) ? null : _cursor.getString(_cursorIndexOfContextPlatform);
                        long _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExtensionProgress));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
                        boolean _tmpCompletionOrProgress = _tmp_2 != 0;
                        long _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
                        boolean _tmpIsSubStatement = _tmp_3 != 0;
                        StatementEntity _tmpStatementEntity = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                        if (!(_cursor.isNull(_cursorIndexOfActUid) && _cursor.isNull(_cursorIndexOfActIdIri) && _cursor.isNull(_cursorIndexOfActType) && _cursor.isNull(_cursorIndexOfActMoreInfo) && _cursor.isNull(_cursorIndexOfActInteractionType) && _cursor.isNull(_cursorIndexOfActCorrectResponsePatterns) && _cursor.isNull(_cursorIndexOfActLct))) {
                            long _tmpActUid = _cursor.getLong(_cursorIndexOfActUid);
                            String _tmpActIdIri = _cursor.isNull(_cursorIndexOfActIdIri) ? null : _cursor.getString(_cursorIndexOfActIdIri);
                            String _tmpActType = _cursor.isNull(_cursorIndexOfActType) ? null : _cursor.getString(_cursorIndexOfActType);
                            String _tmpActMoreInfo = _cursor.isNull(_cursorIndexOfActMoreInfo) ? null : _cursor.getString(_cursorIndexOfActMoreInfo);
                            int _tmpActInteractionType = _cursor.getInt(_cursorIndexOfActInteractionType);
                            String _tmpActCorrectResponsePatterns = _cursor.isNull(_cursorIndexOfActCorrectResponsePatterns) ? null : _cursor.getString(_cursorIndexOfActCorrectResponsePatterns);
                            long _tmpActLct = _cursor.getLong(_cursorIndexOfActLct);
                            _tmpActivityEntity = new ActivityEntity(_tmpActUid, _tmpActIdIri, _tmpActType, _tmpActMoreInfo, _tmpActInteractionType, _tmpActCorrectResponsePatterns, _tmpActLct);
                        } else {
                            _tmpActivityEntity = null;
                        }
                        _result2 = new StatementAndActivity(_tmpStatementEntity, _tmpActivityEntity);
                    } else {
                        _result2 = null;
                    }
                    StatementAndActivity statementAndActivity = _result2;
                    return statementAndActivity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object runReportQuery(final SupportSQLiteQuery query, Continuation<? super List<StatementReportRow>> $completion) {
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementReportRow>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementReportRow> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)query, (boolean)false, null);){
                    int _cursorIndexOfYAxis = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"yAxis");
                    int _cursorIndexOfXAxis = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"xAxis");
                    int _cursorIndexOfSubgroup = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"subgroup");
                    ArrayList<StatementReportRow> _result2 = new ArrayList<StatementReportRow>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        double _tmpYAxis = _cursorIndexOfYAxis == -1 ? 0.0 : _cursor.getDouble(_cursorIndexOfYAxis);
                        String _tmpXAxis = _cursorIndexOfXAxis == -1 ? null : _cursor.getString(_cursorIndexOfXAxis);
                        String _tmpSubgroup = _cursorIndexOfSubgroup == -1 ? null : _cursor.getString(_cursorIndexOfSubgroup);
                        StatementReportRow _item = new StatementReportRow(_tmpYAxis, _tmpXAxis, _tmpSubgroup);
                        _result2.add(_item);
                    }
                    ArrayList<StatementReportRow> arrayList = _result2;
                    return arrayList;
                }
            }
        }, $completion);
    }

    @Override
    public Object getResults(final SupportSQLiteQuery query, Continuation<? super List<StatementReportData>> $completion) {
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementReportData>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementReportData> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StatementDao_Impl.this.__db, (SupportSQLiteQuery)query, (boolean)false, null);){
                    int _cursorIndexOfYAxis = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"yAxis");
                    int _cursorIndexOfXAxis = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"xAxis");
                    int _cursorIndexOfSubgroup = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"subgroup");
                    ArrayList<StatementReportData> _result2 = new ArrayList<StatementReportData>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        float _tmpYAxis = _cursorIndexOfYAxis == -1 ? 0.0f : _cursor.getFloat(_cursorIndexOfYAxis);
                        String _tmpXAxis = _cursorIndexOfXAxis == -1 ? null : (_cursor.isNull(_cursorIndexOfXAxis) ? null : _cursor.getString(_cursorIndexOfXAxis));
                        String _tmpSubgroup = _cursorIndexOfSubgroup == -1 ? null : (_cursor.isNull(_cursorIndexOfSubgroup) ? null : _cursor.getString(_cursorIndexOfSubgroup));
                        StatementReportData _item = new StatementReportData(_tmpYAxis, _tmpXAxis, _tmpSubgroup);
                        _result2.add(_item);
                    }
                    ArrayList<StatementReportData> arrayList = _result2;
                    return arrayList;
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, StatementEntityAndDisplayDetails> getListResults(SupportSQLiteQuery query) {
        return new LimitOffsetPagingSource<StatementEntityAndDisplayDetails>(query, this.__db, new String[]{"StatementEntity", "Person"}){

            @NonNull
            protected List<StatementEntityAndDisplayDetails> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementIdHi");
                int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementIdLo");
                int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementActorPersonUid");
                int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementVerbUid");
                int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementObjectType");
                int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementObjectUid1");
                int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementObjectUid2");
                int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementActorUid");
                int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"authorityActorUid");
                int _cursorIndexOfTeamUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"teamUid");
                int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndex((Cursor)cursor, (String)"resultCompletion");
                int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndex((Cursor)cursor, (String)"resultSuccess");
                int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndex((Cursor)cursor, (String)"resultScoreScaled");
                int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndex((Cursor)cursor, (String)"resultScoreRaw");
                int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndex((Cursor)cursor, (String)"resultScoreMin");
                int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndex((Cursor)cursor, (String)"resultScoreMax");
                int _cursorIndexOfResultDuration = CursorUtil.getColumnIndex((Cursor)cursor, (String)"resultDuration");
                int _cursorIndexOfResultResponse = CursorUtil.getColumnIndex((Cursor)cursor, (String)"resultResponse");
                int _cursorIndexOfTimestamp = CursorUtil.getColumnIndex((Cursor)cursor, (String)"timestamp");
                int _cursorIndexOfStored = CursorUtil.getColumnIndex((Cursor)cursor, (String)"stored");
                int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndex((Cursor)cursor, (String)"contextRegistrationHi");
                int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndex((Cursor)cursor, (String)"contextRegistrationLo");
                int _cursorIndexOfContextRegistrationHash = CursorUtil.getColumnIndex((Cursor)cursor, (String)"contextRegistrationHash");
                int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndex((Cursor)cursor, (String)"contextPlatform");
                int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndex((Cursor)cursor, (String)"contextStatementRefIdHi");
                int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndex((Cursor)cursor, (String)"contextStatementRefIdLo");
                int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"contextInstructorActorUid");
                int _cursorIndexOfStatementLct = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementLct");
                int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndex((Cursor)cursor, (String)"extensionProgress");
                int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndex((Cursor)cursor, (String)"completionOrProgress");
                int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementContentEntryUid");
                int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementLearnerGroupUid");
                int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementClazzUid");
                int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementCbUid");
                int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndex((Cursor)cursor, (String)"statementDoorNode");
                int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndex((Cursor)cursor, (String)"isSubStatement");
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndex((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndex((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndex((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndex((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndex((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndex((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndex((Cursor)cursor, (String)"active");
                int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndex((Cursor)cursor, (String)"isPersonalAccount");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndex((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndex((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndex((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndex((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndex((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndex((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndex((Cursor)cursor, (String)"motherNum");
                ArrayList<StatementEntityAndDisplayDetails> _result2 = new ArrayList<StatementEntityAndDisplayDetails>(cursor.getCount());
                while (cursor.moveToNext()) {
                    Person _tmpPerson;
                    StatementEntity _tmpStatement;
                    if (_cursorIndexOfStatementIdHi != -1 && !cursor.isNull(_cursorIndexOfStatementIdHi) || _cursorIndexOfStatementIdLo != -1 && !cursor.isNull(_cursorIndexOfStatementIdLo) || _cursorIndexOfStatementActorPersonUid != -1 && !cursor.isNull(_cursorIndexOfStatementActorPersonUid) || _cursorIndexOfStatementVerbUid != -1 && !cursor.isNull(_cursorIndexOfStatementVerbUid) || _cursorIndexOfStatementObjectType != -1 && !cursor.isNull(_cursorIndexOfStatementObjectType) || _cursorIndexOfStatementObjectUid1 != -1 && !cursor.isNull(_cursorIndexOfStatementObjectUid1) || _cursorIndexOfStatementObjectUid2 != -1 && !cursor.isNull(_cursorIndexOfStatementObjectUid2) || _cursorIndexOfStatementActorUid != -1 && !cursor.isNull(_cursorIndexOfStatementActorUid) || _cursorIndexOfAuthorityActorUid != -1 && !cursor.isNull(_cursorIndexOfAuthorityActorUid) || _cursorIndexOfTeamUid != -1 && !cursor.isNull(_cursorIndexOfTeamUid) || _cursorIndexOfResultCompletion != -1 && !cursor.isNull(_cursorIndexOfResultCompletion) || _cursorIndexOfResultSuccess != -1 && !cursor.isNull(_cursorIndexOfResultSuccess) || _cursorIndexOfResultScoreScaled != -1 && !cursor.isNull(_cursorIndexOfResultScoreScaled) || _cursorIndexOfResultScoreRaw != -1 && !cursor.isNull(_cursorIndexOfResultScoreRaw) || _cursorIndexOfResultScoreMin != -1 && !cursor.isNull(_cursorIndexOfResultScoreMin) || _cursorIndexOfResultScoreMax != -1 && !cursor.isNull(_cursorIndexOfResultScoreMax) || _cursorIndexOfResultDuration != -1 && !cursor.isNull(_cursorIndexOfResultDuration) || _cursorIndexOfResultResponse != -1 && !cursor.isNull(_cursorIndexOfResultResponse) || _cursorIndexOfTimestamp != -1 && !cursor.isNull(_cursorIndexOfTimestamp) || _cursorIndexOfStored != -1 && !cursor.isNull(_cursorIndexOfStored) || _cursorIndexOfContextRegistrationHi != -1 && !cursor.isNull(_cursorIndexOfContextRegistrationHi) || _cursorIndexOfContextRegistrationLo != -1 && !cursor.isNull(_cursorIndexOfContextRegistrationLo) || _cursorIndexOfContextRegistrationHash != -1 && !cursor.isNull(_cursorIndexOfContextRegistrationHash) || _cursorIndexOfContextPlatform != -1 && !cursor.isNull(_cursorIndexOfContextPlatform) || _cursorIndexOfContextStatementRefIdHi != -1 && !cursor.isNull(_cursorIndexOfContextStatementRefIdHi) || _cursorIndexOfContextStatementRefIdLo != -1 && !cursor.isNull(_cursorIndexOfContextStatementRefIdLo) || _cursorIndexOfContextInstructorActorUid != -1 && !cursor.isNull(_cursorIndexOfContextInstructorActorUid) || _cursorIndexOfStatementLct != -1 && !cursor.isNull(_cursorIndexOfStatementLct) || _cursorIndexOfExtensionProgress != -1 && !cursor.isNull(_cursorIndexOfExtensionProgress) || _cursorIndexOfCompletionOrProgress != -1 && !cursor.isNull(_cursorIndexOfCompletionOrProgress) || _cursorIndexOfStatementContentEntryUid != -1 && !cursor.isNull(_cursorIndexOfStatementContentEntryUid) || _cursorIndexOfStatementLearnerGroupUid != -1 && !cursor.isNull(_cursorIndexOfStatementLearnerGroupUid) || _cursorIndexOfStatementClazzUid != -1 && !cursor.isNull(_cursorIndexOfStatementClazzUid) || _cursorIndexOfStatementCbUid != -1 && !cursor.isNull(_cursorIndexOfStatementCbUid) || _cursorIndexOfStatementDoorNode != -1 && !cursor.isNull(_cursorIndexOfStatementDoorNode) || _cursorIndexOfIsSubStatement != -1 && !cursor.isNull(_cursorIndexOfIsSubStatement)) {
                        int _tmp_3;
                        int _tmp_2;
                        Boolean _tmpResultSuccess;
                        Boolean _tmpResultCompletion;
                        long _tmpStatementIdHi = _cursorIndexOfStatementIdHi == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementIdHi);
                        long _tmpStatementIdLo = _cursorIndexOfStatementIdLo == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementIdLo);
                        long _tmpStatementActorPersonUid = _cursorIndexOfStatementActorPersonUid == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementActorPersonUid);
                        long _tmpStatementVerbUid = _cursorIndexOfStatementVerbUid == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementVerbUid);
                        int _tmpStatementObjectType = _cursorIndexOfStatementObjectType == -1 ? 0 : cursor.getInt(_cursorIndexOfStatementObjectType);
                        long _tmpStatementObjectUid1 = _cursorIndexOfStatementObjectUid1 == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementObjectUid1);
                        long _tmpStatementObjectUid2 = _cursorIndexOfStatementObjectUid2 == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementObjectUid2);
                        long _tmpStatementActorUid = _cursorIndexOfStatementActorUid == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementActorUid);
                        long _tmpAuthorityActorUid = _cursorIndexOfAuthorityActorUid == -1 ? 0L : cursor.getLong(_cursorIndexOfAuthorityActorUid);
                        long _tmpTeamUid = _cursorIndexOfTeamUid == -1 ? 0L : cursor.getLong(_cursorIndexOfTeamUid);
                        if (_cursorIndexOfResultCompletion == -1) {
                            _tmpResultCompletion = null;
                        } else {
                            Integer _tmp = cursor.isNull(_cursorIndexOfResultCompletion) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResultCompletion));
                            Boolean bl = _tmp == null ? null : (_tmpResultCompletion = Boolean.valueOf(_tmp != 0));
                        }
                        if (_cursorIndexOfResultSuccess == -1) {
                            _tmpResultSuccess = null;
                        } else {
                            Integer _tmp_1 = cursor.isNull(_cursorIndexOfResultSuccess) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResultSuccess));
                            Boolean bl = _tmp_1 == null ? null : (_tmpResultSuccess = Boolean.valueOf(_tmp_1 != 0));
                        }
                        Float _tmpResultScoreScaled = _cursorIndexOfResultScoreScaled == -1 ? null : (cursor.isNull(_cursorIndexOfResultScoreScaled) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfResultScoreScaled)));
                        Float _tmpResultScoreRaw = _cursorIndexOfResultScoreRaw == -1 ? null : (cursor.isNull(_cursorIndexOfResultScoreRaw) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfResultScoreRaw)));
                        Float _tmpResultScoreMin = _cursorIndexOfResultScoreMin == -1 ? null : (cursor.isNull(_cursorIndexOfResultScoreMin) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfResultScoreMin)));
                        Float _tmpResultScoreMax = _cursorIndexOfResultScoreMax == -1 ? null : (cursor.isNull(_cursorIndexOfResultScoreMax) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfResultScoreMax)));
                        Long _tmpResultDuration = _cursorIndexOfResultDuration == -1 ? null : (cursor.isNull(_cursorIndexOfResultDuration) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfResultDuration)));
                        String _tmpResultResponse = _cursorIndexOfResultResponse == -1 ? null : (cursor.isNull(_cursorIndexOfResultResponse) ? null : cursor.getString(_cursorIndexOfResultResponse));
                        long _tmpTimestamp = _cursorIndexOfTimestamp == -1 ? 0L : cursor.getLong(_cursorIndexOfTimestamp);
                        long _tmpStored = _cursorIndexOfStored == -1 ? 0L : cursor.getLong(_cursorIndexOfStored);
                        long _tmpContextRegistrationHi = _cursorIndexOfContextRegistrationHi == -1 ? 0L : cursor.getLong(_cursorIndexOfContextRegistrationHi);
                        long _tmpContextRegistrationLo = _cursorIndexOfContextRegistrationLo == -1 ? 0L : cursor.getLong(_cursorIndexOfContextRegistrationLo);
                        long _tmpContextRegistrationHash = _cursorIndexOfContextRegistrationHash == -1 ? 0L : cursor.getLong(_cursorIndexOfContextRegistrationHash);
                        String _tmpContextPlatform = _cursorIndexOfContextPlatform == -1 ? null : (cursor.isNull(_cursorIndexOfContextPlatform) ? null : cursor.getString(_cursorIndexOfContextPlatform));
                        long _tmpContextStatementRefIdHi = _cursorIndexOfContextStatementRefIdHi == -1 ? 0L : cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
                        long _tmpContextStatementRefIdLo = _cursorIndexOfContextStatementRefIdLo == -1 ? 0L : cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
                        long _tmpContextInstructorActorUid = _cursorIndexOfContextInstructorActorUid == -1 ? 0L : cursor.getLong(_cursorIndexOfContextInstructorActorUid);
                        long _tmpStatementLct = _cursorIndexOfStatementLct == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementLct);
                        Integer _tmpExtensionProgress = _cursorIndexOfExtensionProgress == -1 ? null : (cursor.isNull(_cursorIndexOfExtensionProgress) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfExtensionProgress)));
                        boolean _tmpCompletionOrProgress = _cursorIndexOfCompletionOrProgress == -1 ? false : (_tmp_2 = cursor.getInt(_cursorIndexOfCompletionOrProgress)) != 0;
                        long _tmpStatementContentEntryUid = _cursorIndexOfStatementContentEntryUid == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                        long _tmpStatementLearnerGroupUid = _cursorIndexOfStatementLearnerGroupUid == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                        long _tmpStatementClazzUid = _cursorIndexOfStatementClazzUid == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementClazzUid);
                        long _tmpStatementCbUid = _cursorIndexOfStatementCbUid == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementCbUid);
                        long _tmpStatementDoorNode = _cursorIndexOfStatementDoorNode == -1 ? 0L : cursor.getLong(_cursorIndexOfStatementDoorNode);
                        boolean _tmpIsSubStatement = _cursorIndexOfIsSubStatement == -1 ? false : (_tmp_3 = cursor.getInt(_cursorIndexOfIsSubStatement)) != 0;
                        _tmpStatement = new StatementEntity(_tmpStatementIdHi, _tmpStatementIdLo, _tmpStatementActorPersonUid, _tmpStatementVerbUid, _tmpStatementObjectType, _tmpStatementObjectUid1, _tmpStatementObjectUid2, _tmpStatementActorUid, _tmpAuthorityActorUid, _tmpTeamUid, _tmpResultCompletion, _tmpResultSuccess, _tmpResultScoreScaled, _tmpResultScoreRaw, _tmpResultScoreMin, _tmpResultScoreMax, _tmpResultDuration, _tmpResultResponse, _tmpTimestamp, _tmpStored, _tmpContextRegistrationHi, _tmpContextRegistrationLo, _tmpContextRegistrationHash, _tmpContextPlatform, _tmpContextStatementRefIdHi, _tmpContextStatementRefIdLo, _tmpContextInstructorActorUid, _tmpStatementLct, _tmpExtensionProgress, _tmpCompletionOrProgress, _tmpStatementContentEntryUid, _tmpStatementLearnerGroupUid, _tmpStatementClazzUid, _tmpStatementCbUid, _tmpStatementDoorNode, _tmpIsSubStatement);
                    } else {
                        _tmpStatement = null;
                    }
                    if (_cursorIndexOfPersonUid != -1 && !cursor.isNull(_cursorIndexOfPersonUid) || _cursorIndexOfUsername != -1 && !cursor.isNull(_cursorIndexOfUsername) || _cursorIndexOfFirstNames != -1 && !cursor.isNull(_cursorIndexOfFirstNames) || _cursorIndexOfLastName != -1 && !cursor.isNull(_cursorIndexOfLastName) || _cursorIndexOfEmailAddr != -1 && !cursor.isNull(_cursorIndexOfEmailAddr) || _cursorIndexOfPhoneNum != -1 && !cursor.isNull(_cursorIndexOfPhoneNum) || _cursorIndexOfGender != -1 && !cursor.isNull(_cursorIndexOfGender) || _cursorIndexOfActive != -1 && !cursor.isNull(_cursorIndexOfActive) || _cursorIndexOfIsPersonalAccount != -1 && !cursor.isNull(_cursorIndexOfIsPersonalAccount) || _cursorIndexOfDateOfBirth != -1 && !cursor.isNull(_cursorIndexOfDateOfBirth) || _cursorIndexOfPersonAddress != -1 && !cursor.isNull(_cursorIndexOfPersonAddress) || _cursorIndexOfPersonOrgId != -1 && !cursor.isNull(_cursorIndexOfPersonOrgId) || _cursorIndexOfPersonGroupUid != -1 && !cursor.isNull(_cursorIndexOfPersonGroupUid) || _cursorIndexOfPersonLct != -1 && !cursor.isNull(_cursorIndexOfPersonLct) || _cursorIndexOfPersonCountry != -1 && !cursor.isNull(_cursorIndexOfPersonCountry) || _cursorIndexOfPersonType != -1 && !cursor.isNull(_cursorIndexOfPersonType) || _cursorIndexOfPersonMasterChangeSeqNum != -1 && !cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) || _cursorIndexOfPersonLocalChangeSeqNum != -1 && !cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) || _cursorIndexOfPersonLastChangedBy != -1 && !cursor.isNull(_cursorIndexOfPersonLastChangedBy) || _cursorIndexOfAdmin != -1 && !cursor.isNull(_cursorIndexOfAdmin) || _cursorIndexOfPersonNotes != -1 && !cursor.isNull(_cursorIndexOfPersonNotes) || _cursorIndexOfFatherName != -1 && !cursor.isNull(_cursorIndexOfFatherName) || _cursorIndexOfFatherNumber != -1 && !cursor.isNull(_cursorIndexOfFatherNumber) || _cursorIndexOfMotherName != -1 && !cursor.isNull(_cursorIndexOfMotherName) || _cursorIndexOfMotherNum != -1 && !cursor.isNull(_cursorIndexOfMotherNum)) {
                        boolean _tmpAdmin;
                        int _tmp_5;
                        boolean _tmpActive;
                        long _tmpPersonUid = _cursorIndexOfPersonUid == -1 ? 0L : cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = _cursorIndexOfUsername == -1 ? null : (cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername));
                        String _tmpFirstNames = _cursorIndexOfFirstNames == -1 ? null : (cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames));
                        String _tmpLastName = _cursorIndexOfLastName == -1 ? null : (cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName));
                        String _tmpEmailAddr = _cursorIndexOfEmailAddr == -1 ? null : (cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr));
                        String _tmpPhoneNum = _cursorIndexOfPhoneNum == -1 ? null : (cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum));
                        int _tmpGender = _cursorIndexOfGender == -1 ? 0 : cursor.getInt(_cursorIndexOfGender);
                        if (_cursorIndexOfActive == -1) {
                            _tmpActive = false;
                        } else {
                            int _tmp_4 = cursor.getInt(_cursorIndexOfActive);
                            boolean bl = _tmpActive = _tmp_4 != 0;
                        }
                        boolean _tmpIsPersonalAccount = _cursorIndexOfIsPersonalAccount == -1 ? false : (_tmp_5 = cursor.getInt(_cursorIndexOfIsPersonalAccount)) != 0;
                        long _tmpDateOfBirth = _cursorIndexOfDateOfBirth == -1 ? 0L : cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = _cursorIndexOfPersonAddress == -1 ? null : (cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress));
                        String _tmpPersonOrgId = _cursorIndexOfPersonOrgId == -1 ? null : (cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId));
                        long _tmpPersonGroupUid = _cursorIndexOfPersonGroupUid == -1 ? 0L : cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = _cursorIndexOfPersonLct == -1 ? 0L : cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = _cursorIndexOfPersonCountry == -1 ? null : (cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry));
                        int _tmpPersonType = _cursorIndexOfPersonType == -1 ? 0 : cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = _cursorIndexOfPersonMasterChangeSeqNum == -1 ? 0L : cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = _cursorIndexOfPersonLocalChangeSeqNum == -1 ? 0L : cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = _cursorIndexOfPersonLastChangedBy == -1 ? 0 : cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        if (_cursorIndexOfAdmin == -1) {
                            _tmpAdmin = false;
                        } else {
                            int _tmp_6 = cursor.getInt(_cursorIndexOfAdmin);
                            boolean bl = _tmpAdmin = _tmp_6 != 0;
                        }
                        String _tmpPersonNotes = _cursorIndexOfPersonNotes == -1 ? null : (cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes));
                        String _tmpFatherName = _cursorIndexOfFatherName == -1 ? null : (cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName));
                        String _tmpFatherNumber = _cursorIndexOfFatherNumber == -1 ? null : (cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber));
                        String _tmpMotherName = _cursorIndexOfMotherName == -1 ? null : (cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName));
                        String _tmpMotherNum = _cursorIndexOfMotherNum == -1 ? null : (cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum));
                        _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _tmpPerson = null;
                    }
                    StatementEntityAndDisplayDetails _item = new StatementEntityAndDisplayDetails(_tmpStatement, _tmpPerson);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

