# lib-database

The database modules are structured as follows:

* [lib-database-entities](../lib-database-entities/) contains POJO entity
objects which are persisted to and from the database. These objects have
@UmEntity and related annotations (roughly analagous to Room Persistence
Framework annotations). 
* [lib-database-annotation](../lib-database-annotation/) contains only
annotation classes. These annotations are used to generate platform
specific implementations.
* [lib-database](./) contains the Database (annotated with @UmDatabase)
and DAO (annotated with @UmDao) classes.
[core annotation processor](../lib-annotation-processor-core/) runs over
this module to generate platform specific implementations. The generated
platform-specific implementation code is output into platform specific
modules (e.g. lib-database-android)
* [lib-database-android](../lib-database-android/) contains the processed
entities generated by lib-database-entity-processor and the Room
Persistence Framework DAO and Database classes generated by the core
annotation processor.
* [lib-database-jdbc](../lib-database-jdbc/) contains JDBC helper classes
for the JDBC implementation.
* [lib-database-annotation-processor-core](../lib-database-annotation-processor-core)
the core annotation processor runs over the lib-database projects and
generates the required Database and DAO class implementations for that
each platform, and places the generated sources into a platform specific
module.


Any module using lib-database must either depend on
lib-database-entities or include a processed
version of those classes with identical public classes and methods.

Notes for migrating:

When renaming or dropping a column in sqlite, make sure to drop the old table after inserts and then create the index. Example below

database.execSQL("ALTER TABLE ClazzMember RENAME to ClazzMember_OLD")
database.execSQL("CREATE TABLE IF NOT EXISTS `ClazzMember` (`clazzMemberUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `clazzMemberPersonUid` INTEGER NOT NULL DEFAULT 0, `clazzMemberClazzUid` INTEGER NOT NULL DEFAULT 0, `clazzMemberDateJoined` INTEGER NOT NULL, `clazzMemberDateLeft` INTEGER NOT NULL, `clazzMemberRole` INTEGER NOT NULL, `clazzMemberAttendancePercentage` REAL NOT NULL, `clazzMemberActive` INTEGER NOT NULL, `clazzMemberLocalChangeSeqNum` INTEGER NOT NULL, `clazzMemberMasterChangeSeqNum` INTEGER NOT NULL, `clazzMemberLastChangedBy` INTEGER NOT NULL)")
database.execSQL("INSERT INTO ClazzMember (clazzMemberUid, clazzMemberPersonUid, clazzMemberClazzUid, clazzMemberDateJoined, clazzMemberDateLeft, clazzMemberRole, clazzMemberAttendancePercentage, clazzMemberActive, clazzMemberLocalChangeSeqNum, clazzMemberMasterChangeSeqNum, clazzMemberLastChangedBy) SELECT clazzMemberUid, clazzMemberPersonUid, clazzMemberClazzUid, dateJoined, dateLeft, role, clazzMemberAttendancePercentage, clazzMemberActive, clazzMemberLocalChangeSeqNum, clazzMemberMasterChangeSeqNum, clazzMemberLastChangedBy FROM ClazzMember_OLD")
database.execSQL("DROP TABLE ClazzMember_OLD")

database.execSQL("CREATE INDEX IF NOT EXISTS index_ClazzMember_clazzMemberPersonUid ON ClazzMember (clazzMemberPersonUid)")
database.execSQL("CREATE INDEX IF NOT EXISTS index_ClazzMember_clazzMemberClazzUid ON ClazzMember (clazzMemberClazzUid)")
database.execSQL("CREATE TABLE IF NOT EXISTS `ClazzMember_trk` (`pk` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `epk` INTEGER NOT NULL, `clientId` INTEGER NOT NULL, `csn` INTEGER NOT NULL, `rx` INTEGER NOT NULL, `reqId` INTEGER NOT NULL, `ts` INTEGER NOT NULL)")
database.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzMember_trk_clientId_epk_rx_csn` ON `ClazzMember_trk` (`clientId`, `epk`, `rx`, `csn`)")





## Replacing DataSource.Factory with DoorDataSourceFactory

```
find ./lib-database/src/commonMain/ -name \*.kt -print0 | xargs -0 sed -i 's/ DataSource.Factory/ DoorDataSource.Factory/g'
find ./lib-database/src/commonMain/ -name \*.kt -print0 | xargs -0 sed -i 's/import androidx.paging.DataSource/import com.ustadmobile.door.DoorDataSource/g'

find ./core/ -name \*.kt -print0 | xargs -0 sed -i 's/ DataSource.Factory/ DoorDataSourceFactory/g'
find ./core/ -name \*.kt -print0 | xargs -0 sed -i 's/import androidx.paging.DataSource/import com.ustadmobile.door.DoorDataSourceFactory/g'
```
