package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.ContentEntryPicture2
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class ContentEntryPicture2Dao : ImageDao {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertListAsync(entities: List<ContentEntryPicture2>)

  @Query(`value` =
      "\n        UPDATE ContentEntryPicture2\n           SET cepPictureUri = :uri,\n               cepThumbnailUri = :thumbnailUri,\n               cepLct = :time\n         WHERE cepUid = :uid  \n    ")
  actual abstract override suspend fun updateUri(
    uid: Long,
    uri: String?,
    thumbnailUri: String?,
    time: Long,
  )
}
