package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentEntryVersion;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryVersionDao_Impl extends ContentEntryVersionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntryVersion> __insertionAdapterOfContentEntryVersion;

  private final SharedSQLiteStatement __preparedStmtOfUpdateTransferJobItemEtag;

  public ContentEntryVersionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntryVersion = new EntityInsertionAdapter<ContentEntryVersion>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntryVersion` (`cevUid`,`cevContentEntryUid`,`cevOpenUri`,`cevContentType`,`cevManifestUrl`,`cevSize`,`cevInActive`,`cevLastModified`,`cevLct`,`cevStorageSize`,`cevOriginalSize`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntryVersion entity) {
        statement.bindLong(1, entity.getCevUid());
        statement.bindLong(2, entity.getCevContentEntryUid());
        if (entity.getCevOpenUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCevOpenUri());
        }
        if (entity.getCevContentType() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCevContentType());
        }
        if (entity.getCevManifestUrl() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getCevManifestUrl());
        }
        statement.bindLong(6, entity.getCevSize());
        final int _tmp = entity.getCevInActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getCevLastModified());
        statement.bindLong(9, entity.getCevLct());
        statement.bindLong(10, entity.getCevStorageSize());
        statement.bindLong(11, entity.getCevOriginalSize());
      }
    };
    this.__preparedStmtOfUpdateTransferJobItemEtag = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE TransferJobItem\n"
                + "           SET tjiEntityEtag = \n"
                + "               (SELECT cevLct\n"
                + "                  FROM ContentEntryVersion\n"
                + "                 WHERE cevUid = ?)\n"
                + "         WHERE tjiUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final ContentEntryVersion contentEntryVersion,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfContentEntryVersion.insertAndReturnId(contentEntryVersion);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateTransferJobItemEtag(final long entityUid, final int transferJobItemUid,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateTransferJobItemEtag.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, entityUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, transferJobItemUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateTransferJobItemEtag.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long cevUid,
      final Continuation<? super ContentEntryVersion> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntryVersion.*\n"
            + "          FROM ContentEntryVersion\n"
            + "         WHERE cevUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cevUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryVersion>() {
      @Override
      @Nullable
      public ContentEntryVersion call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevUid");
          final int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentEntryUid");
          final int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOpenUri");
          final int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentType");
          final int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "cevManifestUrl");
          final int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevSize");
          final int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cevInActive");
          final int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLastModified");
          final int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLct");
          final int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevStorageSize");
          final int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOriginalSize");
          final ContentEntryVersion _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCevUid;
            _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
            final long _tmpCevContentEntryUid;
            _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
            final String _tmpCevOpenUri;
            if (_cursor.isNull(_cursorIndexOfCevOpenUri)) {
              _tmpCevOpenUri = null;
            } else {
              _tmpCevOpenUri = _cursor.getString(_cursorIndexOfCevOpenUri);
            }
            final String _tmpCevContentType;
            if (_cursor.isNull(_cursorIndexOfCevContentType)) {
              _tmpCevContentType = null;
            } else {
              _tmpCevContentType = _cursor.getString(_cursorIndexOfCevContentType);
            }
            final String _tmpCevManifestUrl;
            if (_cursor.isNull(_cursorIndexOfCevManifestUrl)) {
              _tmpCevManifestUrl = null;
            } else {
              _tmpCevManifestUrl = _cursor.getString(_cursorIndexOfCevManifestUrl);
            }
            final long _tmpCevSize;
            _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
            final boolean _tmpCevInActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCevInActive);
            _tmpCevInActive = _tmp != 0;
            final long _tmpCevLastModified;
            _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
            final long _tmpCevLct;
            _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
            final long _tmpCevStorageSize;
            _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
            final long _tmpCevOriginalSize;
            _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
            _result = new ContentEntryVersion(_tmpCevUid,_tmpCevContentEntryUid,_tmpCevOpenUri,_tmpCevContentType,_tmpCevManifestUrl,_tmpCevSize,_tmpCevInActive,_tmpCevLastModified,_tmpCevLct,_tmpCevStorageSize,_tmpCevOriginalSize);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findLatestVersionUidByContentEntryUidEntity(final long contentEntryUid,
      final Continuation<? super ContentEntryVersion> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntryVersion.*\n"
            + "          FROM ContentEntryVersion\n"
            + "         WHERE ContentEntryVersion.cevContentEntryUid = ?\n"
            + "      ORDER BY ContentEntryVersion.cevLastModified DESC\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryVersion>() {
      @Override
      @Nullable
      public ContentEntryVersion call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevUid");
          final int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentEntryUid");
          final int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOpenUri");
          final int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentType");
          final int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "cevManifestUrl");
          final int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevSize");
          final int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cevInActive");
          final int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLastModified");
          final int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLct");
          final int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevStorageSize");
          final int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOriginalSize");
          final ContentEntryVersion _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCevUid;
            _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
            final long _tmpCevContentEntryUid;
            _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
            final String _tmpCevOpenUri;
            if (_cursor.isNull(_cursorIndexOfCevOpenUri)) {
              _tmpCevOpenUri = null;
            } else {
              _tmpCevOpenUri = _cursor.getString(_cursorIndexOfCevOpenUri);
            }
            final String _tmpCevContentType;
            if (_cursor.isNull(_cursorIndexOfCevContentType)) {
              _tmpCevContentType = null;
            } else {
              _tmpCevContentType = _cursor.getString(_cursorIndexOfCevContentType);
            }
            final String _tmpCevManifestUrl;
            if (_cursor.isNull(_cursorIndexOfCevManifestUrl)) {
              _tmpCevManifestUrl = null;
            } else {
              _tmpCevManifestUrl = _cursor.getString(_cursorIndexOfCevManifestUrl);
            }
            final long _tmpCevSize;
            _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
            final boolean _tmpCevInActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCevInActive);
            _tmpCevInActive = _tmp != 0;
            final long _tmpCevLastModified;
            _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
            final long _tmpCevLct;
            _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
            final long _tmpCevStorageSize;
            _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
            final long _tmpCevOriginalSize;
            _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
            _result = new ContentEntryVersion(_tmpCevUid,_tmpCevContentEntryUid,_tmpCevOpenUri,_tmpCevContentType,_tmpCevManifestUrl,_tmpCevSize,_tmpCevInActive,_tmpCevLastModified,_tmpCevLct,_tmpCevStorageSize,_tmpCevOriginalSize);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<ContentEntryVersion> findLatestByContentEntryUidAsFlow(final long contentEntryUid) {
    final String _sql = "\n"
            + "        SELECT ContentEntryVersion.*\n"
            + "          FROM ContentEntryVersion\n"
            + "         WHERE ContentEntryVersion.cevContentEntryUid = ?\n"
            + "      ORDER BY ContentEntryVersion.cevLastModified DESC\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ContentEntryVersion"}, new Callable<ContentEntryVersion>() {
      @Override
      @Nullable
      public ContentEntryVersion call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevUid");
          final int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentEntryUid");
          final int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOpenUri");
          final int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentType");
          final int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "cevManifestUrl");
          final int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevSize");
          final int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cevInActive");
          final int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLastModified");
          final int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLct");
          final int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevStorageSize");
          final int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOriginalSize");
          final ContentEntryVersion _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCevUid;
            _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
            final long _tmpCevContentEntryUid;
            _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
            final String _tmpCevOpenUri;
            if (_cursor.isNull(_cursorIndexOfCevOpenUri)) {
              _tmpCevOpenUri = null;
            } else {
              _tmpCevOpenUri = _cursor.getString(_cursorIndexOfCevOpenUri);
            }
            final String _tmpCevContentType;
            if (_cursor.isNull(_cursorIndexOfCevContentType)) {
              _tmpCevContentType = null;
            } else {
              _tmpCevContentType = _cursor.getString(_cursorIndexOfCevContentType);
            }
            final String _tmpCevManifestUrl;
            if (_cursor.isNull(_cursorIndexOfCevManifestUrl)) {
              _tmpCevManifestUrl = null;
            } else {
              _tmpCevManifestUrl = _cursor.getString(_cursorIndexOfCevManifestUrl);
            }
            final long _tmpCevSize;
            _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
            final boolean _tmpCevInActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCevInActive);
            _tmpCevInActive = _tmp != 0;
            final long _tmpCevLastModified;
            _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
            final long _tmpCevLct;
            _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
            final long _tmpCevStorageSize;
            _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
            final long _tmpCevOriginalSize;
            _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
            _result = new ContentEntryVersion(_tmpCevUid,_tmpCevContentEntryUid,_tmpCevOpenUri,_tmpCevContentType,_tmpCevManifestUrl,_tmpCevSize,_tmpCevInActive,_tmpCevLastModified,_tmpCevLct,_tmpCevStorageSize,_tmpCevOriginalSize);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findContentEntryVersionsWithoutCacheLock(
      final Continuation<? super List<ContentEntryVersion>> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntryVersion.*\n"
            + "          FROM ContentEntryVersion\n"
            + "         WHERE NOT EXISTS(\n"
            + "               SELECT CacheLockJoin.cljId\n"
            + "                 FROM CacheLockJoin\n"
            + "                WHERE CacheLockJoin.cljTableId = 738\n"
            + "                  AND CacheLockJoin.cljEntityUid = ContentEntryVersion.cevUid\n"
            + "                  AND CacheLockJoin.cljUrl = ContentEntryVersion.cevManifestUrl) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntryVersion>>() {
      @Override
      @NonNull
      public List<ContentEntryVersion> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevUid");
          final int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentEntryUid");
          final int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOpenUri");
          final int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentType");
          final int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "cevManifestUrl");
          final int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevSize");
          final int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cevInActive");
          final int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLastModified");
          final int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLct");
          final int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevStorageSize");
          final int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOriginalSize");
          final List<ContentEntryVersion> _result = new ArrayList<ContentEntryVersion>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ContentEntryVersion _item;
            final long _tmpCevUid;
            _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
            final long _tmpCevContentEntryUid;
            _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
            final String _tmpCevOpenUri;
            if (_cursor.isNull(_cursorIndexOfCevOpenUri)) {
              _tmpCevOpenUri = null;
            } else {
              _tmpCevOpenUri = _cursor.getString(_cursorIndexOfCevOpenUri);
            }
            final String _tmpCevContentType;
            if (_cursor.isNull(_cursorIndexOfCevContentType)) {
              _tmpCevContentType = null;
            } else {
              _tmpCevContentType = _cursor.getString(_cursorIndexOfCevContentType);
            }
            final String _tmpCevManifestUrl;
            if (_cursor.isNull(_cursorIndexOfCevManifestUrl)) {
              _tmpCevManifestUrl = null;
            } else {
              _tmpCevManifestUrl = _cursor.getString(_cursorIndexOfCevManifestUrl);
            }
            final long _tmpCevSize;
            _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
            final boolean _tmpCevInActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCevInActive);
            _tmpCevInActive = _tmp != 0;
            final long _tmpCevLastModified;
            _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
            final long _tmpCevLct;
            _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
            final long _tmpCevStorageSize;
            _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
            final long _tmpCevOriginalSize;
            _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
            _item = new ContentEntryVersion(_tmpCevUid,_tmpCevContentEntryUid,_tmpCevOpenUri,_tmpCevContentType,_tmpCevManifestUrl,_tmpCevSize,_tmpCevInActive,_tmpCevLastModified,_tmpCevLct,_tmpCevStorageSize,_tmpCevOriginalSize);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
